/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.JComponents;

import icy.gui.frame.progress.ProgressFrame;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.tools.Comparators;
import plugins.fmp.multiSPOTS96.tools.LazyExperiment;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;

public class JComboBoxExperimentLazy
extends JComboBox<Experiment> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = Logger.getLogger(JComboBoxExperimentLazy.class.getName());
    public int index0 = 0;
    public int index1 = 0;
    public int maxSizeOfSpotsArrays = 0;
    public String stringExpBinSubDirectory = null;
    private List<LazyExperiment.ExperimentMetadata> experimentMetadataList = new ArrayList<LazyExperiment.ExperimentMetadata>();

    @Override
    public void removeAllItems() {
        super.removeAllItems();
        this.stringExpBinSubDirectory = null;
        this.experimentMetadataList.clear();
    }

    public int addExperiment(Experiment exp, boolean allowDuplicates) {
        String exptName = exp.toString();
        int index = this.getExperimentIndexFromExptName(exptName);
        if (allowDuplicates || index < 0) {
            Experiment lazyExp = this.convertToLazyExperiment(exp);
            this.addItem(lazyExp);
            index = this.getExperimentIndexFromExptName(exptName);
        }
        return index;
    }

    public int addLazyExperiment(LazyExperiment lazyExp, boolean allowDuplicates) {
        String exptName = lazyExp.toString();
        int index = this.getExperimentIndexFromExptName(exptName);
        if (allowDuplicates || index < 0) {
            this.addItem(lazyExp);
            index = this.getItemCount() - 1;
        }
        return index;
    }

    public int addLazyExperimentDirect(LazyExperiment lazyExp) {
        this.addItem(lazyExp);
        return this.getItemCount() - 1;
    }

    public void addLazyExperimentsBulk(List<LazyExperiment> lazyExperiments) {
        for (LazyExperiment lazyExp : lazyExperiments) {
            this.addItem(lazyExp);
        }
    }

    private Experiment convertToLazyExperiment(Experiment exp) {
        if (exp instanceof LazyExperiment) {
            return exp;
        }
        LazyExperiment.ExperimentMetadata metadata = new LazyExperiment.ExperimentMetadata(exp.seqCamData != null ? exp.seqCamData.getImagesDirectory() : exp.toString(), exp.getResultsDirectory(), this.stringExpBinSubDirectory);
        this.experimentMetadataList.add(metadata);
        return new LazyExperiment(metadata);
    }

    @Override
    public Experiment getItemAt(int index) {
        Object item = super.getItemAt(index);
        if (item instanceof Experiment) {
            Experiment exp = (Experiment)item;
            if (exp instanceof LazyExperiment) {
                ((LazyExperiment)exp).loadIfNeeded();
            }
            return exp;
        }
        return null;
    }

    @Override
    public Experiment getSelectedItem() {
        Object selected = super.getSelectedItem();
        if (selected instanceof Experiment) {
            Experiment exp = (Experiment)selected;
            if (exp instanceof LazyExperiment) {
                ((LazyExperiment)exp).loadIfNeeded();
            }
            return exp;
        }
        return null;
    }

    public Experiment get_MsTime_of_StartAndEnd_AllExperiments(XLSExportOptions options) {
        Experiment expAll = new Experiment();
        Experiment exp0 = this.getItemAt(0);
        if (options.fixedIntervals) {
            expAll.seqCamData.getTimeManager().setFirstImageMs(options.startAll_Ms);
            expAll.seqCamData.setLastImageMs(options.endAll_Ms);
        } else if (options.absoluteTime) {
            Experiment expFirst = exp0.getFirstChainedExperiment(options.collateSeries);
            expAll.setFileTimeImageFirst(expFirst.firstImage_FileTime);
            Experiment expLast = exp0.getLastChainedExperiment(options.collateSeries);
            expAll.setFileTimeImageLast(expLast.lastImage_FileTime);
            for (int i = 0; i < this.getItemCount(); ++i) {
                Experiment exp = this.getItemAt(i);
                expFirst = exp.getFirstChainedExperiment(options.collateSeries);
                if (expAll.firstImage_FileTime.compareTo(expFirst.firstImage_FileTime) > 0) {
                    expAll.setFileTimeImageFirst(expFirst.firstImage_FileTime);
                }
                expLast = exp.getLastChainedExperiment(options.collateSeries);
                if (expAll.lastImage_FileTime.compareTo(expLast.lastImage_FileTime) >= 0) continue;
                expAll.setFileTimeImageLast(expLast.lastImage_FileTime);
            }
            expAll.seqCamData.setFirstImageMs(expAll.firstImage_FileTime.toMillis());
            expAll.seqCamData.setLastImageMs(expAll.lastImage_FileTime.toMillis());
        } else {
            expAll.seqCamData.setFirstImageMs(0L);
            expAll.seqCamData.setLastImageMs(exp0.seqCamData.getTimeManager().getBinLast_ms() - exp0.seqCamData.getTimeManager().getBinFirst_ms());
            long firstOffset_Ms = 0L;
            long lastOffset_Ms = 0L;
            for (int i = 0; i < this.getItemCount(); ++i) {
                long diff;
                Experiment exp = this.getItemAt(i);
                Experiment expFirst = exp.getFirstChainedExperiment(options.collateSeries);
                firstOffset_Ms = expFirst.seqCamData.getTimeManager().getBinFirst_ms() + expFirst.seqCamData.getFirstImageMs();
                exp.chainImageFirst_ms = expFirst.seqCamData.getFirstImageMs() + expFirst.seqCamData.getTimeManager().getBinFirst_ms();
                Experiment expLast = exp.getLastChainedExperiment(options.collateSeries);
                if (expLast.seqCamData.getTimeManager().getBinLast_ms() <= 0L) {
                    expLast.seqCamData.getTimeManager().setBinLast_ms(expLast.seqCamData.getLastImageMs() - expLast.seqCamData.getFirstImageMs());
                }
                if ((diff = (lastOffset_Ms = expLast.seqCamData.getTimeManager().getBinLast_ms() + expLast.seqCamData.getFirstImageMs()) - firstOffset_Ms) < 1L) {
                    System.out.println("ExperimentCombo:get_MsTime_of_StartAndEnd_AllExperiments() Expt # " + i + ": FileTime difference between last and first image < 1; set dt between images = 1 ms");
                    diff = exp.seqCamData.getSequence().getSizeT();
                }
                if (expAll.seqCamData.getLastImageMs() >= diff) continue;
                expAll.seqCamData.setLastImageMs(diff);
            }
        }
        return expAll;
    }

    public boolean loadListOfMeasuresFromAllExperiments(final boolean loadSpots, final boolean loadDrosoTrack) {
        final ProgressFrame progress = new ProgressFrame("Load experiment(s) parameters");
        final int nexpts = this.getItemCount();
        this.maxSizeOfSpotsArrays = 0;
        progress.setLength((double)nexpts);
        boolean flag = true;
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("loadAllExperiments");
        processor.setPriority(5);
        ArrayList futuresArray = new ArrayList(nexpts);
        futuresArray.clear();
        int i = 0;
        while (i < nexpts) {
            final int it = i++;
            final Experiment exp = this.getItemAt(it);
            futuresArray.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    int nSpotsPerCage;
                    int nCages;
                    int nMaxSpots;
                    progress.setMessage("Load experiment " + it + " of " + nexpts);
                    if (exp instanceof LazyExperiment) {
                        ((LazyExperiment)exp).loadIfNeeded();
                    }
                    exp.load_MS96_experiment();
                    exp.load_MS96_cages();
                    if (loadSpots) {
                        exp.load_MS96_spotsMeasures();
                    }
                    if (loadDrosoTrack) {
                        exp.zopenPositionsMeasures();
                    }
                    if (JComboBoxExperimentLazy.this.maxSizeOfSpotsArrays < (nMaxSpots = (nCages = exp.cagesArray.cagesList.size()) * (nSpotsPerCage = exp.cagesArray.nColumnsPerCage * exp.cagesArray.nRowsPerCage))) {
                        JComboBoxExperimentLazy.this.maxSizeOfSpotsArrays = nMaxSpots;
                        if (JComboBoxExperimentLazy.this.maxSizeOfSpotsArrays % 2 != 0) {
                            ++JComboBoxExperimentLazy.this.maxSizeOfSpotsArrays;
                        }
                    }
                    progress.incPosition();
                }
            }));
        }
        this.waitFuturesCompletion(processor, futuresArray, progress);
        progress.close();
        return flag;
    }

    protected void waitFuturesCompletion(Processor processor, ArrayList<Future<?>> futuresArray, ProgressFrame progressBar) {
        int frame = 1;
        int nframes = futuresArray.size();
        while (!futuresArray.isEmpty()) {
            Future<?> f = futuresArray.get(futuresArray.size() - 1);
            if (progressBar != null) {
                progressBar.setMessage("Analyze experiment: " + frame + "//" + nframes);
            }
            try {
                f.get();
            }
            catch (ExecutionException e) {
                System.out.println("ExperimentCombo:waitFuturesCompletion() - Warning: " + e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            futuresArray.remove(f);
            ++frame;
        }
    }

    public void setFirstImageForAllExperiments(boolean collate) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            Experiment expi = this.getItemAt(i);
            Experiment expFirst = expi.getFirstChainedExperiment(collate);
            expi.chainImageFirst_ms = expFirst.seqCamData.getFirstImageMs() + expFirst.seqCamData.getTimeManager().getBinFirst_ms();
        }
    }

    private void resetChaining(Experiment expi) {
        expi.chainToPreviousExperiment = null;
        expi.chainToNextExperiment = null;
    }

    public void chainExperimentsUsingKymoIndexes(boolean collate) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            Experiment expi = this.getItemAt(i);
            if (!collate) {
                this.resetChaining(expi);
                continue;
            }
            if (expi.chainToNextExperiment != null || expi.chainToPreviousExperiment != null) continue;
            ArrayList<Experiment> list = new ArrayList<Experiment>();
            list.add(expi);
            for (int j = 0; j < this.getItemCount(); ++j) {
                if (i == j) continue;
                Experiment expj = this.getItemAt(j);
                if (!expi.getProperties().isSameProperties(expj.getProperties()) || expj.chainToNextExperiment != null || expj.chainToPreviousExperiment != null) continue;
                list.add(expj);
            }
            if (list.size() < 2) continue;
            Collections.sort(list, new Comparators.Experiment_Start());
            for (int k = 0; k < list.size(); ++k) {
                Experiment expk = (Experiment)list.get(k);
                if (k > 0) {
                    expk.chainToPreviousExperiment = (Experiment)list.get(k - 1);
                }
                if (k >= list.size() - 1) continue;
                expk.chainToNextExperiment = (Experiment)list.get(k + 1);
            }
        }
    }

    public int getExperimentIndexFromExptName(String filename) {
        int position = -1;
        if (filename != null) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                Experiment exp;
                Object item = super.getItemAt(i);
                if (!(item instanceof Experiment) || !filename.equals((exp = (Experiment)item).toString())) continue;
                position = i;
                break;
            }
        }
        return position;
    }

    public Experiment getExperimentFromExptName(String filename) {
        Experiment exp = null;
        for (int i = 0; i < this.getItemCount(); ++i) {
            Experiment experiment;
            String expString;
            Object item = super.getItemAt(i);
            if (!(item instanceof Experiment) || !filename.equals(expString = (experiment = (Experiment)item).toString())) continue;
            exp = experiment;
            break;
        }
        return exp;
    }

    public List<String> getFieldValuesFromAllExperiments(EnumXLSColumnHeader field) {
        ArrayList<String> textList = new ArrayList<String>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            Experiment exp = this.getItemAt(i);
            if (exp instanceof LazyExperiment) {
                ((LazyExperiment)exp).loadIfNeeded();
            }
            exp.load_MS96_experiment();
            textList.addAll(exp.getFieldValues(field));
        }
        return textList;
    }

    public List<String> getFieldValuesFromAllExperimentsLightweight(EnumXLSColumnHeader field) {
        ArrayList<String> textList = new ArrayList<String>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object item = super.getItemAt(i);
            if (item instanceof LazyExperiment) {
                LazyExperiment lazyExp = (LazyExperiment)item;
                String fieldValue = lazyExp.getFieldValue(field);
                if (fieldValue == null || fieldValue.isEmpty() || fieldValue.equals("..")) continue;
                textList.add(fieldValue);
                continue;
            }
            if (!(item instanceof Experiment)) continue;
            Experiment exp = (Experiment)item;
            if (exp instanceof LazyExperiment) {
                ((LazyExperiment)exp).loadIfNeeded();
            }
            exp.load_MS96_experiment();
            textList.addAll(exp.getFieldValues(field));
        }
        ArrayList<String> uniqueList = new ArrayList<String>();
        for (String value : textList) {
            if (uniqueList.contains(value)) continue;
            uniqueList.add(value);
        }
        return uniqueList;
    }

    public void getFieldValuesToCombo(JComboBox<String> combo, EnumXLSColumnHeader header) {
        combo.removeAllItems();
        List<String> textList = this.getFieldValuesFromAllExperiments(header);
        Collections.sort(textList);
        for (String text : textList) {
            combo.addItem(text);
        }
    }

    public void getFieldValuesToComboLightweight(JComboBox<String> combo, EnumXLSColumnHeader header) {
        combo.removeAllItems();
        List<String> textList = this.getFieldValuesFromAllExperimentsLightweight(header);
        Collections.sort(textList);
        for (String text : textList) {
            combo.addItem(text);
        }
    }

    public List<Experiment> getExperimentsAsList() {
        int nitems = this.getItemCount();
        ArrayList<Experiment> expList = new ArrayList<Experiment>(nitems);
        for (int i = 0; i < nitems; ++i) {
            expList.add(this.getItemAt(i));
        }
        return expList;
    }

    public void setExperimentsFromList(List<Experiment> listExp) {
        this.removeAllItems();
        for (Experiment exp : listExp) {
            Experiment lazyExp = this.convertToLazyExperiment(exp);
            this.addItem(lazyExp);
        }
    }

    public String getMemoryUsageInfo() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        return String.format("Memory: %dMB used, %dMB total, %d experiments loaded", usedMemory / 1024L / 1024L, totalMemory / 1024L / 1024L, this.experimentMetadataList.size());
    }

    public int getLoadedExperimentCount() {
        int count = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            Object item = super.getItemAt(i);
            if (!(item instanceof Experiment)) continue;
            Experiment exp = (Experiment)item;
            if (exp instanceof LazyExperiment) {
                if (!((LazyExperiment)exp).isLoaded()) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }
}

