/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.a_browse;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.dlg.a_browse.SelectFilesPanel;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS96.tools.JComponents.SequenceNameListRenderer;
import plugins.fmp.multiSPOTS96.tools.LazyExperiment;

public class LoadSaveExperimentOptimized
extends JPanel
implements PropertyChangeListener,
ItemListener,
SequenceListener {
    private static final long serialVersionUID = -690874563607080412L;
    private static final Logger LOGGER = Logger.getLogger(LoadSaveExperimentOptimized.class.getName());
    private static final int METADATA_BATCH_SIZE = 20;
    private static final int PROGRESS_UPDATE_INTERVAL = 10;
    private JButton createButton = new JButton("Create...");
    private JButton openButton = new JButton("Open...");
    private JButton searchButton = new JButton("Search...");
    private JButton closeButton = new JButton("Close");
    public JCheckBox filteredCheck = new JCheckBox("List filtered");
    public List<String> selectedNames = new ArrayList<String>();
    private SelectFilesPanel dialogSelect = null;
    private JButton previousButton = new JButton("<");
    private JButton nextButton = new JButton(">");
    private MultiSPOTS96 parent0 = null;
    private List<LazyExperiment.ExperimentMetadata> experimentMetadataList = new ArrayList<LazyExperiment.ExperimentMetadata>();
    private volatile boolean isProcessing = false;
    private final AtomicInteger processingCount = new AtomicInteger(0);

    public JPanel initPanel(MultiSPOTS96 parent0) {
        this.parent0 = parent0;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 200));
        JPanel group2Panel = this.initUI();
        this.defineActionListeners();
        parent0.expListCombo.addItemListener(this);
        return group2Panel;
    }

    private JPanel initUI() {
        JPanel group2Panel = new JPanel(new GridLayout(2, 1));
        JPanel navPanel = this.initNavigationPanel();
        JPanel buttonPanel = this.initButtonPanel();
        group2Panel.add(navPanel);
        group2Panel.add(buttonPanel);
        return group2Panel;
    }

    private JPanel initNavigationPanel() {
        JPanel navPanel = new JPanel(new BorderLayout());
        SequenceNameListRenderer renderer = new SequenceNameListRenderer();
        this.parent0.expListCombo.setRenderer(renderer);
        int bWidth = 30;
        int height = 20;
        this.previousButton.setPreferredSize(new Dimension(bWidth, height));
        this.nextButton.setPreferredSize(new Dimension(bWidth, height));
        navPanel.add((Component)this.previousButton, "Before");
        navPanel.add((Component)this.parent0.expListCombo, "Center");
        navPanel.add((Component)this.nextButton, "After");
        return navPanel;
    }

    private JPanel initButtonPanel() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(1);
        JPanel subPanel = new JPanel(layout);
        subPanel.add(this.openButton);
        subPanel.add(this.createButton);
        subPanel.add(this.searchButton);
        subPanel.add(this.closeButton);
        subPanel.add(this.filteredCheck);
        buttonPanel.add((Component)subPanel, "Before");
        return buttonPanel;
    }

    private void defineActionListeners() {
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSaveExperimentOptimized.this.handleCreateButton();
            }
        });
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSaveExperimentOptimized.this.handleOpenButton();
            }
        });
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSaveExperimentOptimized.this.handleSearchButton();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LoadSaveExperimentOptimized.this.handleCloseButton();
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LoadSaveExperimentOptimized.this.handlePreviousButton();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LoadSaveExperimentOptimized.this.handleNextButton();
            }
        });
        this.parent0.expListCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadSaveExperimentOptimized.this.updateBrowseInterface();
            }
        });
        this.filteredCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((LoadSaveExperimentOptimized)LoadSaveExperimentOptimized.this).parent0.dlgExperiment.tabFilter.filterExperimentList(LoadSaveExperimentOptimized.this.filteredCheck.isSelected());
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SELECT1_CLOSED")) {
            if (this.selectedNames.size() < 1) {
                return;
            }
            if (this.isProcessing) {
                LOGGER.warning("File processing already in progress, ignoring new request");
                return;
            }
            this.processSelectedFilesMetadataOnly();
        }
    }

    private void processSelectedFilesMetadataOnly() {
        this.isProcessing = true;
        this.processingCount.set(0);
        this.experimentMetadataList.clear();
        final ProgressFrame progressFrame = new ProgressFrame("Processing Experiment Metadata");
        progressFrame.setMessage("Scanning " + this.selectedNames.size() + " experiment directories...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                LoadSaveExperimentOptimized.this.processMetadataOnly(progressFrame);
                return null;
            }

            @Override
            protected void done() {
                LoadSaveExperimentOptimized.this.isProcessing = false;
                progressFrame.close();
                SwingUtilities.invokeLater(() -> LoadSaveExperimentOptimized.this.updateBrowseInterface());
            }
        };
        worker.execute();
    }

    private void processMetadataOnly(ProgressFrame progressFrame) {
        String subDir = this.parent0.expListCombo.stringExpBinSubDirectory;
        int totalFiles = this.selectedNames.size();
        try {
            block4: for (int i = 0; i < totalFiles; i += 20) {
                int endIndex = Math.min(i + 20, totalFiles);
                int currentBatch = i;
                int currentEndIndex = endIndex;
                SwingUtilities.invokeLater(() -> {
                    progressFrame.setMessage(String.format("Scanning experiments %d-%d of %d", currentBatch + 1, currentEndIndex, totalFiles));
                    progressFrame.setPosition((double)currentBatch / (double)totalFiles);
                });
                for (int j = i; j < endIndex; ++j) {
                    String fileName = this.selectedNames.get(j);
                    this.processSingleFileMetadataOnly(fileName, subDir);
                    this.processingCount.incrementAndGet();
                    if (j % 10 == 0) {
                        int currentProgress = j;
                        SwingUtilities.invokeLater(() -> progressFrame.setMessage(String.format("Found %d experiments...", currentProgress + 1)));
                    }
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue block4;
                    }
                }
            }
            SwingUtilities.invokeLater(() -> this.addMetadataToUI());
            this.selectedNames.clear();
        }
        catch (Exception e) {
            LOGGER.severe("Error processing experiment metadata: " + e.getMessage());
            SwingUtilities.invokeLater(() -> progressFrame.setMessage("Error: " + e.getMessage()));
        }
    }

    private void processSingleFileMetadataOnly(String fileName, String subDir) {
        try {
            ExperimentDirectories expDirectories = new ExperimentDirectories();
            if (expDirectories.getDirectoriesFromExptPath(subDir, fileName)) {
                String camDataImagesDirectory = expDirectories.getCameraImagesDirectory();
                String resultsDirectory = expDirectories.getResultsDirectory();
                LazyExperiment.ExperimentMetadata metadata = new LazyExperiment.ExperimentMetadata(camDataImagesDirectory, resultsDirectory, subDir);
                this.experimentMetadataList.add(metadata);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Failed to process metadata for file " + fileName + ": " + e.getMessage());
        }
    }

    private void addMetadataToUI() {
        try {
            this.parent0.expListCombo.removeAllItems();
            ArrayList<LazyExperiment> lazyExperiments = new ArrayList<LazyExperiment>();
            for (LazyExperiment.ExperimentMetadata metadata : this.experimentMetadataList) {
                LazyExperiment lazyExp = new LazyExperiment(metadata);
                lazyExperiments.add(lazyExp);
            }
            this.parent0.expListCombo.addLazyExperimentsBulk(lazyExperiments);
            this.parent0.dlgExperiment.tabInfos.initInfosCombos();
        }
        catch (Exception e) {
            LOGGER.warning("Error adding metadata to UI: " + e.getMessage());
        }
    }

    public boolean openSelectedExperiment(Experiment exp) {
        ProgressFrame progressFrame = new ProgressFrame("Load Experiment Data");
        try {
            if (exp instanceof LazyExperiment) {
                progressFrame.setMessage("Loading experiment data...");
                ((LazyExperiment)exp).loadIfNeeded();
            }
            progressFrame.setMessage("Loading experiment data...");
            exp.load_MS96_experiment();
            progressFrame.setMessage("Loading images...");
            List<String> imagesList = ExperimentDirectories.getImagesListFromPathV2(exp.seqCamData.getImagesDirectory(), "jpg");
            exp.seqCamData.loadImageList(imagesList);
            exp.seqCamData.getSequence().addListener((SequenceListener)this);
            if (exp.seqCamData == null) {
                LOGGER.warning("No jpg files found for experiment: " + exp.toString());
                progressFrame.close();
                return false;
            }
            progressFrame.setMessage("Loading cages and spots...");
            exp.load_MS96_cages();
            exp.transferCagesROI_toSequence();
            exp.transferSpotsROI_toSequence();
            exp.load_MS96_spotsMeasures();
            this.parent0.dlgMeasure.tabCharts.displayChartPanels(exp);
            progressFrame.setMessage("Updating dialogs...");
            this.parent0.dlgExperiment.updateDialogs(exp);
            this.parent0.dlgSpots.updateDialogs(exp);
            this.parent0.dlgExperiment.tabInfos.transferPreviousExperimentInfosToDialog(exp, exp);
            progressFrame.close();
            this.parent0.dlgExperiment.updateViewerForSequenceCam(exp);
            return true;
        }
        catch (Exception e) {
            LOGGER.severe("Error opening experiment: " + e.getMessage());
            progressFrame.close();
            return false;
        }
    }

    private void handleCreateButton() {
        ExperimentDirectories eDAF = new ExperimentDirectories();
        String binDirectory = this.parent0.expListCombo.stringExpBinSubDirectory;
        if (eDAF.getDirectoriesFromDialog(binDirectory, null, true)) {
            String experimentName = new File(eDAF.getResultsDirectory()).getName();
            String experimentPath = eDAF.getResultsDirectory();
            LazyExperiment.ExperimentMetadata metadata = new LazyExperiment.ExperimentMetadata(experimentName, experimentPath, binDirectory);
            this.experimentMetadataList.add(metadata);
            LazyExperiment lazyExp = new LazyExperiment(metadata);
            this.parent0.expListCombo.addLazyExperimentDirect(lazyExp);
            this.parent0.dlgExperiment.tabInfos.initInfosCombos();
            this.parent0.expListCombo.setSelectedIndex(this.parent0.expListCombo.getItemCount() - 1);
        }
    }

    private void handleOpenButton() {
        ExperimentDirectories eDAF = new ExperimentDirectories();
        String binDirectory = this.parent0.expListCombo.stringExpBinSubDirectory;
        if (eDAF.getDirectoriesFromDialog(binDirectory, null, false)) {
            String camDataImagesDirectory = eDAF.getCameraImagesDirectory();
            String resultsDirectory = eDAF.getResultsDirectory();
            LazyExperiment.ExperimentMetadata metadata = new LazyExperiment.ExperimentMetadata(camDataImagesDirectory, resultsDirectory, binDirectory);
            this.experimentMetadataList.add(metadata);
            LazyExperiment lazyExp = new LazyExperiment(metadata);
            this.parent0.expListCombo.addLazyExperimentDirect(lazyExp);
            this.parent0.dlgExperiment.tabInfos.initInfosCombos();
            this.parent0.expListCombo.setSelectedIndex(this.parent0.expListCombo.getItemCount() - 1);
        }
    }

    private void handleSearchButton() {
        this.selectedNames = new ArrayList<String>();
        this.dialogSelect = new SelectFilesPanel();
        this.dialogSelect.initialize(this.parent0, this.selectedNames);
    }

    private void handleCloseButton() {
        this.closeAllExperiments();
        this.parent0.expListCombo.removeAllItems();
        this.parent0.expListCombo.updateUI();
    }

    private void handlePreviousButton() {
        this.parent0.expListCombo.setSelectedIndex(this.parent0.expListCombo.getSelectedIndex() - 1);
        this.updateBrowseInterface();
    }

    private void handleNextButton() {
        this.parent0.expListCombo.setSelectedIndex(this.parent0.expListCombo.getSelectedIndex() + 1);
        this.updateBrowseInterface();
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        if (sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            // empty if block
        }
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Experiment exp = this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                this.openSelectedExperiment(exp);
            }
        } else if (e.getStateChange() == 2) {
            Experiment exp = (Experiment)e.getItem();
            if (exp != null) {
                this.closeViewsForCurrentExperiment(exp);
            } else {
                System.out.println("experiment = null");
            }
        }
    }

    public void closeViewsForCurrentExperiment(Experiment exp) {
        if (exp != null) {
            if (exp.seqCamData != null) {
                Viewer v;
                exp.save_MS96_experiment();
                exp.save_MS96_spotsMeasures();
                if (exp.seqCamData.getSequence() != null && (v = exp.seqCamData.getSequence().getFirstViewer()) != null) {
                    v.close();
                }
            }
            exp.closeSequences();
        }
    }

    public void closeCurrentExperiment() {
        if (this.parent0.expListCombo.getSelectedIndex() < 0) {
            return;
        }
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.closeViewsForCurrentExperiment(exp);
        }
    }

    public void closeAllExperiments() {
        this.closeCurrentExperiment();
        this.parent0.expListCombo.removeAllItems();
        this.parent0.dlgExperiment.tabFilter.clearAllCheckBoxes();
        this.parent0.dlgExperiment.tabFilter.filterExpList.removeAllItems();
        this.parent0.dlgExperiment.tabInfos.clearCombos();
        this.filteredCheck.setSelected(false);
        this.experimentMetadataList.clear();
    }

    void updateBrowseInterface() {
        int isel = this.parent0.expListCombo.getSelectedIndex();
        boolean flag1 = isel != 0;
        boolean flag2 = isel != this.parent0.expListCombo.getItemCount() - 1;
        this.previousButton.setEnabled(flag1);
        this.nextButton.setEnabled(flag2);
    }

    public String getMemoryUsageInfo() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        return String.format("Memory: %dMB used, %dMB total, %d experiments loaded", usedMemory / 1024L / 1024L, totalMemory / 1024L / 1024L, this.experimentMetadataList.size());
    }
}

