/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.b_spots;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.dlg.b_spots.CreateSpotsArrayPanel;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.ExperimentUtils;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DGeometryException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DGrid;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DPolygonPlus;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DProcessingException;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class CreateSpots
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private JButton cageGridButton = new JButton("(1) Cage grid");
    private JComboBox<Integer> nRowsCombo = new JComboBox<Integer>(new Integer[]{1, 2, 4});
    private JComboBox<Integer> nColumnsCombo = new JComboBox<Integer>(new Integer[]{1, 2, 4, 8});
    private JButton selectButton = new JButton("(2) Select");
    private JButton createSpotsButton = new JButton("(3) Create spots");
    private MultiSPOTS96 parent0 = null;
    private ROI2DGrid roiGrid = null;
    private Point2D.Double referencePosition = null;
    private CreateSpotsArrayPanel spotsPanel = null;

    void init(GridLayout capLayout, MultiSPOTS96 parent0) {
        this.setLayout(capLayout);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0 = new JPanel(flowLayout);
        panel0.add(this.cageGridButton);
        panel0.add(new JLabel("cols"));
        panel0.add(this.nColumnsCombo);
        panel0.add(new JLabel("rows"));
        panel0.add(this.nRowsCombo);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.selectButton);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.createSpotsButton);
        this.add(panel0);
        this.add(panel1);
        this.add(panel2);
        this.nRowsCombo.setSelectedItem(4);
        this.nColumnsCombo.setSelectedItem(8);
        this.defineActionListeners();
        this.parent0 = parent0;
    }

    private void defineActionListeners() {
        this.cageGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.seqCamData.removeROIsContainingString("carre");
                    exp.seqCamData.removeROIsContainingString("spot");
                    Cage cageFound = exp.cagesArray.findFirstSelectedCage();
                    if (cageFound == null) {
                        cageFound = exp.cagesArray.cagesList.get(0);
                    }
                    if (cageFound != null) {
                        exp.seqCamData.centerDisplayOnRoi(cageFound.getRoi());
                        CreateSpots.this.changeGrid(exp, cageFound);
                    }
                    if (CreateSpots.this.spotsPanel == null) {
                        CreateSpots.this.spotsPanel = new CreateSpotsArrayPanel();
                        int n_columns = (Integer)CreateSpots.this.nColumnsCombo.getSelectedItem();
                        int n_rows = (Integer)CreateSpots.this.nRowsCombo.getSelectedItem();
                        CreateSpots.this.spotsPanel.initialize(CreateSpots.this.parent0, n_columns, n_rows);
                        CreateSpots.this.spotsPanel.requestFocus();
                    }
                }
            }
        });
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    CreateSpots.this.keepSelectedAreas(exp);
                }
            }
        });
        this.createSpotsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.seqCamData.removeROIsContainingString("spot");
                    CreateSpots.this.createSpotsForAllCages(exp, CreateSpots.this.roiGrid, CreateSpots.this.referencePosition);
                    ExperimentUtils.transferSpotsToCamDataSequence(exp);
                    exp.seqCamData.removeROIsContainingString("carre");
                }
            }
        });
    }

    private void keepSelectedAreas(Experiment exp) {
        ArrayList<ROI2DPolygonPlus> listCarres = this.roiGrid.getAreaRois();
        for (ROI2DPolygonPlus roi : listCarres) {
            roi.setSelected(roi.isSelected());
            if (roi.getSelected()) continue;
            exp.seqCamData.getSequence().removeROI((ROI)roi);
        }
    }

    private void createSpotsForAllCages(Experiment exp, ROI2DGrid roiGrid, Point2D.Double referenceCagePosition) {
        ArrayList<ROI2DPolygonPlus> listSelectedAreas = roiGrid.getSelectedAreaRois();
        for (Cage cage : exp.cagesArray.cagesList) {
            ROI2D cageRoi = cage.getRoi();
            ROI2DGrid cageGrid = this.createGrid(cageRoi);
            cage.spotsArray.getSpotsList().clear();
            for (ROI2DPolygonPlus roi : listSelectedAreas) {
                try {
                    ROI2DPolygonPlus roiP = cageGrid.getAreaAt(roi.getCagePosition());
                    Rectangle2D rect = roiP.getBounds2D();
                    Point2D.Double center = (Point2D.Double)roiP.getPosition2D();
                    int radius = (int)(rect.getHeight() / 2.0);
                    cage.addEllipseSpot(center, radius);
                }
                catch (ROI2DValidationException e) {
                    System.err.println("Error getting area at position " + roi.getCagePosition() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
            cage.getRoi().setSelected(false);
        }
    }

    void changeGrid(Experiment exp, Cage cage) {
        if (this.roiGrid != null) {
            Sequence sequence = exp.seqCamData.getSequence();
            try {
                this.roiGrid.clearGridRois(sequence);
            }
            catch (ROI2DValidationException e) {
                e.printStackTrace();
            }
        }
        this.roiGrid = this.createGrid(cage.getRoi());
        exp.seqCamData.getSequence().addROIs(this.roiGrid.getAreaRois(), false);
    }

    private ROI2DGrid createGrid(ROI2D roi) {
        ROI2DGrid grid = null;
        Polygon2D polygon = ((ROI2DPolygon)roi).getPolygon2D();
        if (polygon != null) {
            int n_columns = (Integer)this.nColumnsCombo.getSelectedItem();
            int n_rows = (Integer)this.nRowsCombo.getSelectedItem();
            grid = new ROI2DGrid();
            try {
                grid.createGridFromFrame(polygon, n_columns, n_rows);
            }
            catch (ROI2DGeometryException | ROI2DValidationException e) {
                e.printStackTrace();
            }
            try {
                grid.gridToRois("carre", Color.RED, 1, 1);
            }
            catch (ROI2DProcessingException | ROI2DValidationException e) {
                e.printStackTrace();
            }
        }
        return grid;
    }
}

