/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.b_spots;

import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.adufour.quickhull.QuickHull2D;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DMeasures;
import plugins.fmp.multiSPOTS96.tools.canvas2D.Canvas2D_3Transforms;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformOptions;
import plugins.fmp.multiSPOTS96.tools.overlay.OverlayThreshold;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ShapeSpots
extends JPanel {
    private static final long serialVersionUID = 4950182090521600937L;
    private JButton detectContoursButton = new JButton("Detect spots contours");
    private JButton restoreContoursButton = new JButton("Restore contours");
    private JCheckBox selectedSpotCheckBox = new JCheckBox("selected spots", false);
    private JButton cutAndInterpolateButton = new JButton("Cut");
    private JLabel spotsFilterLabel = new JLabel("Filter");
    ImageTransformEnums[] transforms = new ImageTransformEnums[]{ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB};
    private JComboBox<ImageTransformEnums> spotsTransformsComboBox = new JComboBox<ImageTransformEnums>(this.transforms);
    private String[] directions = new String[]{" threshold >", " threshold <"};
    private JComboBox<String> spotsDirectionComboBox = new JComboBox<String>(this.directions);
    private JSpinner spotsThresholdSpinner = new JSpinner(new SpinnerNumberModel(35, 0, 255, 1));
    private JToggleButton spotsViewButton = new JToggleButton("View");
    private JCheckBox spotsOverlayCheckBox = new JCheckBox("overlay");
    private OverlayThreshold overlayThreshold = null;
    private MultiSPOTS96 parent0 = null;

    void init(GridLayout gridLayout, MultiSPOTS96 parent0) {
        this.setLayout(gridLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        layoutLeft.setVgap(0);
        JPanel panel0 = new JPanel(layoutLeft);
        panel0.add(this.detectContoursButton);
        panel0.add(this.restoreContoursButton);
        panel0.add(this.selectedSpotCheckBox);
        this.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.spotsFilterLabel);
        panel1.add(this.spotsTransformsComboBox);
        panel1.add(this.spotsDirectionComboBox);
        panel1.add(this.spotsThresholdSpinner);
        panel1.add(this.spotsViewButton);
        panel1.add(this.spotsOverlayCheckBox);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(this.cutAndInterpolateButton);
        this.add(panel2);
        this.spotsTransformsComboBox.setSelectedItem((Object)ImageTransformEnums.RGB_DIFFS);
        this.spotsDirectionComboBox.setSelectedIndex(1);
        this.declareListeners();
    }

    private void declareListeners() {
        this.spotsOverlayCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = ((ShapeSpots)ShapeSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (ShapeSpots.this.spotsOverlayCheckBox.isSelected()) {
                        ShapeSpots.this.updateOverlay(exp);
                        ShapeSpots.this.updateOverlayThreshold();
                    } else {
                        ShapeSpots.this.removeOverlay(exp);
                        ShapeSpots.this.overlayThreshold = null;
                    }
                }
            }
        });
        this.spotsTransformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ShapeSpots)ShapeSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    int index = ShapeSpots.this.spotsTransformsComboBox.getSelectedIndex();
                    Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
                    ShapeSpots.this.updateTransformFunctionsOfCanvas(exp);
                    if (!ShapeSpots.this.spotsViewButton.isSelected()) {
                        ShapeSpots.this.spotsViewButton.setSelected(true);
                    }
                    canvas.setTransformStep1Index(index + 1);
                    ShapeSpots.this.updateOverlayThreshold();
                }
            }
        });
        this.spotsDirectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShapeSpots.this.updateOverlayThreshold();
            }
        });
        this.spotsThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ShapeSpots.this.updateOverlayThreshold();
            }
        });
        this.spotsViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ShapeSpots)ShapeSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ShapeSpots.this.displayTransform(exp);
                }
            }
        });
        this.detectContoursButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ShapeSpots)ShapeSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.seqCamData.removeROIsContainingString("_mask");
                    ShapeSpots.this.detectContours(exp);
                    exp.saveSpotsArray_file();
                }
            }
        });
        this.restoreContoursButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ShapeSpots)ShapeSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ShapeSpots.this.restoreContours(exp);
                }
            }
        });
        this.cutAndInterpolateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ShapeSpots)ShapeSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ShapeSpots.this.cutAndInterpolate(exp);
                    exp.saveSpotsArray_file();
                }
            }
        });
    }

    void updateOverlay(Experiment exp) {
        if (this.overlayThreshold == null) {
            this.overlayThreshold = new OverlayThreshold(exp.seqCamData.getSequence());
        } else {
            exp.seqCamData.getSequence().removeOverlay((Overlay)this.overlayThreshold);
            this.overlayThreshold.setSequence(exp.seqCamData.getSequence());
        }
        exp.seqCamData.getSequence().addOverlay((Overlay)this.overlayThreshold);
    }

    void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.getSequence() != null) {
            exp.seqCamData.getSequence().removeOverlay((Overlay)this.overlayThreshold);
        }
    }

    void updateOverlayThreshold() {
        Experiment exp;
        if (!this.spotsOverlayCheckBox.isSelected()) {
            return;
        }
        if (this.overlayThreshold == null && (exp = this.parent0.expListCombo.getSelectedItem()) != null) {
            this.updateOverlay(exp);
        }
        boolean ifGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        int threshold = (Integer)this.spotsThresholdSpinner.getValue();
        ImageTransformEnums transform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        this.overlayThreshold.setThresholdSingle(threshold, transform, ifGreater);
        this.overlayThreshold.painterChanged();
    }

    private BuildSeriesOptions initDetectOptions(Experiment exp) {
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.parent0.expListCombo.getSelectedIndex();
        options.detectAllSeries = false;
        options.seriesFirst = 0;
        options.transform01 = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        options.spotThresholdUp = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        options.spotThreshold = (Integer)this.spotsThresholdSpinner.getValue();
        options.analyzePartOnly = false;
        options.overlayTransform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        options.overlayIfGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        options.overlayThreshold = (Integer)this.spotsThresholdSpinner.getValue();
        options.detectSelectedROIs = this.selectedSpotCheckBox.isSelected();
        return options;
    }

    private void displayTransform(Experiment exp) {
        boolean displayCheckOverlay = false;
        if (this.spotsViewButton.isSelected()) {
            this.updateTransformFunctionsOfCanvas(exp);
            displayCheckOverlay = true;
        } else {
            this.removeOverlay(exp);
            this.spotsOverlayCheckBox.setSelected(false);
            Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
            canvas.setTransformStep1Index(0);
        }
        this.spotsOverlayCheckBox.setEnabled(displayCheckOverlay);
    }

    private void updateTransformFunctionsOfCanvas(Experiment exp) {
        Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
        if (canvas.getTransformStep1ItemCount() < this.spotsTransformsComboBox.getItemCount() + 1) {
            canvas.updateTransformsComboStep1(this.transforms);
        }
        int index = this.spotsTransformsComboBox.getSelectedIndex();
        canvas.selectImageTransformFunctionStep1(index + 1, null);
    }

    private void detectContours(Experiment exp) {
        BuildSeriesOptions options = this.initDetectOptions(exp);
        ImageTransformOptions transformOptions = new ImageTransformOptions();
        transformOptions.transformOption = options.transform01;
        transformOptions.setSingleThreshold(options.spotThreshold, options.spotThresholdUp);
        ImageTransformInterface transformFunction = options.transform01.getFunction();
        Sequence seq = exp.seqCamData.getSequence();
        int t = seq.getFirstViewer().getPositionT();
        IcyBufferedImage sourceImage = seq.getImage(t, 0);
        IcyBufferedImage workImage = transformFunction.getTransformedImage(sourceImage, transformOptions);
        boolean detectSelectedROIs = this.selectedSpotCheckBox.isSelected();
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                ROI2D roi_in = spot.getRoi();
                if (detectSelectedROIs && !roi_in.isSelected()) continue;
                exp.seqCamData.getSequence().removeROI((ROI)roi_in);
                try {
                    spot.setMask2DSpot(spot.getRoi().getBooleanMask2D(0, 0, 1, true));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ROI2DPolygon roi0 = ROI2DMeasures.getContourOfDetectedSpot(workImage, spot, options);
                if (roi0 != null) {
                    List listPoints = QuickHull2D.computeConvexEnvelope((List)roi0.getPoints());
                    ROI2DPolygon roi_new = new ROI2DPolygon(listPoints);
                    roi_new.setName(spot.getRoi().getName());
                    roi_new.setColor(spot.getRoi().getColor());
                    spot.setRoi((ROI2DShape)roi_new);
                }
                exp.seqCamData.getSequence().addROI((ROI)spot.getRoi());
            }
        }
    }

    private void restoreContours(Experiment exp) {
        boolean detectSelectedROIs = this.selectedSpotCheckBox.isSelected();
        for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                ROI2D roi_in = spot.getRoi();
                if (detectSelectedROIs && !roi_in.isSelected()) continue;
                String roiName = roi_in.getName();
                exp.seqCamData.getSequence().removeROI((ROI)roi_in);
                Point2D.Double point = new Point2D.Double(spot.getProperties().getSpotXCoord(), spot.getProperties().getSpotYCoord());
                double x = ((Point2D)point).getX() - (double)spot.getProperties().getSpotRadius();
                double y = ((Point2D)point).getY() - (double)spot.getProperties().getSpotRadius();
                Ellipse2D.Double ellipse = new Ellipse2D.Double(x, y, 2 * spot.getProperties().getSpotRadius(), 2 * spot.getProperties().getSpotRadius());
                ROI2DEllipse roiEllipse = new ROI2DEllipse((Ellipse2D)ellipse);
                roiEllipse.setName(roiName);
                spot.setRoi((ROI2DShape)roiEllipse);
                exp.seqCamData.getSequence().addROI((ROI)spot.getRoi());
            }
        }
    }

    private void replaceRoi(Experiment exp, Spot spot, ROI2D roi_old, ROI2D roi_new) {
        exp.seqCamData.getSequence().removeROI((ROI)roi_new);
        exp.seqCamData.getSequence().removeROI((ROI)roi_old);
        roi_new.setName(roi_old.getName());
        roi_new.setColor(roi_old.getColor());
        spot.setRoi((ROI2DShape)roi_new);
        try {
            spot.getProperties().setSpotNPixels((int)roi_new.getNumberOfPoints());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        exp.seqCamData.getSequence().addROI((ROI)roi_new);
    }

    void cutAndInterpolate(Experiment exp) {
        ROI2D roi = exp.seqCamData.getSequence().getSelectedROI2D();
        if (roi == null) {
            return;
        }
        block2: for (Cage cage : exp.cagesArray.cagesList) {
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                ROI2D spotRoi = spot.getRoi();
                try {
                    if (!spotRoi.intersects((ROI)roi)) continue;
                    ROI newRoi = spotRoi.getSubtraction((ROI)roi);
                    this.replaceRoi(exp, spot, spotRoi, (ROI2D)newRoi);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue block2;
            }
        }
    }
}

