/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.dlg.d_spotsMeasures;

import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS96.MultiSPOTS96;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.series.AdvancedMemoryOptions;
import plugins.fmp.multiSPOTS96.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS96.series.BuildSpotsMeasuresAdvanced;
import plugins.fmp.multiSPOTS96.tools.canvas2D.Canvas2D_3Transforms;
import plugins.fmp.multiSPOTS96.tools.imageTransform.ImageTransformEnums;

public class ThresholdSimpleAdvanced
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 8921207247623517524L;
    private String detectString = "Detect";
    private JButton detectButton = new JButton(this.detectString);
    private JComboBox<String> memUseComboBox = new JComboBox<String>(new String[]{"balanced", "conservative", "aggressive"});
    private JCheckBox allSeriesCheckBox = new JCheckBox("ALL (current to last)", false);
    private JLabel spotsFilterLabel = new JLabel("Spots filter");
    private String[] directions = new String[]{" threshold >", " threshold <"};
    private ImageTransformEnums[] transforms = new ImageTransformEnums[]{ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB};
    private JComboBox<ImageTransformEnums> spotsTransformsComboBox = new JComboBox<ImageTransformEnums>(this.transforms);
    private JComboBox<String> spotsDirectionComboBox = new JComboBox<String>(this.directions);
    private JSpinner spotsThresholdSpinner = new JSpinner(new SpinnerNumberModel(35, 0, 255, 1));
    private JToggleButton viewButton1 = new JToggleButton("View");
    private JToggleButton viewButton2 = new JToggleButton("View");
    private JLabel fliesFilterLabel = new JLabel("  Flies filter");
    private JComboBox<ImageTransformEnums> fliesTransformsComboBox = new JComboBox<ImageTransformEnums>(this.transforms);
    private JComboBox<String> fliesDirectionComboBox = new JComboBox<String>(this.directions);
    private JSpinner fliesThresholdSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 255, 1));
    private boolean vocalAboutMemory = false;
    private WeakReference<BuildSpotsMeasuresAdvanced> processorRef = null;
    private MultiSPOTS96 parent0 = null;

    public void init(GridLayout gridLayout, MultiSPOTS96 parent0) {
        this.setLayout(gridLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        layoutLeft.setVgap(0);
        JPanel panel0 = new JPanel(layoutLeft);
        panel0.add(this.detectButton);
        panel0.add(new JLabel("memory use"));
        panel0.add(this.memUseComboBox);
        panel0.add(this.allSeriesCheckBox);
        this.add(panel0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.spotsFilterLabel);
        panel1.add(this.spotsTransformsComboBox);
        panel1.add(this.spotsDirectionComboBox);
        panel1.add(this.spotsThresholdSpinner);
        panel1.add(this.viewButton1);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(this.fliesFilterLabel);
        panel2.add(this.fliesDirectionComboBox);
        panel2.add(this.fliesThresholdSpinner);
        panel2.add(this.viewButton2);
        this.add(panel2);
        this.spotsTransformsComboBox.setSelectedItem((Object)ImageTransformEnums.RGB_DIFFS);
        this.spotsDirectionComboBox.setSelectedIndex(1);
        this.fliesTransformsComboBox.setSelectedItem((Object)ImageTransformEnums.B_RGB);
        this.fliesDirectionComboBox.setSelectedIndex(0);
        this.declareListeners();
    }

    private void forceDialogReturnCleanup() {
        for (int i = 0; i < 3; ++i) {
            System.gc();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.clearDialogCaches();
    }

    private void clearDialogCaches() {
        System.out.println("Cleared dialog caches");
    }

    private BuildSpotsMeasuresAdvanced getProcessor() {
        if (this.processorRef != null) {
            return (BuildSpotsMeasuresAdvanced)this.processorRef.get();
        }
        return null;
    }

    private void setProcessor(BuildSpotsMeasuresAdvanced processor) {
        this.processorRef = new WeakReference<BuildSpotsMeasuresAdvanced>(processor);
    }

    private void declareListeners() {
        this.spotsTransformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ThresholdSimpleAdvanced)ThresholdSimpleAdvanced.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    int index = ThresholdSimpleAdvanced.this.spotsTransformsComboBox.getSelectedIndex();
                    ThresholdSimpleAdvanced.this.updateCanvasFunctions(exp, index);
                    ThresholdSimpleAdvanced.this.updateOverlaysThreshold();
                }
            }
        });
        this.fliesTransformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ThresholdSimpleAdvanced)ThresholdSimpleAdvanced.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && ThresholdSimpleAdvanced.this.viewButton2.isSelected()) {
                    int index = ThresholdSimpleAdvanced.this.fliesTransformsComboBox.getSelectedIndex();
                    Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
                    ThresholdSimpleAdvanced.this.updateTransformFunctions2OfCanvas(canvas);
                    if (!ThresholdSimpleAdvanced.this.viewButton2.isSelected()) {
                        ThresholdSimpleAdvanced.this.viewButton2.setSelected(true);
                    }
                    canvas.setTransformStep1Index(index + 1);
                    ThresholdSimpleAdvanced.this.updateOverlaysThreshold();
                }
            }
        });
        this.spotsDirectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThresholdSimpleAdvanced.this.updateOverlaysThreshold();
            }
        });
        this.fliesDirectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThresholdSimpleAdvanced.this.updateOverlaysThreshold();
            }
        });
        this.spotsThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ThresholdSimpleAdvanced.this.updateOverlaysThreshold();
            }
        });
        this.fliesThresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ThresholdSimpleAdvanced.this.updateOverlaysThreshold();
            }
        });
        this.viewButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ThresholdSimpleAdvanced)ThresholdSimpleAdvanced.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ThresholdSimpleAdvanced.this.displayTransform1(exp);
                    ThresholdSimpleAdvanced.this.displayOverlays(ThresholdSimpleAdvanced.this.viewButton1.isSelected(), exp);
                }
            }
        });
        this.viewButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = ((ThresholdSimpleAdvanced)ThresholdSimpleAdvanced.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ThresholdSimpleAdvanced.this.displayTransform2(exp);
                }
            }
        });
        this.detectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ThresholdSimpleAdvanced.this.detectButton.getText().equals(ThresholdSimpleAdvanced.this.detectString)) {
                    ThresholdSimpleAdvanced.this.startDetection();
                } else {
                    ThresholdSimpleAdvanced.this.stopDetection();
                }
            }
        });
    }

    void updateOverlaysThreshold() {
        ImageTransformEnums transform = ImageTransformEnums.NONE;
        boolean ifGreater = true;
        int threshold = 0;
        if (this.viewButton1.isSelected()) {
            transform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
            threshold = (Integer)this.spotsThresholdSpinner.getValue();
            ifGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        } else {
            transform = (ImageTransformEnums)((Object)this.fliesTransformsComboBox.getSelectedItem());
            threshold = (Integer)this.fliesThresholdSpinner.getValue();
            ifGreater = this.fliesDirectionComboBox.getSelectedIndex() == 0;
        }
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null && exp.seqCamData != null) {
            exp.seqCamData.updateOverlayThreshold(threshold, transform, ifGreater);
        }
    }

    AdvancedMemoryOptions createMemoryOptionsAccordingToUserSelection() {
        String selected;
        switch (selected = (String)this.memUseComboBox.getSelectedItem()) {
            case "conservative": {
                return AdvancedMemoryOptions.createConservative();
            }
            case "aggressive": {
                return AdvancedMemoryOptions.createAggressive();
            }
        }
        return AdvancedMemoryOptions.createBalanced();
    }

    void startDetection() {
        Experiment exp = this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            AdvancedMemoryOptions memOptions = new AdvancedMemoryOptions();
            AdvancedMemoryOptions.ValidationResult result = memOptions.validate();
            if (result.isValid()) {
                System.out.println("Custom configuration is valid");
                System.out.println(memOptions.getConfigurationSummary());
            } else {
                System.err.println("Configuration issues: " + result);
            }
            BuildSpotsMeasuresAdvanced processor = new BuildSpotsMeasuresAdvanced(memOptions);
            processor.options = this.initDetectOptions(exp);
            processor.addPropertyChangeListener(this);
            this.setProcessor(processor);
            processor.execute();
            this.detectButton.setText("STOP");
        }
    }

    private void stopDetection() {
        BuildSpotsMeasuresAdvanced processor = this.getProcessor();
        if (processor != null && !processor.stopFlag) {
            processor.stopFlag = true;
        }
    }

    private BuildSeriesOptions initDetectOptions(Experiment exp) {
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allSeriesCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.detectAllSeries = this.allSeriesCheckBox.isSelected();
        if (!this.allSeriesCheckBox.isSelected()) {
            options.seriesLast = options.seriesFirst;
        } else {
            options.seriesFirst = 0;
        }
        options.concurrentDisplay = false;
        options.transform01 = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        options.spotThresholdUp = this.spotsDirectionComboBox.getSelectedIndex() == 1;
        options.spotThreshold = (Integer)this.spotsThresholdSpinner.getValue();
        options.analyzePartOnly = false;
        options.overlayTransform = (ImageTransformEnums)((Object)this.spotsTransformsComboBox.getSelectedItem());
        options.overlayIfGreater = this.spotsDirectionComboBox.getSelectedIndex() == 1;
        options.overlayThreshold = (Integer)this.spotsThresholdSpinner.getValue();
        options.transform02 = (ImageTransformEnums)((Object)this.fliesTransformsComboBox.getSelectedItem());
        options.flyThreshold = (Integer)this.fliesThresholdSpinner.getValue();
        options.flyThresholdUp = this.fliesDirectionComboBox.getSelectedIndex() == 1;
        return options;
    }

    private void displayTransform2(Experiment exp) {
        if (this.viewButton2.isSelected()) {
            Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
            this.updateTransformFunctions2OfCanvas(canvas);
        } else {
            this.removeOverlays(exp);
            Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)exp.seqCamData.getSequence().getFirstViewer().getCanvas();
            canvas.setTransformStep1Index(0);
        }
    }

    private void displayOverlays(boolean displayOn, Experiment exp) {
        if (displayOn) {
            this.setOverlays(exp);
        } else {
            this.removeOverlays(exp);
        }
    }

    private void setOverlays(Experiment exp) {
        if (exp.seqCamData != null) {
            exp.seqCamData.updateOverlay();
        }
    }

    private void removeOverlays(Experiment exp) {
        if (exp.seqCamData != null) {
            exp.seqCamData.removeOverlay();
        }
    }

    private void updateCanvasFunctions(Experiment exp, int index) {
        if (exp.seqCamData != null) {
            this.updateCanvasFunction(exp.seqCamData, index);
        }
    }

    private void updateCanvasFunction(SequenceCamData seqCamData, int index) {
        Sequence sequence = seqCamData.getSequence();
        if (sequence == null) {
            return;
        }
        Viewer v = sequence.getFirstViewer();
        if (v == null) {
            return;
        }
        Canvas2D_3Transforms canvas = (Canvas2D_3Transforms)v.getCanvas();
        this.updateTransformFunctions1OfCanvas(canvas);
        canvas.setTransformStep1Index(index + 1);
    }

    private void displayTransform1(Experiment exp) {
        int index = this.spotsTransformsComboBox.getSelectedIndex();
        if (!this.viewButton1.isSelected()) {
            index = -1;
        }
        this.updateCanvasFunctions(exp, index);
    }

    private void updateTransformFunctions1OfCanvas(Canvas2D_3Transforms canvas) {
        if (canvas.getTransformStep1ItemCount() < this.spotsTransformsComboBox.getItemCount() + 1) {
            canvas.updateTransformsStep1(this.transforms);
        }
        int index = this.spotsTransformsComboBox.getSelectedIndex();
        canvas.setTransformStep1(index + 1, null);
    }

    private void updateTransformFunctions2OfCanvas(Canvas2D_3Transforms canvas) {
        if (canvas.getTransformStep1ItemCount() < this.fliesDirectionComboBox.getItemCount() + 1) {
            canvas.updateTransformsStep1(this.transforms);
        }
        int index = this.fliesDirectionComboBox.getSelectedIndex();
        canvas.setTransformStep1(index + 1, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.detectButton.setText(this.detectString);
            this.checkMemoryBeforeLoading();
            Experiment exp = this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                this.loadExperimentDataOptimized(exp);
                this.parent0.dlgMeasure.tabCharts.displayChartPanels(exp);
            }
            this.processorRef = null;
        }
    }

    private void checkMemoryBeforeLoading() {
        if (!this.vocalAboutMemory) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        double usagePercent = (double)usedMemory * 100.0 / (double)runtime.maxMemory();
        System.out.println("=== BEFORE EXPERIMENT LOADING ===");
        System.out.println("Memory Usage: " + usagePercent + "%");
        System.out.println("Used Memory: " + usedMemory / 1024L / 1024L + " MB");
        if (usagePercent > 50.0) {
            System.err.println("WARNING: High memory before loading experiment data!");
            System.err.println("Forcing cleanup before loading...");
            this.forcePreLoadingCleanup();
            usedMemory = runtime.totalMemory() - runtime.freeMemory();
            usagePercent = (double)usedMemory * 100.0 / (double)runtime.maxMemory();
            System.out.println("After cleanup: " + usagePercent + "%");
        }
    }

    private void forcePreLoadingCleanup() {
        if (this.vocalAboutMemory) {
            System.out.println("=== FORCING PRE-LOADING CLEANUP ===");
        }
        for (int i = 0; i < 3; ++i) {
            System.gc();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void loadExperimentDataOptimized(Experiment exp) {
        try {
            long startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            boolean success = exp.load_MS96_spotsMeasures();
            long endMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long memoryIncrease = endMemory - startMemory;
            if (memoryIncrease > 0x40000000L) {
                System.err.println("WARNING: Large memory increase during loading: " + memoryIncrease / 1024L / 1024L + " MB");
                System.err.println("Consider implementing streaming loading for large datasets");
            }
        }
        catch (Exception e) {
            System.err.println("Error during optimized experiment loading: " + e.getMessage());
            exp.load_MS96_spotsMeasures();
        }
    }
}

