/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment;

import icy.file.FileUtil;
import icy.gui.dialog.LoaderDialog;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import plugins.fmp.multiSPOTS96.tools.Directories;

public class ExperimentDirectories {
    private String cameraImagesDirectory = null;
    private String resultsDirectory = null;
    public List<String> cameraImagesList = null;

    public String getResultsDirectory() {
        return this.resultsDirectory;
    }

    public String getCameraImagesDirectory() {
        return this.cameraImagesDirectory;
    }

    public static List<String> keepOnlyAcceptedNames_List(List<String> namesList, String[] strExtension) {
        int count = namesList.size();
        ArrayList<String> outList = new ArrayList<String>(count);
        block0: for (String name : namesList) {
            for (int i = 0; i < strExtension.length; ++i) {
                String ext = strExtension[i].toLowerCase();
                String nameGeneric = FileUtil.getGenericPath((String)name);
                if (!nameGeneric.toLowerCase().endsWith(ext)) continue;
                outList.add(nameGeneric);
                continue block0;
            }
        }
        Collections.sort(outList);
        return outList;
    }

    private List<String> getImagesListFromPath(String strDirectory) {
        ArrayList<String> list = new ArrayList<String>();
        Path pathDir = Paths.get(strDirectory, new String[0]);
        if (Files.exists(pathDir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(pathDir);){
                for (Path entry : stream) {
                    String toAdd = FileUtil.getGenericPath((String)entry.toString());
                    list.add(toAdd);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static List<String> getImagesListFromPathV2(String dir, String extension) {
        List<String> list;
        block9: {
            if (!new File(dir).exists()) {
                return null;
            }
            Path pDir = Paths.get(dir, new String[0]).toAbsolutePath();
            Stream<Path> stream = Files.list(pDir);
            try {
                list = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).filter(s -> s.toString().endsWith(extension)).map(Path::toString).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            stream.close();
        }
        return list;
    }

    public List<String> getImagesListFromDialog(String strPath) {
        File[] selectedFiles;
        List<String> list = new ArrayList<String>();
        LoaderDialog dialog = new LoaderDialog(false);
        if (strPath != null) {
            dialog.setCurrentDirectory(new File(strPath));
        }
        if ((selectedFiles = dialog.getSelectedFiles()).length == 0) {
            return null;
        }
        String strDirectory = Directories.getDirectoryFromName(selectedFiles[0].toString());
        if (strDirectory != null && selectedFiles.length == 1) {
            list = this.getImagesListFromPath(strDirectory);
        }
        return list;
    }

    public boolean checkCameraImagesList() {
        boolean isOK = false;
        if (this.cameraImagesList != null) {
            boolean imageFound = false;
            String jpg = "jpg";
            String grabs = "grabs";
            String grabsDirectory = null;
            for (String name : this.cameraImagesList) {
                if (name.toLowerCase().endsWith(jpg)) {
                    imageFound = true;
                    break;
                }
                if (!name.toLowerCase().endsWith(grabs)) continue;
                grabsDirectory = name;
            }
            if (imageFound) {
                String[] ext = new String[]{"jpg"};
                this.cameraImagesList = ExperimentDirectories.keepOnlyAcceptedNames_List(this.cameraImagesList, ext);
                isOK = true;
            } else if (grabsDirectory != null) {
                this.cameraImagesList = this.getImagesListFromPath(grabsDirectory);
                isOK = this.checkCameraImagesList();
            }
        }
        return isOK;
    }

    public boolean getDirectoriesFromDialog(String expListBinSubDirectory, String rootDirectory, boolean createResults) {
        this.cameraImagesList = this.getImagesListFromDialog(rootDirectory);
        if (!this.checkCameraImagesList()) {
            return false;
        }
        this.cameraImagesDirectory = Directories.getDirectoryFromName(this.cameraImagesList.get(0));
        this.resultsDirectory = this.getResultsDirectoryDialog(this.cameraImagesDirectory, "results", createResults);
        return true;
    }

    public boolean getDirectoriesFromExptPath(String expListBinSubDirectory, String exptDirectory) {
        this.cameraImagesDirectory = ExperimentDirectories.getImagesDirectoryAsParentFromFileName(exptDirectory);
        this.cameraImagesList = ExperimentDirectories.getImagesListFromPathV2(this.cameraImagesDirectory, "jpg");
        this.resultsDirectory = this.getResultsDirectory(this.cameraImagesDirectory, exptDirectory);
        return true;
    }

    public boolean getDirectoriesFromGrabPath(String grabsDirectory) {
        this.cameraImagesList = ExperimentDirectories.getImagesListFromPathV2(grabsDirectory, "jpg");
        this.cameraImagesDirectory = grabsDirectory;
        this.resultsDirectory = this.getResultsDirectory(this.cameraImagesDirectory, "results");
        return true;
    }

    public static String getParentIf(String filename, String filter) {
        if (filename != null && filename.contains(filter)) {
            filename = Paths.get(filename, new String[0]).getParent().toString();
        }
        return filename;
    }

    public static String getImagesDirectoryAsParentFromFileName(String filename) {
        filename = ExperimentDirectories.getParentIf(filename, "bin_");
        filename = ExperimentDirectories.getParentIf(filename, "results");
        return filename;
    }

    private String getResultsDirectory(String parentDirectory, String resultsSubDirectory) {
        if (!(resultsSubDirectory = ExperimentDirectories.getParentIf(resultsSubDirectory, "bin_")).contains("results") || !resultsSubDirectory.contains(parentDirectory)) {
            resultsSubDirectory = parentDirectory + File.separator + "results";
        }
        return resultsSubDirectory;
    }

    private String getResultsDirectoryDialog(String parentDirectory, String filter, boolean createResults) {
        List<String> expList = Directories.fetchSubDirectoriesMatchingFilter(parentDirectory, filter);
        expList = Directories.reduceFullNameToLastDirectory(expList);
        String name = null;
        name = createResults || expList.size() > 1 ? this.selectSubDirDialog(expList, "Select item or type resultsxxx", "results", true) : (expList.size() == 1 ? expList.get(0) : filter);
        return parentDirectory + File.separator + name;
    }

    static void moveAndRename(String oldFileName, String oldDirectory, String newFileName, String newDirectory) {
        String oldFilePathString = oldDirectory + File.separator + oldFileName;
        File oldFile = new File(oldFilePathString);
        if (!oldFile.exists() || oldFile.isDirectory()) {
            return;
        }
        Path oldFilePath = Paths.get(oldFilePathString, new String[0]);
        String newFilePathString = newDirectory + File.separator + newFileName;
        Path newFilePath = Paths.get(newFilePathString, new String[0]);
        if (Files.exists(newFilePath, new LinkOption[0])) {
            newFilePath = Paths.get(newDirectory + File.separator + oldFileName, new String[0]);
        }
        try {
            Files.move(oldFilePath, newFilePath, new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String selectSubDirDialog(List<String> expList, String title, String type, boolean editable) {
        Object[] array = expList.toArray();
        JComboBox<Object> jcb = new JComboBox<Object>(array);
        jcb.setEditable(editable);
        JOptionPane.showMessageDialog(null, jcb, title, 3);
        return (String)jcb.getSelectedItem();
    }
}

