/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.cages;

import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import icy.util.XMLUtil;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS96.experiment.cages.CageProperties;
import plugins.fmp.multiSPOTS96.experiment.cages.FlyPosition;
import plugins.fmp.multiSPOTS96.experiment.cages.FlyPositions;
import plugins.fmp.multiSPOTS96.experiment.cages.ModernCage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotString;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSColumnHeader;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Cage
implements Comparable<Cage>,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(ModernCage.class.getName());
    private ROI2D cageROI2D = null;
    public int kymographIndex = -1;
    public BooleanMask2D cageMask2D = null;
    public CageProperties prop = new CageProperties();
    public FlyPositions flyPositions = new FlyPositions();
    public SpotsArray spotsArray = new SpotsArray();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    public boolean valid = false;
    public boolean bDetect = true;
    public boolean initialflyRemoved = false;
    private final String ID_CAGELIMITS = "CageLimits";
    private final String ID_FLYPOSITIONS = "FlyPositions";

    public Cage(ROI2DShape roi) {
        this.cageROI2D = roi;
    }

    public Cage() {
    }

    @Override
    public int compareTo(Cage o) {
        if (o != null) {
            return this.cageROI2D.getName().compareTo(o.cageROI2D.getName());
        }
        return 1;
    }

    public SpotsArray getSpotsArray() {
        return this.spotsArray;
    }

    public CageProperties getProperties() {
        return this.prop;
    }

    public ROI2D getRoi() {
        return this.cageROI2D;
    }

    public void setRoi(ROI2DShape roi) {
        this.cageROI2D = roi;
    }

    public String getCageNumberFromRoiName() {
        this.prop.setStrCageNumber(this.cageROI2D.getName().substring(this.cageROI2D.getName().length() - 3));
        return this.prop.getStrCageNumber();
    }

    public void clearMeasures() {
        this.flyPositions.clear();
    }

    public Point2D getCenterTopCage() {
        Rectangle2D rect = this.cageROI2D.getBounds2D();
        Point2D.Double pt = new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY());
        return pt;
    }

    public void copyCageInfo(Cage cageFrom) {
        this.copyCage(cageFrom, false);
    }

    public void copyCage(Cage cageFrom, boolean bMeasures) {
        this.prop.copy(cageFrom.prop);
        this.cageROI2D = (ROI2D)cageFrom.cageROI2D.getCopy();
        this.valid = false;
        if (bMeasures) {
            this.flyPositions.copyXYTaSeries(cageFrom.flyPositions);
        }
        this.spotsArray.copySpotsInfo(cageFrom.spotsArray);
    }

    public void pasteCageInfo(Cage cageTo) {
        this.prop.paste(cageTo.prop);
        cageTo.cageROI2D = (ROI2D)this.cageROI2D.getCopy();
        this.spotsArray.pasteSpotsInfo(cageTo.spotsArray);
    }

    public void pasteCage(Cage cageTo, boolean bMeasures) {
        this.prop.paste(cageTo.prop);
        cageTo.cageROI2D = (ROI2D)this.cageROI2D.getCopy();
        this.spotsArray.pasteSpots(cageTo.spotsArray, bMeasures);
        if (bMeasures) {
            this.flyPositions.copyXYTaSeries(cageTo.flyPositions);
        }
    }

    public String getField(EnumXLSColumnHeader fieldEnumCode) {
        String stringValue = null;
        switch (fieldEnumCode) {
            case CAGE_SEX: {
                stringValue = this.prop.getFlySex();
                break;
            }
            case CAGE_AGE: {
                stringValue = String.valueOf(this.prop.getFlyAge());
                break;
            }
            case CAGE_STRAIN: {
                stringValue = this.prop.getFlyStrain();
                break;
            }
        }
        return stringValue;
    }

    public void setField(EnumXLSColumnHeader fieldEnumCode, String stringValue) {
        switch (fieldEnumCode) {
            case CAGE_SEX: {
                this.prop.setFlySex(stringValue);
                break;
            }
            case CAGE_AGE: {
                int ageValue = Integer.valueOf(stringValue);
                this.prop.setFlyAge(ageValue);
                break;
            }
            case CAGE_STRAIN: {
                this.prop.setFlyStrain(stringValue);
                break;
            }
        }
    }

    public ROI2DRectangle getRoiRectangleFromPositionAtT(int t) {
        int nitems = this.flyPositions.flyPositionList.size();
        if (nitems == 0 || t >= nitems) {
            return null;
        }
        FlyPosition aValue = this.flyPositions.flyPositionList.get(t);
        ROI2DRectangle flyRoiR = new ROI2DRectangle(aValue.rectPosition);
        flyRoiR.setName("detR" + this.getCageNumberFromRoiName() + "_" + t);
        flyRoiR.setT(t);
        return flyRoiR;
    }

    public void transferRoisToPositions(List<ROI2D> detectedROIsList) {
        String filter = "detR" + this.getCageNumberFromRoiName();
        for (ROI2D roi : detectedROIsList) {
            String name = roi.getName();
            if (!name.contains(filter)) continue;
            Rectangle2D rect = ((ROI2DRectangle)roi).getRectangle();
            int t = roi.getT();
            this.flyPositions.flyPositionList.get((int)t).rectPosition = rect;
        }
    }

    public void computeCageBooleanMask2D() throws InterruptedException {
        this.cageMask2D = this.cageROI2D.getBooleanMask2D(0, 0, 1, true);
    }

    public boolean xmlLoadCage(Node node, int index) {
        long startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        try {
            if (node == null) {
                System.err.println("ERROR: Null node provided for cage " + index);
                return false;
            }
            Element xmlVal = XMLUtil.getElement((Node)node, (String)("Cage" + index));
            if (xmlVal == null) {
                System.err.println("ERROR: Could not find Cage" + index + " element");
                return false;
            }
            if (!this.xmlLoadCageLimits(xmlVal)) {
                System.err.println("ERROR: Failed to load cage limits for cage " + index);
                return false;
            }
            if (!this.prop.xmlLoadCageParameters(xmlVal)) {
                System.err.println("ERROR: Failed to load cage parameters for cage " + index);
                return false;
            }
            if (this.cageROI2D != null) {
                this.cageROI2D.setColor(this.prop.getColor());
            }
            if (!this.spotsArray.loadFromXml(xmlVal)) {
                System.err.println("ERROR: Failed to load spots array for cage " + index);
                return false;
            }
            long endMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long memoryIncrease = endMemory - startMemory;
            return true;
        }
        catch (Exception e) {
            System.err.println("ERROR loading cage " + index + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean xmlSaveCage(Node node, int index) {
        long startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        try {
            if (node == null) {
                System.err.println("ERROR: Null node provided for cage " + index);
                return false;
            }
            Element xmlVal = XMLUtil.addElement((Node)node, (String)("Cage" + index));
            if (xmlVal == null) {
                System.err.println("ERROR: Could not create Cage" + index + " element");
                return false;
            }
            if (!this.xmlSaveCageLimits(xmlVal)) {
                System.err.println("ERROR: Failed to save cage limits for cage " + index);
                return false;
            }
            if (!this.prop.xmlSaveCageParameters(xmlVal)) {
                System.err.println("ERROR: Failed to save cage parameters for cage " + index);
                return false;
            }
            if (!this.spotsArray.saveToXml(xmlVal)) {
                System.err.println("ERROR: Failed to save spots array for cage " + index);
                return false;
            }
            long endMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long memoryIncrease = endMemory - startMemory;
            return true;
        }
        catch (Exception e) {
            System.err.println("ERROR saving cage " + index + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean xmlLoadCageLimits(Element xmlVal) {
        try {
            Element xmlVal2 = XMLUtil.getElement((Node)xmlVal, (String)"CageLimits");
            if (xmlVal2 != null) {
                this.cageROI2D = (ROI2D)ROI.createFromXML((Node)xmlVal2);
                if (this.cageROI2D != null) {
                    this.cageROI2D.setSelected(false);
                } else {
                    System.err.println("WARNING: Failed to create ROI from XML for cage limits");
                }
            } else {
                System.err.println("WARNING: No cage limits found in XML");
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("ERROR loading cage limits: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean xmlSaveCageLimits(Element xmlVal) {
        try {
            Element xmlVal2 = XMLUtil.addElement((Node)xmlVal, (String)"CageLimits");
            if (this.cageROI2D != null) {
                this.cageROI2D.setSelected(false);
                this.cageROI2D.saveToXML((Node)xmlVal2);
            } else {
                System.err.println("WARNING: No cage ROI to save");
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("ERROR saving cage limits: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean xmlLoadFlyPositions(Element xmlVal) {
        Element xmlVal2 = XMLUtil.getElement((Node)xmlVal, (String)"FlyPositions");
        if (xmlVal2 != null) {
            this.flyPositions.loadXYTseriesFromXML(xmlVal2);
            return true;
        }
        return false;
    }

    public boolean xmlSaveFlyPositions(Element xmlVal) {
        Element xmlVal2 = XMLUtil.addElement((Node)xmlVal, (String)"FlyPositions");
        this.flyPositions.saveXYTseriesToXML(xmlVal2);
        return true;
    }

    public String csvExportCageDescription(String sep) {
        StringBuffer sbf = new StringBuffer();
        ArrayList<String> row = new ArrayList<String>();
        row.add(this.prop.getStrCageNumber());
        row.add(this.cageROI2D.getName());
        row.add(Integer.toString(this.prop.getCageNFlies()));
        row.add(Integer.toString(this.prop.getFlyAge()));
        row.add(this.prop.getComment());
        row.add(this.prop.getFlyStrain());
        row.add(this.prop.getFlySex());
        int npoints = 0;
        if (this.cageROI2D != null) {
            Polygon2D polygon = ((ROI2DPolygon)this.cageROI2D).getPolygon2D();
            row.add(Integer.toString(polygon.npoints));
            for (int i = 0; i < npoints; ++i) {
                row.add(Integer.toString((int)polygon.xpoints[i]));
                row.add(Integer.toString((int)polygon.ypoints[i]));
            }
        } else {
            row.add("0");
        }
        sbf.append(String.join((CharSequence)sep, row));
        sbf.append("\n");
        return sbf.toString();
    }

    public void setNFlies(int nFlies) {
        this.getProperties().setCageNFlies(nFlies);
    }

    public int addEllipseSpot(Point2D.Double center, int radius) {
        int index = this.spotsArray.getSpotsCount();
        Spot spot = this.createEllipseSpot(index, center, radius);
        spot.getProperties().setCagePosition(this.spotsArray.getSpotsCount());
        this.spotsArray.addSpot(spot);
        return this.spotsArray.getSpotsCount();
    }

    private Spot createEllipseSpot(int cagePosition, Point2D.Double center, int radius) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(center.x, center.y, 2 * radius, 2 * radius);
        ROI2DEllipse roiEllipse = new ROI2DEllipse((Ellipse2D)ellipse);
        roiEllipse.setName(SpotString.createSpotString(this.prop.getCageID(), cagePosition));
        Spot spot = new Spot((ROI2DShape)roiEllipse);
        spot.getProperties().setCageID(this.prop.getCageID());
        spot.getProperties().setCagePosition(cagePosition);
        spot.getProperties().setSpotRadius(radius);
        spot.getProperties().setSpotXCoord((int)center.getX());
        spot.getProperties().setSpotYCoord((int)center.getY());
        try {
            spot.getProperties().setSpotNPixels((int)roiEllipse.getNumberOfPoints());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return spot;
    }

    public Spot getSpotFromRoiName(String name) {
        int cagePosition = SpotString.getSpotCagePositionFromSpotName(name);
        for (Spot spot : this.spotsArray.getSpotsList()) {
            if (spot.getProperties().getCagePosition() != cagePosition) continue;
            return spot;
        }
        return null;
    }

    public void mapSpotsToCageColumnRow() {
        Rectangle rect = this.cageROI2D.getBounds();
        int deltaX = rect.width / 8;
        int deltaY = rect.height / 4;
        for (Spot spot : this.spotsArray.getSpotsList()) {
            Rectangle rectSpot = spot.getRoi().getBounds();
            spot.getProperties().setCageColumn((rectSpot.x - rect.x) / deltaX);
            spot.getProperties().setCageRow((rectSpot.y - rect.y) / deltaY);
        }
    }

    public void cleanUpSpotNames() {
        for (int i = 0; i < this.spotsArray.getSpotsList().size(); ++i) {
            Spot spot = this.spotsArray.getSpotsList().get(i);
            spot.setName(this.prop.getCageID(), i);
            spot.getProperties().setCageID(this.prop.getCageID());
            spot.getProperties().setCagePosition(i);
        }
    }

    public void updateSpotsStimulus_i() {
        ArrayList<String> stimulusArray = new ArrayList<String>(8);
        for (Spot spot : this.spotsArray.getSpotsList()) {
            String test = spot.getProperties().getStimulus();
            stimulusArray.add(test);
            spot.getProperties().setStimulusI(test + "_" + this.findNumberOfIdenticalItems(test, stimulusArray));
        }
    }

    private int findNumberOfIdenticalItems(String test, ArrayList<String> array) {
        int items = 0;
        for (String element : array) {
            if (!element.equals(test)) continue;
            ++items;
        }
        return items;
    }

    public Spot combineSpotsWithSameStimConc(String stim, String conc) {
        Spot spotCombined = null;
        for (Spot spotSource : this.spotsArray.getSpotsList()) {
            if (!stim.equals(spotSource.getProperties().getStimulus()) || !conc.equals(spotSource.getProperties().getConcentration())) continue;
            if (spotCombined == null) {
                spotCombined = new Spot(spotSource, true);
                continue;
            }
            spotCombined.addMeasurements(spotSource);
        }
        return spotCombined;
    }

    public void normalizeSpotMeasures() {
        for (Spot spot : this.spotsArray.getSpotsList()) {
            spot.normalizeMeasures();
        }
    }

    public Spot createSpotPI(Spot spot1, Spot spot2) {
        if (spot1 == null || spot2 == null) {
            return null;
        }
        Spot spotPI = new Spot();
        spotPI.getProperties().setCageID(spot1.getProperties().getCageID());
        spotPI.getProperties().setName("PI");
        spotPI.getProperties().setStimulus("PI");
        spotPI.getProperties().setConcentration(spot1.getCombinedStimulusConcentration() + " / " + spot2.getCombinedStimulusConcentration());
        spotPI.computePI(spot1, spot2);
        return spotPI;
    }

    public Spot createSpotSUM(Spot spot1, Spot spot2) {
        if (spot1 == null || spot2 == null) {
            return null;
        }
        Spot spotSUM = new Spot();
        spotSUM.getProperties().setCageID(spot1.getProperties().getCageID());
        spotSUM.getProperties().setName("SUM");
        spotSUM.getProperties().setStimulus("SUM");
        spotSUM.getProperties().setConcentration(spot1.getCombinedStimulusConcentration() + " / " + spot2.getCombinedStimulusConcentration());
        spotSUM.computeSUM(spot1, spot2);
        return spotSUM;
    }

    @Override
    public void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            LOGGER.fine("Closing cage: ");
            this.flyPositions.clear();
        }
    }
}

