/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.experiment.cages;

import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import plugins.fmp.multiSPOTS96.experiment.cages.CageData;
import plugins.fmp.multiSPOTS96.experiment.cages.CageOperationResult;
import plugins.fmp.multiSPOTS96.experiment.cages.CageProperties;
import plugins.fmp.multiSPOTS96.experiment.cages.FlyPositions;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotString;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotsArray;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DShape;

public final class ModernCage
implements Comparable<ModernCage>,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(ModernCage.class.getName());
    private final CageData data;
    private final FlyPositions flyPositions;
    private final SpotsArray spotsArray;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private ModernCage(Builder builder) {
        this.data = Objects.requireNonNull(builder.data, "CageData cannot be null");
        this.flyPositions = builder.flyPositions != null ? builder.flyPositions : new FlyPositions();
        this.spotsArray = builder.spotsArray != null ? builder.spotsArray : new SpotsArray();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModernCage createValid(ROI2D roi, CageProperties properties) {
        CageData cageData = CageData.createValid(roi, properties);
        return ModernCage.builder().withData(cageData).build();
    }

    public static ModernCage createInvalid(ROI2D roi, String reason) {
        CageData cageData = CageData.createInvalid(roi, reason);
        return ModernCage.builder().withData(cageData).build();
    }

    public CageData getData() {
        this.ensureNotClosed();
        return this.data;
    }

    public FlyPositions getFlyPositions() {
        this.ensureNotClosed();
        return this.flyPositions;
    }

    public SpotsArray getSpotsArray() {
        this.ensureNotClosed();
        return this.spotsArray;
    }

    public CageOperationResult addSpot(Point2D.Double center, int radius) {
        this.ensureNotClosed();
        long startTime = System.currentTimeMillis();
        try {
            if (center == null) {
                return CageOperationResult.failure("ADD_SPOT", new IllegalArgumentException("Center cannot be null"), "Invalid spot center");
            }
            if (radius <= 0) {
                return CageOperationResult.failure("ADD_SPOT", new IllegalArgumentException("Radius must be positive"), "Invalid spot radius: " + radius);
            }
            Spot spot = this.createEllipseSpot(this.spotsArray.getSpotsList().size(), center, radius);
            this.spotsArray.getSpotsList().add(spot);
            long processingTime = System.currentTimeMillis() - startTime;
            return CageOperationResult.success("ADD_SPOT", "Successfully added spot").toBuilder().processingTimeMs(processingTime).addMetadata("spotCount", this.spotsArray.getSpotsList().size()).addMetadata("spotRadius", radius).addMetadata("spotCenter", center).build();
        }
        catch (Exception e) {
            return CageOperationResult.failure("ADD_SPOT", e, "Unexpected error adding spot");
        }
    }

    public CageOperationResult computeMask() {
        this.ensureNotClosed();
        long startTime = System.currentTimeMillis();
        try {
            BooleanMask2D mask = this.data.getRoi().getBooleanMask2D(0, 0, 1, true);
            long processingTime = System.currentTimeMillis() - startTime;
            return CageOperationResult.success("COMPUTE_MASK", "Successfully computed cage mask").toBuilder().processingTimeMs(processingTime).addMetadata("maskPoints", mask.getNumberOfPoints()).build();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return CageOperationResult.failure("COMPUTE_MASK", e, "Mask computation was interrupted");
        }
        catch (Exception e) {
            return CageOperationResult.failure("COMPUTE_MASK", e, "Failed to compute mask: " + e.getMessage());
        }
    }

    public CageOperationResult clearMeasures() {
        this.ensureNotClosed();
        long startTime = System.currentTimeMillis();
        try {
            this.flyPositions.clear();
            long processingTime = System.currentTimeMillis() - startTime;
            return CageOperationResult.success("CLEAR_MEASURES", "Successfully cleared all measures").toBuilder().processingTimeMs(processingTime).build();
        }
        catch (Exception e) {
            return CageOperationResult.failure("CLEAR_MEASURES", e, "Failed to clear measures");
        }
    }

    public CageOperationResult validateCage() {
        this.ensureNotClosed();
        long startTime = System.currentTimeMillis();
        try {
            boolean isValid = true;
            StringBuilder issues = new StringBuilder();
            if (this.data.getRoi() == null) {
                isValid = false;
                issues.append("ROI is null; ");
            } else if (!this.data.hasValidBounds()) {
                isValid = false;
                issues.append("ROI bounds are invalid; ");
            }
            if (this.data.getProperties() == null) {
                isValid = false;
                issues.append("Properties are null; ");
            } else if (this.data.getProperties().getCageID() < 0) {
                isValid = false;
                issues.append("Cage ID is invalid; ");
            }
            String name = this.data.getName();
            if (name == null || name.trim().isEmpty()) {
                isValid = false;
                issues.append("Cage name is empty; ");
            }
            long processingTime = System.currentTimeMillis() - startTime;
            if (isValid) {
                return CageOperationResult.success("VALIDATE", "Cage validation passed").toBuilder().processingTimeMs(processingTime).addMetadata("cageName", name).addMetadata("cageID", this.data.getProperties().getCageID()).build();
            }
            return CageOperationResult.failure("VALIDATE", new IllegalStateException("Validation failed"), "Cage validation failed: " + issues.toString()).toBuilder().processingTimeMs(processingTime).build();
        }
        catch (Exception e) {
            return CageOperationResult.failure("VALIDATE", e, "Unexpected error during validation");
        }
    }

    @Override
    public int compareTo(ModernCage other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot compare with null cage");
        }
        return this.data.getName().compareTo(other.data.getName());
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            LOGGER.fine("Closing cage: " + this.data.getName());
            this.flyPositions.clear();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModernCage that = (ModernCage)obj;
        return Objects.equals(this.data.getName(), that.data.getName()) && Objects.equals(this.data.getProperties().getCageID(), that.data.getProperties().getCageID());
    }

    public int hashCode() {
        return Objects.hash(this.data.getName(), this.data.getProperties().getCageID());
    }

    public String toString() {
        return String.format("ModernCage{name='%s', id=%d, valid=%b, spots=%d}", this.data.getName(), this.data.getProperties().getCageID(), this.data.isValid(), this.spotsArray.getSpotsList().size());
    }

    private void ensureNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Cage is closed: " + this.data.getName());
        }
    }

    private Spot createEllipseSpot(int position, Point2D.Double center, int radius) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(center.x - (double)radius, center.y - (double)radius, 2 * radius, 2 * radius);
        ROI2DEllipse roiEllipse = new ROI2DEllipse((Ellipse2D)ellipse);
        roiEllipse.setName(SpotString.createSpotString(this.data.getProperties().getCageID(), position));
        Spot spot = new Spot((ROI2DShape)roiEllipse);
        spot.getProperties().setCageID(this.data.getProperties().getCageID());
        spot.getProperties().setCagePosition(position);
        spot.getProperties().setSpotRadius(radius);
        spot.getProperties().setSpotXCoord((int)center.getX());
        spot.getProperties().setSpotYCoord((int)center.getY());
        try {
            spot.getProperties().setSpotNPixels((int)roiEllipse.getNumberOfPoints());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warning("Interrupted while computing spot pixels for cage: " + this.data.getName());
            spot.getProperties().setSpotNPixels(0);
        }
        return spot;
    }

    public static class Builder {
        private CageData data;
        private FlyPositions flyPositions;
        private SpotsArray spotsArray;

        public Builder withData(CageData data) {
            this.data = data;
            return this;
        }

        public Builder withFlyPositions(FlyPositions flyPositions) {
            this.flyPositions = flyPositions;
            return this;
        }

        public Builder withSpotsArray(SpotsArray spotsArray) {
            this.spotsArray = spotsArray;
            return this;
        }

        public ModernCage build() {
            if (this.data == null) {
                throw new IllegalArgumentException("CageData is required");
            }
            return new ModernCage(this);
        }
    }
}

