/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.type.DataType;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ImageMemoryPool {
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int MAX_POOL_SIZE = 50;
    private static final long POOL_CLEANUP_INTERVAL_MS = 30000L;
    private final ConcurrentLinkedQueue<IcyBufferedImage> imagePool = new ConcurrentLinkedQueue();
    private final AtomicInteger totalImagesCreated = new AtomicInteger(0);
    private final AtomicInteger totalImagesReused = new AtomicInteger(0);
    private final AtomicLong totalMemorySaved = new AtomicLong(0L);
    private int imageWidth = -1;
    private int imageHeight = -1;
    private int imageChannels = -1;
    private DataType dataType = null;
    private volatile boolean poolEnabled = true;
    private volatile long lastCleanupTime = System.currentTimeMillis();
    private volatile boolean initialized = false;

    public void initializeWithImage(IcyBufferedImage templateImage) {
        if (templateImage == null) {
            System.err.println("ERROR: Cannot initialize pool with null image");
            return;
        }
        this.imageWidth = templateImage.getSizeX();
        this.imageHeight = templateImage.getSizeY();
        this.imageChannels = templateImage.getSizeC();
        this.dataType = templateImage.getDataType_();
        this.initialized = true;
    }

    private void initializePool() {
        for (int i = 0; i < 10; ++i) {
            IcyBufferedImage pooledImage = this.createNewImage();
            if (pooledImage == null) continue;
            this.imagePool.offer(pooledImage);
            this.totalImagesCreated.incrementAndGet();
        }
    }

    public IcyBufferedImage getImage() {
        if (!this.poolEnabled || !this.initialized) {
            return null;
        }
        IcyBufferedImage image = this.imagePool.poll();
        if (image != null) {
            this.totalImagesReused.incrementAndGet();
            this.resetImage(image);
            return image;
        }
        IcyBufferedImage newImage = this.createNewImage();
        if (newImage != null) {
            this.totalImagesCreated.incrementAndGet();
        }
        return newImage;
    }

    public void returnImage(IcyBufferedImage image) {
        if (!this.poolEnabled || image == null) {
            return;
        }
        if (this.imagePool.size() < 50) {
            this.clearImageData(image);
            this.imagePool.offer(image);
        }
    }

    public IcyBufferedImageCursor createCursor(IcyBufferedImage image) {
        if (image == null) {
            return null;
        }
        return new IcyBufferedImageCursor(image);
    }

    private IcyBufferedImage createNewImage() {
        if (!this.initialized) {
            System.err.println("ERROR: Cannot create image - pool not initialized");
            return null;
        }
        try {
            IcyBufferedImage image = new IcyBufferedImage(this.imageWidth, this.imageHeight, this.imageChannels, this.dataType);
            return image;
        }
        catch (Exception e) {
            System.err.println("ERROR creating pooled image: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void resetImage(IcyBufferedImage image) {
        if (image != null) {
            try {
                image.setDataXY(0, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearImageData(IcyBufferedImage image) {
        if (image != null) {
            try {
                image.setDataXY(0, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void performPeriodicCleanup() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCleanupTime > 30000L) {
            this.cleanupPool();
            this.lastCleanupTime = currentTime;
        }
    }

    private void cleanupPool() {
        int targetSize = Math.max(5, 5);
        while (this.imagePool.size() > targetSize) {
            IcyBufferedImage image = this.imagePool.poll();
            if (image == null) continue;
            this.clearImageData(image);
        }
    }

    public void clearPool() {
        IcyBufferedImage image;
        while ((image = this.imagePool.poll()) != null) {
            this.clearImageData(image);
        }
    }

    public void setPoolEnabled(boolean enabled) {
        this.poolEnabled = enabled;
        if (!enabled) {
            this.clearPool();
        }
    }

    public String getPoolStatistics() {
        if (!this.initialized) {
            return "Image Pool: Not initialized yet";
        }
        return String.format("Image Pool: %d/%d images, %d created, %d reused", this.imagePool.size(), 50, this.totalImagesCreated.get(), this.totalImagesReused.get());
    }

    public String getMemoryStatistics() {
        if (!this.initialized) {
            return "Pool Memory: Not initialized yet";
        }
        int bytesPerPixel = 1;
        if (this.dataType != null) {
            switch (this.dataType.toString()) {
                case "UINT16": {
                    bytesPerPixel = 2;
                    break;
                }
                case "FLOAT": 
                case "INT32": {
                    bytesPerPixel = 4;
                    break;
                }
                case "DOUBLE": {
                    bytesPerPixel = 8;
                    break;
                }
                default: {
                    bytesPerPixel = 1;
                }
            }
        }
        long imageMemory = (long)this.imageWidth * (long)this.imageHeight * (long)this.imageChannels * (long)bytesPerPixel;
        long totalPooledMemory = imageMemory * (long)this.imagePool.size();
        return String.format("Pool Memory: %d images \u00d7 %d bytes = %d MB | Estimated Memory Saved: %d MB", this.imagePool.size(), imageMemory, totalPooledMemory / 1024L / 1024L, this.totalMemorySaved.get() / 1024L / 1024L);
    }

    public int getPoolSize() {
        return this.imagePool.size();
    }
}

