/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.series;

import icy.image.IcyBufferedImage;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import plugins.fmp.multiSPOTS96.experiment.sequence.SequenceCamData;
import plugins.fmp.multiSPOTS96.series.MemoryMonitor;

public class StreamingImageProcessor {
    private final ArrayList<String> imageFiles = new ArrayList();
    private final MemoryMonitor memoryMonitor;

    public StreamingImageProcessor(MemoryMonitor memoryMonitor) {
        this.memoryMonitor = memoryMonitor;
    }

    public void start(SequenceCamData seqCamData, int startFrame, int endFrame) {
        for (int i = startFrame; i < endFrame; ++i) {
            String fileName = seqCamData.getFileNameFromImageList(i);
            if (fileName == null) continue;
            this.imageFiles.add(fileName);
        }
    }

    public void stop() {
        this.clearAllImages();
    }

    public void clearAllImages() {
    }

    public IcyBufferedImage getImage(int frameIndex) {
        String fileName = this.imageFiles.get(frameIndex);
        if (fileName == null) {
            System.err.println("No filename found for frame " + frameIndex);
            return null;
        }
        return this.imageIORead(fileName);
    }

    private IcyBufferedImage imageIORead(String fileName) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(fileName));
        }
        catch (IOException e) {
            System.err.println("Error loading image: " + fileName + " - " + e.getMessage());
            return null;
        }
        return IcyBufferedImage.createFrom((BufferedImage)image);
    }
}

