/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Directories {
    private static final Logger LOGGER = Logger.getLogger(Directories.class.getName());
    private static final int DEFAULT_DEPTH = 1;
    private static final int MIN_DIR_NAME_LENGTH = 4;
    private static final String TIFF_EXTENSION = ".tiff";
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = String.CASE_INSENSITIVE_ORDER;

    public static List<String> reduceFullNameToLastDirectory(List<String> dirList) {
        if (dirList == null) {
            throw new IllegalArgumentException("Directory list cannot be null");
        }
        ArrayList<String> shortList = new ArrayList<String>(dirList.size());
        for (String name : dirList) {
            Path pathName;
            if (name == null || name.trim().isEmpty() || (pathName = Paths.get(name, new String[0])).getNameCount() <= 0) continue;
            shortList.add(pathName.getName(pathName.getNameCount() - 1).toString());
        }
        Collections.sort(shortList, CASE_INSENSITIVE_COMPARATOR);
        LOGGER.fine("Reduced " + dirList.size() + " full paths to " + shortList.size() + " short names");
        return shortList;
    }

    public static HashSet<String> getDirectoriesWithFilesType(String rootDirectory, String filter) {
        if (rootDirectory == null) {
            throw new IllegalArgumentException("Root directory cannot be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        HashSet<String> hSet = new HashSet<String>();
        try {
            Path rootPath = Paths.get(rootDirectory, new String[0]);
            if (Files.exists(rootPath, new LinkOption[0])) {
                Files.walk(rootPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().toLowerCase().endsWith(filter.toLowerCase())).forEach(p -> hSet.add(p.toFile().getParent().toString()));
            } else {
                LOGGER.warning("Root directory does not exist: " + rootDirectory);
            }
        }
        catch (IOException e) {
            LOGGER.severe("Error accessing directory " + rootDirectory + ": " + e.getMessage());
        }
        return hSet;
    }

    public static List<String> fetchSubDirectoriesMatchingFilter(String directory, String filter) {
        if (directory == null) {
            throw new IllegalArgumentException("Directory cannot be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        List<Path> subfolders = Directories.getAllSubPathsOfDirectory(directory, 1);
        if (subfolders == null) {
            LOGGER.warning("No subdirectories found in " + directory);
            return null;
        }
        List<String> dirList = Directories.getPathsContainingString(subfolders, filter);
        if (dirList != null) {
            Collections.sort(dirList, CASE_INSENSITIVE_COMPARATOR);
        }
        return dirList;
    }

    public static List<String> getPathsContainingString(List<Path> subfolders, String filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        if (subfolders == null) {
            LOGGER.warning("Subfolders list is null");
            return null;
        }
        HashSet<String> dirList = new HashSet<String>();
        for (Path dirPath : subfolders) {
            String subString;
            if (dirPath == null || !(subString = dirPath.toString()).contains(filter)) continue;
            dirList.add(subString);
        }
        ArrayList<String> result = new ArrayList<String>(dirList);
        return result;
    }

    public static List<Path> getAllSubPathsOfDirectory(String directory, int depth) {
        if (directory == null) {
            throw new IllegalArgumentException("Directory cannot be null");
        }
        if (depth < 0) {
            throw new IllegalArgumentException("Depth cannot be negative: " + depth);
        }
        Path pathExperimentDir = Paths.get(directory, new String[0]);
        List<Path> subfolders = null;
        try {
            if (Files.exists(pathExperimentDir, new LinkOption[0])) {
                subfolders = Files.walk(pathExperimentDir, depth, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
                if (subfolders != null && !subfolders.isEmpty()) {
                    subfolders.remove(0);
                }
                LOGGER.fine("Found " + (subfolders != null ? subfolders.size() : 0) + " subdirectories in " + directory);
            } else {
                LOGGER.warning("Directory does not exist: " + directory);
            }
        }
        catch (IOException e) {
            LOGGER.severe("Error accessing directory " + directory + ": " + e.getMessage());
        }
        return subfolders;
    }

    public static String getDirectoryFromName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("File name cannot be null");
        }
        File filepath = new File(fileName);
        String strDirectory = filepath.isDirectory() ? filepath.getAbsolutePath() : filepath.getParentFile().getAbsolutePath();
        return strDirectory;
    }

    public static List<String> getSortedListOfSubDirectoriesWithTIFF(String parentDirectory) {
        if (parentDirectory == null) {
            throw new IllegalArgumentException("Parent directory cannot be null");
        }
        HashSet<String> hSet = Directories.getDirectoriesWithFilesType(parentDirectory, TIFF_EXTENSION);
        List<String> list = Directories.reduceFullNameToLastDirectory(new ArrayList<String>(hSet));
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int number2;
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 == null) {
                    return 1;
                }
                if (s2 == null) {
                    return -1;
                }
                if (s1.equalsIgnoreCase(s2)) {
                    return 0;
                }
                if (s1.length() < 4 || s2.length() < 4) {
                    return s1.compareToIgnoreCase(s2);
                }
                String tokens1 = s1.substring(4);
                String tokens2 = s2.substring(4);
                if (!Directories.isInteger(tokens1) || !Directories.isInteger(tokens2)) {
                    return tokens1.compareToIgnoreCase(tokens2);
                }
                int number1 = Integer.parseInt(tokens1);
                if (number1 != (number2 = Integer.parseInt(tokens2))) {
                    return number1 - number2;
                }
                return tokens1.compareToIgnoreCase(tokens2);
            }
        });
        return list;
    }

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void deleteFilesWithExtension(String directory, String filter) {
        if (directory == null) {
            throw new IllegalArgumentException("Directory cannot be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        File folder = new File(directory);
        if (!folder.exists() || !folder.isDirectory()) {
            LOGGER.warning("Directory does not exist or is not a directory: " + directory);
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            LOGGER.warning("Cannot list files in directory: " + directory);
            return;
        }
        for (File file : files) {
            String name;
            if (file == null || !file.isFile() || !(name = file.getName()).toLowerCase().endsWith(filter.toLowerCase()) || file.delete()) continue;
            LOGGER.warning("Failed to delete file: " + file.getAbsolutePath());
        }
    }
}

