/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.ROI2D;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import java.awt.geom.Point2D;
import java.util.List;
import plugins.fmp.multiSPOTS96.tools.ROI2D.ROI2DValidationException;

public final class ROI2DValidator {
    private ROI2DValidator() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static void validateNotNull(ROI roi, String parameterName) throws ROI2DValidationException {
        if (roi == null) {
            throw new ROI2DValidationException(parameterName, (Object)null, "ROI cannot be null");
        }
    }

    public static void validateNotNull(Sequence sequence, String parameterName) throws ROI2DValidationException {
        if (sequence == null) {
            throw new ROI2DValidationException(parameterName, (Object)null, "Sequence cannot be null");
        }
    }

    public static void validateNotNull(Polygon2D polygon, String parameterName) throws ROI2DValidationException {
        if (polygon == null) {
            throw new ROI2DValidationException(parameterName, (Object)null, "Polygon cannot be null");
        }
    }

    public static void validateNotNullOrEmpty(List<Point2D> points, String parameterName) throws ROI2DValidationException {
        if (points == null) {
            throw new ROI2DValidationException(parameterName, (Object)null, "Points list cannot be null");
        }
        if (points.isEmpty()) {
            throw new ROI2DValidationException(parameterName, points.size(), "Points list cannot be empty");
        }
    }

    public static void validatePolygonSides(Polygon2D polygon, int requiredSides, String parameterName) throws ROI2DValidationException {
        ROI2DValidator.validateNotNull(polygon, parameterName);
        if (polygon.npoints != requiredSides) {
            throw new ROI2DValidationException(parameterName, polygon.npoints, String.format("Polygon must be %d-sided, but has %d sides", requiredSides, polygon.npoints));
        }
    }

    public static void validateGridDimensions(int columns, int rows) throws ROI2DValidationException {
        if (columns < 1 || columns > 1000) {
            throw new ROI2DValidationException("columns", columns, String.format("Must be between %d and %d", 1, 1000));
        }
        if (rows < 1 || rows > 1000) {
            throw new ROI2DValidationException("rows", rows, String.format("Must be between %d and %d", 1, 1000));
        }
    }

    public static void validateEllipsePoints(int pointCount, String parameterName) throws ROI2DValidationException {
        if (pointCount < 4) {
            throw new ROI2DValidationException(parameterName, pointCount, String.format("At least %d points required for ellipse fitting, but only %d provided", 4, pointCount));
        }
    }

    public static void validateThreshold(int threshold, String parameterName) throws ROI2DValidationException {
        if (threshold < 0 || threshold > 255) {
            throw new ROI2DValidationException(parameterName, threshold, String.format("Threshold must be between %d and %d, but was %d", 0, 255, threshold));
        }
    }

    public static void validatePositiveScaleFactor(double scaleFactor, String parameterName) throws ROI2DValidationException {
        if (scaleFactor <= 0.0) {
            throw new ROI2DValidationException(parameterName, scaleFactor, String.format("Scale factor must be positive, but was %f", scaleFactor));
        }
    }

    public static void validateInterpolationIntervals(int intervals, String parameterName) throws ROI2DValidationException {
        if (intervals < 1) {
            throw new ROI2DValidationException(parameterName, intervals, String.format("Must be at least %d", 1));
        }
    }

    public static void validateArrayIndex(int index, int arrayLength, String parameterName) throws ROI2DValidationException {
        if (index < 0 || index >= arrayLength) {
            throw new ROI2DValidationException(parameterName, index, String.format("Array index %d is out of bounds for array of length %d", index, arrayLength));
        }
    }

    public static void validateROI2D(ROI roi, String parameterName) throws ROI2DValidationException {
        ROI2DValidator.validateNotNull(roi, parameterName);
        if (!(roi instanceof ROI2D)) {
            throw new ROI2DValidationException(parameterName, (Object)roi.getClass().getSimpleName(), String.format("Unsupported ROI type for operation: %s", roi.getClass().getSimpleName()));
        }
    }
}

