/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools;

import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import java.util.logging.Logger;

public class ViewerFMP
extends Viewer {
    private static final Logger LOGGER = Logger.getLogger(ViewerFMP.class.getName());
    private boolean inhibitRefreshViewerTitle = false;

    public ViewerFMP(Sequence sequence, boolean visible, boolean inhibit) {
        super(sequence, visible);
        if (sequence == null) {
            throw new IllegalArgumentException("Sequence cannot be null");
        }
        this.inhibitRefreshViewerTitle = inhibit;
    }

    public void refreshViewerTitle() {
        if (!this.inhibitRefreshViewerTitle) {
            super.refreshViewerTitle();
        }
    }

    public void setInhibitRefreshViewerTitle(boolean inhibit) {
        this.inhibitRefreshViewerTitle = inhibit;
    }

    public boolean isInhibitRefreshViewerTitle() {
        return this.inhibitRefreshViewerTitle;
    }

    public void performWithoutTitleRefresh(Runnable operation) throws Exception {
        if (operation == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        boolean originalInhibit = this.inhibitRefreshViewerTitle;
        try {
            this.inhibitRefreshViewerTitle = true;
            operation.run();
        }
        finally {
            this.inhibitRefreshViewerTitle = originalInhibit;
        }
    }

    public String toString() {
        return String.format("ViewerFMP[inhibitRefresh=%s, visible=%s]", this.inhibitRefreshViewerTitle, this.isVisible());
    }
}

