/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.logging.Logger;
import org.jfree.chart.ChartColor;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.cages.CageProperties;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.experiment.spots.SpotMeasure;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;

public class ChartCageBuild {
    private static final Logger LOGGER = Logger.getLogger(ChartCageBuild.class.getName());
    private static final float DEFAULT_STROKE_WIDTH = 0.5f;
    private static final float[] DASH_PATTERN = new float[]{2.0f, 4.0f};
    private static final float DASH_PHASE = 0.0f;
    private static final Color BACKGROUND_WITH_DATA = Color.WHITE;
    private static final Color BACKGROUND_WITHOUT_DATA = Color.LIGHT_GRAY;
    private static final Color GRID_WITH_DATA = Color.GRAY;
    private static final Color GRID_WITHOUT_DATA = Color.WHITE;
    private static final String SECONDARY_DATA_TOKEN = "*";
    private static final String DESCRIPTION_DELIMITER = ":";
    private static boolean flagMaxMinSet = false;
    private static double globalYMax = 0.0;
    private static double globalYMin = 0.0;
    private static double globalXMax = 0.0;
    private static double ymax = 0.0;
    private static double ymin = 0.0;
    private static double xmax = 0.0;

    public static void initMaxMin() {
        ymax = 0.0;
        ymin = 0.0;
        xmax = 0.0;
        flagMaxMinSet = false;
        globalYMax = 0.0;
        globalYMin = 0.0;
        globalXMax = 0.0;
    }

    public static XYPlot buildXYPlot(XYSeriesCollection xySeriesCollection, NumberAxis xAxis, NumberAxis yAxis) {
        if (xySeriesCollection == null) {
            throw new IllegalArgumentException("XYSeriesCollection cannot be null");
        }
        if (xAxis == null) {
            throw new IllegalArgumentException("X-axis cannot be null");
        }
        if (yAxis == null) {
            throw new IllegalArgumentException("Y-axis cannot be null");
        }
        XYLineAndShapeRenderer subPlotRenderer = ChartCageBuild.getSubPlotRenderer(xySeriesCollection);
        XYPlot xyPlot = new XYPlot((XYDataset)xySeriesCollection, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)subPlotRenderer);
        ChartCageBuild.updatePlotBackgroundAccordingToNFlies(xySeriesCollection, xyPlot);
        return xyPlot;
    }

    private static void updatePlotBackgroundAccordingToNFlies(XYSeriesCollection xySeriesCollection, XYPlot xyPlot) {
        int nFlies = ChartCageBuild.getNFliesFromxySeriesCollectionDescription(xySeriesCollection);
        ChartCageBuild.setXYPlotBackGroundAccordingToNFlies(xyPlot, nFlies);
    }

    private static int getNFliesFromxySeriesCollectionDescription(XYSeriesCollection xySeriesCollection) {
        int nFlies = -1;
        if (xySeriesCollection == null || xySeriesCollection.getSeriesCount() == 0) {
            LOGGER.warning("Cannot update plot background: dataset is null or empty");
            return nFlies;
        }
        try {
            String[] description = xySeriesCollection.getSeries(0).getDescription().split(DESCRIPTION_DELIMITER);
            if (description.length < 6) {
                LOGGER.warning("Invalid series description format, using default background");
                return nFlies;
            }
            nFlies = Integer.parseInt(description[5]);
        }
        catch (NumberFormatException e) {
            LOGGER.warning("Could not parse number of flies from description: " + e.getMessage());
        }
        return nFlies;
    }

    private static void setXYPlotBackGroundAccordingToNFlies(XYPlot xyPlot, int nFlies) {
        if (nFlies > 0) {
            xyPlot.setBackgroundPaint((Paint)BACKGROUND_WITH_DATA);
            xyPlot.setDomainGridlinePaint((Paint)GRID_WITH_DATA);
            xyPlot.setRangeGridlinePaint((Paint)GRID_WITH_DATA);
        } else {
            xyPlot.setBackgroundPaint((Paint)BACKGROUND_WITHOUT_DATA);
            xyPlot.setDomainGridlinePaint((Paint)GRID_WITHOUT_DATA);
            xyPlot.setRangeGridlinePaint((Paint)GRID_WITHOUT_DATA);
        }
    }

    static XYSeriesCollection getSpotDataDirectlyFromOneCage(Experiment exp, Cage cage, XLSExportOptions xlsExportOptions) {
        if (cage == null || cage.spotsArray == null || cage.spotsArray.getSpotsCount() < 1) {
            LOGGER.warning("Cannot get spot data: spot array is empty or cage is null");
            return new XYSeriesCollection();
        }
        XYSeriesCollection xySeriesCollection = null;
        for (Spot spot : cage.spotsArray.getSpotsList()) {
            XYSeries seriesXY;
            if (xySeriesCollection == null) {
                xySeriesCollection = new XYSeriesCollection();
            }
            if ((seriesXY = ChartCageBuild.createXYSeriesFromSpotMeasure(exp, spot, xlsExportOptions)) == null) continue;
            seriesXY.setDescription(ChartCageBuild.buildSeriesDescriptionFromCageAndSpot(cage, spot));
            xySeriesCollection.addSeries(seriesXY);
            ChartCageBuild.updateGlobalMaxMin();
        }
        return xySeriesCollection;
    }

    private static String buildSeriesDescriptionFromCageAndSpot(Cage cage, Spot spot) {
        CageProperties cageProp = cage.getProperties();
        Color color = spot.getProperties().getColor();
        return "ID:" + cageProp.getCageID() + ":Pos:" + cageProp.getCagePosition() + ":nflies:" + cageProp.getCageNFlies() + ":R:" + color.getRed() + ":G:" + color.getGreen() + ":B:" + color.getBlue();
    }

    private static XYSeries createXYSeriesFromSpotMeasure(Experiment exp, Spot spot, XLSExportOptions xlsExportOptions) {
        XYSeries seriesXY = new XYSeries((Comparable)((Object)spot.getName()), false);
        if (exp.seqCamData.getTimeManager().getCamImagesTime_Ms() == null) {
            exp.seqCamData.build_MsTimesArray_From_FileNamesList();
        }
        double[] camImages_time_min = exp.seqCamData.getTimeManager().getCamImagesTime_Minutes();
        SpotMeasure spotMeasure = spot.getMeasurements(xlsExportOptions.exportType);
        double divider = 1.0;
        if (xlsExportOptions.relativeToT0 && xlsExportOptions.exportType != EnumXLSExport.AREA_FLYPRESENT) {
            divider = spotMeasure.getMaximumValue();
        }
        int npoints = spotMeasure.getCount();
        for (int j = 0; j < npoints; ++j) {
            double x = camImages_time_min[j];
            double y = spotMeasure.getValueAt(j) / divider;
            seriesXY.add(x, y);
            if (ymax < y) {
                ymax = y;
            }
            if (ymin > y) {
                ymin = y;
            }
            x += 1.0;
        }
        return seriesXY;
    }

    private static void updateGlobalMaxMin() {
        if (!flagMaxMinSet) {
            globalYMax = ymax;
            globalYMin = ymin;
            globalXMax = xmax;
            flagMaxMinSet = true;
        } else {
            if (globalYMax < ymax) {
                globalYMax = ymax;
            }
            if (globalYMin > ymin) {
                globalYMin = ymin;
            }
            if (globalXMax < xmax) {
                globalXMax = xmax;
            }
        }
    }

    private static XYLineAndShapeRenderer getSubPlotRenderer(XYSeriesCollection xySeriesCollection) {
        if (xySeriesCollection == null) {
            LOGGER.warning("Cannot create renderer: dataset is null");
            return null;
        }
        XYLineAndShapeRenderer subPlotRenderer = new XYLineAndShapeRenderer(true, false);
        BasicStroke stroke = new BasicStroke(0.5f, 1, 1, 1.0f, DASH_PATTERN, 0.0f);
        for (int i = 0; i < xySeriesCollection.getSeriesCount(); ++i) {
            try {
                String[] description = xySeriesCollection.getSeries(i).getDescription().split(DESCRIPTION_DELIMITER);
                if (description.length >= 12) {
                    int r = Integer.parseInt(description[7]);
                    int g = Integer.parseInt(description[9]);
                    int b = Integer.parseInt(description[11]);
                    subPlotRenderer.setSeriesPaint(i, (Paint)new ChartColor(r, g, b));
                    String key = (String)((Object)xySeriesCollection.getSeriesKey(i));
                    if (key == null || !key.contains(SECONDARY_DATA_TOKEN)) continue;
                    subPlotRenderer.setSeriesStroke(i, (Stroke)stroke);
                    continue;
                }
                LOGGER.warning("Invalid description format for series " + i + ", using default color");
                subPlotRenderer.setSeriesPaint(i, (Paint)ChartColor.BLACK);
                continue;
            }
            catch (NumberFormatException e) {
                LOGGER.warning("Could not parse color values for series " + i + ": " + e.getMessage());
                subPlotRenderer.setSeriesPaint(i, (Paint)ChartColor.BLACK);
            }
        }
        return subPlotRenderer;
    }

    public double getGlobalYMax() {
        return globalYMax;
    }

    public double getGlobalYMin() {
        return globalYMin;
    }

    public double getGlobalXMax() {
        return globalXMax;
    }

    public boolean isGlobalMaxMinSet() {
        return flagMaxMinSet;
    }
}

