/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.toExcel;

import icy.gui.frame.progress.ProgressFrame;
import java.awt.Point;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumColumnType;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLS_QColumnHeader;
import plugins.fmp.multiSPOTS96.tools.toExcel.ExcelResourceManager;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportMeasuresFromSpot;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSResults;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSUtils;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelDataException;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelExportException;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelResourceException;

public class XLSExportMeasuresCagesAsQuery
extends XLSExportMeasuresFromSpot {
    ArrayList<EnumXLS_QColumnHeader> headers = new ArrayList();

    public void exportQToFile(String filename, XLSExportOptions options) throws ExcelExportException {
        System.out.println("XLSExportBase:exportQToFile() - start output");
        this.options = options;
        this.expList = options.expList;
        try (ExcelResourceManager resourceManager = new ExcelResourceManager(filename);){
            this.resourceManager = resourceManager;
            this.redCellStyle = resourceManager.getRedCellStyle();
            this.blueCellStyle = resourceManager.getBlueCellStyle();
            this.prepareQExperiments();
            this.validateExportParameters();
            this.executeExportQ();
            resourceManager.saveAndClose();
        }
        catch (ExcelResourceException e) {
            throw new ExcelExportException("Resource management failed during export", "export_to_file", filename, e);
        }
        catch (Exception e) {
            throw new ExcelExportException("Unexpected error during export", "export_to_file", filename, e);
        }
        finally {
            this.cleanup();
        }
        System.out.println("XLSExport:exportToFile() - XLS output finished");
    }

    protected void executeExportQ() throws ExcelExportException {
        int nbexpts = this.expList.getItemCount();
        this.initHeadersArray();
        try (ProgressFrame progress = new ProgressFrame("Export data to Excel");){
            progress.setLength((double)nbexpts);
            int column = 1;
            int iSeries = 0;
            for (int index = this.options.experimentIndexFirst; index <= this.options.experimentIndexLast; ++index) {
                Experiment exp = this.expList.getItemAt(index);
                exp.load_MS96_spotsMeasures();
                progress.setMessage("Export experiment " + (index + 1) + " of " + nbexpts);
                System.out.println("Export experiment " + (index + 1) + " of " + nbexpts);
                String seriesIdentifier = CellReference.convertNumToColString((int)iSeries);
                column = this.exportExperimentData(exp, this.options, column, seriesIdentifier);
                ++iSeries;
                progress.incPosition();
            }
            progress.setMessage("Save Excel file to disk... ");
        }
    }

    protected void prepareQExperiments() throws ExcelDataException {
        try {
            this.expList.loadListOfMeasuresFromAllExperiments(true, this.options.onlyalive);
        }
        catch (Exception e) {
            throw new ExcelDataException("Failed to prepare experiments for export", "prepare_experiments", "experiment_loading", e);
        }
    }

    private void initHeadersArray() {
        this.headers.add(EnumXLS_QColumnHeader.DATE);
        this.headers.add(EnumXLS_QColumnHeader.EXP_BOXID);
        this.headers.add(EnumXLS_QColumnHeader.EXP_EXPT);
        this.headers.add(EnumXLS_QColumnHeader.EXP_STIM1);
        this.headers.add(EnumXLS_QColumnHeader.EXP_CONC1);
        this.headers.add(EnumXLS_QColumnHeader.EXP_STIM2);
        this.headers.add(EnumXLS_QColumnHeader.EXP_CONC2);
        this.headers.add(EnumXLS_QColumnHeader.EXP_STRAIN);
        this.headers.add(EnumXLS_QColumnHeader.CAGE_NFLIES);
        this.headers.add(EnumXLS_QColumnHeader.CAGE_POS);
        this.headers.add(EnumXLS_QColumnHeader.VAL_TIME);
        this.headers.add(EnumXLS_QColumnHeader.VAL_STIM1);
        this.headers.add(EnumXLS_QColumnHeader.N_STIM1);
        this.headers.add(EnumXLS_QColumnHeader.VAL_STIM2);
        this.headers.add(EnumXLS_QColumnHeader.N_STIM2);
        this.headers.add(EnumXLS_QColumnHeader.VAL_SUM);
        this.headers.add(EnumXLS_QColumnHeader.VAL_PI);
        for (int i = 0; i < this.headers.size(); ++i) {
            this.headers.get(i).setValue(i);
        }
    }

    @Override
    protected int exportExperimentData(Experiment exp, XLSExportOptions xlsExportOptions, int startColumn, String charSeries) throws ExcelExportException {
        int column = this.getCageDataAndExport(exp, startColumn, charSeries, xlsExportOptions, EnumXLSExport.AREA_SUMCLEAN);
        column = this.getCageDataAndExport(exp, startColumn, charSeries, xlsExportOptions, EnumXLSExport.AREA_SUM);
        return column;
    }

    protected int getCageDataAndExport(Experiment exp, int col0, String charSeries, XLSExportOptions xlsExportOptions, EnumXLSExport exportType) throws ExcelDataException {
        this.options.exportType = exportType;
        int colmax = 0;
        try {
            SXSSFSheet sheet = this.xlsGetQSheet(exportType.toString(), exportType);
            colmax = this.xlsExportExperimentCageDataToSheet(sheet, exp, xlsExportOptions, exportType, col0, charSeries);
        }
        catch (Exception e) {
            throw new ExcelDataException("Failed to get access to sheet or to export", "getCageDataAndExport", "experiment_export", e);
        }
        return colmax;
    }

    SXSSFSheet xlsGetQSheet(String title, EnumXLSExport xlsExport) throws ExcelResourceException {
        SXSSFWorkbook workbook = this.resourceManager.getWorkbook();
        SXSSFSheet sheet = workbook.getSheet(title);
        if (sheet == null) {
            sheet = this.resourceManager.getWorkbook().createSheet(title);
            this.writeTopRow_Qdescriptors(sheet);
        }
        return sheet;
    }

    int writeTopRow_Qdescriptors(SXSSFSheet sheet) {
        Point pt = new Point(0, 0);
        int x = 0;
        boolean transpose = this.options.transpose;
        int nextcol = -1;
        for (EnumXLS_QColumnHeader dumb : this.headers) {
            XLSUtils.setValue(sheet, x, dumb.getValue(), transpose, dumb.getName());
            if (nextcol >= dumb.getValue()) continue;
            nextcol = dumb.getValue();
        }
        pt.y = nextcol + 1;
        return pt.y;
    }

    int xlsExportExperimentCageDataToSheet(SXSSFSheet sheet, Experiment exp, XLSExportOptions xlsExportOptions, EnumXLSExport xlsExportType, int col0, String charSeries) {
        Point pt = new Point(col0, 0);
        String stim1 = exp.getProperties().getField_stim1();
        String conc1 = exp.getProperties().getField_conc1();
        String stim2 = exp.getProperties().getField_stim2();
        String conc2 = exp.getProperties().getField_conc2();
        for (Cage cage : exp.cagesArray.cagesList) {
            if (cage.spotsArray.getSpotsList().size() == 0 || xlsExportOptions.onlyalive && cage.getProperties().getCageNFlies() < 1) continue;
            double scalingFactorToPhysicalUnits = cage.spotsArray.getScalingFactorToPhysicalUnits(xlsExportType);
            Spot spot1 = cage.combineSpotsWithSameStimConc(stim1, conc1);
            XLSResults xlsStim1 = this.getResultForCage(exp, cage, spot1, scalingFactorToPhysicalUnits, xlsExportOptions, xlsExportType);
            if (spot1 != null) {
                cage.getProperties().setCountSpotsStim1(spot1.getProperties().getCountAggregatedSpots());
            }
            Spot spot2 = cage.combineSpotsWithSameStimConc(stim2, conc2);
            XLSResults xlsStim2 = this.getResultForCage(exp, cage, spot2, scalingFactorToPhysicalUnits, xlsExportOptions, xlsExportType);
            if (spot2 != null) {
                cage.getProperties().setCountSpotsStim2(spot2.getProperties().getCountAggregatedSpots());
            }
            Spot spotSUM = cage.createSpotSUM(spot1, spot2);
            XLSResults xlsSUM = this.getResultForCage(exp, cage, spotSUM, scalingFactorToPhysicalUnits, xlsExportOptions, xlsExportType);
            Spot spotPI = cage.createSpotPI(spot1, spot2);
            XLSResults xlsPI = this.getResultForCage(exp, cage, spotPI, scalingFactorToPhysicalUnits, xlsExportOptions, xlsExportType);
            int tStart = 0;
            int tEnd = 0;
            if (xlsExportOptions.fixedIntervals) {
                tStart = (int)xlsExportOptions.startAll_Ms / xlsExportOptions.buildExcelStepMs;
                tEnd = (int)xlsExportOptions.endAll_Ms / xlsExportOptions.buildExcelStepMs;
            } else if (xlsStim1 != null) {
                tEnd = xlsStim1.getValuesOutLength() - 1;
            } else if (xlsStim2 != null) {
                tEnd = xlsStim2.getValuesOutLength() - 1;
            }
            for (int t = tStart; t <= tEnd; ++t) {
                pt.y = 0;
                this.writeCageProperties(sheet, pt, exp, charSeries, cage, xlsExportType);
                pt.y -= 4;
                this.writeCageMeasuresAtT(sheet, pt, t, xlsStim1, xlsStim2, xlsPI, xlsSUM, xlsExportType);
                ++pt.x;
            }
        }
        return pt.x;
    }

    XLSResults getResultForCage(Experiment exp, Cage cage, Spot spot, double scaling, XLSExportOptions xlsExportOptions, EnumXLSExport xlsExportType) {
        XLSResults xlsResults = null;
        if (spot != null) {
            xlsResults = this.getXLSResultsDataValuesFromSpotMeasures(exp, cage, spot, xlsExportOptions);
            xlsResults.transferDataValuesToValuesOut(scaling, xlsExportType);
        }
        return xlsResults;
    }

    void writeCageProperties(SXSSFSheet sheet, Point pt, Experiment exp, String charSeries, Cage cage, EnumXLSExport xlsExportType) {
        boolean transpose = this.options.transpose;
        for (int i = 0; i < this.headers.size(); ++i) {
            if (this.headers.get(i).toType() == EnumColumnType.DESCRIPTOR_STR) {
                String dummy = this.getDescriptorStr(exp, cage, this.headers.get(i));
                pt.y = this.headers.get(i).getValue();
                XLSUtils.setValue(sheet, pt, transpose, dummy);
            }
            if (this.headers.get(i).toType() != EnumColumnType.DESCRIPTOR_INT) continue;
            int value = this.getDescriptorInt(exp, cage, this.headers.get(i));
            pt.y = this.headers.get(i).getValue();
            XLSUtils.setValue(sheet, pt, transpose, value);
        }
    }

    void writeCageMeasuresAtT(SXSSFSheet sheet, Point pt, int t, XLSResults xlsStim1, XLSResults xlsStim2, XLSResults xlsPI, XLSResults xlsSUM, EnumXLSExport xlsExportType) {
        pt.y = EnumXLS_QColumnHeader.VAL_TIME.getValue();
        XLSUtils.setValue(sheet, pt, this.options.transpose, t);
        pt.y = EnumXLS_QColumnHeader.VAL_STIM1.getValue();
        this.writeDataToXLS(sheet, pt, t, xlsStim1);
        pt.y = EnumXLS_QColumnHeader.VAL_STIM2.getValue();
        this.writeDataToXLS(sheet, pt, t, xlsStim2);
        pt.y = EnumXLS_QColumnHeader.VAL_SUM.getValue();
        this.writeDataToXLS(sheet, pt, t, xlsSUM);
        pt.y = EnumXLS_QColumnHeader.VAL_PI.getValue();
        this.writeDataToXLS(sheet, pt, t, xlsPI);
        ++pt.y;
    }

    void writeDataToXLS(SXSSFSheet sheet, Point pt, int t, XLSResults xlsResult) {
        if (xlsResult == null) {
            return;
        }
        double value = xlsResult.getValuesOut()[t];
        boolean transpose = this.options.transpose;
        if (!Double.isNaN(value)) {
            XLSUtils.setValue(sheet, pt, transpose, value);
        }
    }

    String getDescriptorStr(Experiment exp, Cage cage, EnumXLS_QColumnHeader col) {
        String dummy = null;
        switch (col) {
            case DATE: {
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
                return df.format(exp.seqCamData.getTimeManager().getFirstImageMs());
            }
            case EXP_BOXID: {
                return exp.getProperties().getFfield_boxID();
            }
            case CAGEID: {
                return Integer.toString(cage.getProperties().getCageID());
            }
            case EXP_EXPT: {
                return exp.getProperties().getFfield_experiment();
            }
            case EXP_STRAIN: {
                return exp.getProperties().getField_strain();
            }
            case EXP_SEX: {
                return exp.getProperties().getField_sex();
            }
            case EXP_STIM1: {
                return exp.getProperties().getField_stim1();
            }
            case EXP_CONC1: {
                return exp.getProperties().getField_conc1();
            }
            case EXP_STIM2: {
                return exp.getProperties().getField_stim2();
            }
            case EXP_CONC2: {
                return exp.getProperties().getField_conc2();
            }
            case CAGE_STRAIN: {
                return cage.getProperties().getFlyStrain();
            }
            case CAGE_SEX: {
                return cage.getProperties().getFlySex();
            }
            case CAGE_COMMENT: {
                return cage.getProperties().getComment();
            }
        }
        return dummy;
    }

    int getDescriptorInt(Experiment exp, Cage cage, EnumXLS_QColumnHeader col) {
        int dummy = -1;
        switch (col) {
            case CAGE_POS: {
                return cage.getProperties().getArrayIndex();
            }
            case CAGE_NFLIES: {
                return cage.getProperties().getCageNFlies();
            }
            case CAGE_AGE: {
                return cage.getProperties().getFlyAge();
            }
            case N_STIM1: {
                return cage.getProperties().getCountSpotsStim1();
            }
            case N_STIM2: {
                return cage.getProperties().getCountSpotsStim2();
            }
        }
        return dummy;
    }
}

