/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS96.tools.toExcel;

import java.awt.Point;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import plugins.fmp.multiSPOTS96.experiment.Experiment;
import plugins.fmp.multiSPOTS96.experiment.cages.Cage;
import plugins.fmp.multiSPOTS96.experiment.sequence.ImageLoader;
import plugins.fmp.multiSPOTS96.experiment.sequence.TimeManager;
import plugins.fmp.multiSPOTS96.experiment.spots.Spot;
import plugins.fmp.multiSPOTS96.tools.toExcel.EnumXLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS96.tools.toExcel.XLSResults;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelExportException;
import plugins.fmp.multiSPOTS96.tools.toExcel.exceptions.ExcelResourceException;

public class XLSExportMeasuresFromSpot
extends XLSExport {
    @Override
    protected int exportExperimentData(Experiment exp, XLSExportOptions xlsExportOptions, int startColumn, String charSeries) throws ExcelExportException {
        int column = startColumn;
        if (this.options.spotAreas) {
            column = this.getSpotDataAndExport(exp, column, charSeries, EnumXLSExport.AREA_SUM);
            this.getSpotDataAndExport(exp, column, charSeries, EnumXLSExport.AREA_FLYPRESENT);
            this.getSpotDataAndExport(exp, column, charSeries, EnumXLSExport.AREA_SUMCLEAN);
        }
        return column;
    }

    protected int getSpotDataAndExport(Experiment exp, int col0, String charSeries, EnumXLSExport exportType) throws ExcelExportException {
        try {
            this.options.exportType = exportType;
            SXSSFSheet sheet = this.getSheet(exportType.toString(), exportType);
            int colmax = this.xlsExportExperimentSpotDataToSheet(exp, sheet, exportType, col0, charSeries);
            if (this.options.onlyalive) {
                sheet = this.getSheet(exportType.toString() + "_alive", exportType);
                this.xlsExportExperimentSpotDataToSheet(exp, sheet, exportType, col0, charSeries);
            }
            return colmax;
        }
        catch (ExcelResourceException e) {
            throw new ExcelExportException("Failed to export spot data", "get_spot_data_and_export", exportType.toString(), e);
        }
    }

    protected int xlsExportExperimentSpotDataToSheet(Experiment exp, SXSSFSheet sheet, EnumXLSExport xlsExportType, int col0, String charSeries) {
        Point pt = new Point(col0, 0);
        pt = this.writeExperimentSeparator(sheet, pt);
        for (Cage cage : exp.cagesArray.cagesList) {
            double scalingFactorToPhysicalUnits = cage.spotsArray.getScalingFactorToPhysicalUnits(xlsExportType);
            cage.updateSpotsStimulus_i();
            for (Spot spot : cage.spotsArray.getSpotsList()) {
                pt.y = 0;
                pt = this.writeExperimentSpotInfos(sheet, pt, exp, charSeries, cage, spot, xlsExportType);
                XLSResults xlsResults = this.getXLSResultsDataValuesFromSpotMeasures(exp, cage, spot, this.options);
                xlsResults.transferDataValuesToValuesOut(scalingFactorToPhysicalUnits, xlsExportType);
                this.writeXLSResult(sheet, pt, xlsResults);
                ++pt.x;
            }
        }
        return pt.x;
    }

    public XLSResults getXLSResultsDataValuesFromSpotMeasures(Experiment exp, Cage cage, Spot spot, XLSExportOptions xlsExportOptions) {
        int nOutputFrames = this.getNOutputFrames(exp, xlsExportOptions);
        XLSResults xlsResults = new XLSResults(cage.getProperties(), spot.getProperties(), nOutputFrames);
        long binData = exp.seqCamData.getTimeManager().getBinDurationMs();
        long binExcel = xlsExportOptions.buildExcelStepMs;
        xlsResults.getDataFromSpot(spot, binData, binExcel, xlsExportOptions);
        return xlsResults;
    }

    protected int getNOutputFrames(Experiment exp, XLSExportOptions options) {
        TimeManager timeManager = exp.seqCamData.getTimeManager();
        ImageLoader imgLoader = exp.seqCamData.getImageLoader();
        long durationMs = timeManager.getBinLast_ms() - timeManager.getBinFirst_ms();
        int nOutputFrames = (int)(durationMs / (long)options.buildExcelStepMs + 1L);
        if (nOutputFrames <= 1) {
            long binLastMs = timeManager.getBinFirst_ms() + (long)imgLoader.getNTotalFrames() * timeManager.getBinDurationMs();
            timeManager.setBinLast_ms(binLastMs);
            if (binLastMs <= 0L) {
                this.handleExportError(exp, -1);
            }
            if ((nOutputFrames = (int)((binLastMs - timeManager.getBinFirst_ms()) / (long)options.buildExcelStepMs + 1L)) <= 1) {
                nOutputFrames = imgLoader.getNTotalFrames();
                this.handleExportError(exp, nOutputFrames);
            }
        }
        return nOutputFrames;
    }
}

