/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.cages;

import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceCamData;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class BuildCagesAsArray
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private JButton drawPolygon2DButton = new JButton("Draw Polygon2D");
    private JButton createCellsButton = new JButton("Create cells");
    private JSpinner nColumnsTextField = new JSpinner(new SpinnerNumberModel(10, 0, 10000, 1));
    private JSpinner width_cageTextField = new JSpinner(new SpinnerNumberModel(20, 0, 10000, 1));
    private JSpinner width_intervalTextField = new JSpinner(new SpinnerNumberModel(3, 0, 10000, 1));
    private JSpinner nRowsTextField = new JSpinner(new SpinnerNumberModel(1, 0, 10000, 1));
    private int ncolumns = 10;
    private int nrows = 1;
    private int width_cage = 10;
    private int width_interval = 2;
    private MultiCAFE parent0 = null;
    private ROI2DPolygon roiUserPolygon = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.drawPolygon2DButton);
        panel1.add(this.createCellsButton);
        this.add(panel1);
        JLabel nColumnsLabel = new JLabel("N columns ");
        JLabel nRowsLabel = new JLabel("N rows ");
        JLabel cellWidthLabel = new JLabel("cell width ");
        JLabel betweenCellsLabel = new JLabel("between cells ");
        nColumnsLabel.setHorizontalAlignment(4);
        cellWidthLabel.setHorizontalAlignment(4);
        betweenCellsLabel.setHorizontalAlignment(4);
        nRowsLabel.setHorizontalAlignment(4);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(cellWidthLabel);
        panel2.add(this.width_cageTextField);
        panel2.add(nColumnsLabel);
        panel2.add(this.nColumnsTextField);
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(betweenCellsLabel);
        panel3.add(this.width_intervalTextField);
        panel3.add(nRowsLabel);
        panel3.add(this.nRowsTextField);
        this.add(panel3);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.drawPolygon2DButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((BuildCagesAsArray)BuildCagesAsArray.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    BuildCagesAsArray.this.create2DPolygon(exp);
                }
            }
        });
        this.createCellsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((BuildCagesAsArray)BuildCagesAsArray.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    BuildCagesAsArray.this.createROIsFromSelectedPolygon(exp);
                    exp.cages.cagesFromROIs(exp.seqCamData);
                    if (exp.capillaries.capillariesList.size() > 0) {
                        exp.cages.transferNFliesFromCapillariesToCageBox(exp.capillaries.capillariesList);
                    }
                }
            }
        });
    }

    void updateNColumnsFieldFromSequence() {
        int nrois;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null && (nrois = exp.cages.cageList.size()) > 0) {
            this.nColumnsTextField.setValue(nrois);
            this.ncolumns = nrois;
        }
    }

    private void create2DPolygon(Experiment exp) {
        String dummyname = "perimeter_enclosing";
        if (this.roiUserPolygon == null) {
            ArrayList listRois = exp.seqCamData.seq.getROI2Ds();
            for (ROI2D roi : listRois) {
                if (!roi.getName().equals("perimeter_enclosing")) continue;
                return;
            }
            Rectangle rect = exp.seqCamData.seq.getBounds2D();
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            int rectleft = rect.x + rect.width / 6;
            int rectright = rect.x + rect.width * 5 / 6;
            int recttop = rect.y + rect.height * 2 / 3;
            if (exp.capillaries.capillariesList.size() > 0) {
                Rectangle bound0 = exp.capillaries.capillariesList.get(0).getRoi().getBounds();
                int last = exp.capillaries.capillariesList.size() - 1;
                Rectangle bound1 = exp.capillaries.capillariesList.get(last).getRoi().getBounds();
                rectleft = bound0.x;
                rectright = bound1.x + bound1.width;
                int diff = (rectright - rectleft) * 2 / 60;
                rectleft -= diff;
                rectright += diff;
                recttop = bound0.y + bound0.height - bound0.height / 8;
            }
            points.add(new Point2D.Double(rectleft, recttop));
            points.add(new Point2D.Double(rectright, recttop));
            points.add(new Point2D.Double(rectright, rect.y + rect.height - 4));
            points.add(new Point2D.Double(rectleft, rect.y + rect.height - 4));
            this.roiUserPolygon = new ROI2DPolygon(points);
            this.roiUserPolygon.setName("perimeter_enclosing");
        }
        exp.seqCamData.seq.addROI((ROI)this.roiUserPolygon);
        exp.seqCamData.seq.setSelectedROI((ROI)this.roiUserPolygon);
    }

    private void createROIsFromSelectedPolygon(Experiment exp) {
        ROI2DUtilities.removeRoisContainingString(-1, "cage", exp.seqCamData.seq);
        exp.cages.clearCageList();
        try {
            this.ncolumns = (Integer)this.nColumnsTextField.getValue();
            this.nrows = (Integer)this.nRowsTextField.getValue();
            this.width_cage = (Integer)this.width_cageTextField.getValue();
            this.width_interval = (Integer)this.width_intervalTextField.getValue();
        }
        catch (Exception e) {
            new AnnounceFrame("Can't interpret one of the ROI parameters value");
        }
        SequenceCamData seqCamData = exp.seqCamData;
        Polygon2D roiPolygonMin = ROI2DUtilities.orderVerticesofPolygon(this.roiUserPolygon.getPolygon());
        seqCamData.seq.removeROI((ROI)this.roiUserPolygon);
        ROI2DUtilities.removeRoisContainingString(-1, "cage", exp.seqCamData.seq);
        exp.cages.clearCageList();
        String cageRoot = "cage";
        int iRoot = 0;
        Polygon2D roiPolygon = ROI2DUtilities.inflate(roiPolygonMin, this.ncolumns, this.nrows, this.width_cage, this.width_interval);
        double deltax_top = (roiPolygon.xpoints[3] - roiPolygon.xpoints[0]) / (double)this.ncolumns;
        double deltax_bottom = (roiPolygon.xpoints[2] - roiPolygon.xpoints[1]) / (double)this.ncolumns;
        double deltay_top = (roiPolygon.ypoints[3] - roiPolygon.ypoints[0]) / (double)this.ncolumns;
        double deltay_bottom = (roiPolygon.ypoints[2] - roiPolygon.ypoints[1]) / (double)this.ncolumns;
        for (int i = 0; i < this.ncolumns; ++i) {
            double x0i = roiPolygon.xpoints[0] + deltax_top * (double)i;
            double x1i = roiPolygon.xpoints[1] + deltax_bottom * (double)i;
            double x3i = x0i + deltax_top;
            double x2i = x1i + deltax_bottom;
            double y0i = roiPolygon.ypoints[0] + deltay_top * (double)i;
            double y1i = roiPolygon.ypoints[1] + deltay_bottom * (double)i;
            double y3i = y0i + deltay_top;
            double y2i = y1i + deltay_bottom;
            for (int j = 0; j < this.nrows; ++j) {
                double deltax_left = (x1i - x0i) / (double)this.nrows;
                double deltax_right = (x2i - x3i) / (double)this.nrows;
                double deltay_left = (y1i - y0i) / (double)this.nrows;
                double deltay_right = (y2i - y3i) / (double)this.nrows;
                double x0ij = x0i + deltax_left * (double)j;
                double x1ij = x0ij + deltax_left;
                double x3ij = x3i + deltax_right * (double)j;
                double x2ij = x3ij + deltax_right;
                double y0ij = y0i + deltay_left * (double)j;
                double y1ij = y0ij + deltay_left;
                double y3ij = y3i + deltay_right * (double)j;
                double y2ij = y3ij + deltay_right;
                double xspacer_top = (x3ij - x0ij) * (double)this.width_interval / (double)(this.width_cage + 2 * this.width_interval);
                double xspacer_bottom = (x2ij - x1ij) * (double)this.width_interval / (double)(this.width_cage + 2 * this.width_interval);
                double yspacer_left = (y1ij - y0ij) * (double)this.width_interval / (double)(this.width_cage + 2 * this.width_interval);
                double yspacer_right = (y2ij - y3ij) * (double)this.width_interval / (double)(this.width_cage + 2 * this.width_interval);
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                Point2D point0 = ROI2DUtilities.lineIntersect(x0ij + xspacer_top, y0ij, x1ij + xspacer_bottom, y1ij, x0ij, y0ij + yspacer_left, x3ij, y3ij + yspacer_right);
                points.add(point0);
                Point2D point1 = ROI2DUtilities.lineIntersect(x1ij, y1ij - yspacer_left, x2ij, y2ij - yspacer_right, x0ij + xspacer_top, y0ij, x1ij + xspacer_bottom, y1ij);
                points.add(point1);
                Point2D point2 = ROI2DUtilities.lineIntersect(x1ij, y1ij - yspacer_left, x2ij, y2ij - yspacer_right, x3ij - xspacer_top, y3ij, x2ij - xspacer_bottom, y2ij);
                points.add(point2);
                Point2D point3 = ROI2DUtilities.lineIntersect(x0ij, y0ij + yspacer_left, x3ij, y3ij + yspacer_right, x3ij - xspacer_top, y3ij, x2ij - xspacer_bottom, y2ij);
                points.add(point3);
                ROI2DPolygon roiP = new ROI2DPolygon(points);
                roiP.setName(cageRoot + String.format("%03d", iRoot));
                roiP.setColor(Color.MAGENTA);
                ++iRoot;
                seqCamData.seq.addROI((ROI)roiP);
            }
        }
    }
}

