/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.cages;

import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.cages.FlyPositions;
import plugins.fmp.multicafe.tools.chart.ChartPositions;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;

public class ChartPositionsPanel
extends JPanel
implements SequenceListener {
    private static final long serialVersionUID = -7079184380174992501L;
    private ChartPositions ypositionsChart = null;
    private ChartPositions distanceChart = null;
    private ChartPositions aliveChart = null;
    private ChartPositions sleepChart = null;
    private MultiCAFE parent0 = null;
    public JCheckBox moveCheckbox = new JCheckBox("y position", true);
    private JCheckBox distanceCheckbox = new JCheckBox("distance t/t+1", false);
    JCheckBox aliveCheckbox = new JCheckBox("fly alive", true);
    JCheckBox sleepCheckbox = new JCheckBox("sleep", false);
    JSpinner aliveThresholdSpinner = new JSpinner(new SpinnerNumberModel(50.0, 0.0, 100000.0, 0.1));
    public JButton displayResultsButton = new JButton("Display results");

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(2);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.moveCheckbox);
        panel1.add(this.distanceCheckbox);
        panel1.add(this.aliveCheckbox);
        panel1.add(this.sleepCheckbox);
        this.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("Alive threshold"));
        panel2.add(this.aliveThresholdSpinner);
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(this.displayResultsButton);
        this.add(panel3);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.displayResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPositionsPanel.this.displayGraphsPanels();
                ChartPositionsPanel.this.firePropertyChange("DISPLAY_RESULTS", false, true);
            }
        });
    }

    private void displayGraphsPanels() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Rectangle rectv = exp.seqCamData.seq.getFirstViewer().getBounds();
        Point ptRelative = new Point(0, 30);
        int deltay = 230;
        exp.seqCamData.seq.addListener((SequenceListener)this);
        if (this.moveCheckbox.isSelected()) {
            this.ypositionsChart = this.plotYToChart("flies Y positions", this.ypositionsChart, rectv, ptRelative, exp, EnumXLSExport.XYTOPCELL);
            ptRelative.y += 230;
        } else if (this.ypositionsChart != null) {
            this.closeChart(this.ypositionsChart);
        }
        if (this.distanceCheckbox.isSelected()) {
            this.distanceChart = this.plotYToChart("distance between positions at t+1 and t", this.distanceChart, rectv, ptRelative, exp, EnumXLSExport.DISTANCE);
            ptRelative.y += 230;
        } else if (this.distanceChart != null) {
            this.closeChart(this.distanceChart);
        }
        if (this.aliveCheckbox.isSelected()) {
            double threshold = (Double)this.aliveThresholdSpinner.getValue();
            for (Cage cell : exp.cages.cageList) {
                FlyPositions posSeries = cell.flyPositions;
                posSeries.moveThreshold = threshold;
                posSeries.computeIsAlive();
            }
            this.aliveChart = this.plotYToChart("flies alive", this.aliveChart, rectv, ptRelative, exp, EnumXLSExport.ISALIVE);
            ptRelative.y += 230;
        } else if (this.aliveChart != null) {
            this.closeChart(this.aliveChart);
        }
        if (this.sleepCheckbox.isSelected()) {
            for (Cage cell : exp.cages.cageList) {
                FlyPositions posSeries = cell.flyPositions;
                posSeries.computeSleep();
            }
            this.sleepChart = this.plotYToChart("flies asleep", this.sleepChart, rectv, ptRelative, exp, EnumXLSExport.SLEEP);
            ptRelative.y += 230;
        } else if (this.sleepChart != null) {
            this.closeChart(this.sleepChart);
        }
    }

    private ChartPositions plotYToChart(String title, ChartPositions iChart, Rectangle rectv, Point ptRelative, Experiment exp, EnumXLSExport option) {
        if (iChart != null) {
            iChart.mainChartFrame.dispose();
        }
        iChart = new ChartPositions();
        iChart.createPanel(title);
        iChart.setLocationRelativeToRectangle(rectv, ptRelative);
        iChart.displayData(exp.cages.cageList, option);
        iChart.mainChartFrame.toFront();
        iChart.mainChartFrame.requestFocus();
        return iChart;
    }

    private ChartPositions closeChart(ChartPositions chart) {
        if (chart != null) {
            chart.mainChartFrame.dispose();
        }
        chart = null;
        return chart;
    }

    public void closeAllCharts() {
        this.ypositionsChart = this.closeChart(this.ypositionsChart);
        this.distanceChart = this.closeChart(this.distanceChart);
        this.aliveChart = this.closeChart(this.aliveChart);
        this.sleepChart = this.closeChart(this.sleepChart);
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
        this.closeAllCharts();
    }
}

