/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.cages;

import icy.painter.Overlay;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.series.BuildSeriesOptions;
import plugins.fmp.multicafe.series.FlyDetect2;
import plugins.fmp.multicafe.tools.Canvas2D.Canvas2DWithTransforms;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;
import plugins.fmp.multicafe.tools.Overlay.OverlayThreshold;

public class Detect2Flies
extends JPanel
implements ChangeListener,
PropertyChangeListener,
PopupMenuListener {
    private static final long serialVersionUID = -5257698990389571518L;
    private MultiCAFE parent0 = null;
    private String detectString = "Detect...";
    private JButton startComputationButton = new JButton(this.detectString);
    private JComboBox<String> allCagesComboBox = new JComboBox<String>(new String[]{"all cells"});
    private JCheckBox allCheckBox = new JCheckBox("ALL (current to last)", false);
    private JCheckBox objectLowsizeCheckBox = new JCheckBox("size >");
    private JSpinner objectLowsizeSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 9999, 1));
    private JCheckBox objectUpsizeCheckBox = new JCheckBox("<");
    private JSpinner objectUpsizeSpinner = new JSpinner(new SpinnerNumberModel(500, 0, 9999, 1));
    private JSpinner thresholdSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 255, 1));
    private JSpinner jitterTextField = new JSpinner(new SpinnerNumberModel(5, 0, 1000, 1));
    private JSpinner limitRatioSpinner = new JSpinner(new SpinnerNumberModel(4, 0, 1000, 1));
    private JToggleButton viewButton = new JToggleButton("View");
    private JCheckBox overlayCheckBox = new JCheckBox("overlay");
    private JCheckBox whiteObjectCheckBox = new JCheckBox("white object");
    private FlyDetect2 flyDetect2 = null;
    private OverlayThreshold overlayThreshold = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.startComputationButton);
        panel1.add(this.allCagesComboBox);
        panel1.add(this.allCheckBox);
        this.add(panel1);
        this.allCagesComboBox.addPopupMenuListener(this);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("threshold"));
        panel2.add(this.thresholdSpinner);
        panel2.add(this.viewButton);
        panel2.add(this.overlayCheckBox);
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(this.objectLowsizeCheckBox);
        panel3.add(this.objectLowsizeSpinner);
        this.objectLowsizeSpinner.setPreferredSize(new Dimension(80, 20));
        panel3.add(this.objectUpsizeCheckBox);
        panel3.add(this.objectUpsizeSpinner);
        this.objectUpsizeSpinner.setPreferredSize(new Dimension(80, 20));
        panel3.add(this.whiteObjectCheckBox);
        this.add(panel3);
        JPanel panel4 = new JPanel(flowLayout);
        panel4.add(new JLabel("length/width<"));
        panel4.add(this.limitRatioSpinner);
        this.limitRatioSpinner.setPreferredSize(new Dimension(40, 20));
        panel4.add(new JLabel("jitter <="));
        panel4.add(this.jitterTextField);
        this.jitterTextField.setPreferredSize(new Dimension(40, 20));
        this.add(panel4);
        this.defineActionListeners();
        this.defineItemListeners();
    }

    private void defineItemListeners() {
        this.thresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Detect2Flies.this.updateOverlayThreshold();
            }
        });
    }

    private void defineActionListeners() {
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Detect2Flies.this.startComputationButton.getText().equals(Detect2Flies.this.detectString)) {
                    Detect2Flies.this.startComputation();
                } else {
                    Detect2Flies.this.stopComputation();
                }
            }
        });
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Detect2Flies.this.allCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Detect2Flies.this.allCheckBox.setForeground(color);
                Detect2Flies.this.startComputationButton.setForeground(color);
            }
        });
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Detect2Flies)Detect2Flies.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (!Detect2Flies.this.viewButton.isSelected()) {
                        Detect2Flies.this.viewDifference(exp, false);
                        Detect2Flies.this.overlayCheckBox.setSelected(false);
                        Detect2Flies.this.removeOverlay(exp);
                    } else {
                        Detect2Flies.this.viewDifference(exp, true);
                    }
                    Detect2Flies.this.overlayCheckBox.setEnabled(Detect2Flies.this.viewButton.isSelected());
                }
            }
        });
        this.overlayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Detect2Flies)Detect2Flies.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (Detect2Flies.this.overlayCheckBox.isSelected()) {
                        Detect2Flies.this.updateOverlay(exp);
                        Detect2Flies.this.updateOverlayThreshold();
                    } else {
                        Detect2Flies.this.removeOverlay(exp);
                    }
                }
            }
        });
        this.whiteObjectCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Detect2Flies.this.updateOverlayThreshold();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Experiment exp;
        if (e.getSource() == this.thresholdSpinner && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            exp.cages.detect_threshold = (Integer)this.thresholdSpinner.getValue();
        }
    }

    public void updateOverlay(Experiment exp) {
        if (exp.seqCamData == null) {
            return;
        }
        if (this.overlayThreshold == null) {
            this.overlayThreshold = new OverlayThreshold(exp.seqCamData);
        } else {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold);
            this.overlayThreshold.setSequence(exp.seqCamData);
        }
        this.overlayThreshold.setReferenceImage(exp.seqCamData.refImage);
        exp.seqCamData.seq.addOverlay((Overlay)this.overlayThreshold);
    }

    void updateOverlayThreshold() {
        if (this.overlayThreshold == null) {
            return;
        }
        boolean ifGreater = !this.whiteObjectCheckBox.isSelected();
        ImageTransformEnums transformOp = ImageTransformEnums.SUBTRACT_REF;
        int threshold = (Integer)this.thresholdSpinner.getValue();
        this.overlayThreshold.setThresholdSingle(threshold, transformOp, ifGreater);
        this.overlayThreshold.painterChanged();
    }

    private BuildSeriesOptions initTrackParameters(Experiment exp) {
        BuildSeriesOptions options = this.flyDetect2.options;
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.btrackWhite = this.whiteObjectCheckBox.isSelected();
        options.blimitLow = this.objectLowsizeCheckBox.isSelected();
        options.blimitUp = this.objectUpsizeCheckBox.isSelected();
        options.limitLow = (Integer)this.objectLowsizeSpinner.getValue();
        options.limitUp = (Integer)this.objectUpsizeSpinner.getValue();
        options.limitRatio = (Integer)this.limitRatioSpinner.getValue();
        options.jitter = (Integer)this.jitterTextField.getValue();
        options.thresholdDiff = (Integer)this.thresholdSpinner.getValue();
        options.detectFlies = true;
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.binSubDirectory = exp.getBinSubDirectory();
        options.isFrameFixed = this.parent0.paneExcel.tabCommonOptions.getIsFixedFrame();
        options.t_Ms_First = this.parent0.paneExcel.tabCommonOptions.getStartMs();
        options.t_Ms_Last = this.parent0.paneExcel.tabCommonOptions.getEndMs();
        options.t_Ms_BinDuration = this.parent0.paneExcel.tabCommonOptions.getBinMs();
        return options;
    }

    void startComputation() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        this.parent0.paneBrowse.panelLoadSave.closeViewsForCurrentExperiment(exp);
        this.flyDetect2 = new FlyDetect2();
        this.flyDetect2.options = this.initTrackParameters(exp);
        this.flyDetect2.stopFlag = false;
        this.flyDetect2.addPropertyChangeListener(this);
        this.flyDetect2.execute();
        this.startComputationButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.flyDetect2 != null && !this.flyDetect2.stopFlag) {
            this.flyDetect2.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.startComputationButton.setText(this.detectString);
            this.parent0.paneKymos.tabDisplay.selectKymographImage(this.parent0.paneKymos.tabDisplay.indexImagesCombo);
            this.parent0.paneKymos.tabDisplay.indexImagesCombo = -1;
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        int nitems = 1;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            nitems = exp.cages.cageList.size() + 1;
        }
        if (this.allCagesComboBox.getItemCount() != nitems) {
            this.allCagesComboBox.removeAllItems();
            this.allCagesComboBox.addItem("all cells");
            for (Cage cage : exp.cages.cageList) {
                this.allCagesComboBox.addItem(cage.getCageIDasString());
            }
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.seq != null) {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold);
        }
    }

    void viewDifference(Experiment exp, boolean display) {
        Canvas2DWithTransforms canvas = (Canvas2DWithTransforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
        ImageTransformEnums[] imageTransformStep1 = new ImageTransformEnums[]{ImageTransformEnums.NONE, ImageTransformEnums.SUBTRACT_REF};
        ImageTransformOptions optionsStep1 = canvas.getOptionsStep1();
        optionsStep1.backgroundImage = null;
        int index = 0;
        if (display) {
            if (exp.seqCamData.refImage == null) {
                exp.loadReferenceImage();
            }
            optionsStep1.backgroundImage = exp.seqCamData.refImage;
            index = 1;
        }
        canvas.selectItemStep1(imageTransformStep1[index], optionsStep1);
    }
}

