/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.capillaries;

import icy.gui.component.PopupPanel;
import icy.gui.viewer.Viewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.dlg.capillaries.Adjust;
import plugins.fmp.multicafe.dlg.capillaries.CreateForCapillaries;
import plugins.fmp.multicafe.dlg.capillaries.Edit;
import plugins.fmp.multicafe.dlg.capillaries.Infos;
import plugins.fmp.multicafe.dlg.capillaries.LoadSaveCapillaries;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceKymosUtils;

public class MCCapillaries_
extends JPanel
implements PropertyChangeListener,
ChangeListener {
    private static final long serialVersionUID = 853047648249832145L;
    PopupPanel capPopupPanel = null;
    JTabbedPane tabsPane = new JTabbedPane();
    public CreateForCapillaries tabCreate = new CreateForCapillaries();
    Edit tabEdit = new Edit();
    public LoadSaveCapillaries tabFile = new LoadSaveCapillaries();
    Adjust tabAdjust = new Adjust();
    public Infos tabInfos = new Infos();
    private int ID_INFOS = 1;
    private int ID_ADJUST = 3;
    private int ID_EDIT = 2;
    private int ID_FILTER = 4;
    private boolean editSelected = false;
    private MultiCAFE parent0 = null;

    public void init(JPanel mainPanel, String string, final MultiCAFE parent0) {
        this.parent0 = parent0;
        this.capPopupPanel = new PopupPanel(string);
        JPanel capPanel = this.capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        this.capPopupPanel.collapse();
        mainPanel.add((Component)this.capPopupPanel);
        GridLayout capLayout = new GridLayout(3, 1);
        int order = 0;
        this.tabCreate.init(capLayout, parent0);
        this.tabCreate.addPropertyChangeListener(this);
        this.tabsPane.addTab("Create caps", null, this.tabCreate, "Create lines defining capillaries");
        ++order;
        this.ID_INFOS = order++;
        this.tabInfos.init(capLayout, parent0);
        this.tabInfos.addPropertyChangeListener(this);
        this.tabsPane.addTab("Infos", null, this.tabInfos, "Define pixel conversion unit of images and capillaries content");
        this.ID_EDIT = order++;
        this.tabEdit.init(capLayout, parent0);
        this.tabEdit.addPropertyChangeListener(this);
        this.tabsPane.addTab("Edit", null, this.tabEdit, "Edit capillaries position and size");
        this.ID_ADJUST = order++;
        this.tabAdjust.init(capLayout, parent0);
        this.tabAdjust.addPropertyChangeListener(this);
        this.tabsPane.addTab("Adjust", null, this.tabAdjust, "Adjust ROIS position to the capillaries");
        this.tabFile.init(capLayout, parent0);
        this.tabFile.addPropertyChangeListener(this);
        this.tabsPane.addTab("Load/Save", null, this.tabFile, "Load/Save xml file with capillaries descriptors");
        ++order;
        this.tabsPane.setTabLayoutPolicy(1);
        capPanel.add(this.tabsPane);
        this.tabsPane.addChangeListener(this);
        this.capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                parent0.mainFrame.revalidate();
                parent0.mainFrame.pack();
                parent0.mainFrame.repaint();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("CAP_ROIS_OPEN")) {
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                this.displayCapillariesInformation(exp);
                this.tabsPane.setSelectedIndex(this.ID_INFOS);
                this.parent0.paneExperiment.tabIntervals.displayCamDataIntervals(exp);
            }
        } else if (event.getPropertyName().equals("CAP_ROIS_SAVE")) {
            this.tabsPane.setSelectedIndex(this.ID_INFOS);
        } else if (event.getPropertyName().equals("CAPILLARIES_NEW")) {
            this.tabsPane.setSelectedIndex(this.ID_INFOS);
        }
    }

    public void displayCapillariesInformation(final Experiment exp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MCCapillaries_.this.updateDialogs(exp);
                ((MCCapillaries_)MCCapillaries_.this).parent0.paneExperiment.tabOptions.viewCapillariesCheckBox.setSelected(true);
            }
        });
    }

    public void updateDialogs(Experiment exp) {
        if (exp != null) {
            SequenceKymosUtils.transferCamDataROIStoKymo(exp);
            exp.capillaries.desc_old.copy(exp.capillaries.capillariesDescription);
            this.tabInfos.setAllDescriptors(exp.capillaries);
            this.tabCreate.setGroupingAndNumber(exp.capillaries);
        }
    }

    public void getDialogCapillariesInfos(Experiment exp) {
        this.tabInfos.getDescriptors(exp.capillaries);
        this.tabCreate.setCapillariesGrouping(exp.capillaries);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
        int selectedIndex = tabbedPane.getSelectedIndex();
        this.tabAdjust.roisDisplayrefBar(selectedIndex == this.ID_ADJUST);
        boolean disableCapillaries = selectedIndex != this.ID_FILTER;
        this.parent0.paneExperiment.tabOptions.displayROIsCategory(disableCapillaries, "line");
        this.parent0.paneExperiment.tabOptions.viewCapillariesCheckBox.setSelected(selectedIndex == this.ID_INFOS);
        if (selectedIndex == this.ID_EDIT) {
            Viewer v;
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null && (v = exp.seqCamData.seq.getFirstViewer()) != null) {
                v.toFront();
                v.requestFocus();
            }
            this.tabEdit.openDialog();
            this.editSelected = true;
        } else if (this.editSelected) {
            this.tabEdit.closeDialog();
            this.editSelected = false;
        }
    }

    public void transferPreviousExperimentCapillariesInfos(Experiment exp0, Experiment exp) {
        exp.capillaries.capillariesDescription.grouping = exp0.capillaries.capillariesDescription.grouping;
        this.tabCreate.setGroupedBy2(exp0.capillaries.capillariesDescription.grouping == 2);
        exp.capillaries.capillariesDescription.volume = exp0.capillaries.capillariesDescription.volume;
        this.tabInfos.setAllDescriptors(exp0.capillaries);
    }
}

