/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.excel;

import icy.gui.component.PopupPanel;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.dlg.excel.Gulps;
import plugins.fmp.multicafe.dlg.excel.Levels;
import plugins.fmp.multicafe.dlg.excel.Move;
import plugins.fmp.multicafe.dlg.excel.Options;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.tools.JComponents.Dialog;
import plugins.fmp.multicafe.tools.toExcel.XLSExportCapillariesResults;
import plugins.fmp.multicafe.tools.toExcel.XLSExportGulpsResults;
import plugins.fmp.multicafe.tools.toExcel.XLSExportMoveResults;
import plugins.fmp.multicafe.tools.toExcel.XLSExportOptions;

public class MCExcel_
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4296207607692017074L;
    PopupPanel capPopupPanel = null;
    private JTabbedPane tabsPane = new JTabbedPane();
    public Options tabCommonOptions = new Options();
    private Levels tabLevels = new Levels();
    private Gulps tabGulps = new Gulps();
    private Move tabMove = new Move();
    private MultiCAFE parent0 = null;

    public void init(JPanel mainPanel, String string, final MultiCAFE parent0) {
        this.parent0 = parent0;
        this.capPopupPanel = new PopupPanel(string);
        JPanel capPanel = this.capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        this.capPopupPanel.collapse();
        mainPanel.add((Component)this.capPopupPanel);
        GridLayout capLayout = new GridLayout(3, 2);
        this.tabCommonOptions.init(capLayout);
        this.tabsPane.addTab("Common options", null, this.tabCommonOptions, "Define common options");
        this.tabCommonOptions.addPropertyChangeListener(this);
        this.tabLevels.init(capLayout);
        this.tabsPane.addTab("Levels", null, this.tabLevels, "Export capillary levels to file");
        this.tabLevels.addPropertyChangeListener(this);
        this.tabGulps.init(capLayout);
        this.tabsPane.addTab("Gulps", null, this.tabGulps, "Export gulps to file");
        this.tabGulps.addPropertyChangeListener(this);
        this.tabMove.init(capLayout);
        this.tabsPane.addTab("Move", null, this.tabMove, "Export fly positions to file");
        this.tabMove.addPropertyChangeListener(this);
        capPanel.add(this.tabsPane);
        this.tabsPane.setSelectedIndex(0);
        this.capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                parent0.mainFrame.revalidate();
                parent0.mainFrame.pack();
                parent0.mainFrame.repaint();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        final Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        if (evt.getPropertyName().equals("EXPORT_MOVEDATA")) {
            final String file = this.defineXlsFileName(exp, "_move.xlsx");
            if (file == null) {
                return;
            }
            this.updateParametersCurrentExperiment(exp);
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    XLSExportMoveResults xlsExport = new XLSExportMoveResults();
                    xlsExport.exportToFile(file, MCExcel_.this.getMoveOptions(exp));
                }
            });
        } else if (evt.getPropertyName().equals("EXPORT_KYMOSDATA")) {
            final String file = this.defineXlsFileName(exp, "_feeding.xlsx");
            if (file == null) {
                return;
            }
            this.updateParametersCurrentExperiment(exp);
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    XLSExportCapillariesResults xlsExport2 = new XLSExportCapillariesResults();
                    xlsExport2.exportToFile(file, MCExcel_.this.getLevelsOptions(exp));
                }
            });
        } else if (evt.getPropertyName().equals("EXPORT_GULPSDATA")) {
            final String file = this.defineXlsFileName(exp, "_gulps.xlsx");
            if (file == null) {
                return;
            }
            this.updateParametersCurrentExperiment(exp);
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    XLSExportGulpsResults xlsExport2 = new XLSExportGulpsResults();
                    xlsExport2.exportToFile(file, MCExcel_.this.getGulpsOptions(exp));
                }
            });
        }
    }

    private String defineXlsFileName(Experiment exp, String pattern) {
        String filename0 = exp.seqCamData.getFileNameFromImageList(0);
        Path directory = Paths.get(filename0, new String[0]).getParent();
        Path subpath = directory.getName(directory.getNameCount() - 1);
        String tentativeName = subpath.toString() + pattern;
        return Dialog.saveFileAs(tentativeName, directory.getParent().toString(), "xlsx");
    }

    private void updateParametersCurrentExperiment(Experiment exp) {
        this.parent0.paneCapillaries.getDialogCapillariesInfos(exp);
        this.parent0.paneExperiment.tabInfos.getExperimentInfosFromDialog(exp);
    }

    private XLSExportOptions getMoveOptions(Experiment exp) {
        XLSExportOptions options = new XLSExportOptions();
        options.xyImage = this.tabMove.xyCenterCheckBox.isSelected();
        options.xyCage = this.tabMove.xyCageCheckBox.isSelected();
        options.xyCapillaries = this.tabMove.xyTipCapsCheckBox.isSelected();
        options.distance = this.tabMove.distanceCheckBox.isSelected();
        options.alive = this.tabMove.aliveCheckBox.isSelected();
        options.onlyalive = this.tabMove.deadEmptyCheckBox.isSelected();
        options.sleep = this.tabMove.sleepCheckBox.isSelected();
        options.ellipseAxes = this.tabMove.rectSizeCheckBox.isSelected();
        this.getCommonOptions(options, exp);
        return options;
    }

    private XLSExportOptions getLevelsOptions(Experiment exp) {
        XLSExportOptions options = new XLSExportOptions();
        options.sumGulps = false;
        options.nbGulps = false;
        options.topLevel = this.tabLevels.topLevelCheckBox.isSelected();
        options.topLevelDelta = this.tabLevels.topLevelDeltaCheckBox.isSelected();
        options.bottomLevel = this.tabLevels.bottomLevelCheckBox.isSelected();
        options.sumGulps = false;
        options.lrPI = this.tabLevels.lrPICheckBox.isSelected();
        options.lrPIThreshold = (Double)this.tabLevels.lrPIThresholdJSpinner.getValue();
        options.sumPerCage = this.tabLevels.sumPerCageCheckBox.isSelected();
        options.t0 = this.tabLevels.t0CheckBox.isSelected();
        options.subtractEvaporation = this.tabLevels.subtractEvaporationCheckBox.isSelected();
        this.getCommonOptions(options, exp);
        return options;
    }

    private XLSExportOptions getGulpsOptions(Experiment exp) {
        XLSExportOptions options = new XLSExportOptions();
        options.topLevel = false;
        options.topLevelDelta = false;
        options.bottomLevel = false;
        options.derivative = this.tabGulps.derivativeCheckBox.isSelected();
        options.sumPerCage = false;
        options.t0 = false;
        options.sumGulps = this.tabGulps.sumGulpsCheckBox.isSelected();
        options.lrPI = this.tabGulps.sumCheckBox.isSelected();
        options.nbGulps = this.tabGulps.nbGulpsCheckBox.isSelected();
        options.amplitudeGulps = this.tabGulps.amplitudeGulpsCheckBox.isSelected();
        options.autocorrelation = this.tabGulps.autocorrelationCheckBox.isSelected();
        options.crosscorrelation = this.tabGulps.crosscorrelationCheckBox.isSelected();
        options.nbinscorrelation = (Integer)this.tabGulps.nbinsJSpinner.getValue();
        options.subtractEvaporation = false;
        this.getCommonOptions(options, exp);
        return options;
    }

    private void getCommonOptions(XLSExportOptions options, Experiment exp) {
        options.transpose = this.tabCommonOptions.transposeCheckBox.isSelected();
        options.buildExcelStepMs = this.tabCommonOptions.getExcelBuildStep();
        options.buildExcelUnitMs = this.tabCommonOptions.binUnit.getMsUnitValue();
        options.fixedIntervals = this.tabCommonOptions.isFixedFrameButton.isSelected();
        options.startAll_Ms = this.tabCommonOptions.getStartAllMs();
        options.endAll_Ms = this.tabCommonOptions.getEndAllMs();
        options.collateSeries = this.tabCommonOptions.collateSeriesCheckBox.isSelected();
        options.padIntervals = this.tabCommonOptions.padIntervalsCheckBox.isSelected();
        options.absoluteTime = false;
        options.onlyalive = this.tabCommonOptions.onlyAliveCheckBox.isSelected();
        options.exportAllFiles = this.tabCommonOptions.exportAllFilesCheckBox.isSelected();
        options.expList = this.parent0.expListCombo;
        options.expList.expListBinSubDirectory = exp.getBinSubDirectory();
        if (this.tabCommonOptions.exportAllFilesCheckBox.isSelected()) {
            options.firstExp = 0;
            options.lastExp = options.expList.getItemCount() - 1;
        } else {
            options.firstExp = this.parent0.expListCombo.getSelectedIndex();
            options.lastExp = this.parent0.expListCombo.getSelectedIndex();
        }
    }
}

