/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.experiment;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.tools.JComponents.ExperimentsJComboBox;
import plugins.fmp.multicafe.tools.JComponents.SortedComboBoxModel;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSColumnHeader;

public class Filter
extends JPanel {
    private static final long serialVersionUID = 2190848825783418962L;
    private JComboBox<String> cmt1Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> comt2Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> boxIDCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> exptCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> strainCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> sexCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> cond1Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> cond2Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JCheckBox experimentCheck = new JCheckBox(EnumXLSColumnHeader.EXP_EXPT.toString());
    private JCheckBox boxIDCheck = new JCheckBox(EnumXLSColumnHeader.EXP_BOXID.toString());
    private JCheckBox comment1Check = new JCheckBox(EnumXLSColumnHeader.EXP_STIM.toString());
    private JCheckBox comment2Check = new JCheckBox(EnumXLSColumnHeader.EXP_CONC.toString());
    private JCheckBox strainCheck = new JCheckBox(EnumXLSColumnHeader.EXP_STRAIN.toString());
    private JCheckBox sexCheck = new JCheckBox(EnumXLSColumnHeader.EXP_SEX.toString());
    private JCheckBox cond1Check = new JCheckBox(EnumXLSColumnHeader.EXP_COND1.toString());
    private JCheckBox cond2Check = new JCheckBox(EnumXLSColumnHeader.EXP_COND2.toString());
    private JButton applyButton = new JButton("Apply");
    private JButton clearButton = new JButton("Clear");
    private MultiCAFE parent0 = null;
    boolean disableChangeFile = false;
    public ExperimentsJComboBox filterExpList = new ExperimentsJComboBox();

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.parent0 = parent0;
        GridBagLayout layoutThis = new GridBagLayout();
        this.setLayout(layoutThis);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 256;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(1, 2, 1, 2);
        c.gridy = 0;
        this.addLineOfElements(c, this.experimentCheck, this.exptCombo, this.boxIDCheck, this.boxIDCombo, this.applyButton);
        c.gridy = 1;
        this.addLineOfElements(c, this.comment1Check, this.cmt1Combo, this.comment2Check, this.comt2Combo, this.clearButton);
        c.gridy = 2;
        this.addLineOfElements(c, this.strainCheck, this.strainCombo, this.sexCheck, this.sexCombo, null);
        c.gridy = 3;
        this.addLineOfElements(c, this.cond1Check, this.cond1Combo, this.cond2Check, this.cond2Combo, null);
        this.defineActionListeners();
    }

    void addLineOfElements(GridBagConstraints c, JComponent element1, JComponent element2, JComponent element3, JComponent element4, JComponent element5) {
        c.gridx = 0;
        int delta1 = 1;
        int delta2 = 3;
        if (element1 != null) {
            this.add((Component)element1, c);
        }
        c.gridx += delta1;
        if (element2 != null) {
            this.add((Component)element2, c);
        }
        c.gridx += delta2;
        if (element3 != null) {
            this.add((Component)element3, c);
        }
        c.gridx += delta1;
        if (element4 != null) {
            this.add((Component)element4, c);
        }
        c.gridx += delta2;
        if (element5 != null) {
            this.add((Component)element5, c);
        }
    }

    public void initFilterCombos() {
        if (!this.parent0.paneBrowse.panelLoadSave.filteredCheck.isSelected()) {
            this.filterExpList.setExperimentsFromList(this.parent0.expListCombo.getExperimentsAsList());
        }
        this.filterExpList.getFieldValuesToCombo(this.exptCombo, EnumXLSColumnHeader.EXP_EXPT);
        this.filterExpList.getFieldValuesToCombo(this.cmt1Combo, EnumXLSColumnHeader.EXP_STIM);
        this.filterExpList.getFieldValuesToCombo(this.comt2Combo, EnumXLSColumnHeader.EXP_CONC);
        this.filterExpList.getFieldValuesToCombo(this.boxIDCombo, EnumXLSColumnHeader.EXP_BOXID);
        this.filterExpList.getFieldValuesToCombo(this.sexCombo, EnumXLSColumnHeader.EXP_SEX);
        this.filterExpList.getFieldValuesToCombo(this.strainCombo, EnumXLSColumnHeader.EXP_STRAIN);
        this.filterExpList.getFieldValuesToCombo(this.cond1Combo, EnumXLSColumnHeader.EXP_COND1);
        this.filterExpList.getFieldValuesToCombo(this.cond2Combo, EnumXLSColumnHeader.EXP_COND2);
    }

    private void defineActionListeners() {
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter.this.filterExperimentList(true);
                ((Filter)Filter.this).parent0.paneExperiment.tabsPane.setSelectedIndex(0);
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filter.this.filterExperimentList(false);
            }
        });
    }

    public void filterExperimentList(boolean setFilter) {
        if (setFilter) {
            this.parent0.expListCombo.setExperimentsFromList(this.filterAllItems());
        } else {
            this.clearAllCheckBoxes();
            this.parent0.expListCombo.setExperimentsFromList(this.filterExpList.getExperimentsAsList());
        }
        if (this.parent0.expListCombo.getItemCount() > 0) {
            this.parent0.expListCombo.setSelectedIndex(0);
        }
        if (setFilter != this.parent0.paneBrowse.panelLoadSave.filteredCheck.isSelected()) {
            this.parent0.paneBrowse.panelLoadSave.filteredCheck.setSelected(setFilter);
        }
    }

    public void clearAllCheckBoxes() {
        boolean select = false;
        this.experimentCheck.setSelected(select);
        this.boxIDCheck.setSelected(select);
        this.comment1Check.setSelected(select);
        this.comment2Check.setSelected(select);
        this.strainCheck.setSelected(select);
        this.sexCheck.setSelected(select);
        this.cond1Check.setSelected(select);
        this.cond2Check.setSelected(select);
    }

    private List<Experiment> filterAllItems() {
        ArrayList<Experiment> filteredList = new ArrayList<Experiment>(this.filterExpList.getExperimentsAsList());
        if (this.experimentCheck.isSelected()) {
            this.filterItem(filteredList, EnumXLSColumnHeader.EXP_EXPT, (String)this.exptCombo.getSelectedItem());
        }
        if (this.boxIDCheck.isSelected()) {
            this.filterItem(filteredList, EnumXLSColumnHeader.EXP_BOXID, (String)this.boxIDCombo.getSelectedItem());
        }
        if (this.comment1Check.isSelected()) {
            this.filterItem(filteredList, EnumXLSColumnHeader.EXP_STIM, (String)this.cmt1Combo.getSelectedItem());
        }
        if (this.comment2Check.isSelected()) {
            this.filterItem(filteredList, EnumXLSColumnHeader.EXP_CONC, (String)this.comt2Combo.getSelectedItem());
        }
        if (this.sexCheck.isSelected()) {
            this.filterItem(filteredList, EnumXLSColumnHeader.EXP_SEX, (String)this.sexCombo.getSelectedItem());
        }
        if (this.strainCheck.isSelected()) {
            this.filterItem(filteredList, EnumXLSColumnHeader.EXP_STRAIN, (String)this.strainCombo.getSelectedItem());
        }
        if (this.cond1Check.isSelected()) {
            this.filterItem(filteredList, EnumXLSColumnHeader.EXP_COND1, (String)this.cond1Combo.getSelectedItem());
        }
        if (this.cond2Check.isSelected()) {
            this.filterItem(filteredList, EnumXLSColumnHeader.EXP_COND2, (String)this.cond2Combo.getSelectedItem());
        }
        return filteredList;
    }

    void filterItem(List<Experiment> filteredList, EnumXLSColumnHeader header, String filter) {
        Iterator<Experiment> iterator = filteredList.iterator();
        while (iterator.hasNext()) {
            Experiment exp = iterator.next();
            int compare = exp.getExperimentField(header).compareTo(filter);
            if (compare == 0) continue;
            iterator.remove();
        }
    }
}

