/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.experiment;

import icy.canvas.Canvas2D;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.tools.JComponents.SortedComboBoxModel;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSColumnHeader;

public class Infos
extends JPanel {
    private static final long serialVersionUID = 2190848825783418962L;
    private JComboBox<String> cmt1Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> comt2Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> boxIDCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> exptCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> strainCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> sexCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> cond1Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> cond2Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JLabel experimentCheck = new JLabel(EnumXLSColumnHeader.EXP_EXPT.toString());
    private JLabel boxIDCheck = new JLabel(EnumXLSColumnHeader.EXP_BOXID.toString());
    private JLabel comment1Check = new JLabel(EnumXLSColumnHeader.EXP_STIM.toString());
    private JLabel comment2Check = new JLabel(EnumXLSColumnHeader.EXP_CONC.toString());
    private JLabel strainCheck = new JLabel(EnumXLSColumnHeader.EXP_STRAIN.toString());
    private JLabel sexCheck = new JLabel(EnumXLSColumnHeader.EXP_SEX.toString());
    private JLabel cond1Check = new JLabel(EnumXLSColumnHeader.EXP_COND1.toString());
    private JLabel cond2Check = new JLabel(EnumXLSColumnHeader.EXP_COND2.toString());
    private JButton openButton = new JButton("Load...");
    private JButton saveButton = new JButton("Save...");
    private JButton duplicateButton = new JButton("Get previous");
    private JButton zoomButton = new JButton("zoom top");
    private MultiCAFE parent0 = null;
    public boolean disableChangeFile = false;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.parent0 = parent0;
        GridBagLayout layoutThis = new GridBagLayout();
        this.setLayout(layoutThis);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 256;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(1, 2, 1, 2);
        int delta1 = 1;
        int delta2 = 3;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.experimentCheck, c);
        c.gridx += delta1;
        this.add(this.exptCombo, c);
        c.gridx += delta2;
        this.add((Component)this.boxIDCheck, c);
        c.gridx += delta1;
        this.add(this.boxIDCombo, c);
        c.gridx += delta2;
        this.add((Component)this.openButton, c);
        c.gridy = 1;
        c.gridx = 0;
        this.add((Component)this.comment1Check, c);
        c.gridx += delta1;
        this.add(this.cmt1Combo, c);
        c.gridx += delta2;
        this.add((Component)this.comment2Check, c);
        c.gridx += delta1;
        this.add(this.comt2Combo, c);
        c.gridx += delta2;
        this.add((Component)this.saveButton, c);
        c.gridy = 2;
        c.gridx = 0;
        this.add((Component)this.strainCheck, c);
        c.gridx += delta1;
        this.add(this.strainCombo, c);
        c.gridx += delta2;
        this.add((Component)this.sexCheck, c);
        c.gridx += delta1;
        this.add(this.sexCombo, c);
        c.gridx += delta2;
        this.add((Component)this.duplicateButton, c);
        c.gridy = 3;
        c.gridx = 0;
        this.add((Component)this.cond1Check, c);
        c.gridx += delta1;
        this.add(this.cond1Combo, c);
        c.gridx += delta2;
        this.add((Component)this.cond2Check, c);
        c.gridx += delta1;
        this.add(this.cond2Combo, c);
        c.gridx += delta2;
        this.add((Component)this.zoomButton, c);
        this.zoomButton.setEnabled(false);
        this.boxIDCombo.setEditable(true);
        this.exptCombo.setEditable(true);
        this.cmt1Combo.setEditable(true);
        this.comt2Combo.setEditable(true);
        this.strainCombo.setEditable(true);
        this.sexCombo.setEditable(true);
        this.cond1Combo.setEditable(true);
        this.cond2Combo.setEditable(true);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.xmlLoad_MCExperiment();
                    Infos.this.transferPreviousExperimentInfosToDialog(exp, exp);
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Infos.this.getExperimentInfosFromDialog(exp);
                    exp.xmlSave_MCExperiment();
                }
            }
        });
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.duplicatePreviousDescriptors();
            }
        });
        this.zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Infos.this.zoomToUpperCorner(exp);
                }
            }
        });
    }

    public void transferPreviousExperimentInfosToDialog(Experiment exp_source, Experiment exp_destination) {
        this.setInfoCombo(exp_destination, exp_source, this.boxIDCombo, EnumXLSColumnHeader.EXP_BOXID);
        this.setInfoCombo(exp_destination, exp_source, this.exptCombo, EnumXLSColumnHeader.EXP_EXPT);
        this.setInfoCombo(exp_destination, exp_source, this.cmt1Combo, EnumXLSColumnHeader.EXP_STIM);
        this.setInfoCombo(exp_destination, exp_source, this.comt2Combo, EnumXLSColumnHeader.EXP_CONC);
        this.setInfoCombo(exp_destination, exp_source, this.strainCombo, EnumXLSColumnHeader.EXP_STRAIN);
        this.setInfoCombo(exp_destination, exp_source, this.sexCombo, EnumXLSColumnHeader.EXP_SEX);
        this.setInfoCombo(exp_destination, exp_source, this.cond1Combo, EnumXLSColumnHeader.EXP_COND1);
        this.setInfoCombo(exp_destination, exp_source, this.cond2Combo, EnumXLSColumnHeader.EXP_COND2);
    }

    private void setInfoCombo(Experiment exp_dest, Experiment exp_source, JComboBox<String> combo, EnumXLSColumnHeader field) {
        String altText = exp_source.getExperimentField(field);
        String text = exp_dest.getExperimentField(field);
        if (text.equals("..")) {
            exp_dest.setExperimentFieldNoTest(field, altText);
        }
        text = exp_dest.getExperimentField(field);
        this.addItemToComboIfNew(text, combo);
        combo.setSelectedItem(text);
    }

    public void getExperimentInfosFromDialog(Experiment exp) {
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_BOXID, (String)this.boxIDCombo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_EXPT, (String)this.exptCombo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STIM, (String)this.cmt1Combo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_CONC, (String)this.comt2Combo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STRAIN, (String)this.strainCombo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_SEX, (String)this.sexCombo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_COND1, (String)this.cond1Combo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_COND2, (String)this.cond2Combo.getSelectedItem());
    }

    private void addItemToComboIfNew(String toAdd, JComboBox<String> combo) {
        if (toAdd == null) {
            return;
        }
        SortedComboBoxModel model = (SortedComboBoxModel)combo.getModel();
        if (model.getIndexOf(toAdd) == -1) {
            model.addElement(toAdd);
        }
    }

    public void initInfosCombos() {
        this.parent0.expListCombo.getFieldValuesToCombo(this.exptCombo, EnumXLSColumnHeader.EXP_EXPT);
        this.parent0.expListCombo.getFieldValuesToCombo(this.cmt1Combo, EnumXLSColumnHeader.EXP_STIM);
        this.parent0.expListCombo.getFieldValuesToCombo(this.comt2Combo, EnumXLSColumnHeader.EXP_CONC);
        this.parent0.expListCombo.getFieldValuesToCombo(this.boxIDCombo, EnumXLSColumnHeader.EXP_BOXID);
        this.parent0.expListCombo.getFieldValuesToCombo(this.strainCombo, EnumXLSColumnHeader.EXP_STRAIN);
        this.parent0.expListCombo.getFieldValuesToCombo(this.sexCombo, EnumXLSColumnHeader.EXP_SEX);
        this.parent0.expListCombo.getFieldValuesToCombo(this.cond1Combo, EnumXLSColumnHeader.EXP_COND1);
        this.parent0.expListCombo.getFieldValuesToCombo(this.cond2Combo, EnumXLSColumnHeader.EXP_COND2);
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.transferPreviousExperimentInfosToDialog(exp, exp);
        }
    }

    public void clearCombos() {
        this.exptCombo.removeAllItems();
        this.cmt1Combo.removeAllItems();
        this.comt2Combo.removeAllItems();
        this.boxIDCombo.removeAllItems();
        this.strainCombo.removeAllItems();
        this.sexCombo.removeAllItems();
        this.cond1Combo.removeAllItems();
        this.cond2Combo.removeAllItems();
    }

    void duplicatePreviousDescriptors() {
        int iprevious = this.parent0.expListCombo.getSelectedIndex() - 1;
        if (iprevious < 0) {
            return;
        }
        Experiment exp0 = (Experiment)this.parent0.expListCombo.getItemAt(iprevious);
        Experiment exp = (Experiment)this.parent0.expListCombo.getItemAt(iprevious + 1);
        this.transferPreviousExperimentInfosToDialog(exp0, exp);
        this.parent0.paneCapillaries.transferPreviousExperimentCapillariesInfos(exp0, exp);
    }

    void zoomToUpperCorner(Experiment exp) {
        Sequence seq = exp.seqCamData.seq;
        Viewer v = seq.getFirstViewer();
        if (v != null) {
            Canvas2D canvas = (Canvas2D)v.getCanvas();
            canvas.setScale(2.0, 2.0, true);
            canvas.setOffset(0, 0, true);
        }
    }
}

