/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.levels;

import icy.painter.Overlay;
import icy.roi.ROI;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.series.BuildSeriesOptions;
import plugins.fmp.multicafe.series.DetectLevels;
import plugins.fmp.multicafe.tools.Canvas2D.Canvas2DWithTransforms;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multicafe.tools.Overlay.OverlayThreshold;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class Levels
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -6329863521455897561L;
    private JCheckBox pass1CheckBox = new JCheckBox("pass1", true);
    private JComboBox<String> direction1ComboBox = new JComboBox<String>(new String[]{" threshold >", " threshold <"});
    private JSpinner threshold1Spinner = new JSpinner(new SpinnerNumberModel(35, 1, 255, 1));
    private ImageTransformEnums[] transformPass1 = new ImageTransformEnums[]{ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.RGB_DIFFS, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB};
    public JComboBox<ImageTransformEnums> transformPass1ComboBox = new JComboBox<ImageTransformEnums>(this.transformPass1);
    private JToggleButton transformPass1DisplayButton = new JToggleButton("View");
    private JCheckBox overlayPass1CheckBox = new JCheckBox("overlay");
    private JCheckBox pass2CheckBox = new JCheckBox("pass2", false);
    private JComboBox<String> direction2ComboBox = new JComboBox<String>(new String[]{" threshold >", " threshold <"});
    private JSpinner threshold2Spinner = new JSpinner(new SpinnerNumberModel(40, 1, 255, 1));
    private ImageTransformEnums[] transformPass2 = new ImageTransformEnums[]{ImageTransformEnums.YDIFFN, ImageTransformEnums.YDIFFN2, ImageTransformEnums.DERICHE, ImageTransformEnums.DERICHE_COLOR, ImageTransformEnums.MINUSHORIZAVG, ImageTransformEnums.COLORDISTANCE_L1_Y, ImageTransformEnums.COLORDISTANCE_L2_Y, ImageTransformEnums.SUBTRACT_1RSTCOL, ImageTransformEnums.L1DIST_TO_1RSTCOL};
    private JComboBox<ImageTransformEnums> transformPass2ComboBox = new JComboBox<ImageTransformEnums>(this.transformPass2);
    private JToggleButton transformPass2DisplayButton = new JToggleButton("View");
    private JCheckBox overlayPass2CheckBox = new JCheckBox("overlay");
    private JCheckBox allKymosCheckBox = new JCheckBox("all kymographs", true);
    private JSpinner spanTopSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 100, 1));
    private String detectString = "        Detect     ";
    private JButton detectButton = new JButton(this.detectString);
    private JCheckBox fromCheckBox = new JCheckBox(" detection from ROI rectangle", false);
    private JCheckBox allSeriesCheckBox = new JCheckBox("ALL (current to last)", false);
    private JCheckBox leftCheckBox = new JCheckBox("L", true);
    private JCheckBox rightCheckBox = new JCheckBox("R", true);
    private JCheckBox runBackwardsCheckBox = new JCheckBox("run backwards", false);
    private MultiCAFE parent0 = null;
    private DetectLevels threadDetectLevels = null;
    private String SEARCHRECT = new String("search_rectangle");
    private ROI2DRectangle searchRectangleROI2D = null;
    private OverlayThreshold overlayThreshold = null;
    private int currentKymographImage = 0;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel0 = new JPanel(layoutLeft);
        ((FlowLayout)panel0.getLayout()).setVgap(0);
        panel0.add(this.detectButton);
        panel0.add(this.allSeriesCheckBox);
        panel0.add(this.allKymosCheckBox);
        panel0.add(this.leftCheckBox);
        panel0.add(this.rightCheckBox);
        this.add(panel0);
        JPanel panel01 = new JPanel(layoutLeft);
        panel01.add(this.pass1CheckBox);
        panel01.add(this.direction1ComboBox);
        ((JLabel)((Object)this.direction1ComboBox.getRenderer())).setHorizontalAlignment(4);
        panel01.add(this.threshold1Spinner);
        panel01.add(this.transformPass1ComboBox);
        panel01.add(this.transformPass1DisplayButton);
        panel01.add(this.overlayPass1CheckBox);
        this.add(panel01);
        JPanel panel02 = new JPanel(layoutLeft);
        panel02.add(this.pass2CheckBox);
        panel02.add(this.direction2ComboBox);
        ((JLabel)((Object)this.direction2ComboBox.getRenderer())).setHorizontalAlignment(4);
        panel02.add(this.threshold2Spinner);
        panel02.add(this.transformPass2ComboBox);
        panel02.add(this.transformPass2DisplayButton);
        panel02.add(this.overlayPass2CheckBox);
        this.add(panel02);
        JPanel panel03 = new JPanel(layoutLeft);
        panel03.add(this.fromCheckBox);
        panel03.add(this.runBackwardsCheckBox);
        this.add(panel03);
        this.defineActionListeners();
        this.defineItemListeners();
        this.allowItemsAccordingToSelection();
    }

    private void defineItemListeners() {
        this.overlayPass1CheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = (Experiment)((Levels)Levels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (Levels.this.overlayPass1CheckBox.isSelected()) {
                        Levels.this.updateOverlay(exp);
                    } else {
                        Levels.this.removeOverlay(exp);
                    }
                }
            }
        });
        this.overlayPass2CheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = (Experiment)((Levels)Levels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (Levels.this.overlayPass2CheckBox.isSelected()) {
                        Levels.this.updateOverlay(exp);
                    } else {
                        Levels.this.removeOverlay(exp);
                    }
                }
            }
        });
        this.threshold1Spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Levels.this.updateOverlayThreshold();
            }
        });
        this.threshold2Spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Levels.this.updateOverlayThreshold();
            }
        });
    }

    private void defineActionListeners() {
        this.transformPass1ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Levels)Levels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqKymos != null) {
                    int index = Levels.this.transformPass1ComboBox.getSelectedIndex();
                    Levels.this.getKymosCanvas((Experiment)exp).transformsCombo1.setSelectedIndex(index + 1);
                    Levels.this.updateOverlayThreshold();
                }
            }
        });
        this.transformPass2ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Levels.this.allowItemsAccordingToSelection();
                Experiment exp = (Experiment)((Levels)Levels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqCamData != null) {
                    int index = Levels.this.transformPass2ComboBox.getSelectedIndex();
                    Levels.this.getKymosCanvas((Experiment)exp).transformsCombo1.setSelectedIndex(index + 1);
                    Levels.this.updateOverlayThreshold();
                }
            }
        });
        this.detectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Levels.this.detectButton.getText().equals(Levels.this.detectString)) {
                    Levels.this.startLevelsDetection();
                } else {
                    Levels.this.stopLevelsDetection();
                }
            }
        });
        this.transformPass1DisplayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Levels)Levels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    boolean displayCheckOverlay = false;
                    if (Levels.this.transformPass1DisplayButton.isSelected()) {
                        Levels.this.transformPass2DisplayButton.setSelected(false);
                        Canvas2DWithTransforms canvas = Levels.this.getKymosCanvas(exp);
                        canvas.updateTransformsComboStep1(Levels.this.transformPass1);
                        int index = Levels.this.transformPass1ComboBox.getSelectedIndex();
                        canvas.selectIndexStep1(index + 1, null);
                        displayCheckOverlay = true;
                    } else {
                        Levels.this.removeOverlay(exp);
                        Levels.this.overlayPass1CheckBox.setSelected(false);
                        Levels.this.getKymosCanvas((Experiment)exp).transformsCombo1.setSelectedIndex(0);
                    }
                    Levels.this.overlayPass1CheckBox.setEnabled(displayCheckOverlay);
                }
            }
        });
        this.transformPass2DisplayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Levels)Levels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    boolean displayCheckOverlay = false;
                    if (Levels.this.transformPass2DisplayButton.isSelected()) {
                        Levels.this.transformPass1DisplayButton.setSelected(false);
                        Canvas2DWithTransforms canvas = Levels.this.getKymosCanvas(exp);
                        canvas.updateTransformsComboStep1(Levels.this.transformPass2);
                        int index = Levels.this.transformPass2ComboBox.getSelectedIndex();
                        canvas.selectIndexStep1(index + 1, null);
                        displayCheckOverlay = true;
                    } else {
                        Levels.this.removeOverlay(exp);
                        Levels.this.overlayPass2CheckBox.setSelected(false);
                        Levels.this.getKymosCanvas((Experiment)exp).transformsCombo1.setSelectedIndex(0);
                    }
                    Levels.this.overlayPass1CheckBox.setEnabled(displayCheckOverlay);
                }
            }
        });
        this.allSeriesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Levels.this.allSeriesCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Levels.this.allSeriesCheckBox.setForeground(color);
                Levels.this.detectButton.setForeground(color);
            }
        });
        this.fromCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Levels)Levels.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                if (Levels.this.fromCheckBox.isSelected()) {
                    Levels.this.displaySearchArea(exp);
                } else if (Levels.this.searchRectangleROI2D != null) {
                    exp.seqKymos.seq.removeROI((ROI)Levels.this.searchRectangleROI2D);
                }
            }
        });
        this.direction1ComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Levels.this.updateOverlayThreshold();
            }
        });
    }

    void allowItemsAccordingToSelection() {
        boolean flag = false;
        switch ((ImageTransformEnums)((Object)this.transformPass2ComboBox.getSelectedItem())) {
            case SUBTRACT_1RSTCOL: 
            case L1DIST_TO_1RSTCOL: {
                flag = true;
                break;
            }
        }
        this.threshold2Spinner.setEnabled(flag);
    }

    void setDialogFromOptions(Capillary cap) {
        BuildSeriesOptions options = cap.limitsOptions;
        this.pass1CheckBox.setSelected(options.pass1);
        this.pass2CheckBox.setSelected(options.pass2);
        this.transformPass1ComboBox.setSelectedItem((Object)options.transform01);
        int index = options.directionUp1 ? 0 : 1;
        this.direction1ComboBox.setSelectedIndex(index);
        this.threshold1Spinner.setValue(options.detectLevel1Threshold);
        this.transformPass2ComboBox.setSelectedItem((Object)options.transform02);
        index = options.directionUp2 ? 0 : 1;
        this.direction2ComboBox.setSelectedIndex(index);
        this.threshold2Spinner.setValue(options.detectLevel2Threshold);
        this.allKymosCheckBox.setSelected(options.detectAllKymos);
        this.leftCheckBox.setSelected(options.detectL);
        this.rightCheckBox.setSelected(options.detectR);
        this.fromCheckBox.setSelected(false);
    }

    void setOptionsFromDialog(Capillary cap) {
        BuildSeriesOptions capOptions = cap.limitsOptions;
        capOptions.pass1 = this.pass1CheckBox.isSelected();
        capOptions.pass2 = this.pass2CheckBox.isSelected();
        capOptions.transform01 = (ImageTransformEnums)((Object)this.transformPass1ComboBox.getSelectedItem());
        capOptions.transform02 = (ImageTransformEnums)((Object)this.transformPass2ComboBox.getSelectedItem());
        capOptions.directionUp1 = this.direction1ComboBox.getSelectedIndex() == 0;
        capOptions.detectLevel1Threshold = (Integer)this.threshold1Spinner.getValue();
        capOptions.directionUp2 = this.direction2ComboBox.getSelectedIndex() == 0;
        capOptions.detectLevel2Threshold = (Integer)this.threshold2Spinner.getValue();
        capOptions.detectAllKymos = this.allKymosCheckBox.isSelected();
        capOptions.detectL = this.leftCheckBox.isSelected();
        capOptions.detectR = this.rightCheckBox.isSelected();
    }

    private BuildSeriesOptions initBuildParameters(Experiment exp) {
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allSeriesCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.detectAllKymos = this.allKymosCheckBox.isSelected();
        this.currentKymographImage = 0;
        if (!this.allKymosCheckBox.isSelected()) {
            int t;
            options.kymoFirst = t = exp.seqKymos.seq.getFirstViewer().getPositionT();
            options.kymoLast = t;
            this.currentKymographImage = exp.seqKymos.seq.getFirstViewer().getPositionT();
        } else {
            options.kymoFirst = 0;
            options.kymoLast = exp.seqKymos.seq.getSizeT() - 1;
        }
        options.pass1 = this.pass1CheckBox.isSelected();
        options.transform01 = (ImageTransformEnums)((Object)this.transformPass1ComboBox.getSelectedItem());
        options.directionUp1 = this.direction1ComboBox.getSelectedIndex() == 0;
        options.detectLevel1Threshold = (Integer)this.threshold1Spinner.getValue();
        options.pass2 = this.pass2CheckBox.isSelected();
        options.transform02 = (ImageTransformEnums)((Object)this.transformPass2ComboBox.getSelectedItem());
        options.directionUp2 = this.direction2ComboBox.getSelectedIndex() == 0;
        options.detectLevel2Threshold = (Integer)this.threshold2Spinner.getValue();
        options.analyzePartOnly = this.fromCheckBox.isSelected();
        options.searchArea = this.getSearchAreaFromSearchRectangle(exp, this.fromCheckBox.isSelected() && this.searchRectangleROI2D != null);
        options.spanDiffTop = (Integer)this.spanTopSpinner.getValue();
        options.detectL = this.leftCheckBox.isSelected();
        options.detectR = this.rightCheckBox.isSelected();
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.binSubDirectory = this.parent0.expListCombo.expListBinSubDirectory;
        options.runBackwards = this.runBackwardsCheckBox.isSelected();
        return options;
    }

    void startLevelsDetection() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.threadDetectLevels = new DetectLevels();
            this.threadDetectLevels.options = this.initBuildParameters(exp);
            this.threadDetectLevels.addPropertyChangeListener(this);
            this.threadDetectLevels.execute();
            this.detectButton.setText("STOP");
        }
    }

    private void stopLevelsDetection() {
        if (this.threadDetectLevels != null && !this.threadDetectLevels.stopFlag) {
            this.threadDetectLevels.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.detectButton.setText(this.detectString);
            System.out.println("thread_ended");
            this.parent0.paneKymos.tabDisplay.selectKymographImage(this.currentKymographImage);
            this.parent0.paneKymos.tabDisplay.indexImagesCombo = -1;
            this.fromCheckBox.setSelected(false);
        }
    }

    private void displaySearchArea(Experiment exp) {
        if (this.searchRectangleROI2D == null) {
            Rectangle searchRectangle = exp.seqKymos.seq.getBounds2D();
            --searchRectangle.width;
            --searchRectangle.height;
            this.searchRectangleROI2D = new ROI2DRectangle((Rectangle2D)searchRectangle);
            this.searchRectangleROI2D.setName(this.SEARCHRECT);
            this.searchRectangleROI2D.setColor(Color.ORANGE);
        }
        exp.seqKymos.seq.addROI((ROI)this.searchRectangleROI2D);
        exp.seqKymos.seq.setSelectedROI((ROI)this.searchRectangleROI2D);
    }

    private Rectangle getSearchAreaFromSearchRectangle(Experiment exp, boolean fitSmallerRectangle) {
        Rectangle seqRectangle = exp.seqKymos.seq.getBounds2D();
        --seqRectangle.height;
        --seqRectangle.width;
        if (fitSmallerRectangle) {
            Rectangle rectangle = this.searchRectangleROI2D.getBounds();
            if (rectangle.x < 0) {
                rectangle.width += rectangle.x;
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.height += rectangle.y;
                rectangle.y = 0;
            }
            if (rectangle.width + rectangle.x > seqRectangle.width) {
                rectangle.width = seqRectangle.width - rectangle.x;
            }
            if (rectangle.height + rectangle.y > seqRectangle.height) {
                rectangle.height = seqRectangle.height - rectangle.y;
            }
            System.out.println(rectangle);
            return rectangle;
        }
        return seqRectangle;
    }

    protected Canvas2DWithTransforms getKymosCanvas(Experiment exp) {
        Canvas2DWithTransforms canvas = (Canvas2DWithTransforms)exp.seqKymos.seq.getFirstViewer().getCanvas();
        return canvas;
    }

    void updateOverlay(Experiment exp) {
        if (exp.seqKymos == null) {
            return;
        }
        if (this.overlayThreshold == null) {
            this.overlayThreshold = new OverlayThreshold(exp.seqKymos);
        } else {
            exp.seqKymos.seq.removeOverlay((Overlay)this.overlayThreshold);
            this.overlayThreshold.setSequence(exp.seqKymos);
        }
        if (this.transformPass1DisplayButton.isSelected() || this.transformPass2DisplayButton.isSelected()) {
            exp.seqKymos.seq.addOverlay((Overlay)this.overlayThreshold);
            this.updateOverlayThreshold();
        }
    }

    void updateOverlayThreshold() {
        if (this.overlayThreshold == null) {
            return;
        }
        boolean ifGreater = true;
        int threshold = 0;
        ImageTransformEnums transform = ImageTransformEnums.NONE;
        if (this.transformPass1DisplayButton.isSelected()) {
            ifGreater = this.direction1ComboBox.getSelectedIndex() == 0;
            threshold = (Integer)this.threshold1Spinner.getValue();
            transform = (ImageTransformEnums)((Object)this.transformPass1ComboBox.getSelectedItem());
        } else if (this.transformPass2DisplayButton.isSelected()) {
            ifGreater = this.direction2ComboBox.getSelectedIndex() == 0;
            threshold = (Integer)this.threshold2Spinner.getValue();
            transform = (ImageTransformEnums)((Object)this.transformPass2ComboBox.getSelectedItem());
        } else {
            return;
        }
        this.overlayThreshold.setThresholdSingle(threshold, transform, ifGreater);
        this.overlayThreshold.painterChanged();
    }

    void removeOverlay(Experiment exp) {
        if (exp.seqKymos != null && exp.seqKymos.seq != null) {
            exp.seqKymos.seq.removeOverlay((Overlay)this.overlayThreshold);
        }
    }
}

