/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.levels;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.FontUtil;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;

public class LoadSaveLevels
extends JPanel {
    private static final long serialVersionUID = -3973928400949966679L;
    private JButton loadMeasuresButton = new JButton("Load");
    private JButton saveMeasuresButton = new JButton("Save");
    private MultiCAFE parent0 = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        JLabel loadsaveText = new JLabel("-> File (xml) ", 4);
        loadsaveText.setFont(FontUtil.setStyle((Font)loadsaveText.getFont(), (int)2));
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(loadsaveText);
        panel1.add(this.loadMeasuresButton);
        panel1.add(this.saveMeasuresButton);
        panel1.validate();
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.loadMeasuresButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveLevels)LoadSaveLevels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveLevels.this.dlg_levels_loadCapillaries_Measures(exp);
                }
            }
        });
        this.saveMeasuresButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveLevels)LoadSaveLevels.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveLevels.this.dlg_levels_saveCapillaries_Measures(exp);
                    LoadSaveLevels.this.firePropertyChange("MEASURES_SAVE", false, true);
                }
            }
        });
    }

    public boolean dlg_levels_loadCapillaries_Measures(Experiment exp) {
        boolean flag = false;
        if (exp.seqKymos != null) {
            ProgressFrame progress = new ProgressFrame("load capillary measures");
            flag = exp.loadCapillaries();
            if (flag) {
                exp.seqKymos.transferCapillariesMeasuresToKymos(exp.capillaries);
            }
            progress.close();
        }
        return flag;
    }

    public boolean dlg_levels_saveCapillaries_Measures(Experiment exp) {
        boolean flag = true;
        if (exp.seqKymos != null) {
            ProgressFrame progress = new ProgressFrame("save capillary measures");
            flag = exp.saveCapillariesMeasures(exp.getKymosBinFullDirectory());
            progress.close();
        }
        return flag;
    }
}

