/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment;

import java.util.ArrayList;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;

public class CombinedExperiment
extends Experiment {
    ArrayList<Experiment> experimentList = new ArrayList(1);
    boolean collateExperiments = false;

    public CombinedExperiment(Experiment exp, boolean collate) {
        this.experimentList.add(exp);
        this.collateExperiments = collate;
        if (this.collateExperiments) {
            this.setGroupedExperiment(exp);
        }
    }

    public void loadExperimentDescriptors() {
        Experiment expi = this.experimentList.get(0);
        this.copyExperimentFields(expi);
        this.copyOtherExperimentFields(expi);
        this.firstImage_FileTime = expi.firstImage_FileTime;
        expi = this.experimentList.get(this.experimentList.size() - 1);
        this.lastImage_FileTime = expi.lastImage_FileTime;
    }

    public void loadExperimentCamFileNames() {
        Experiment expi = this.experimentList.get(0);
        while (expi != null) {
            this.seqCamData.imagesList.addAll(expi.seqCamData.imagesList);
            expi = expi.chainToNextExperiment;
        }
    }

    private void copyOtherExperimentFields(Experiment source) {
        this.setImagesDirectory(source.getImagesDirectory());
        this.setExperimentDirectory(source.getExperimentDirectory());
        this.setBinSubDirectory(source.getBinSubDirectory());
    }

    private void setGroupedExperiment(Experiment exp) {
        Experiment expi = exp.getFirstChainedExperiment(true);
        this.experimentList = new ArrayList(1);
        while (expi != null) {
            this.experimentList.add(expi);
            expi = expi.chainToNextExperiment;
        }
    }

    public void setSingleExperiment() {
        Experiment expi = this.experimentList.get(0);
        this.experimentList = new ArrayList(1);
        this.experimentList.add(expi);
    }

    public void loadCapillaryMeasures() {
    }

    public void loadFlyPositions() {
        long time_start_ms = this.firstImage_FileTime.toMillis();
        Experiment exp = this.experimentList.get(0);
        exp.initTmsForFlyPositions(time_start_ms);
        this.cages.cageList.addAll(exp.cages.cageList);
        for (int i = 1; i < this.experimentList.size(); ++i) {
            Experiment expi = this.experimentList.get(i);
            expi.initTmsForFlyPositions(time_start_ms);
            for (Cage cell : this.cages.cageList) {
                String cellName = cell.getRoiName();
                for (Cage cellExpi : expi.cages.cageList) {
                    if (!cellName.equals(cellExpi.getRoiName())) continue;
                    cell.addFlyPositionsFromOtherCage(cellExpi);
                }
            }
        }
    }
}

