/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment;

import icy.image.IcyBufferedImage;
import icy.image.ImageUtil;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.util.XMLUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multicafe.experiment.ExperimentDirectories;
import plugins.fmp.multicafe.experiment.ImageFileDescriptor;
import plugins.fmp.multicafe.experiment.SequenceCamData;
import plugins.fmp.multicafe.experiment.SequenceKymos;
import plugins.fmp.multicafe.experiment.SequenceKymosUtils;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.cages.Cages;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.Directories;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSColumnHeader;

public class Experiment {
    public static final String RESULTS = "results";
    public static final String BIN = "bin_";
    private String strImagesDirectory = null;
    private String strExperimentDirectory = null;
    private String strBinSubDirectory = null;
    public SequenceCamData seqCamData = null;
    public SequenceKymos seqKymos = null;
    public Sequence seqReference = null;
    public Capillaries capillaries = new Capillaries();
    public Cages cages = new Cages();
    public FileTime firstImage_FileTime;
    public FileTime lastImage_FileTime;
    public long camImageFirst_ms = -1L;
    public long camImageLast_ms = -1L;
    public long camImageBin_ms = -1L;
    public long[] camImages_ms = null;
    public long binT0 = 0L;
    public long kymoFirst_ms = 0L;
    public long kymoLast_ms = 0L;
    public long kymoBin_ms = 60000L;
    private String field_boxID = new String("..");
    private String field_experiment = new String("..");
    private String field_comment1 = new String("..");
    private String field_comment2 = new String("..");
    private String field_strain = new String("..");
    private String field_sex = new String("..");
    private String field_cond1 = new String("..");
    private String field_cond2 = new String("..");
    public int col = -1;
    public Experiment chainToPreviousExperiment = null;
    public Experiment chainToNextExperiment = null;
    public long chainImageFirst_ms = 0L;
    public int experimentID = 0;
    private static final String ID_VERSION = "version";
    private static final String ID_VERSIONNUM = "1.0.0";
    private static final String ID_TIMEFIRSTIMAGE = "fileTimeImageFirstMinute";
    private static final String ID_TIMELASTIMAGE = "fileTimeImageLastMinute";
    private static final String ID_BINT0 = "indexBinT0";
    private static final String ID_TIMEFIRSTIMAGEMS = "fileTimeImageFirstMs";
    private static final String ID_TIMELASTIMAGEMS = "fileTimeImageLastMs";
    private static final String ID_FIRSTKYMOCOLMS = "firstKymoColMs";
    private static final String ID_LASTKYMOCOLMS = "lastKymoColMs";
    private static final String ID_BINKYMOCOLMS = "binKymoColMs";
    private static final String ID_IMAGESDIRECTORY = "imagesDirectory";
    private static final String ID_MCEXPERIMENT = "MCexperiment";
    private static final String ID_MCEXPERIMENT_XML = "MCexperiment.xml";
    private static final String ID_BOXID = "boxID";
    private static final String ID_EXPERIMENT = "experiment";
    private static final String ID_COMMENT1 = "comment";
    private static final String ID_COMMENT2 = "comment2";
    private static final String ID_STRAIN = "strain";
    private static final String ID_SEX = "sex";
    private static final String ID_COND1 = "cond1";
    private static final String ID_COND2 = "cond2";
    private static final int EXPT_DIRECTORY = 1;
    private static final int IMG_DIRECTORY = 2;
    private static final int BIN_DIRECTORY = 3;

    public Experiment() {
        this.seqCamData = new SequenceCamData();
        this.seqKymos = new SequenceKymos();
    }

    public Experiment(String expDirectory) {
        this.seqCamData = new SequenceCamData();
        this.seqKymos = new SequenceKymos();
        this.strExperimentDirectory = expDirectory;
    }

    public Experiment(SequenceCamData seqCamData) {
        this.seqCamData = seqCamData;
        this.seqKymos = new SequenceKymos();
        this.strExperimentDirectory = this.seqCamData.getImagesDirectory() + File.separator + RESULTS;
        this.getFileIntervalsFromSeqCamData();
        this.xmlLoadExperiment(this.concatenateExptDirectoryWithSubpathAndName(null, ID_MCEXPERIMENT_XML));
    }

    public Experiment(ExperimentDirectories eADF) {
        String imgDir = null;
        if (eADF.cameraImagesList.size() > 0) {
            imgDir = eADF.cameraImagesList.get(0);
        }
        this.strImagesDirectory = Directories.getDirectoryFromName(imgDir);
        this.strExperimentDirectory = eADF.resultsDirectory;
        String binDirectory = this.strExperimentDirectory + File.separator + eADF.binSubDirectory;
        Path binDirectoryPath = Paths.get(binDirectory, new String[0]);
        Path lastSubPath = binDirectoryPath.getName(binDirectoryPath.getNameCount() - 1);
        this.strBinSubDirectory = lastSubPath.toString();
        this.seqCamData = new SequenceCamData(eADF.cameraImagesList);
        this.getFileIntervalsFromSeqCamData();
        this.seqKymos = new SequenceKymos(eADF.kymosImagesList);
        this.xmlLoadExperiment(this.concatenateExptDirectoryWithSubpathAndName(null, ID_MCEXPERIMENT_XML));
    }

    public String getExperimentDirectory() {
        return this.strExperimentDirectory;
    }

    public void setExperimentDirectory(String fileName) {
        this.strExperimentDirectory = ExperimentDirectories.getParentIf(fileName, BIN);
    }

    public String toString() {
        return this.strExperimentDirectory;
    }

    public String getKymosBinFullDirectory() {
        String filename = this.strExperimentDirectory;
        if (this.strBinSubDirectory != null) {
            filename = filename + File.separator + this.strBinSubDirectory;
        }
        return filename;
    }

    public void setBinSubDirectory(String bin) {
        this.strBinSubDirectory = bin;
    }

    public String getBinSubDirectory() {
        return this.strBinSubDirectory;
    }

    public boolean createDirectoryIfDoesNotExist(String directory) {
        Path pathDir = Paths.get(directory, new String[0]);
        if (Files.notExists(pathDir, new LinkOption[0])) {
            try {
                Files.createDirectory(pathDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Experiment:createDirectoryIfDoesNotExist() Creating directory failed: " + directory);
                return false;
            }
        }
        return true;
    }

    public void checkKymosDirectory(String kymosSubDirectory) {
        if (kymosSubDirectory == null) {
            List<String> listTIFFlocations = Directories.getSortedListOfSubDirectoriesWithTIFF(this.getExperimentDirectory());
            if (listTIFFlocations.size() < 1) {
                return;
            }
            boolean found = false;
            for (String subDir : listTIFFlocations) {
                String test = subDir.toLowerCase();
                if (test.contains(BIN)) {
                    kymosSubDirectory = subDir;
                    found = true;
                    break;
                }
                if (!test.contains(RESULTS)) continue;
                found = true;
                break;
            }
            if (!found) {
                int lowest = this.getBinStepFromDirectoryName(listTIFFlocations.get(0)) + 1;
                for (String subDir : listTIFFlocations) {
                    int val = this.getBinStepFromDirectoryName(subDir);
                    if (val >= lowest) continue;
                    lowest = val;
                    kymosSubDirectory = subDir;
                }
            }
        }
        this.setBinSubDirectory(kymosSubDirectory);
    }

    public void setImagesDirectory(String name) {
        this.strImagesDirectory = name;
    }

    public String getImagesDirectory() {
        return this.strImagesDirectory;
    }

    public void closeSequences() {
        if (this.seqKymos != null) {
            this.seqKymos.closeSequence();
        }
        if (this.seqCamData != null) {
            this.seqCamData.closeSequence();
        }
        if (this.seqReference != null) {
            this.seqReference.close();
        }
    }

    public boolean openMeasures(boolean loadCapillaries, boolean loadDrosoPositions) {
        if (this.seqCamData == null) {
            this.seqCamData = new SequenceCamData();
        }
        this.xmlLoad_MCExperiment();
        this.getFileIntervalsFromSeqCamData();
        if (this.seqKymos == null) {
            this.seqKymos = new SequenceKymos();
        }
        if (loadCapillaries) {
            this.loadMCCapillaries_Only();
            if (!this.capillaries.load_Capillaries(this.getKymosBinFullDirectory())) {
                return false;
            }
        }
        if (loadDrosoPositions) {
            this.loadCageMeasures();
        }
        return true;
    }

    private String getRootWithNoResultNorBinString(String directoryName) {
        String name = directoryName.toLowerCase();
        while (name.contains(RESULTS) || name.contains(BIN)) {
            name = Paths.get(this.strExperimentDirectory, new String[0]).getParent().toString();
        }
        return name;
    }

    private SequenceCamData loadImagesForSequenceCamData(String filename) {
        this.strImagesDirectory = ExperimentDirectories.getImagesDirectoryAsParentFromFileName(filename);
        List<String> imagesList = ExperimentDirectories.getV2ImagesListFromPath(this.strImagesDirectory);
        if ((imagesList = ExperimentDirectories.keepOnlyAcceptedNames_List(imagesList, "jpg")).size() < 1) {
            this.seqCamData = null;
        } else {
            this.seqCamData = new SequenceCamData();
            this.seqCamData.setImagesList(imagesList);
            this.seqCamData.attachSequence(this.seqCamData.loadSequenceFromImagesList(imagesList));
        }
        return this.seqCamData;
    }

    public boolean loadCamDataImages() {
        if (this.seqCamData != null) {
            this.seqCamData.loadImages();
        }
        return this.seqCamData != null && this.seqCamData.seq != null;
    }

    public boolean loadCamDataCapillaries() {
        this.loadMCCapillaries_Only();
        if (this.seqCamData != null && this.seqCamData.seq != null) {
            this.capillaries.transferCapillaryRoiToSequence(this.seqCamData.seq);
        }
        return this.seqCamData != null && this.seqCamData.seq != null;
    }

    public SequenceCamData openSequenceCamData() {
        this.loadImagesForSequenceCamData(this.strImagesDirectory);
        if (this.seqCamData != null) {
            this.xmlLoad_MCExperiment();
            this.getFileIntervalsFromSeqCamData();
        }
        return this.seqCamData;
    }

    public void getFileIntervalsFromSeqCamData() {
        if (this.seqCamData != null && (this.camImageFirst_ms < 0L || this.camImageLast_ms < 0L || this.camImageBin_ms < 0L)) {
            this.loadFileIntervalsFromSeqCamData();
        }
    }

    public void loadFileIntervalsFromSeqCamData() {
        if (this.seqCamData != null) {
            this.seqCamData.setImagesDirectory(this.strImagesDirectory);
            this.firstImage_FileTime = this.seqCamData.getFileTimeFromStructuredName(0);
            this.lastImage_FileTime = this.seqCamData.getFileTimeFromStructuredName(this.seqCamData.nTotalFrames - 1);
            if (this.firstImage_FileTime != null && this.lastImage_FileTime != null) {
                this.camImageFirst_ms = this.firstImage_FileTime.toMillis();
                this.camImageLast_ms = this.lastImage_FileTime.toMillis();
                this.camImageBin_ms = (this.camImageLast_ms - this.camImageFirst_ms) / (long)(this.seqCamData.nTotalFrames - 1);
                if (this.camImageBin_ms == 0L) {
                    System.out.println("Experiment:loadFileIntervalsFromSeqCamData() error / file interval size");
                }
            } else {
                System.out.println("Experiment:loadFileIntervalsFromSeqCamData() error / file intervals of " + this.seqCamData.getImagesDirectory());
            }
        }
    }

    public long[] build_MsTimeIntervalsArray_From_SeqCamData_FileNamesList(long firstImage_ms) {
        this.camImages_ms = new long[this.seqCamData.nTotalFrames];
        for (int i = 0; i < this.seqCamData.nTotalFrames; ++i) {
            long image_ms;
            FileTime image_FileTime = this.seqCamData.getFileTimeFromStructuredName(i);
            this.camImages_ms[i] = image_ms = image_FileTime.toMillis() - firstImage_ms;
        }
        return this.camImages_ms;
    }

    public void initTmsForFlyPositions(long time_start_ms) {
        this.build_MsTimeIntervalsArray_From_SeqCamData_FileNamesList(time_start_ms);
        this.cages.initCagesTmsForFlyPositions(this.camImages_ms);
    }

    public int findNearestIntervalWithBinarySearch(long value, int low, int high) {
        int mid;
        int result = -1;
        result = high - low > 1 ? (this.camImages_ms[mid = (low + high) / 2] > value ? this.findNearestIntervalWithBinarySearch(value, low, mid) : (this.camImages_ms[mid] < value ? this.findNearestIntervalWithBinarySearch(value, mid, high) : mid)) : (Math.abs(value - this.camImages_ms[low]) < Math.abs(value - this.camImages_ms[high]) ? low : high);
        return result;
    }

    public String getBinNameFromKymoFrameStep() {
        return BIN + this.kymoBin_ms / 1000L;
    }

    public String getDirectoryToSaveResults() {
        String directory;
        Path dir = Paths.get(this.strExperimentDirectory, new String[0]);
        if (this.strBinSubDirectory != null) {
            dir = dir.resolve(this.strBinSubDirectory);
        }
        if (!this.createDirectoryIfDoesNotExist(directory = dir.toAbsolutePath().toString())) {
            directory = null;
        }
        return directory;
    }

    public boolean xmlLoad_MCExperiment() {
        if (this.strExperimentDirectory == null && this.seqCamData != null) {
            this.strImagesDirectory = this.seqCamData.getImagesDirectory();
            this.strExperimentDirectory = this.strImagesDirectory + File.separator + RESULTS;
        }
        boolean found = this.xmlLoadExperiment(this.concatenateExptDirectoryWithSubpathAndName(null, ID_MCEXPERIMENT_XML));
        return found;
    }

    public boolean xmlSave_MCExperiment() {
        Document doc = XMLUtil.createDocument((boolean)true);
        if (doc != null) {
            Element xmlRoot = XMLUtil.getRootElement((Document)doc, (boolean)true);
            Element node = XMLUtil.setElement((Node)xmlRoot, (String)ID_MCEXPERIMENT);
            if (node == null) {
                return false;
            }
            XMLUtil.setElementValue((Node)node, (String)ID_VERSION, (String)ID_VERSIONNUM);
            XMLUtil.setElementLongValue((Node)node, (String)ID_TIMEFIRSTIMAGEMS, (long)this.camImageFirst_ms);
            XMLUtil.setElementLongValue((Node)node, (String)ID_TIMELASTIMAGEMS, (long)this.camImageLast_ms);
            XMLUtil.setElementLongValue((Node)node, (String)ID_BINT0, (long)this.binT0);
            XMLUtil.setElementLongValue((Node)node, (String)ID_FIRSTKYMOCOLMS, (long)this.kymoFirst_ms);
            XMLUtil.setElementLongValue((Node)node, (String)ID_LASTKYMOCOLMS, (long)this.kymoLast_ms);
            XMLUtil.setElementLongValue((Node)node, (String)ID_BINKYMOCOLMS, (long)this.kymoBin_ms);
            XMLUtil.setElementValue((Node)node, (String)ID_BOXID, (String)this.field_boxID);
            XMLUtil.setElementValue((Node)node, (String)ID_EXPERIMENT, (String)this.field_experiment);
            XMLUtil.setElementValue((Node)node, (String)ID_COMMENT1, (String)this.field_comment1);
            XMLUtil.setElementValue((Node)node, (String)ID_COMMENT2, (String)this.field_comment2);
            XMLUtil.setElementValue((Node)node, (String)ID_STRAIN, (String)this.field_strain);
            XMLUtil.setElementValue((Node)node, (String)ID_SEX, (String)this.field_sex);
            XMLUtil.setElementValue((Node)node, (String)ID_COND1, (String)this.field_cond1);
            XMLUtil.setElementValue((Node)node, (String)ID_COND2, (String)this.field_cond2);
            if (this.strImagesDirectory == null) {
                this.strImagesDirectory = this.seqCamData.getImagesDirectory();
            }
            XMLUtil.setElementValue((Node)node, (String)ID_IMAGESDIRECTORY, (String)this.strImagesDirectory);
            String tempname = this.concatenateExptDirectoryWithSubpathAndName(null, ID_MCEXPERIMENT_XML);
            return XMLUtil.saveDocument((Document)doc, (String)tempname);
        }
        return false;
    }

    public boolean loadKymographs() {
        if (this.seqKymos == null) {
            this.seqKymos = new SequenceKymos();
        }
        List<ImageFileDescriptor> myList = this.seqKymos.loadListOfPotentialKymographsFromCapillaries(this.getKymosBinFullDirectory(), this.capillaries);
        ImageFileDescriptor.getExistingFileNames(myList);
        return this.seqKymos.loadImagesFromList(myList, true);
    }

    public boolean loadMCCapillaries_Only() {
        String mcCapillaryFileName = this.findFile_3Locations(this.capillaries.getXMLNameToAppend(), 1, 3, 2);
        if (mcCapillaryFileName == null && this.seqCamData != null) {
            return this.xmlLoadOldCapillaries();
        }
        boolean flag = this.capillaries.loadMCCapillaries_Descriptors(mcCapillaryFileName);
        if (this.capillaries.capillariesList.size() < 1) {
            flag = this.xmlLoadOldCapillaries();
        }
        if (this.field_boxID.contentEquals("..") && this.field_experiment.contentEquals("..") && this.field_comment1.contentEquals("..") && this.field_comment2.contentEquals("..") && this.field_sex.contentEquals("..") && this.field_strain.contentEquals("..")) {
            this.field_boxID = this.capillaries.capillariesDescription.old_boxID;
            this.field_experiment = this.capillaries.capillariesDescription.old_experiment;
            this.field_comment1 = this.capillaries.capillariesDescription.old_comment1;
            this.field_comment2 = this.capillaries.capillariesDescription.old_comment2;
            this.field_sex = this.capillaries.capillariesDescription.old_sex;
            this.field_strain = this.capillaries.capillariesDescription.old_strain;
            this.field_cond1 = this.capillaries.capillariesDescription.old_cond1;
            this.field_cond2 = this.capillaries.capillariesDescription.old_cond2;
        }
        return flag;
    }

    public boolean loadMCCapillaries() {
        String kymosImagesDirectory;
        boolean flag2;
        String xmlCapillaryFileName = this.findFile_3Locations(this.capillaries.getXMLNameToAppend(), 1, 3, 2);
        boolean flag1 = this.capillaries.loadMCCapillaries_Descriptors(xmlCapillaryFileName);
        if (flag1 & (flag2 = this.capillaries.load_Capillaries(kymosImagesDirectory = this.getKymosBinFullDirectory()))) {
            this.seqKymos.loadListOfPotentialKymographsFromCapillaries(kymosImagesDirectory, this.capillaries);
        }
        return flag1 & flag2;
    }

    private boolean xmlLoadOldCapillaries() {
        String filename = this.findFile_3Locations("capillarytrack.xml", 2, 1, 3);
        if (this.capillaries.xmlLoadOldCapillaries_Only(filename)) {
            this.saveMCCapillaries_Only();
            this.saveCapillaries();
            try {
                Files.delete(Paths.get(filename, new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        filename = this.findFile_3Locations("roislines.xml", 2, 1, 3);
        if (this.xmlReadCamDataROIs(filename)) {
            this.xmlReadRoiLineParameters(filename);
            try {
                Files.delete(Paths.get(filename, new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private boolean xmlReadCamDataROIs(String fileName) {
        Document doc;
        Sequence seq = this.seqCamData.seq;
        if (fileName != null && (doc = XMLUtil.loadDocument((String)fileName)) != null) {
            List seqRoisList = seq.getROI2Ds(false);
            List<ROI2D> newRoisList = ROI2DUtilities.loadROIsFromXML(doc);
            ROI2DUtilities.mergeROIsListNoDuplicate(seqRoisList, newRoisList, seq);
            seq.removeAllROI();
            seq.addROIs((Collection)seqRoisList, false);
            return true;
        }
        return false;
    }

    private boolean xmlReadRoiLineParameters(String filename) {
        Document doc;
        if (filename != null && (doc = XMLUtil.loadDocument((String)filename)) != null) {
            return this.capillaries.capillariesDescription.xmlLoadCapillaryDescription(doc);
        }
        return false;
    }

    public boolean saveMCCapillaries_Only() {
        String xmlCapillaryFileName = this.strExperimentDirectory + File.separator + this.capillaries.getXMLNameToAppend();
        this.transferExpDescriptorsToCapillariesDescriptors();
        return this.capillaries.xmlSaveCapillaries_Descriptors(xmlCapillaryFileName);
    }

    public boolean loadCapillaries() {
        return this.capillaries.load_Capillaries(this.getKymosBinFullDirectory());
    }

    public boolean saveCapillaries() {
        return this.capillaries.save_Capillaries(this.getKymosBinFullDirectory());
    }

    public boolean loadCageMeasures() {
        boolean flag;
        String pathToMeasures = this.getExperimentDirectory() + File.separator + "CagesMeasures.csv";
        File f = new File(pathToMeasures);
        if (!f.exists()) {
            this.moveCageMeasuresToExperimentDirectory(pathToMeasures);
        }
        if ((flag = this.cages.load_Cages(this.getExperimentDirectory())) & this.seqCamData.seq != null) {
            this.cages.cagesToROIs(this.seqCamData);
        }
        return flag;
    }

    private boolean moveCageMeasuresToExperimentDirectory(String pathToMeasures) {
        boolean flag = false;
        String pathToOldCsv = this.getKymosBinFullDirectory() + File.separator + "CagesMeasures.csv";
        File fileToMove = new File(pathToOldCsv);
        if (fileToMove.exists()) {
            flag = fileToMove.renameTo(new File(pathToMeasures));
        }
        return flag;
    }

    public boolean saveCageMeasures() {
        return this.cages.save_Cages(this.getExperimentDirectory());
    }

    public void saveCageAndMeasures() {
        this.cages.cagesFromROIs(this.seqCamData);
        this.saveCageMeasures();
    }

    public Experiment getFirstChainedExperiment(boolean globalValue) {
        Experiment exp = this;
        if (globalValue && this.chainToPreviousExperiment != null) {
            exp = this.chainToPreviousExperiment.getFirstChainedExperiment(globalValue);
        }
        return exp;
    }

    public Experiment getLastChainedExperiment(boolean globalValue) {
        Experiment exp = this;
        if (globalValue && this.chainToNextExperiment != null) {
            exp = this.chainToNextExperiment.getLastChainedExperiment(globalValue);
        }
        return exp;
    }

    public void setFileTimeImageFirst(FileTime fileTimeImageFirst) {
        this.firstImage_FileTime = fileTimeImageFirst;
    }

    public void setFileTimeImageLast(FileTime fileTimeImageLast) {
        this.lastImage_FileTime = fileTimeImageLast;
    }

    public int getSeqCamSizeT() {
        int lastFrame = 0;
        if (this.seqCamData != null) {
            lastFrame = this.seqCamData.nTotalFrames - 1;
        }
        return lastFrame;
    }

    public String getExperimentField(EnumXLSColumnHeader fieldEnumCode) {
        String strField = null;
        switch (fieldEnumCode) {
            case EXP_PATH: {
                strField = this.getPath();
                break;
            }
            case EXP_DATE: {
                strField = this.getDate();
                break;
            }
            case EXP_CAM: {
                strField = this.getCam();
                break;
            }
            case EXP_STIM: {
                strField = this.field_comment1;
                break;
            }
            case EXP_CONC: {
                strField = this.field_comment2;
                break;
            }
            case EXP_EXPT: {
                strField = this.field_experiment;
                break;
            }
            case EXP_BOXID: {
                strField = this.field_boxID;
                break;
            }
            case EXP_STRAIN: {
                strField = this.field_strain;
                break;
            }
            case EXP_SEX: {
                strField = this.field_sex;
                break;
            }
            case EXP_COND1: {
                strField = this.field_cond1;
                break;
            }
            case EXP_COND2: {
                strField = this.field_cond2;
                break;
            }
        }
        return strField;
    }

    private String getPath() {
        String filename = this.getExperimentDirectory();
        if (filename == null) {
            filename = this.seqCamData.getImagesDirectory();
        }
        Path path = Paths.get(filename, new String[0]);
        return path.toString();
    }

    private String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        return df.format(this.chainImageFirst_ms);
    }

    private String getCam() {
        String strField = this.getPath();
        int pos = strField.indexOf("cam");
        if (pos > 0) {
            int pos5 = pos + 5;
            if (pos5 >= strField.length()) {
                pos5 = strField.length() - 1;
            }
            strField = strField.substring(pos, pos5);
        }
        return strField;
    }

    public void getFieldValues(EnumXLSColumnHeader fieldEnumCode, List<String> textList) {
        switch (fieldEnumCode) {
            case EXP_STIM: 
            case EXP_CONC: 
            case EXP_EXPT: 
            case EXP_BOXID: 
            case EXP_STRAIN: 
            case EXP_SEX: 
            case EXP_COND1: 
            case EXP_COND2: {
                this.addValue(this.getExperimentField(fieldEnumCode), textList);
                break;
            }
            case CAP_STIM: 
            case CAP_CONC: {
                this.addCapillariesValues(fieldEnumCode, textList);
                break;
            }
        }
    }

    public boolean replaceExperimentFieldIfEqualOld(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        boolean flag = this.getExperimentField(fieldEnumCode).equals(oldValue);
        if (flag) {
            this.setExperimentFieldNoTest(fieldEnumCode, newValue);
        }
        return flag;
    }

    public void copyExperimentFields(Experiment expSource) {
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_BOXID, expSource.getExperimentField(EnumXLSColumnHeader.EXP_BOXID));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_EXPT, expSource.getExperimentField(EnumXLSColumnHeader.EXP_EXPT));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STIM, expSource.getExperimentField(EnumXLSColumnHeader.EXP_STIM));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_CONC, expSource.getExperimentField(EnumXLSColumnHeader.EXP_CONC));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STRAIN, expSource.getExperimentField(EnumXLSColumnHeader.EXP_STRAIN));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_SEX, expSource.getExperimentField(EnumXLSColumnHeader.EXP_SEX));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_COND1, expSource.getExperimentField(EnumXLSColumnHeader.EXP_COND1));
        this.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_COND2, expSource.getExperimentField(EnumXLSColumnHeader.EXP_COND2));
    }

    public void setExperimentFieldNoTest(EnumXLSColumnHeader fieldEnumCode, String newValue) {
        switch (fieldEnumCode) {
            case EXP_STIM: {
                this.field_comment1 = newValue;
                break;
            }
            case EXP_CONC: {
                this.field_comment2 = newValue;
                break;
            }
            case EXP_EXPT: {
                this.field_experiment = newValue;
                break;
            }
            case EXP_BOXID: {
                this.field_boxID = newValue;
                break;
            }
            case EXP_STRAIN: {
                this.field_strain = newValue;
                break;
            }
            case EXP_SEX: {
                this.field_sex = newValue;
                break;
            }
            case EXP_COND1: {
                this.field_cond1 = newValue;
                break;
            }
            case EXP_COND2: {
                this.field_cond2 = newValue;
                break;
            }
        }
    }

    public void replaceFieldValue(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        switch (fieldEnumCode) {
            case EXP_STIM: 
            case EXP_CONC: 
            case EXP_EXPT: 
            case EXP_BOXID: 
            case EXP_STRAIN: 
            case EXP_SEX: 
            case EXP_COND1: 
            case EXP_COND2: {
                this.replaceExperimentFieldIfEqualOld(fieldEnumCode, oldValue, newValue);
                break;
            }
            case CAP_STIM: 
            case CAP_CONC: {
                if (this.replaceCapillariesValuesIfEqualOld(fieldEnumCode, oldValue, newValue)) {
                    // empty if block
                }
                this.saveMCCapillaries_Only();
                break;
            }
        }
    }

    public boolean adjustCapillaryMeasuresDimensions() {
        if (this.seqKymos.imageWidthMax < 1) {
            this.seqKymos.imageWidthMax = this.seqKymos.seq.getSizeX();
            if (this.seqKymos.imageWidthMax < 1) {
                return false;
            }
        }
        int imageWidth = this.seqKymos.imageWidthMax;
        this.capillaries.adjustToImageWidth(imageWidth);
        this.seqKymos.seq.removeAllROI();
        this.seqKymos.transferCapillariesMeasuresToKymos(this.capillaries);
        return true;
    }

    public boolean cropCapillaryMeasuresDimensions() {
        if (this.seqKymos.imageWidthMax < 1) {
            this.seqKymos.imageWidthMax = this.seqKymos.seq.getSizeX();
            if (this.seqKymos.imageWidthMax < 1) {
                return false;
            }
        }
        int imageWidth = this.seqKymos.imageWidthMax;
        this.capillaries.cropToImageWidth(imageWidth);
        this.seqKymos.seq.removeAllROI();
        this.seqKymos.transferCapillariesMeasuresToKymos(this.capillaries);
        return true;
    }

    public boolean saveCapillariesMeasures(String directory) {
        boolean flag = false;
        if (this.seqKymos != null && this.seqKymos.seq != null) {
            this.seqKymos.validateRois();
            this.seqKymos.transferKymosRoisToCapillaries_Measures(this.capillaries);
            flag = this.capillaries.save_Capillaries(directory);
        }
        return flag;
    }

    public void dispatchCapillariesToCages() {
        for (Cage cage : this.cages.cageList) {
            cage.clearCapillaryList();
        }
        for (Capillary cap : this.capillaries.capillariesList) {
            int cageID = cap.getCageIndexFromRoiName();
            Cage cage = this.cages.getCageFromID(cageID);
            if (cage == null) {
                cage = new Cage();
                cage.setCageID(cageID);
                this.cages.cageList.add(cage);
            }
            cage.addCapillaryIfUnique(cap);
        }
    }

    public void kymosBuildFiltered01(int zChannelSource, int zChannelDestination, ImageTransformEnums transformop1, int spanDiff) {
        int nimages = this.seqKymos.seq.getSizeT();
        this.seqKymos.seq.beginUpdate();
        ImageTransformInterface transform = transformop1.getFunction();
        if (transform == null) {
            return;
        }
        if (this.capillaries.capillariesList.size() != nimages) {
            SequenceKymosUtils.transferCamDataROIStoKymo(this);
        }
        for (int t = 0; t < nimages; ++t) {
            Capillary cap = this.capillaries.capillariesList.get(t);
            cap.kymographIndex = t;
            IcyBufferedImage img = this.seqKymos.getSeqImage(t, zChannelSource);
            IcyBufferedImage img2 = transform.getTransformedImage(img, null);
            if (this.seqKymos.seq.getSizeZ(0) < zChannelDestination + 1) {
                this.seqKymos.seq.addImage(t, (BufferedImage)img2);
                continue;
            }
            this.seqKymos.seq.setImage(t, zChannelDestination, (BufferedImage)img2);
        }
        this.seqKymos.seq.dataChanged();
        this.seqKymos.seq.endUpdate();
    }

    public boolean loadReferenceImage() {
        BufferedImage image = null;
        File inputfile = new File(this.getReferenceImageFullName());
        boolean exists = inputfile.exists();
        if (!exists) {
            return false;
        }
        image = ImageUtil.load((File)inputfile, (boolean)true);
        if (image == null) {
            System.out.println("Experiment:loadReferenceImage() image not loaded / not found");
            return false;
        }
        this.seqCamData.refImage = IcyBufferedImage.createFrom((BufferedImage)image);
        this.seqReference = new Sequence(this.seqCamData.refImage);
        this.seqReference.setName("referenceImage");
        return true;
    }

    public boolean saveReferenceImage(IcyBufferedImage referenceImage) {
        File outputfile = new File(this.getReferenceImageFullName());
        BufferedImage image = ImageUtil.toRGBImage((Image)referenceImage);
        return ImageUtil.save((RenderedImage)image, (String)"jpg", (File)outputfile);
    }

    public void cleanPreviousDetectedFliesROIs() {
        ArrayList list = this.seqCamData.seq.getROI2Ds();
        for (ROI2D roi : list) {
            if (!roi.getName().contains("det")) continue;
            this.seqCamData.seq.removeROI((ROI)roi);
        }
    }

    public void updateROIsAt(int t) {
        this.seqCamData.seq.beginUpdate();
        ArrayList rois = this.seqCamData.seq.getROI2Ds();
        for (ROI2D roi : rois) {
            if (!roi.getName().contains("det")) continue;
            this.seqCamData.seq.removeROI((ROI)roi);
        }
        this.seqCamData.seq.addROIs(this.cages.getPositionsAsListOfROI2DRectanglesAtT(t), false);
        this.seqCamData.seq.endUpdate();
    }

    public void saveDetRoisToPositions() {
        ArrayList detectedROIsList = this.seqCamData.seq.getROI2Ds();
        for (Cage cell : this.cages.cageList) {
            cell.transferRoisToPositions(detectedROIsList);
        }
    }

    private int getBinStepFromDirectoryName(String resultsPath) {
        int step = -1;
        if (resultsPath.contains(BIN)) {
            step = resultsPath.length() < BIN.length() + 1 ? (int)this.kymoBin_ms : Integer.valueOf(resultsPath.substring(BIN.length())) * 1000;
        }
        return step;
    }

    private String findFile_3Locations(String xmlFileName, int first, int second, int third) {
        String xmlFullFileName = this.findFile_1Location(xmlFileName, first);
        if (xmlFullFileName == null) {
            xmlFullFileName = this.findFile_1Location(xmlFileName, second);
        }
        if (xmlFullFileName == null) {
            xmlFullFileName = this.findFile_1Location(xmlFileName, third);
        }
        return xmlFullFileName;
    }

    private String findFile_1Location(String xmlFileName, int item) {
        String xmlFullFileName = File.separator + xmlFileName;
        block0 : switch (item) {
            case 2: {
                this.strImagesDirectory = this.getRootWithNoResultNorBinString(this.strExperimentDirectory);
                xmlFullFileName = this.strImagesDirectory + File.separator + xmlFileName;
                break;
            }
            case 3: {
                Path dirPath = Paths.get(this.strExperimentDirectory, new String[0]);
                List<Path> subFolders = Directories.getAllSubPathsOfDirectory(this.strExperimentDirectory, 1);
                if (subFolders == null) {
                    return null;
                }
                List<String> resultsDirList = Directories.getPathsContainingString(subFolders, RESULTS);
                List<String> binDirList = Directories.getPathsContainingString(subFolders, BIN);
                resultsDirList.addAll(binDirList);
                for (String resultsSub : resultsDirList) {
                    Path dir = dirPath.resolve(resultsSub + File.separator + xmlFileName);
                    if (Files.notExists(dir, new LinkOption[0])) continue;
                    xmlFullFileName = dir.toAbsolutePath().toString();
                    break block0;
                }
                break;
            }
            default: {
                xmlFullFileName = this.strExperimentDirectory + xmlFullFileName;
            }
        }
        if (xmlFullFileName != null && this.fileExists(xmlFullFileName)) {
            if (item == 2) {
                this.strImagesDirectory = this.getRootWithNoResultNorBinString(this.strExperimentDirectory);
                ExperimentDirectories.moveAndRename(xmlFileName, this.strImagesDirectory, xmlFileName, this.strExperimentDirectory);
                xmlFullFileName = this.strExperimentDirectory + xmlFullFileName;
            }
            return xmlFullFileName;
        }
        return null;
    }

    private boolean fileExists(String fileName) {
        File f = new File(fileName);
        return f.exists() && !f.isDirectory();
    }

    private boolean replaceCapillariesValuesIfEqualOld(EnumXLSColumnHeader fieldEnumCode, String oldValue, String newValue) {
        if (this.capillaries.capillariesList.size() == 0) {
            this.loadMCCapillaries_Only();
        }
        boolean flag = false;
        for (Capillary cap : this.capillaries.capillariesList) {
            if (!cap.getCapillaryField(fieldEnumCode).equals(oldValue)) continue;
            cap.setCapillaryField(fieldEnumCode, newValue);
            flag = true;
        }
        return flag;
    }

    private String concatenateExptDirectoryWithSubpathAndName(String subpath, String name) {
        if (subpath != null) {
            return this.strExperimentDirectory + File.separator + subpath + File.separator + name;
        }
        return this.strExperimentDirectory + File.separator + name;
    }

    private boolean xmlLoadExperiment(String csFileName) {
        Document doc = XMLUtil.loadDocument((String)csFileName);
        if (doc == null) {
            return false;
        }
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_MCEXPERIMENT);
        if (node == null) {
            return false;
        }
        String version = XMLUtil.getElementValue((Node)node, (String)ID_VERSION, (String)ID_VERSIONNUM);
        if (!version.equals(ID_VERSIONNUM)) {
            return false;
        }
        this.camImageFirst_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMEFIRSTIMAGEMS, (long)0L);
        this.camImageLast_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMELASTIMAGEMS, (long)0L);
        if (this.camImageLast_ms <= 0L) {
            this.camImageFirst_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMEFIRSTIMAGE, (long)0L) * 60000L;
            this.camImageLast_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_TIMELASTIMAGE, (long)0L) * 60000L;
        }
        this.binT0 = XMLUtil.getElementLongValue((Node)node, (String)ID_BINT0, (long)0L);
        this.kymoFirst_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_FIRSTKYMOCOLMS, (long)-1L);
        this.kymoLast_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_LASTKYMOCOLMS, (long)-1L);
        this.kymoBin_ms = XMLUtil.getElementLongValue((Node)node, (String)ID_BINKYMOCOLMS, (long)-1L);
        this.ugly_checkOffsetValues();
        if (this.field_boxID != null && this.field_boxID.contentEquals("..")) {
            this.field_boxID = XMLUtil.getElementValue((Node)node, (String)ID_BOXID, (String)"..");
            this.field_experiment = XMLUtil.getElementValue((Node)node, (String)ID_EXPERIMENT, (String)"..");
            this.field_comment1 = XMLUtil.getElementValue((Node)node, (String)ID_COMMENT1, (String)"..");
            this.field_comment2 = XMLUtil.getElementValue((Node)node, (String)ID_COMMENT2, (String)"..");
            this.field_strain = XMLUtil.getElementValue((Node)node, (String)ID_STRAIN, (String)"..");
            this.field_sex = XMLUtil.getElementValue((Node)node, (String)ID_SEX, (String)"..");
            this.field_cond1 = XMLUtil.getElementValue((Node)node, (String)ID_COND1, (String)"..");
            this.field_cond2 = XMLUtil.getElementValue((Node)node, (String)ID_COND2, (String)"..");
        }
        return true;
    }

    private void ugly_checkOffsetValues() {
        if (this.camImageFirst_ms < 0L) {
            this.camImageFirst_ms = 0L;
        }
        if (this.camImageLast_ms < 0L) {
            this.camImageLast_ms = 0L;
        }
        if (this.kymoFirst_ms < 0L) {
            this.kymoFirst_ms = 0L;
        }
        if (this.kymoLast_ms < 0L) {
            this.kymoLast_ms = 0L;
        }
        if (this.kymoBin_ms < 0L) {
            this.kymoBin_ms = 60000L;
        }
    }

    private void addCapillariesValues(EnumXLSColumnHeader fieldEnumCode, List<String> textList) {
        if (this.capillaries.capillariesList.size() == 0) {
            this.loadMCCapillaries_Only();
        }
        for (Capillary cap : this.capillaries.capillariesList) {
            this.addValue(cap.getCapillaryField(fieldEnumCode), textList);
        }
    }

    private void addValue(String text, List<String> textList) {
        if (!this.isFound(text, textList)) {
            textList.add(text);
        }
    }

    private boolean isFound(String pattern, List<String> names) {
        boolean found;
        block1: {
            String name;
            found = false;
            if (names.size() <= 0) break block1;
            Iterator<String> iterator = names.iterator();
            while (iterator.hasNext() && !(found = (name = iterator.next()).equals(pattern))) {
            }
        }
        return found;
    }

    private void transferExpDescriptorsToCapillariesDescriptors() {
        this.capillaries.capillariesDescription.old_boxID = this.field_boxID;
        this.capillaries.capillariesDescription.old_experiment = this.field_experiment;
        this.capillaries.capillariesDescription.old_comment1 = this.field_comment1;
        this.capillaries.capillariesDescription.old_comment2 = this.field_comment2;
        this.capillaries.capillariesDescription.old_strain = this.field_strain;
        this.capillaries.capillariesDescription.old_sex = this.field_sex;
        this.capillaries.capillariesDescription.old_cond1 = this.field_cond1;
        this.capillaries.capillariesDescription.old_cond2 = this.field_cond2;
    }

    private String getReferenceImageFullName() {
        return this.strExperimentDirectory + File.separator + "referenceImage.jpg";
    }
}

