/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.file.Saver;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.MetaDataUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.geom.Polyline2D;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import loci.formats.FormatException;
import ome.xml.meta.OMEXMLMetadata;
import org.apache.commons.io.FileUtils;
import plugins.fmp.multicafe.experiment.EnumStatus;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.ExperimentDirectories;
import plugins.fmp.multicafe.experiment.ImageFileDescriptor;
import plugins.fmp.multicafe.experiment.SequenceCamData;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.experiment.capillaries.CapillaryMeasure;
import plugins.fmp.multicafe.tools.Comparators;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class SequenceKymos
extends SequenceCamData {
    public boolean isRunning_loadImages = false;
    public int imageWidthMax = 0;
    public int imageHeightMax = 0;

    public SequenceKymos() {
        this.status = EnumStatus.KYMOGRAPH;
    }

    public SequenceKymos(String name, IcyBufferedImage image) {
        super(name, image);
        this.status = EnumStatus.KYMOGRAPH;
    }

    public SequenceKymos(List<String> listNames) {
        this.setImagesList(this.convertLinexLRFileNames(listNames));
        this.status = EnumStatus.KYMOGRAPH;
    }

    public void validateRoisAtT(int t) {
        ArrayList listRois = this.seq.getROI2Ds();
        int width = this.seq.getWidth();
        for (ROI2D roi : listRois) {
            if (!(roi instanceof ROI2DPolyLine)) continue;
            if (roi.getT() == -1) {
                roi.setT(t);
            }
            if (roi.getT() != t) continue;
            if (roi.getName().contains("level") || roi.getName().contains("gulp")) {
                ROI2DUtilities.interpolateMissingPointsAlongXAxis((ROI2DPolyLine)roi, width);
                continue;
            }
            if (roi.getName().contains("deriv")) continue;
            ROI2DPolyLine roiLine = (ROI2DPolyLine)roi;
            Polyline2D line = roiLine.getPolyline2D();
            roi.setName("gulp" + String.format("%07d", (int)line.xpoints[0]));
            roi.setColor(Color.red);
        }
        Collections.sort(listRois, new Comparators.ROI2D_Name_Comparator());
    }

    public void removeROIsPolylineAtT(int t) {
        ArrayList listRois = this.seq.getROI2Ds();
        for (ROI2D roi : listRois) {
            if (!(roi instanceof ROI2DPolyLine) || roi.getT() != t) continue;
            this.seq.removeROI((ROI)roi);
        }
    }

    public void updateROIFromCapillaryMeasure(Capillary cap, CapillaryMeasure caplimits) {
        int t = cap.kymographIndex;
        ArrayList listRois = this.seq.getROI2Ds();
        for (ROI2D roi : listRois) {
            if (!(roi instanceof ROI2DPolyLine) || roi.getT() != t || !roi.getName().contains(caplimits.capName)) continue;
            ((ROI2DPolyLine)roi).setPolyline2D((Polyline2D)caplimits.polylineLevel);
            roi.setName(caplimits.capName);
            this.seq.roiChanged((ROI)roi);
            break;
        }
    }

    public void validateRois() {
        ArrayList listRois = this.seq.getROI2Ds();
        int width = this.seq.getWidth();
        for (ROI2D roi : listRois) {
            if (!(roi instanceof ROI2DPolyLine)) continue;
            if (roi.getName().contains("level") || roi.getName().contains("gulp")) {
                ROI2DUtilities.interpolateMissingPointsAlongXAxis((ROI2DPolyLine)roi, width);
                continue;
            }
            if (roi.getName().contains("derivative")) continue;
            ROI2DPolyLine roiLine = (ROI2DPolyLine)roi;
            Polyline2D line = roiLine.getPolyline2D();
            roi.setName("gulp" + String.format("%07d", (int)line.xpoints[0]));
            roi.setColor(Color.red);
        }
        Collections.sort(listRois, new Comparators.ROI2D_Name_Comparator());
    }

    public boolean transferKymosRoisToCapillaries_Measures(Capillaries capillaries) {
        ArrayList allRois = this.seq.getROIs();
        if (allRois.size() < 1) {
            return false;
        }
        int kymo = 0;
        while (kymo < this.seq.getSizeT()) {
            ArrayList<ROI> roisAtT = new ArrayList<ROI>();
            for (ROI roi : allRois) {
                if (!(roi instanceof ROI2D) || ((ROI2D)roi).getT() != kymo) continue;
                roisAtT.add(roi);
            }
            if (capillaries.capillariesList.size() <= kymo) {
                capillaries.capillariesList.add(new Capillary());
            }
            Capillary cap = capillaries.capillariesList.get(kymo);
            cap.filenameTIFF = this.getFileNameFromImageList(kymo);
            cap.kymographIndex = kymo++;
            cap.transferROIsToMeasures(roisAtT);
        }
        return true;
    }

    public boolean transferKymosRoi_atT_ToCapillaries_Measures(int t, Capillaries capillaries) {
        ArrayList allRois = this.seq.getROIs();
        if (allRois.size() < 1) {
            return false;
        }
        ArrayList<ROI> roisAtT = new ArrayList<ROI>();
        for (ROI roi : allRois) {
            if (!(roi instanceof ROI2D) || ((ROI2D)roi).getT() != t) continue;
            roisAtT.add(roi);
        }
        if (capillaries.capillariesList.size() <= t) {
            capillaries.capillariesList.add(new Capillary());
        }
        Capillary cap = capillaries.capillariesList.get(t);
        cap.filenameTIFF = this.getFileNameFromImageList(t);
        cap.kymographIndex = t;
        cap.transferROIsToMeasures(roisAtT);
        return true;
    }

    public void transferCapillariesMeasuresToKymos(Capillaries capillaries) {
        List seqRoisList = this.seq.getROI2Ds(false);
        ROI2DUtilities.removeROIsMissingChar(seqRoisList, '_');
        ArrayList<ROI2D> newRoisList = new ArrayList<ROI2D>();
        int ncapillaries = capillaries.capillariesList.size();
        for (int i = 0; i < ncapillaries; ++i) {
            List<ROI2D> listOfRois = capillaries.capillariesList.get(i).transferMeasuresToROIs();
            newRoisList.addAll(listOfRois);
        }
        ROI2DUtilities.mergeROIsListNoDuplicate(seqRoisList, newRoisList, this.seq);
        this.seq.removeAllROI();
        this.seq.addROIs((Collection)seqRoisList, false);
    }

    public void saveKymosCurvesToCapillariesMeasures(Experiment exp) {
        exp.seqKymos.validateRois();
        exp.seqKymos.transferKymosRoisToCapillaries_Measures(exp.capillaries);
        exp.saveCapillaries();
    }

    public List<ImageFileDescriptor> loadListOfPotentialKymographsFromCapillaries(String dir, Capillaries capillaries) {
        this.renameCapillary_Files(dir);
        String directoryFull = dir + File.separator;
        int ncapillaries = capillaries.capillariesList.size();
        ArrayList<ImageFileDescriptor> myListOfFiles = new ArrayList<ImageFileDescriptor>(ncapillaries);
        for (int i = 0; i < ncapillaries; ++i) {
            ImageFileDescriptor temp = new ImageFileDescriptor();
            temp.fileName = directoryFull + capillaries.capillariesList.get(i).getKymographName() + ".tiff";
            myListOfFiles.add(temp);
        }
        return myListOfFiles;
    }

    private void renameCapillary_Files(String directory) {
        File folder = new File(directory);
        File[] listFiles = folder.listFiles();
        if (listFiles == null || listFiles.length < 1) {
            return;
        }
        for (File file : folder.listFiles()) {
            String destinationName;
            String name = file.getName();
            if (!name.toLowerCase().endsWith(".tiff") && !name.toLowerCase().startsWith("line") || name.contains(destinationName = Capillary.replace_LR_with_12(name))) continue;
            file.renameTo(new File(directory + File.separator + destinationName));
        }
    }

    public boolean loadImagesFromList(List<ImageFileDescriptor> kymoImagesDesc, boolean adjustImagesSize) {
        boolean flag;
        this.isRunning_loadImages = true;
        boolean bl = flag = kymoImagesDesc.size() > 0;
        if (!flag) {
            return flag;
        }
        if (adjustImagesSize) {
            this.adjustImagesToMaxSize(kymoImagesDesc, this.getMaxSizeofTiffFiles(kymoImagesDesc));
        }
        List<String> myList = new ArrayList<String>();
        for (ImageFileDescriptor prop : kymoImagesDesc) {
            if (!prop.exists) continue;
            myList.add(prop.fileName);
        }
        if (myList.size() > 0) {
            myList = ExperimentDirectories.keepOnlyAcceptedNames_List(myList, "tiff");
            this.setImagesList(this.convertLinexLRFileNames(myList));
            this.loadImages();
            this.setParentDirectoryAsCSCamFileName((String)this.imagesList.get(0));
            this.status = EnumStatus.KYMOGRAPH;
        }
        this.isRunning_loadImages = false;
        return flag;
    }

    protected void setParentDirectoryAsCSCamFileName(String filename) {
        if (filename != null) {
            Path path = Paths.get(filename, new String[0]);
            this.csCamFileName = path.getName(path.getNameCount() - 2).toString();
            this.seq.setName(this.csCamFileName);
        }
    }

    Rectangle getMaxSizeofTiffFiles(List<ImageFileDescriptor> files) {
        this.imageWidthMax = 0;
        this.imageHeightMax = 0;
        for (int i = 0; i < files.size(); ++i) {
            ImageFileDescriptor fileProp = files.get(i);
            if (!fileProp.exists) continue;
            this.getImageDim(fileProp);
            if (fileProp.imageWidth > this.imageWidthMax) {
                this.imageWidthMax = fileProp.imageWidth;
            }
            if (fileProp.imageHeight <= this.imageHeightMax) continue;
            this.imageHeightMax = fileProp.imageHeight;
        }
        return new Rectangle(0, 0, this.imageWidthMax, this.imageHeightMax);
    }

    boolean getImageDim(ImageFileDescriptor fileProp) {
        boolean flag = false;
        OMEXMLMetadata metaData = null;
        try {
            metaData = Loader.getOMEXMLMetaData((String)fileProp.fileName);
            fileProp.imageWidth = MetaDataUtil.getSizeX((OMEXMLMetadata)metaData, (int)0);
            fileProp.imageHeight = MetaDataUtil.getSizeY((OMEXMLMetadata)metaData, (int)0);
            flag = true;
        }
        catch (UnsupportedFormatException | IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return flag;
    }

    void adjustImagesToMaxSize(List<ImageFileDescriptor> files, Rectangle rect) {
        ProgressFrame progress = new ProgressFrame("Make kymographs the same width and height");
        progress.setLength((double)files.size());
        for (int i = 0; i < files.size(); ++i) {
            ImageFileDescriptor fileProp = files.get(i);
            if (!fileProp.exists || fileProp.imageWidth == rect.width && fileProp.imageHeight == rect.height) continue;
            progress.setMessage("adjust image " + fileProp.fileName);
            IcyBufferedImage ibufImage1 = null;
            try {
                ibufImage1 = Loader.loadImage((String)fileProp.fileName);
            }
            catch (UnsupportedFormatException | IOException | InterruptedException e1) {
                e1.printStackTrace();
            }
            IcyBufferedImage ibufImage2 = new IcyBufferedImage(this.imageWidthMax, this.imageHeightMax, ibufImage1.getSizeC(), ibufImage1.getDataType_());
            SequenceKymos.transferImage1To2(ibufImage1, ibufImage2);
            try {
                Saver.saveImage((IcyBufferedImage)ibufImage2, (File)new File(fileProp.fileName), (boolean)true);
            }
            catch (IOException | FormatException e) {
                e.printStackTrace();
            }
            progress.incPosition();
        }
        progress.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferImage1To2(IcyBufferedImage source, IcyBufferedImage result) {
        int sizeY = source.getSizeY();
        int endC = source.getSizeC();
        int sourceSizeX = source.getSizeX();
        int destSizeX = result.getSizeX();
        DataType dataType = source.getDataType_();
        boolean signed = dataType.isSigned();
        result.lockRaster();
        try {
            for (int ch = 0; ch < endC; ++ch) {
                Object src = source.getDataXY(ch);
                Object dst = result.getDataXY(ch);
                int srcOffset = 0;
                int dstOffset = 0;
                for (int curY = 0; curY < sizeY; ++curY) {
                    Array1DUtil.arrayToArray((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)sourceSizeX, (boolean)signed);
                    result.setDataXY(ch, dst);
                    srcOffset += sourceSizeX;
                    dstOffset += destSizeX;
                }
            }
        }
        finally {
            result.releaseRaster(true);
        }
        result.dataChanged();
    }

    private List<String> convertLinexLRFileNames(List<String> myListOfFilesNames) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String oldName : myListOfFilesNames) {
            newList.add(this.convertLinexLRFileName(oldName));
        }
        return newList;
    }

    private String convertLinexLRFileName(String oldName) {
        Path path = Paths.get(oldName, new String[0]);
        String test = path.getFileName().toString();
        String newName = oldName;
        if (test.contains("R.")) {
            newName = path.getParent() + File.separator + test.replace("R.", "2.");
            this.renameOldFile(oldName, newName);
        } else if (test.contains("L")) {
            newName = path.getParent() + File.separator + test.replace("L.", "1.");
            this.renameOldFile(oldName, newName);
        }
        return newName;
    }

    private void renameOldFile(String oldName, String newName) {
        File oldfile = new File(oldName);
        if (newName != null && oldfile.exists()) {
            try {
                FileUtils.moveFile((File)FileUtils.getFile((String[])new String[]{oldName}), (File)FileUtils.getFile((String[])new String[]{newName}));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

