/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.cages.Cages;
import plugins.fmp.multicafe.series.BuildSeriesOptions;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class FlyDetectTools {
    public List<BooleanMask2D> cellMaskList = new ArrayList<BooleanMask2D>();
    public Rectangle rectangleAllCages = null;
    public BuildSeriesOptions options = null;
    public Cages box = null;

    BooleanMask2D findLargestBlob(ROI2DArea roiAll, BooleanMask2D cellMask) throws InterruptedException {
        if (cellMask == null) {
            return null;
        }
        ROI2DArea roi = new ROI2DArea(roiAll.getBooleanMask(true).getIntersection(cellMask));
        int max = 0;
        BooleanMask2D bestMask = null;
        BooleanMask2D roiBooleanMask = roi.getBooleanMask(true);
        for (BooleanMask2D mask : roiBooleanMask.getComponents()) {
            int len = mask.getPoints().length;
            if (this.options.blimitLow && len < this.options.limitLow) {
                len = 0;
            }
            if (this.options.blimitUp && len > this.options.limitUp) {
                len = 0;
            }
            int width = mask.bounds.width;
            int height = mask.bounds.height;
            int ratio = width / height;
            if (width < height) {
                ratio = height / width;
            }
            if (ratio > 4) {
                len = 0;
            }
            if (len <= max) continue;
            bestMask = mask;
            max = len;
        }
        return bestMask;
    }

    public ROI2DArea binarizeImage(IcyBufferedImage img, int threshold) {
        if (img == null) {
            return null;
        }
        boolean[] mask = new boolean[img.getSizeX() * img.getSizeY()];
        if (this.options.btrackWhite) {
            byte[] arrayRed = img.getDataXYAsByte(0);
            byte[] arrayGreen = img.getDataXYAsByte(1);
            byte[] arrayBlue = img.getDataXYAsByte(2);
            for (int i = 0; i < arrayRed.length; ++i) {
                float r = arrayRed[i] & 0xFF;
                float g = arrayGreen[i] & 0xFF;
                float b = arrayBlue[i] & 0xFF;
                float intensity = (r + g + b) / 3.0f;
                mask[i] = intensity > (float)threshold;
            }
        } else {
            byte[] arrayChan = img.getDataXYAsByte(this.options.videoChannel);
            for (int i = 0; i < arrayChan.length; ++i) {
                mask[i] = (arrayChan[i] & 0xFF) < threshold;
            }
        }
        BooleanMask2D bmask = new BooleanMask2D(img.getBounds(), mask);
        return new ROI2DArea(bmask);
    }

    public List<Rectangle2D> findFlies(IcyBufferedImage workimage, final int t) throws InterruptedException {
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("detectFlies");
        processor.setPriority(5);
        ArrayList futures = new ArrayList(this.box.cageList.size());
        futures.clear();
        final ROI2DArea binarizedImageRoi = this.binarizeImage(workimage, this.options.threshold);
        final ArrayList<Rectangle2D> listRectangles = new ArrayList<Rectangle2D>(this.box.cageList.size());
        for (final Cage cage : this.box.cageList) {
            if (this.options.detectCage != -1 && cage.getCageID() != this.options.detectCage || cage.cageNFlies < 1) continue;
            futures.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    BooleanMask2D bestMask = FlyDetectTools.this.getBestMask(binarizedImageRoi, cage.cageMask2D);
                    Rectangle2D rect = FlyDetectTools.this.saveBestMask(bestMask, cage, t);
                    if (rect != null) {
                        listRectangles.add(rect);
                    }
                }
            }));
        }
        this.waitDetectCompletion(processor, futures, null);
        processor.shutdown();
        return listRectangles;
    }

    BooleanMask2D getBestMask(ROI2DArea binarizedImageRoi, BooleanMask2D cellMask) {
        BooleanMask2D bestMask = null;
        try {
            bestMask = this.findLargestBlob(binarizedImageRoi, cellMask);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return bestMask;
    }

    Rectangle2D saveBestMask(BooleanMask2D bestMask, Cage cell, int t) {
        Rectangle rect = null;
        if (bestMask != null) {
            rect = bestMask.getOptimizedBounds();
        }
        cell.flyPositions.addPositionWithoutRoiArea(t, rect);
        return rect;
    }

    public ROI2DArea binarizeInvertedImage(IcyBufferedImage img, int threshold) {
        if (img == null) {
            return null;
        }
        boolean[] mask = new boolean[img.getSizeX() * img.getSizeY()];
        if (this.options.btrackWhite) {
            byte[] arrayRed = img.getDataXYAsByte(0);
            byte[] arrayGreen = img.getDataXYAsByte(1);
            byte[] arrayBlue = img.getDataXYAsByte(2);
            for (int i = 0; i < arrayRed.length; ++i) {
                float r = arrayRed[i] & 0xFF;
                float g = arrayGreen[i] & 0xFF;
                float b = arrayBlue[i] & 0xFF;
                float intensity = (r + g + b) / 3.0f;
                mask[i] = intensity < (float)threshold;
            }
        } else {
            byte[] arrayChan = img.getDataXYAsByte(this.options.videoChannel);
            for (int i = 0; i < arrayChan.length; ++i) {
                mask[i] = (arrayChan[i] & 0xFF) > threshold;
            }
        }
        BooleanMask2D bmask = new BooleanMask2D(img.getBounds(), mask);
        return new ROI2DArea(bmask);
    }

    public void initParametersForDetection(Experiment exp, BuildSeriesOptions options) {
        this.options = options;
        exp.cages.detect_nframes = (int)((exp.cages.detectLast_Ms - exp.cages.detectFirst_Ms) / exp.cages.detectBin_Ms + 1L);
        exp.cages.clearAllMeasures(options.detectCage);
        this.box = exp.cages;
        this.box.computeBooleanMasksForCages();
        this.rectangleAllCages = null;
        for (Cage cell : this.box.cageList) {
            if (cell.cageNFlies < 1) continue;
            Rectangle rect = cell.cageRoi2D.getBounds();
            if (this.rectangleAllCages == null) {
                this.rectangleAllCages = new Rectangle(rect);
                continue;
            }
            this.rectangleAllCages.add(rect);
        }
    }

    protected void waitDetectCompletion(Processor processor, ArrayList<Future<?>> futuresArray, ProgressFrame progressBar) {
        int frame = 1;
        int nframes = futuresArray.size();
        while (!futuresArray.isEmpty()) {
            Future<?> f = futuresArray.get(futuresArray.size() - 1);
            if (progressBar != null) {
                progressBar.setMessage("Analyze frame: " + frame + "//" + nframes);
            }
            try {
                f.get();
            }
            catch (ExecutionException e) {
                System.out.println("FlyDetectTools:waitDetectCompletion - frame:" + frame + " Execution exception: " + e);
            }
            catch (InterruptedException e) {
                System.out.println("FlyDetectTools:waitDetectCompletion - Interrupted exception: " + e);
            }
            futuresArray.remove(f);
            ++frame;
        }
    }
}

