/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import flanagan.complex.Complex;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

public class GaspardRigidRegistration {
    public static Vector2d findTranslation2D(IcyBufferedImage source, int sourceC, IcyBufferedImage target, int targetC) {
        if (!source.getBounds().equals(target.getBounds())) {
            throw new UnsupportedOperationException("Cannot register images of different size (yet)");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        float[] _source = Array1DUtil.arrayToFloatArray((Object)source.getDataXY(sourceC), (boolean)source.isSignedDataType());
        float[] _target = Array1DUtil.arrayToFloatArray((Object)target.getDataXY(targetC), (boolean)target.isSignedDataType());
        float[] correlationMap = GaspardRigidRegistration.spectralCorrelation(_source, _target, width, height);
        int argMax = GaspardRigidRegistration.argMax(correlationMap, correlationMap.length);
        int transX = argMax % width;
        int transY = argMax / width;
        if (transX > width / 2) {
            transX -= width;
        }
        if (transY > height / 2) {
            transY -= height;
        }
        return new Vector2d((double)(-transX), (double)(-transY));
    }

    private static float[] spectralCorrelation(float[] a1, float[] a2, int width, int height) {
        FloatFFT_2D fft = new FloatFFT_2D(height, width);
        return GaspardRigidRegistration.spectralCorrelation(a1, a2, width, height, fft);
    }

    private static float[] spectralCorrelation(float[] a1, float[] a2, int width, int height, FloatFFT_2D fft) {
        float[] sourceFFT = GaspardRigidRegistration.forwardFFT(a1, fft);
        float[] targetFFT = GaspardRigidRegistration.forwardFFT(a2, fft);
        Complex c1 = new Complex();
        Complex c2 = new Complex();
        for (int i = 0; i < sourceFFT.length; i += 2) {
            c1.setReal((double)sourceFFT[i]);
            c1.setImag((double)sourceFFT[i + 1]);
            c2.setReal((double)targetFFT[i]);
            c2.setImag((double)targetFFT[i + 1]);
            c1.timesEquals(c2.conjugate());
            sourceFFT[i] = (float)c1.getReal();
            sourceFFT[i + 1] = (float)c1.getImag();
        }
        return GaspardRigidRegistration.inverseFFT(sourceFFT, fft);
    }

    private static int argMax(float[] array, int n) {
        int argMax = 0;
        float max = array[0];
        for (int i = 1; i < n; ++i) {
            float val = array[i];
            if (!(val > max)) continue;
            max = val;
            argMax = i;
        }
        return argMax;
    }

    private static float[] forwardFFT(float[] realData, FloatFFT_2D fft) {
        float[] out = new float[realData.length * 2];
        int i = 0;
        int j = 0;
        while (i < realData.length) {
            out[j] = realData[i];
            ++i;
            j += 2;
        }
        fft.complexForward(out);
        return out;
    }

    private static float[] inverseFFT(float[] cplxData, FloatFFT_2D fft) {
        float[] out = new float[cplxData.length / 2];
        fft.complexInverse(cplxData, true);
        int i = 0;
        int j = 0;
        while (i < cplxData.length) {
            out[j] = cplxData[i];
            i += 2;
            ++j;
        }
        return out;
    }

    public static boolean correctTranslation2D(IcyBufferedImage img, IcyBufferedImage ref, int referenceChannel) {
        boolean change = false;
        Vector2d translation = new Vector2d();
        int n = 0;
        int minC = referenceChannel == -1 ? 0 : referenceChannel;
        int maxC = referenceChannel == -1 ? img.getSizeC() - 1 : referenceChannel;
        for (int c = minC; c <= maxC; ++c) {
            translation.add((Tuple2d)GaspardRigidRegistration.findTranslation2D(img, c, ref, c));
            ++n;
        }
        translation.scale(1.0 / (double)n);
        if (translation.lengthSquared() != 0.0) {
            change = true;
            img = GaspardRigidRegistration.applyTranslation2D(img, -1, translation, true);
        }
        return change;
    }

    public static IcyBufferedImage applyTranslation2D(IcyBufferedImage image, int channel, Vector2d vector, boolean preserveImageSize) {
        int dx = (int)Math.round(vector.x);
        int dy = (int)Math.round(vector.y);
        System.out.println("GasparRigidRegistration:applyTranslation2D() dx=" + dx + " dy=" + dy);
        if (dx == 0 && dy == 0) {
            return image;
        }
        Rectangle newSize = image.getBounds();
        newSize.width += Math.abs(dx);
        newSize.height += Math.abs(dy);
        Point dstPoint_shiftedChannel = new Point(Math.max(0, dx), Math.max(0, dy));
        Point dstPoint_otherChannels = new Point(Math.max(0, -dx), Math.max(0, -dy));
        IcyBufferedImage newImage = new IcyBufferedImage(newSize.width, newSize.height, image.getSizeC(), image.getDataType_());
        for (int c = 0; c < image.getSizeC(); ++c) {
            Point dstPoint = channel == -1 || c == channel ? dstPoint_shiftedChannel : dstPoint_otherChannels;
            newImage.copyData(image, null, dstPoint, c, c);
        }
        if (preserveImageSize) {
            newSize = image.getBounds();
            newSize.x = Math.max(0, -dx);
            newSize.y = Math.max(0, -dy);
            return IcyBufferedImageUtil.getSubImage((IcyBufferedImage)newImage, (Rectangle)newSize);
        }
        return newImage;
    }

    public static boolean correctRotation2D(IcyBufferedImage img, IcyBufferedImage ref, int referenceChannel) {
        boolean change = false;
        double angle = 0.0;
        int n = 0;
        int minC = referenceChannel == -1 ? 0 : referenceChannel;
        int maxC = referenceChannel == -1 ? ref.getSizeC() : referenceChannel;
        for (int c = minC; c <= maxC; ++c) {
            angle += GaspardRigidRegistration.findRotation2D(img, c, ref, c);
            ++n;
        }
        if ((angle /= (double)n) != 0.0) {
            change = true;
            img = GaspardRigidRegistration.applyRotation2D(img, -1, angle, true);
        }
        return change;
    }

    public static double findRotation2D(IcyBufferedImage source, int sourceC, IcyBufferedImage target, int targetC) {
        return GaspardRigidRegistration.findRotation2D(source, sourceC, target, targetC, null);
    }

    public static double findRotation2D(IcyBufferedImage source, int sourceC, IcyBufferedImage target, int targetC, Vector2d previousTranslation) {
        float[] _targetLogPol;
        if (!source.getBounds().equals(target.getBounds())) {
            if (previousTranslation != null) {
                int xAlign = previousTranslation.x > 0.0 ? 2 : 4;
                int yAlign = previousTranslation.y > 0.0 ? 1 : 3;
                target = IcyBufferedImageUtil.scale((IcyBufferedImage)target, (int)source.getSizeX(), (int)source.getSizeY(), (boolean)false, (int)xAlign, (int)yAlign);
            } else {
                throw new UnsupportedOperationException("Cannot register images of different size (yet)");
            }
        }
        IcyBufferedImage sourceLogPol = GaspardRigidRegistration.toLogPolar(source.getImage(sourceC));
        IcyBufferedImage targetLogPol = GaspardRigidRegistration.toLogPolar(target.getImage(targetC));
        int width = sourceLogPol.getWidth();
        int height = sourceLogPol.getHeight();
        float[] _sourceLogPol = sourceLogPol.getDataXYAsFloat(0);
        float[] correlationMap = GaspardRigidRegistration.spectralCorrelation(_sourceLogPol, _targetLogPol = targetLogPol.getDataXYAsFloat(0), width, height);
        int argMax = GaspardRigidRegistration.argMax(correlationMap, correlationMap.length / 2);
        int rotX = argMax % width;
        if (rotX > width / 2) {
            rotX -= width;
        }
        return (double)(-rotX * 2) * Math.PI / (double)width;
    }

    private static IcyBufferedImage toLogPolar(IcyBufferedImage image) {
        return GaspardRigidRegistration.toLogPolar(image, image.getWidth() / 2, image.getHeight() / 2, 1080, 360);
    }

    private static IcyBufferedImage toLogPolar(IcyBufferedImage image, int centerX, int centerY, int sizeTheta, int sizeRho) {
        int sizeC = image.getSizeC();
        double theta = 0.0;
        double dtheta = Math.PI * 2 / (double)sizeTheta;
        float[] cosTheta = new float[sizeTheta];
        float[] sinTheta = new float[sizeTheta];
        int thetaIndex = 0;
        while (thetaIndex < sizeTheta) {
            cosTheta[thetaIndex] = (float)Math.cos(theta);
            sinTheta[thetaIndex] = (float)Math.sin(theta);
            ++thetaIndex;
            theta += dtheta;
        }
        float drho = (float)(Math.sqrt(centerX * centerX + centerY * centerY) / (double)sizeRho);
        IcyBufferedImage logPol = new IcyBufferedImage(sizeTheta, sizeRho, sizeC, DataType.FLOAT);
        for (int c = 0; c < sizeC; ++c) {
            float[] out = logPol.getDataXYAsFloat(c);
            Array1DUtil.fill((float[])out, (int)0, (int)sizeTheta, (float)GaspardRigidRegistration.getPixelValue(image, centerX, centerY, c));
            float rho = drho;
            int outOffset = sizeTheta;
            int rhoIndex = 1;
            while (rhoIndex < sizeRho) {
                int thetaIndex2 = 0;
                while (thetaIndex2 < sizeTheta) {
                    double x = (float)centerX + rho * cosTheta[thetaIndex2];
                    double y = (float)centerY + rho * sinTheta[thetaIndex2];
                    out[outOffset] = GaspardRigidRegistration.getPixelValue(image, x, y, c);
                    ++thetaIndex2;
                    ++outOffset;
                }
                ++rhoIndex;
                rho += drho;
            }
        }
        logPol.updateChannelsBounds();
        return logPol;
    }

    private static float getPixelValue(IcyBufferedImage img, double x, double y, int c) {
        int width = img.getWidth();
        int height = img.getHeight();
        Object data = img.getDataXY(c);
        DataType type = img.getDataType_();
        int i = (int)Math.floor(x -= 0.5);
        int j = (int)Math.floor(y -= 0.5);
        if (i <= 0 || i >= width - 1 || j <= 0 || j >= height - 1) {
            return 0.0f;
        }
        float value = 0.0f;
        int offset = i + j * width;
        int offset_plus_1 = offset + 1;
        double mx = 1.0 - (x -= (double)i);
        double my = 1.0 - (y -= (double)j);
        value = (float)((double)value + mx * my * (double)Array1DUtil.getValueAsFloat((Object)data, (int)offset, (DataType)type));
        value = (float)((double)value + x * my * (double)Array1DUtil.getValueAsFloat((Object)data, (int)offset_plus_1, (DataType)type));
        value = (float)((double)value + mx * y * (double)Array1DUtil.getValueAsFloat((Object)data, (int)(offset + width), (DataType)type));
        value = (float)((double)value + x * y * (double)Array1DUtil.getValueAsFloat((Object)data, (int)(offset_plus_1 + width), (DataType)type));
        return value;
    }

    public static IcyBufferedImage applyRotation2D(IcyBufferedImage img, int channel, double angle, boolean preserveImageSize) {
        if (angle == 0.0) {
            return img;
        }
        IcyBufferedImage rotImg = IcyBufferedImageUtil.rotate((IcyBufferedImage)img.getImage(channel), (double)angle);
        Rectangle oldSize = img.getBounds();
        Rectangle newSize = rotImg.getBounds();
        int dw = (newSize.width - oldSize.width) / 2;
        int dh = (newSize.height - oldSize.height) / 2;
        if (channel == -1 || img.getSizeC() == 1) {
            if (preserveImageSize) {
                oldSize.translate(dw, dh);
                return IcyBufferedImageUtil.getSubImage((IcyBufferedImage)rotImg, (Rectangle)oldSize);
            }
            return rotImg;
        }
        IcyBufferedImage[] newImages = new IcyBufferedImage[img.getSizeC()];
        if (preserveImageSize) {
            for (int c = 0; c < newImages.length; ++c) {
                if (c == channel) {
                    oldSize.translate(dw, dh);
                    newImages[c] = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)rotImg, (Rectangle)oldSize);
                    continue;
                }
                newImages[c] = img.getImage(c);
            }
        } else {
            for (int c = 0; c < newImages.length; ++c) {
                if (c != channel) {
                    newImages[c] = new IcyBufferedImage(newSize.width, newSize.height, 1, img.getDataType_());
                    newImages[c].copyData(img.getImage(c), null, new Point(dw, dh));
                    continue;
                }
                newImages[channel] = rotImg;
            }
        }
        return IcyBufferedImage.createFrom(Arrays.asList(newImages));
    }
}

