/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.chart;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.cages.FlyPositions;
import plugins.fmp.multicafe.tools.MaxMinDouble;
import plugins.fmp.multicafe.tools.chart.ChartData;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;

public class ChartPositions
extends IcyFrame {
    public JPanel mainChartPanel = null;
    private ArrayList<ChartPanel> chartsInMainChartPanel = null;
    public IcyFrame mainChartFrame = null;
    private String title;
    private Point pt = new Point(0, 0);
    private double globalXMax = 0.0;

    public void createPanel(String cstitle) {
        this.title = cstitle;
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)this.title, (JPanel)new JPanel(), (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.mainChartPanel = new JPanel();
        this.mainChartPanel.setLayout(new BoxLayout(this.mainChartPanel, 2));
        this.mainChartFrame.add((Component)this.mainChartPanel);
    }

    public void setLocationRelativeToRectangle(Rectangle rectv, Point deltapt) {
        this.pt = new Point(rectv.x + deltapt.x, rectv.y + deltapt.y);
    }

    public void displayData(List<Cage> cellList, EnumXLSExport option) {
        ArrayList<XYSeriesCollection> xyDataSetList = new ArrayList<XYSeriesCollection>();
        MaxMinDouble yMaxMin = new MaxMinDouble();
        int count = 0;
        for (Cage cell : cellList) {
            if (cell.flyPositions == null || cell.flyPositions.flyPositionList.size() <= 0) continue;
            ChartData chartData = this.getDataSet(cell, option);
            XYSeriesCollection xyDataset = chartData.xyDataset;
            yMaxMin = chartData.yMaxMin;
            if (count != 0) {
                yMaxMin.getMaxMin(chartData.yMaxMin);
            }
            xyDataSetList.add(xyDataset);
            ++count;
        }
        this.cleanChartsPanel(this.chartsInMainChartPanel);
        int width = 100;
        boolean displayLabels = false;
        for (XYSeriesCollection xyDataset : xyDataSetList) {
            JFreeChart xyChart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            xyChart.setAntiAlias(true);
            xyChart.setTextAntiAlias(true);
            ValueAxis yAxis = xyChart.getXYPlot().getRangeAxis(0);
            yAxis.setRange(yMaxMin.min, yMaxMin.max);
            yAxis.setTickLabelsVisible(displayLabels);
            ValueAxis xAxis = xyChart.getXYPlot().getDomainAxis(0);
            xAxis.setRange(0.0, this.globalXMax);
            ChartPanel xyChartPanel = new ChartPanel(xyChart, width, 200, 50, 100, 100, 200, false, false, true, true, true, true);
            this.mainChartPanel.add((Component)xyChartPanel);
            width = 100;
            displayLabels = false;
        }
        this.mainChartFrame.pack();
        this.mainChartFrame.setLocation(this.pt);
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.setVisible(true);
    }

    private MaxMinDouble addPointsToXYSeries(Cage cell, EnumXLSExport option, XYSeries seriesXY) {
        FlyPositions results = cell.flyPositions;
        int itmax = results.flyPositionList.size();
        MaxMinDouble yMaxMin = null;
        if (itmax > 0) {
            switch (option) {
                case DISTANCE: {
                    double previousY = results.flyPositionList.get((int)0).x + results.flyPositionList.get((int)0).h / 2.0;
                    for (int it = 0; it < itmax; ++it) {
                        double currentY = results.flyPositionList.get((int)it).y + results.flyPositionList.get((int)it).h / 2.0;
                        double ypos = currentY - previousY;
                        this.addxyPos(seriesXY, results, it, ypos);
                        previousY = currentY;
                    }
                    Rectangle rect = cell.cageRoi2D.getBounds();
                    double length_diagonal = Math.sqrt(rect.height * rect.height + rect.width * rect.width);
                    yMaxMin = new MaxMinDouble(0.0, length_diagonal);
                    break;
                }
                case ISALIVE: {
                    for (int it = 0; it < itmax; ++it) {
                        boolean alive = results.flyPositionList.get((int)it).bAlive;
                        double ypos = alive ? 1.0 : 0.0;
                        this.addxyPos(seriesXY, results, it, ypos);
                    }
                    yMaxMin = new MaxMinDouble(0.0, 1.2);
                    break;
                }
                case SLEEP: {
                    for (int it = 0; it < itmax; ++it) {
                        boolean sleep = results.flyPositionList.get((int)it).bSleep;
                        double ypos = sleep ? 1.0 : 0.0;
                        this.addxyPos(seriesXY, results, it, ypos);
                    }
                    yMaxMin = new MaxMinDouble(0.0, 1.2);
                    break;
                }
                default: {
                    Rectangle rect1 = cell.cageRoi2D.getBounds();
                    double yOrigin = rect1.getY() + rect1.getHeight();
                    for (int it = 0; it < itmax; ++it) {
                        Rectangle2D itRect = results.flyPositionList.get(it).getRectangle2D();
                        double ypos = yOrigin - itRect.getY();
                        this.addxyPos(seriesXY, results, it, ypos);
                    }
                    yMaxMin = new MaxMinDouble(0.0, (double)rect1.height * 1.2);
                }
            }
        }
        return yMaxMin;
    }

    private void addxyPos(XYSeries seriesXY, FlyPositions positionxyt, int it, Double ypos) {
        double indexT = positionxyt.flyPositionList.get((int)it).flyIndexT;
        seriesXY.add(indexT, (Number)ypos);
        if (this.globalXMax < indexT) {
            this.globalXMax = indexT;
        }
    }

    private ChartData getDataSet(Cage cell, EnumXLSExport option) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        String name = cell.cageRoi2D.getName();
        XYSeries seriesXY = new XYSeries((Comparable)((Object)name));
        seriesXY.setDescription(name);
        MaxMinDouble yMaxMin = this.addPointsToXYSeries(cell, option, seriesXY);
        xyDataset.addSeries(seriesXY);
        return new ChartData(new MaxMinDouble(this.globalXMax, 0.0), yMaxMin, xyDataset);
    }

    private void cleanChartsPanel(ArrayList<ChartPanel> chartsPanel) {
        if (chartsPanel != null && chartsPanel.size() > 0) {
            chartsPanel.clear();
        }
    }
}

