/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.toExcel;

import java.awt.Point;
import java.util.List;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import plugins.fmp.multicafe.experiment.CombinedExperiment;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.JComponents.ExperimentsJComboBox;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSMeasure;
import plugins.fmp.multicafe.tools.toExcel.XLSExportOptions;
import plugins.fmp.multicafe.tools.toExcel.XLSResults;
import plugins.fmp.multicafe.tools.toExcel.XLSResultsArray;
import plugins.fmp.multicafe.tools.toExcel.XLSUtils;

public class XLSExport {
    protected XLSExportOptions options = null;
    protected CombinedExperiment expAll = null;
    XSSFCellStyle xssfCellStyle_red = null;
    XSSFCellStyle xssfCellStyle_blue = null;
    XSSFFont font_red = null;
    XSSFFont font_blue = null;
    XSSFWorkbook workbook = null;
    ExperimentsJComboBox expList = null;

    int writeTop_descriptors(XSSFSheet sheet, EnumXLSExport xlsExport) {
        Point pt = new Point(0, 0);
        int x = 0;
        boolean transpose = this.options.transpose;
        int columnIndex = 0;
        for (EnumXLSColumnHeader dumb : EnumXLSColumnHeader.values()) {
            EnumXLSMeasure columnType = dumb.toType();
            dumb.setValue(columnIndex);
            if (columnType != EnumXLSMeasure.COMMON && xlsExport.toType() != columnType) continue;
            XLSUtils.setValue(sheet, x, columnIndex, transpose, dumb.getName());
            ++columnIndex;
        }
        pt.y = columnIndex;
        return pt.y;
    }

    void writeTop_timeIntervals(XSSFSheet sheet, int row, EnumXLSExport xlsExport) {
        switch (xlsExport) {
            case AUTOCORREL: 
            case CROSSCORREL: 
            case AUTOCORREL_LR: 
            case CROSSCORREL_LR: {
                this.writeTop_timeIntervals_Correl(sheet, row);
                break;
            }
            default: {
                this.writeTop_timeIntervals_Default(sheet, row);
            }
        }
    }

    void writeTop_timeIntervals_Correl(XSSFSheet sheet, int row) {
        boolean transpose = this.options.transpose;
        Point pt = new Point(0, row);
        for (long interval = (long)(-this.options.nbinscorrelation); interval < (long)this.options.nbinscorrelation; ++interval) {
            int i = (int)interval;
            XLSUtils.setValue(sheet, pt, transpose, "t" + i);
            ++pt.y;
        }
    }

    void writeTop_timeIntervals_Default(XSSFSheet sheet, int row) {
        boolean transpose = this.options.transpose;
        Point pt = new Point(0, row);
        long duration = this.expAll.camImageLast_ms - this.expAll.camImageFirst_ms;
        for (long interval = 0L; interval < duration; interval += (long)this.options.buildExcelStepMs) {
            int i = (int)(interval / (long)this.options.buildExcelUnitMs);
            XLSUtils.setValue(sheet, pt, transpose, "t" + i);
            ++pt.y;
        }
    }

    protected int desc_getIndex_CageFromCapillaryName(String name) {
        if (!name.contains("line")) {
            return -1;
        }
        String num = name.substring(4, 5);
        int numFromName = Integer.valueOf(num);
        return numFromName;
    }

    protected int getRowIndexFromKymoFileName(String name) {
        String side;
        if (!name.contains("line")) {
            return -1;
        }
        String num = name.substring(4, 5);
        int numFromName = Integer.valueOf(num);
        if (name.length() > 5 && (side = name.substring(5, 6)) != null) {
            if (side.equals("R")) {
                numFromName *= 2;
                ++numFromName;
            } else if (side.equals("L")) {
                numFromName *= 2;
            }
        }
        return numFromName;
    }

    protected int getRowIndexFromCageName(String name) {
        if (!name.contains("cage") && !name.contains("cell")) {
            return -1;
        }
        String num = name.substring(4, name.length());
        int numFromName = Integer.valueOf(num);
        return numFromName;
    }

    protected Point getCageXCoordinateFromDataName(XLSResults xlsResults, Point pt_main, int colseries) {
        int col = this.getRowIndexFromKymoFileName(xlsResults.name);
        if (col >= 0) {
            pt_main.x = colseries + col;
        }
        return pt_main;
    }

    protected int getCageIndexFromKymoFileName(String name) {
        if (!name.contains("line")) {
            return -1;
        }
        return Integer.valueOf(name.substring(4, 5));
    }

    XSSFWorkbook xlsInitWorkbook() {
        XSSFWorkbook workbook = new XSSFWorkbook();
        workbook.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
        this.xssfCellStyle_red = workbook.createCellStyle();
        this.font_red = workbook.createFont();
        this.font_red.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        this.xssfCellStyle_red.setFont((Font)this.font_red);
        this.xssfCellStyle_blue = workbook.createCellStyle();
        this.font_blue = workbook.createFont();
        this.font_blue.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        this.xssfCellStyle_blue.setFont((Font)this.font_blue);
        return workbook;
    }

    XSSFSheet xlsGetSheet(String title, EnumXLSExport xlsExport) {
        XSSFSheet sheet = this.workbook.getSheet(title);
        if (sheet == null) {
            sheet = this.workbook.createSheet(title);
            int row = this.writeTop_descriptors(sheet, xlsExport);
            this.writeTop_timeIntervals(sheet, row, xlsExport);
            sheet.setActiveCell(new CellAddress(1, 0));
        }
        return sheet;
    }

    protected Point writeExperiment_data(XLSResultsArray rowListForOneExp, XSSFSheet sheet, EnumXLSExport option, Point pt_main) {
        int rowSeries = pt_main.x + 2;
        int column_dataArea = pt_main.y;
        Point pt = new Point(pt_main);
        this.writeExperiment_data_as_rows(rowListForOneExp, sheet, column_dataArea, rowSeries, pt);
        pt_main.x = pt.x + 1;
        return pt_main;
    }

    private void writeExperiment_data_as_rows(XLSResultsArray rowListForOneExp, XSSFSheet sheet, int column_dataArea, int rowSeries, Point pt) {
        for (int iRow = 0; iRow < rowListForOneExp.size(); ++iRow) {
            XLSResults row = rowListForOneExp.getRow(iRow);
            this.writeExperiment_data_single_row(sheet, column_dataArea, rowSeries, pt, row);
        }
    }

    private void writeExperiment_data_single_row(XSSFSheet sheet, int column_dataArea, int rowSeries, Point pt, XLSResults row) {
        int i_from;
        boolean transpose = this.options.transpose;
        pt.y = column_dataArea;
        int col = this.getRowIndexFromKymoFileName(row.name);
        pt.x = rowSeries + col;
        if (row.valuesOut == null) {
            return;
        }
        long coltime = this.expAll.camImageFirst_ms;
        while (coltime < this.expAll.camImageLast_ms && (i_from = (int)((coltime - this.expAll.camImageFirst_ms) / (long)this.options.buildExcelStepMs)) < row.valuesOut.length) {
            double value = row.valuesOut[i_from];
            if (!Double.isNaN(value)) {
                XLSUtils.setValue(sheet, pt, transpose, value);
                if (i_from < row.padded_out.length && row.padded_out[i_from]) {
                    XLSUtils.getCell(sheet, pt, transpose).setCellStyle((CellStyle)this.xssfCellStyle_red);
                }
            }
            coltime += (long)this.options.buildExcelStepMs;
            ++pt.y;
        }
        ++pt.x;
    }

    protected void exportExperimentField(XSSFSheet sheet, int x, int y, boolean transpose, Experiment exp, EnumXLSColumnHeader colHeader) {
        XLSUtils.setValue(sheet, x, y + colHeader.getValue(), transpose, exp.getExperimentField(colHeader));
    }

    protected void XLSExportExperimentParameters(XSSFSheet sheet, boolean transpose, int x, int y, String charSeries, Experiment exp) {
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_PATH);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_DATE);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_CAM);
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.EXP_BOXID.getValue(), transpose, charSeries);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_EXPT);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_STIM);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_CONC);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_STRAIN);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_SEX);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_COND1);
        this.exportExperimentField(sheet, x, y, transpose, exp, EnumXLSColumnHeader.EXP_COND2);
    }

    protected void xlsExportCageParameters(XSSFSheet sheet, boolean transpose, int x, int y, String charSeries, Experiment exp, Cage cage) {
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_INDEX.getValue(), transpose, cage.getCageIDasString());
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_ID.getValue(), transpose, charSeries + "_" + cage.getCageID());
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_STRAIN.getValue(), transpose, cage.cageStrain);
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_SEX.getValue(), transpose, cage.cageSex);
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_AGE.getValue(), transpose, cage.cageAge);
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAGE_COMMENT.getValue(), transpose, cage.cageComment);
    }

    protected void XLSExportCapillaryParameters(XSSFSheet sheet, boolean transpose, int x, int y, String charSeries, Experiment exp, Capillary cap, EnumXLSExport xlsExportOption, int index) {
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP.getValue(), transpose, cap.getSideDescriptor(xlsExportOption));
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_INDEX.getValue(), transpose, charSeries + "_" + cap.getLast2ofCapillaryName());
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_VOLUME.getValue(), transpose, exp.capillaries.capillariesDescription.volume);
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_PIXELS.getValue(), transpose, exp.capillaries.capillariesDescription.pixels);
        this.outputStimAndConc_according_to_DataOption(sheet, xlsExportOption, cap, transpose, x, y);
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_NFLIES.getValue(), transpose, cap.capNFlies);
        XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CHOICE_NOCHOICE.getValue(), transpose, this.desc_getChoiceTestType(exp.capillaries.capillariesList, index));
    }

    private void outputStimAndConc_according_to_DataOption(XSSFSheet sheet, EnumXLSExport xlsExportOption, Capillary cap, boolean transpose, int x, int y) {
        switch (xlsExportOption) {
            case TOPLEVEL_LR: 
            case TOPLEVELDELTA_LR: 
            case SUMGULPS_LR: {
                if (cap.getCapillarySide().equals("L")) {
                    XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_STIM.getValue(), transpose, "L+R");
                } else {
                    XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_STIM.getValue(), transpose, "(L-R)/(L+R)");
                }
                XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_CONC.getValue(), transpose, cap.capStimulus + ": " + cap.capConcentration);
                break;
            }
            case TTOGULP_LR: {
                if (cap.getCapillarySide().equals("L")) {
                    XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_STIM.getValue(), transpose, "min_t_to_gulp");
                } else {
                    XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_STIM.getValue(), transpose, "max_t_to_gulp");
                }
                XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_CONC.getValue(), transpose, cap.capStimulus + ": " + cap.capConcentration);
                break;
            }
            default: {
                XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_STIM.getValue(), transpose, cap.capStimulus);
                XLSUtils.setValue(sheet, x, y + EnumXLSColumnHeader.CAP_CONC.getValue(), transpose, cap.capConcentration);
            }
        }
    }

    private String desc_getChoiceTestType(List<Capillary> capList, int index) {
        Capillary othercap;
        String otherSide;
        Capillary cap = capList.get(index);
        String choiceText = "..";
        String side = cap.getCapillarySide();
        index = side.contains("L") ? ++index : --index;
        if (index >= 0 && index < capList.size() && !(otherSide = (othercap = capList.get(index)).getCapillarySide()).contains(side)) {
            choiceText = cap.capStimulus.equals(othercap.capStimulus) && cap.capConcentration.equals(othercap.capConcentration) ? "no-choice" : "choice";
        }
        return choiceText;
    }

    protected int writeSeparator_Between_Experiments(XSSFSheet sheet, Point pt, boolean transpose) {
        XLSUtils.setValue(sheet, pt, transpose, "..");
        ++pt.x;
        XLSUtils.setValue(sheet, pt, transpose, "..");
        ++pt.x;
        return pt.x;
    }
}

