/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.toExcel;

import java.util.ArrayList;
import java.util.Arrays;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSExportOptions;
import plugins.fmp.multicafe.tools.toExcel.XLSResults;
import plugins.fmp.multicafe.tools.toExcel.XLSResultsArray;

public class XLSResultsFromCapillaries
extends XLSResultsArray {
    XLSResults evapL = null;
    XLSResults evapR = null;
    boolean sameLR = true;
    String stim = null;
    String conc = null;
    double lowestPiAllowed = -1.2;
    double highestPiAllowed = 1.2;

    public XLSResultsFromCapillaries(int size) {
        this.resultsList = new ArrayList(size);
    }

    public XLSResults getNextRowIfSameCage(int irow) {
        XLSResults rowL = (XLSResults)this.resultsList.get(irow);
        int cellL = this.getCageFromKymoFileName(rowL.name);
        XLSResults rowR = null;
        if (irow + 1 < this.resultsList.size()) {
            rowR = (XLSResults)this.resultsList.get(irow + 1);
            int cellR = this.getCageFromKymoFileName(rowR.name);
            if (cellR != cellL) {
                rowR = null;
            }
        }
        return rowR;
    }

    protected int getCageFromKymoFileName(String name) {
        if (!name.contains("line")) {
            return -1;
        }
        return Integer.valueOf(name.substring(4, 5));
    }

    public void checkIfSameStimulusAndConcentration(Capillary cap) {
        if (!this.sameLR) {
            return;
        }
        if (this.stim == null) {
            this.stim = cap.capStimulus;
        }
        if (this.conc == null) {
            this.conc = cap.capConcentration;
        }
        this.sameLR &= this.stim.equals(cap.capStimulus);
        this.sameLR &= this.conc.equals(cap.capConcentration);
    }

    public void subtractEvaporation() {
        int dimension = 0;
        for (XLSResults result : this.resultsList) {
            if (result.valuesOut == null || result.valuesOut.length <= dimension) continue;
            dimension = result.valuesOut.length;
        }
        if (dimension == 0) {
            return;
        }
        this.computeEvaporationFromResultsWithZeroFlies(dimension);
        this.subtractEvaporationLocal();
    }

    private void computeEvaporationFromResultsWithZeroFlies(int dimension) {
        this.evapL = new XLSResults("L", 0, 0, null);
        this.evapR = new XLSResults("R", 0, 0, null);
        this.evapL.initValuesOutArray(dimension, 0.0);
        this.evapR.initValuesOutArray(dimension, 0.0);
        for (XLSResults result : this.resultsList) {
            if (result.valuesOut == null || result.nflies != 0) continue;
            String side = result.name.substring(result.name.length() - 1);
            if (this.sameLR || side.contains("L")) {
                this.evapL.addDataToValOutEvap(result);
                continue;
            }
            this.evapR.addDataToValOutEvap(result);
        }
        this.evapL.averageEvaporation();
        this.evapR.averageEvaporation();
    }

    private void subtractEvaporationLocal() {
        for (XLSResults result : this.resultsList) {
            String side = result.name.substring(result.name.length() - 1);
            if (this.sameLR || side.contains("L")) {
                result.subtractEvap(this.evapL);
                continue;
            }
            result.subtractEvap(this.evapR);
        }
    }

    private int getLen(XLSResults rowL, XLSResults rowR) {
        int lenL = rowL.valuesOut.length;
        int lenR = rowR.valuesOut.length;
        return Math.min(lenL, lenR);
    }

    public void getPI_and_SUM_from_LR(XLSResults rowL, XLSResults rowR, double threshold) {
        int len = this.getLen(rowL, rowR);
        for (int index = 0; index < len; ++index) {
            double dataL = rowL.valuesOut[index];
            double dataR = rowR.valuesOut[index];
            double pi = 0.0;
            double sum = Math.abs(dataL) + Math.abs(dataR);
            if (sum != 0.0 && sum >= threshold) {
                pi = (dataL - dataR) / sum;
            }
            rowL.valuesOut[index] = sum;
            rowR.valuesOut[index] = pi;
        }
    }

    void getMinTimeToGulpLR(XLSResults rowL, XLSResults rowR, XLSResults rowOut) {
        int len = this.getLen(rowL, rowR);
        for (int index = 0; index < len; ++index) {
            double dataMax = Double.NaN;
            double dataL = rowL.valuesOut[index];
            double dataR = rowR.valuesOut[index];
            if (dataL <= dataR) {
                dataMax = dataL;
            } else if (dataL > dataR) {
                dataMax = dataR;
            }
            rowOut.valuesOut[index] = dataMax;
        }
    }

    void getMaxTimeToGulpLR(XLSResults rowL, XLSResults rowR, XLSResults rowOut) {
        int len = this.getLen(rowL, rowR);
        for (int index = 0; index < len; ++index) {
            double dataMin = Double.NaN;
            double dataL = rowL.valuesOut[index];
            double dataR = rowR.valuesOut[index];
            if (dataL >= dataR) {
                dataMin = dataL;
            } else if (dataL < dataR) {
                dataMin = dataR;
            }
            rowOut.valuesOut[index] = dataMin;
        }
    }

    public void getResults1(Experiment expi, EnumXLSExport exportType, int nOutputFrames, long kymoBinCol_Ms, XLSExportOptions xlsExportOptions) {
        xlsExportOptions.exportType = exportType;
        this.buildDataForPass1(expi, nOutputFrames, kymoBinCol_Ms, xlsExportOptions, false);
        if (xlsExportOptions.compensateEvaporation) {
            this.subtractEvaporation();
        }
        this.buildDataForPass2(xlsExportOptions);
    }

    public void getResults_T0(Experiment expi, EnumXLSExport exportType, int nOutputFrames, long kymoBinCol_Ms, XLSExportOptions xlsExportOptions) {
        xlsExportOptions.exportType = exportType;
        this.buildDataForPass1(expi, nOutputFrames, kymoBinCol_Ms, xlsExportOptions, xlsExportOptions.t0);
        if (xlsExportOptions.compensateEvaporation) {
            this.subtractEvaporation();
        }
        this.buildDataForPass2(xlsExportOptions);
    }

    private void buildDataForPass1(Experiment expi, int nOutputFrames, long kymoBinCol_Ms, XLSExportOptions xlsExportOptions, boolean subtractT0) {
        Capillaries caps = expi.capillaries;
        double scalingFactorToPhysicalUnits = caps.getScalingFactorToPhysicalUnits(xlsExportOptions.exportType);
        for (Capillary cap : caps.capillariesList) {
            this.checkIfSameStimulusAndConcentration(cap);
            XLSResults results = new XLSResults(cap.getRoiName(), cap.capNFlies, cap.capCageID, xlsExportOptions.exportType, nOutputFrames);
            results.dataInt = cap.getCapillaryMeasuresForXLSPass1(xlsExportOptions.exportType, kymoBinCol_Ms, xlsExportOptions.buildExcelStepMs);
            if (subtractT0) {
                results.subtractT0();
            }
            results.transferDataIntToValuesOut(scalingFactorToPhysicalUnits, xlsExportOptions.exportType);
            this.addRow(results);
        }
    }

    public void buildDataForPass2(XLSExportOptions xlsExportOptions) {
        switch (xlsExportOptions.exportType) {
            case TOPLEVEL_LR: 
            case TOPLEVELDELTA_LR: 
            case SUMGULPS_LR: {
                this.buildLR(xlsExportOptions.lrPIThreshold);
                break;
            }
            case AUTOCORREL: {
                this.buildAutocorrel(xlsExportOptions);
                break;
            }
            case AUTOCORREL_LR: {
                this.buildAutocorrelLR(xlsExportOptions);
                break;
            }
            case CROSSCORREL: {
                this.buildCrosscorrel(xlsExportOptions);
                break;
            }
            case CROSSCORREL_LR: {
                this.buildCrosscorrelLR(xlsExportOptions);
                break;
            }
        }
    }

    private void buildLR(double threshold) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            XLSResults rowR = this.getNextRowIfSameCage(irow);
            if (rowR == null || rowL == null) continue;
            ++irow;
            this.getPI_and_SUM_from_LR(rowL, rowR, threshold);
        }
    }

    private void buildAutocorrel(XLSExportOptions xlsExportOptions) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            this.correl(rowL, rowL, rowL, xlsExportOptions.nbinscorrelation);
        }
    }

    private void buildCrosscorrel(XLSExportOptions xlsExportOptions) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            XLSResults rowR = this.getNextRowIfSameCage(irow);
            if (rowR == null) continue;
            ++irow;
            XLSResults rowLtoR = new XLSResults("LtoR", 0, 0, null);
            rowLtoR.initValuesOutArray(rowL.dimension, 0.0);
            this.correl(rowL, rowR, rowLtoR, xlsExportOptions.nbinscorrelation);
            XLSResults rowRtoL = new XLSResults("RtoL", 0, 0, null);
            rowRtoL.initValuesOutArray(rowL.dimension, 0.0);
            this.correl(rowR, rowL, rowRtoL, xlsExportOptions.nbinscorrelation);
            rowL.copyValuesOut(rowLtoR);
            rowR.copyValuesOut(rowRtoL);
        }
    }

    private void buildCrosscorrelLR(XLSExportOptions xlsExportOptions) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            XLSResults rowR = this.getNextRowIfSameCage(irow);
            if (rowR == null) continue;
            ++irow;
            XLSResults rowLR = new XLSResults("LR", 0, 0, null);
            rowLR.initValuesOutArray(rowL.dimension, 0.0);
            this.combineIntervals(rowL, rowR, rowLR);
            this.correl(rowL, rowLR, rowL, xlsExportOptions.nbinscorrelation);
            this.correl(rowR, rowLR, rowR, xlsExportOptions.nbinscorrelation);
        }
    }

    private void correl(XLSResults row1, XLSResults row2, XLSResults rowOut, int nbins) {
        double[] sumBins = new double[2 * nbins + 1];
        Arrays.fill(sumBins, 0.0);
        double nitems = 0.0;
        for (int i1 = 0; i1 < row1.valuesOut.length; ++i1) {
            if (row1.valuesOut[i1] == 0.0) continue;
            nitems += 1.0;
            for (int i2 = 0; i2 < row2.valuesOut.length; ++i2) {
                int ibin = i2 - i1;
                if (ibin < -nbins || ibin > nbins || row2.valuesOut[i2] == 0.0) continue;
                int n = ibin + nbins;
                sumBins[n] = sumBins[n] + 1.0;
            }
        }
        Arrays.fill(rowOut.valuesOut, Double.NaN);
        for (int i = 0; i < 2 * nbins; ++i) {
            rowOut.valuesOut[i] = sumBins[i] / nitems;
        }
    }

    private void combineIntervals(XLSResults row1, XLSResults row2, XLSResults rowOut) {
        for (int i = 0; i < rowOut.valuesOut.length; ++i) {
            if (!(row2.valuesOut[i] + row1.valuesOut[i] > 0.0)) continue;
            rowOut.valuesOut[i] = 1.0;
        }
    }

    private void buildAutocorrelLR(XLSExportOptions xlsExportOptions) {
        for (int irow = 0; irow < this.resultsList.size(); ++irow) {
            XLSResults rowL = this.getRow(irow);
            XLSResults rowR = this.getNextRowIfSameCage(irow);
            if (rowR == null) continue;
            ++irow;
            XLSResults rowLR = new XLSResults("LR", 0, 0, null);
            rowLR.initValuesOutArray(rowL.dimension, 0.0);
            this.combineIntervals(rowL, rowR, rowLR);
            this.correl(rowLR, rowLR, rowL, xlsExportOptions.nbinscorrelation);
            this.correl(rowLR, rowLR, rowR, xlsExportOptions.nbinscorrelation);
        }
    }
}

