/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.viewer1D;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvasEvent;
import icy.gui.viewer.Viewer;
import icy.plugin.abstract_.PluginActionable;
import icy.plugin.interface_.PluginCanvas;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.Component;
import java.awt.image.BufferedImage;
import plugins.fmp.multicafe.viewer1D.IntensityProfile;

public class Chart1DCanvas
extends PluginActionable
implements PluginCanvas,
SequenceListener {
    private ChartCanvas chartCanvas;

    public void run() {
        Sequence input = this.getActiveSequence();
        if (input == null) {
            return;
        }
    }

    public String getCanvasClassName() {
        return ChartCanvas.class.getName();
    }

    public IcyCanvas createCanvas(Viewer viewer) {
        this.chartCanvas = new ChartCanvas(viewer);
        Sequence sequence = viewer.getSequence();
        sequence.addListener((SequenceListener)this);
        return this.chartCanvas;
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        switch (sequenceEvent.getSourceType()) {
            case SEQUENCE_DATA: {
                if (sequenceEvent.getType() != SequenceEvent.SequenceEventType.CHANGED) {
                    this.chartCanvas.iprofile.updateXYNav();
                }
                this.chartCanvas.iprofile.updateChart();
                this.chartCanvas.iprofile.updateChannelPainters();
                break;
            }
        }
    }

    public void sequenceClosed(Sequence sequence) {
    }

    public class ChartCanvas
    extends IcyCanvas {
        private static final long serialVersionUID = 1L;
        private IntensityProfile iprofile;

        public ChartCanvas(Viewer viewer) {
            super(viewer);
            this.posZ = 0;
            this.posT = 0;
            this.posY = 0;
            this.posC = -1;
            this.getSequence();
            this.iprofile = new IntensityProfile(this, this.getSequence());
            this.mouseInfPanel.setInfoXVisible(true);
            this.mouseInfPanel.setInfoYVisible(true);
            this.mouseInfPanel.setInfoZVisible(false);
            this.mouseInfPanel.setInfoTVisible(false);
            this.mouseInfPanel.setInfoCVisible(false);
            this.mouseInfPanel.setInfoDataVisible(true);
            this.mouseInfPanel.setInfoColorVisible(false);
            this.updateZNav();
            this.updateTNav();
        }

        public void refresh() {
            this.iprofile.updateChart();
        }

        public Component getViewComponent() {
            return null;
        }

        public BufferedImage getRenderedImage(int t, int z, int c, boolean canvasView) {
            return this.iprofile.getImage();
        }

        public void changed(IcyCanvasEvent event) {
            super.changed(event);
            if (this.iprofile == null) {
                return;
            }
            switch (event.getType()) {
                case POSITION_CHANGED: {
                    DimensionId i = event.getDim();
                    if (i != DimensionId.T && i != DimensionId.Z) break;
                    this.iprofile.updateChart();
                    break;
                }
            }
        }

        public double getMouseImagePosX() {
            if (this.iprofile == null) {
                return 0.0;
            }
            return this.iprofile.posX;
        }

        public double getMouseImagePosY() {
            if (this.iprofile == null) {
                return 0.0;
            }
            return this.iprofile.posY;
        }
    }
}

