/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.workinprogress_gpu;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.type.collection.array.Array1DUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceKymos;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;

public class MCSpots_1
extends JPanel {
    private static final long serialVersionUID = -7614659720134775871L;
    private MultiCAFE parent0 = null;
    private JButton subtractButton = new JButton("Subtract first column");
    private JButton buildHistogramButton = new JButton("Build histogram");
    private JButton removeBackGroundButton = new JButton("Remove background");
    private double[][] avgX = null;
    private double[][] avgY = null;
    IcyFrame mainChartFrame = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{this.subtractButton, this.buildHistogramButton}));
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{this.removeBackGroundButton, new JLabel(" ")}));
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.subtractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((MCSpots_1)MCSpots_1.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    MCSpots_1.this.subtractFirstColumn(exp);
                }
            }
        });
        this.buildHistogramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((MCSpots_1)MCSpots_1.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    MCSpots_1.this.buildHistogram(exp);
                }
            }
        });
        this.removeBackGroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((MCSpots_1)MCSpots_1.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    System.out.println("MCSpots_1:removeBackgroundButton should call removeBackGround()");
                }
            }
        });
    }

    void subtractFirstColumn(Experiment exp) {
        SequenceKymos seqKymos = exp.seqKymos;
        if (seqKymos == null) {
            return;
        }
        ImageTransformEnums transform = ImageTransformEnums.SUBTRACT_1RSTCOL;
        int zChannelDestination = 1;
        exp.kymosBuildFiltered01(0, zChannelDestination, transform, 0);
        seqKymos.seq.getFirstViewer().getCanvas().setPositionZ(zChannelDestination);
    }

    void buildHistogram(Experiment exp) {
        SequenceKymos seqKymos = exp.seqKymos;
        if (seqKymos == null) {
            return;
        }
        int imageIndex = exp.seqKymos.seq.getFirstViewer().getPositionT();
        this.getAverageXandYProfile(seqKymos, imageIndex);
        this.graphDisplay2Panels(exp, this.avgX, this.avgY);
    }

    private void getAverageXandYProfile(SequenceKymos seqKymos, int imageIndex) {
        int chan;
        int height = seqKymos.seq.getSizeY();
        int width = seqKymos.seq.getSizeX();
        Rectangle rect = new Rectangle(0, 0, width, height);
        Point2D.Double[] refpoint = new Point2D.Double[]{new Point2D.Double(rect.x, rect.y), new Point2D.Double(rect.x, rect.y + rect.height - 1), new Point2D.Double(rect.x + rect.width - 1, rect.y + rect.height - 1), new Point2D.Double(rect.x + rect.width - 1, rect.y)};
        int nYpoints = (int)(refpoint[1].y - refpoint[0].y + 1.0);
        int nXpoints = (int)(refpoint[3].x - refpoint[0].x + 1.0);
        double[][] sumXArray = new double[nXpoints][3];
        double[][] countXArray = new double[nXpoints][3];
        this.avgX = new double[nXpoints][4];
        double[][] sumYArray = new double[nYpoints][3];
        double[][] countYArray = new double[nYpoints][3];
        this.avgY = new double[nYpoints][4];
        int z = 0;
        IcyBufferedImage virtualImage = seqKymos.getSeqImage(imageIndex, z);
        for (chan = 0; chan < 3; ++chan) {
            if (virtualImage == null) {
                System.out.println("MCSpots_1:getAverageXandYProfile() An error occurred while reading image: " + seqKymos.currentFrame);
                return;
            }
            int widthImage = virtualImage.getSizeX();
            double[] image1DArray = Array1DUtil.arrayToDoubleArray((Object)virtualImage.getDataXY(chan), (boolean)virtualImage.isSignedDataType());
            double deltaXUp = refpoint[3].x - refpoint[0].x + 1.0;
            double deltaXDown = refpoint[2].x - refpoint[1].x + 1.0;
            double deltaYUp = refpoint[3].y - refpoint[0].y + 1.0;
            double deltaYDown = refpoint[2].y - refpoint[1].y + 1.0;
            for (int ix = 0; ix < nXpoints; ++ix) {
                double xUp = refpoint[0].x + deltaXUp * (double)ix / (double)nXpoints;
                double yUp = refpoint[0].y + deltaYUp * (double)ix / (double)nXpoints;
                double xDown = refpoint[1].x + deltaXDown * (double)ix / (double)nXpoints;
                double yDown = refpoint[1].y + deltaYDown * (double)ix / (double)nXpoints;
                for (int iy = 0; iy < nYpoints; ++iy) {
                    double x = xUp + (xDown - xUp + 1.0) * (double)iy / (double)nYpoints;
                    double y = yUp + (yDown - yUp + 1.0) * (double)iy / (double)nYpoints;
                    int index = (int)x + (int)y * widthImage;
                    double value = image1DArray[index];
                    sumXArray[ix][chan] = sumXArray[ix][chan] + value;
                    countXArray[ix][chan] = countXArray[ix][chan] + 1.0;
                    sumYArray[iy][chan] = sumYArray[iy][chan] + value;
                    countYArray[iy][chan] = countYArray[iy][chan] + 1.0;
                }
            }
        }
        for (chan = 0; chan < 3; ++chan) {
            for (int ix = 0; ix < nXpoints; ++ix) {
                double n = countXArray[ix][chan];
                this.avgX[ix][chan] = sumXArray[ix][chan] / n;
            }
            for (int iy = 0; iy < nYpoints; ++iy) {
                double n = countYArray[iy][chan];
                this.avgY[iy][chan] = sumYArray[iy][chan] / n;
            }
        }
    }

    private void graphDisplay2Panels(Experiment exp, double[][] arrayX, double[][] arrayY) {
        Point pt = null;
        if (this.mainChartFrame != null) {
            pt = this.mainChartFrame.getLocation();
            this.mainChartFrame.removeAll();
            this.mainChartFrame.close();
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 2));
        String localtitle = "Average along X and Y";
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)localtitle, (JPanel)new JPanel(), (Dimension)new Dimension(1400, 800), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        int totalpoints = 0;
        ArrayList<XYSeriesCollection> xyDataSetList = new ArrayList<XYSeriesCollection>();
        XYSeriesCollection xyDataset = this.graphCreateXYDataSet(arrayX, "X chan ");
        xyDataSetList.add(xyDataset);
        totalpoints += xyDataset.getSeries(0).getItemCount();
        xyDataset = this.graphCreateXYDataSet(arrayY, "Y chan ");
        xyDataSetList.add(xyDataset);
        totalpoints += xyDataset.getSeries(0).getItemCount();
        for (int i = 0; i < xyDataSetList.size(); ++i) {
            xyDataset = (XYSeriesCollection)xyDataSetList.get(i);
            int npoints = xyDataset.getSeries(0).getItemCount();
            JFreeChart xyChart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            xyChart.setAntiAlias(true);
            xyChart.setTextAntiAlias(true);
            int drawWidth = npoints * 800 / totalpoints;
            int drawHeight = 400;
            ChartPanel xyChartPanel = new ChartPanel(xyChart, drawWidth, drawHeight, drawWidth, drawHeight, drawWidth, drawHeight, false, false, true, true, true, true);
            mainPanel.add((Component)xyChartPanel);
        }
        this.mainChartFrame.add((Component)mainPanel);
        this.mainChartFrame.pack();
        if (pt == null) {
            SequenceKymos seqKymos = exp.seqKymos;
            Viewer v = seqKymos.seq.getFirstViewer();
            Rectangle rectv = v.getBounds();
            pt = new Point((int)rectv.getX(), (int)rectv.getY() + 30);
        }
        this.mainChartFrame.setLocation(pt);
        this.mainChartFrame.setVisible(true);
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.requestFocus();
    }

    private XYSeriesCollection graphCreateXYDataSet(double[][] array, String rootName) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        for (int chan = 0; chan < 4; ++chan) {
            XYSeries seriesXY = new XYSeries((Comparable)((Object)(rootName + chan)));
            if (chan == 3) {
                seriesXY.setDescription("1-2 + 3-2");
            }
            int len = array.length;
            for (int i = 0; i < len; ++i) {
                double value = array[i][chan];
                seriesXY.add((double)i, value);
            }
            xyDataset.addSeries(seriesXY);
        }
        return xyDataset;
    }
}

