/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.cages;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.DataType;
import icy.type.geom.Polygon2D;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceCamData;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.Blobs;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multicafe.tools.Overlay.OverlayThreshold;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class BuildCagesFromContours
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -121724000730795396L;
    private JButton drawPolygon2DButton = new JButton("Draw Polygon2D");
    private JButton createCellsButton = new JButton("Create cells");
    private JSpinner thresholdSpinner = new JSpinner(new SpinnerNumberModel(60, 0, 10000, 1));
    public JCheckBox overlayCheckBox = new JCheckBox("Overlay ", false);
    private JButton deleteButton = new JButton("Cut points within selected polygon");
    private JComboBox<ImageTransformEnums> transformForLevelsComboBox = new JComboBox<ImageTransformEnums>(new ImageTransformEnums[]{ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.RGB, ImageTransformEnums.GBMINUS_2R, ImageTransformEnums.RBMINUS_2G, ImageTransformEnums.RGMINUS_2B, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB});
    private OverlayThreshold overlayThreshold = null;
    private MultiCAFE parent0 = null;
    private ROI2DPolygon userPolygon = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.drawPolygon2DButton);
        panel1.add(this.createCellsButton);
        this.add(panel1);
        JLabel videochannel = new JLabel("detect from ");
        videochannel.setHorizontalAlignment(4);
        this.transformForLevelsComboBox.setSelectedIndex(2);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(videochannel);
        panel2.add(this.transformForLevelsComboBox);
        panel2.add(this.overlayCheckBox);
        panel2.add(this.thresholdSpinner);
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(this.deleteButton);
        this.add(panel3);
        this.defineActionListeners();
        this.thresholdSpinner.addChangeListener(this);
        this.overlayCheckBox.addChangeListener(this);
    }

    private void defineActionListeners() {
        this.drawPolygon2DButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((BuildCagesFromContours)BuildCagesFromContours.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    BuildCagesFromContours.this.create2DPolygon(exp);
                }
            }
        });
        this.createCellsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((BuildCagesFromContours)BuildCagesFromContours.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    BuildCagesFromContours.this.createROIsFromSelectedPolygon(exp);
                    exp.cages.cagesFromROIs(exp.seqCamData);
                    if (exp.capillaries.capillariesList.size() > 0) {
                        exp.cages.transferNFliesFromCapillariesToCageBox(exp.capillaries.capillariesList);
                    }
                }
            }
        });
        this.transformForLevelsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((BuildCagesFromContours)BuildCagesFromContours.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    BuildCagesFromContours.this.updateOverlay(exp);
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((BuildCagesFromContours)BuildCagesFromContours.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    try {
                        BuildCagesFromContours.this.deletePointsIncluded(exp);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    public void updateOverlay(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData == null) {
            return;
        }
        if (this.overlayThreshold == null) {
            this.overlayThreshold = new OverlayThreshold(seqCamData);
            seqCamData.seq.addOverlay((Overlay)this.overlayThreshold);
        } else {
            seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold);
            this.overlayThreshold.setSequence(seqCamData);
            seqCamData.seq.addOverlay((Overlay)this.overlayThreshold);
        }
        exp.cages.detect_threshold = (Integer)this.thresholdSpinner.getValue();
        this.overlayThreshold.setThresholdTransform(exp.cages.detect_threshold, (ImageTransformEnums)((Object)this.transformForLevelsComboBox.getSelectedItem()), false);
        seqCamData.seq.overlayChanged((Overlay)this.overlayThreshold);
        seqCamData.seq.dataChanged();
    }

    public void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.seq != null) {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Experiment exp;
        if (e.getSource() == this.thresholdSpinner) {
            Experiment exp2 = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp2 != null) {
                this.updateOverlay(exp2);
            }
        } else if (e.getSource() == this.overlayCheckBox && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            if (this.overlayCheckBox.isSelected()) {
                if (this.overlayThreshold == null) {
                    this.overlayThreshold = new OverlayThreshold(exp.seqCamData);
                }
                exp.seqCamData.seq.addOverlay((Overlay)this.overlayThreshold);
                this.updateOverlay(exp);
            } else {
                this.removeOverlay(exp);
            }
        }
    }

    private void createROIsFromSelectedPolygon(Experiment exp) {
        ROI2DUtilities.removeRoisContainingString(-1, "cage", exp.seqCamData.seq);
        exp.cages.clearCageList();
        int t = exp.seqCamData.currentFrame;
        IcyBufferedImage img0 = IcyBufferedImageUtil.convertToType((IcyBufferedImage)this.overlayThreshold.getTransformedImage(t), (DataType)DataType.INT, (boolean)false);
        Rectangle rectGrid = new Rectangle(0, 0, img0.getSizeX(), img0.getSizeY());
        if (this.userPolygon != null) {
            rectGrid = this.userPolygon.getBounds();
            exp.seqCamData.seq.removeROI((ROI)this.userPolygon);
        }
        IcyBufferedImage subImg0 = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)img0, (Rectangle)rectGrid);
        Blobs blobs = new Blobs(subImg0);
        blobs.getPixelsConnected();
        blobs.getBlobsConnected();
        blobs.fillBlanksPixelsWithinBlobs();
        ArrayList<Integer> blobsfound = new ArrayList<Integer>();
        for (Capillary cap : exp.capillaries.capillariesList) {
            Point2D pt = cap.getCapillaryROILowestPoint();
            if (pt == null) continue;
            int ix = (int)(pt.getX() - (double)rectGrid.x);
            int iy = (int)(pt.getY() - (double)rectGrid.y);
            int blobi = blobs.getBlobAt(ix, iy);
            boolean found = false;
            Iterator iterator = blobsfound.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i != blobi) continue;
                found = true;
                break;
            }
            if (found) continue;
            blobsfound.add(blobi);
            ROI2DPolygon roiP = new ROI2DPolygon(blobs.getBlobPolygon2D(blobi));
            roiP.translate((double)rectGrid.x, (double)rectGrid.y);
            int cagenb = cap.getCageIndexFromRoiName();
            roiP.setName("cage" + String.format("%03d", cagenb));
            roiP.setColor(Color.MAGENTA);
            cap.capCageID = cagenb;
            exp.seqCamData.seq.addROI((ROI)roiP);
        }
    }

    void deletePointsIncluded(Experiment exp) throws InterruptedException {
        SequenceCamData seqCamData = exp.seqCamData;
        ROI2D roiSnip = seqCamData.seq.getSelectedROI2D();
        if (roiSnip == null) {
            return;
        }
        List<ROI2D> roiList = ROI2DUtilities.getROIs2DContainingString("cage", seqCamData.seq);
        for (ROI2D cageRoi : roiList) {
            Polygon2D oldPolygon;
            if (!roiSnip.intersects((ROI)cageRoi) || !(cageRoi instanceof ROI2DPolygon) || (oldPolygon = ((ROI2DPolygon)cageRoi).getPolygon2D()) == null) continue;
            Polygon2D newPolygon = new Polygon2D();
            for (int i = 0; i < oldPolygon.npoints; ++i) {
                if (roiSnip.contains(oldPolygon.xpoints[i], oldPolygon.ypoints[i])) continue;
                newPolygon.addPoint(oldPolygon.xpoints[i], oldPolygon.ypoints[i]);
            }
            ((ROI2DPolygon)cageRoi).setPolygon2D(newPolygon);
        }
    }

    private void create2DPolygon(Experiment exp) {
        String dummyname = "perimeter_enclosing";
        if (this.userPolygon == null) {
            ArrayList listRois = exp.seqCamData.seq.getROI2Ds();
            for (ROI2D roi : listRois) {
                if (!roi.getName().equals("perimeter_enclosing")) continue;
                return;
            }
            Rectangle rect = exp.seqCamData.seq.getBounds2D();
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            int rectleft = rect.x + rect.width / 6;
            int rectright = rect.x + rect.width * 5 / 6;
            int recttop = rect.y + rect.height * 2 / 3;
            if (exp.capillaries.capillariesList.size() > 0) {
                Rectangle bound0 = exp.capillaries.capillariesList.get(0).getRoi().getBounds();
                int last = exp.capillaries.capillariesList.size() - 1;
                Rectangle bound1 = exp.capillaries.capillariesList.get(last).getRoi().getBounds();
                rectleft = bound0.x;
                rectright = bound1.x + bound1.width;
                int diff = (rectright - rectleft) * 2 / 60;
                rectleft -= diff;
                rectright += diff;
                recttop = bound0.y + bound0.height - bound0.height / 8;
            }
            points.add(new Point2D.Double(rectleft, recttop));
            points.add(new Point2D.Double(rectright, recttop));
            points.add(new Point2D.Double(rectright, rect.y + rect.height - 4));
            points.add(new Point2D.Double(rectleft, rect.y + rect.height - 4));
            this.userPolygon = new ROI2DPolygon(points);
            this.userPolygon.setName("perimeter_enclosing");
        }
        exp.seqCamData.seq.addROI((ROI)this.userPolygon);
        exp.seqCamData.seq.setSelectedROI((ROI)this.userPolygon);
    }
}

