/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.cages;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.FontUtil;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;

public class LoadSaveCage
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private JButton openCageButton = new JButton("Load...");
    private JButton saveCageButton = new JButton("Save...");
    private MultiCAFE parent0 = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        JLabel loadsaveText = new JLabel("-> File (xml) ", 4);
        loadsaveText.setFont(FontUtil.setStyle((Font)loadsaveText.getFont(), (int)2));
        panel1.add(loadsaveText);
        panel1.add(this.openCageButton);
        panel1.add(this.saveCageButton);
        panel1.validate();
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.openCageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveCage)LoadSaveCage.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveCage.this.loadCage(exp);
                    LoadSaveCage.this.firePropertyChange("LOAD_DATA", false, true);
                    ((LoadSaveCage)LoadSaveCage.this).parent0.paneCages.tabsPane.setSelectedIndex(3);
                }
            }
        });
        this.saveCageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveCage)LoadSaveCage.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveCage.this.saveCageAndMeasures(exp);
                    ((LoadSaveCage)LoadSaveCage.this).parent0.paneCages.tabsPane.setSelectedIndex(3);
                }
            }
        });
    }

    public boolean loadCage(Experiment exp) {
        if (exp == null) {
            return false;
        }
        ProgressFrame progress = new ProgressFrame("load fly positions");
        boolean flag = exp.loadCageMeasures();
        if (flag) {
            exp.updateROIsAt(0);
        }
        progress.close();
        return flag;
    }

    public void saveCageAndMeasures(Experiment exp) {
        if (exp != null) {
            exp.cages.cagesFromROIs(exp.seqCamData);
            exp.saveCageMeasures();
        }
    }
}

