/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.capillaries;

import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceCamData;
import plugins.fmp.multicafe.experiment.SequenceKymosUtils;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class CreateForCapillaries
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private JButton displayFrameButton = new JButton("(1) Display frame");
    private JButton generateCapillariesButton = new JButton("(2) Generate capillaries from edited frame");
    private JComboBox<String> cellsJCombo = new JComboBox<String>(new String[]{"10", "4+(2)", "1+(2)"});
    private JSpinner nbFliesPerCellJSpinner = new JSpinner(new SpinnerNumberModel(1, 0, 500, 1));
    private JLabel widthLabel = new JLabel("with a ratio of");
    private JSpinner nCapillariesPerCell = new JSpinner(new SpinnerNumberModel(2, 1, 500, 1));
    private JSpinner width_between_capillariesJSpinner = new JSpinner(new SpinnerNumberModel(30, 0, 10000, 1));
    private JLabel width_between_capillariesLabel = new JLabel("pixels btw. caps to");
    private JSpinner width_intervalJSpinner = new JSpinner(new SpinnerNumberModel(53, 0, 10000, 1));
    private JLabel width_intervalLabel = new JLabel("pixels btw. cells");
    private String[] flyString = new String[]{"fly", "flies"};
    private String[] capString = new String[]{"cap &", "caps &"};
    private JLabel flyLabel = new JLabel(this.flyString[0]);
    private JLabel capLabel = new JLabel(this.capString[1]);
    private ROI2DPolygon capillariesRoiPolygon = null;
    private MultiCAFE parent0 = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0 = new JPanel(flowLayout);
        panel0.add(this.displayFrameButton);
        panel0.add(this.generateCapillariesButton);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(new JLabel("Grouped as"));
        panel1.add(this.cellsJCombo);
        this.cellsJCombo.setPreferredSize(new Dimension(60, 20));
        panel1.add(new JLabel("cells each with"));
        panel1.add(this.nCapillariesPerCell);
        this.nCapillariesPerCell.setPreferredSize(new Dimension(40, 20));
        panel1.add(this.capLabel);
        panel1.add(this.nbFliesPerCellJSpinner);
        this.nbFliesPerCellJSpinner.setPreferredSize(new Dimension(40, 20));
        panel1.add(this.flyLabel);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.widthLabel);
        panel2.add(this.width_between_capillariesJSpinner);
        this.width_between_capillariesJSpinner.setPreferredSize(new Dimension(40, 20));
        panel2.add(this.width_between_capillariesLabel);
        panel2.add(this.width_intervalJSpinner);
        this.width_intervalJSpinner.setPreferredSize(new Dimension(40, 20));
        panel2.add(this.width_intervalLabel);
        this.add(panel0);
        this.add(panel1);
        this.add(panel2);
        this.defineDlgItemsListeners();
        this.parent0 = parent0;
    }

    private void defineDlgItemsListeners() {
        this.displayFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((CreateForCapillaries)CreateForCapillaries.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                if (exp.capillaries != null && exp.capillaries.capillariesList.size() > 0) {
                    Polygon2D extPolygon = exp.capillaries.get2DPolygonEnclosingCapillaries();
                    if (extPolygon == null) {
                        extPolygon = CreateForCapillaries.this.getCapillariesPolygon(exp.seqCamData.seq);
                    }
                    CreateForCapillaries.this.capillariesRoiPolygon = new ROI2DPolygon(extPolygon);
                    exp.capillaries.deleteAllCapillaries();
                    exp.capillaries.updateCapillariesFromSequence(exp.seqCamData.seq);
                    exp.seqCamData.seq.removeAllROI();
                    String dummyname = "perimeter_enclosing_capillaries";
                    CreateForCapillaries.this.capillariesRoiPolygon.setName("perimeter_enclosing_capillaries");
                    exp.seqCamData.seq.addROI((ROI)CreateForCapillaries.this.capillariesRoiPolygon);
                    exp.seqCamData.seq.setSelectedROI((ROI)CreateForCapillaries.this.capillariesRoiPolygon);
                } else {
                    CreateForCapillaries.this.create_capillariesRoiPolygon(exp);
                }
            }
        });
        this.generateCapillariesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateForCapillaries.this.roisGenerateFromPolygon();
                Experiment exp = (Experiment)((CreateForCapillaries)CreateForCapillaries.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SequenceKymosUtils.transferCamDataROIStoKymo(exp);
                    int nbFliesPerCage = (Integer)CreateForCapillaries.this.nbFliesPerCellJSpinner.getValue();
                    switch (CreateForCapillaries.this.cellsJCombo.getSelectedIndex()) {
                        case 0: {
                            exp.capillaries.initCapillariesWith10Cages(nbFliesPerCage, true);
                            break;
                        }
                        case 1: {
                            exp.capillaries.initCapillariesWith6Cages(nbFliesPerCage);
                            break;
                        }
                    }
                    CreateForCapillaries.this.firePropertyChange("CAPILLARIES_NEW", false, true);
                }
            }
        });
        this.nCapillariesPerCell.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean status = (Integer)CreateForCapillaries.this.nCapillariesPerCell.getValue() == 2;
                CreateForCapillaries.this.EnableBinWidthItems(status);
                int i = (Integer)CreateForCapillaries.this.nCapillariesPerCell.getValue() > 1 ? 1 : 0;
                CreateForCapillaries.this.capLabel.setText(CreateForCapillaries.this.capString[i]);
                CreateForCapillaries.this.nCapillariesPerCell.requestFocus();
            }
        });
        this.nbFliesPerCellJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int i = (Integer)CreateForCapillaries.this.nbFliesPerCellJSpinner.getValue() > 1 ? 1 : 0;
                CreateForCapillaries.this.flyLabel.setText(CreateForCapillaries.this.flyString[i]);
                CreateForCapillaries.this.nbFliesPerCellJSpinner.requestFocus();
            }
        });
    }

    private void EnableBinWidthItems(boolean status) {
        this.widthLabel.setVisible(status);
        this.width_between_capillariesJSpinner.setVisible(status);
        this.width_between_capillariesLabel.setVisible(status);
        this.width_intervalJSpinner.setVisible(status);
        this.width_intervalLabel.setVisible(status);
    }

    private int getNbCapillaries() {
        int nCapillaries = (Integer)this.nCapillariesPerCell.getValue();
        int selectedCellsArrangement = this.cellsJCombo.getSelectedIndex();
        switch (selectedCellsArrangement) {
            case 2: {
                nCapillaries = nCapillaries * 4 + 4;
                break;
            }
            case 3: {
                break;
            }
            default: {
                nCapillaries *= 10;
            }
        }
        return nCapillaries;
    }

    private int getWidthSmallInterval() {
        return (Integer)this.width_between_capillariesJSpinner.getValue();
    }

    private int getWidthLongInterval() {
        return (Integer)this.width_intervalJSpinner.getValue();
    }

    void setGroupedBy2(boolean flag) {
        int nCapillaries = flag ? 2 : 1;
        this.nCapillariesPerCell.setValue(nCapillaries);
    }

    void setGroupingAndNumber(Capillaries cap) {
        this.setGroupedBy2(cap.capillariesDescription.grouping == 2);
    }

    int getCapillariesGrouping() {
        int nCapillaries;
        int grouping = nCapillaries = ((Integer)this.nCapillariesPerCell.getValue()).intValue();
        int selectedCellsArrangement = this.cellsJCombo.getSelectedIndex();
        if (selectedCellsArrangement == 3) {
            grouping = 1;
        }
        return grouping;
    }

    Capillaries setCapillariesGrouping(Capillaries cap) {
        cap.capillariesDescription.grouping = this.getCapillariesGrouping();
        return cap;
    }

    private void create_capillariesRoiPolygon(Experiment exp) {
        Sequence seq = exp.seqCamData.seq;
        String dummyname = "perimeter_enclosing_capillaries";
        this.capillariesRoiPolygon = (ROI2DPolygon)this.isRoiPresent(seq, "perimeter_enclosing_capillaries");
        if (this.capillariesRoiPolygon == null) {
            this.capillariesRoiPolygon = new ROI2DPolygon(this.getCapillariesPolygon(seq));
            this.capillariesRoiPolygon.setName("perimeter_enclosing_capillaries");
            seq.addROI((ROI)this.capillariesRoiPolygon);
        }
        seq.setSelectedROI((ROI)this.capillariesRoiPolygon);
    }

    private ROI2D isRoiPresent(Sequence seq, String dummyname) {
        ArrayList listRois = seq.getROI2Ds();
        for (ROI2D roi : listRois) {
            if (!roi.getName().equals(dummyname)) continue;
            return roi;
        }
        return null;
    }

    private Polygon2D getCapillariesPolygon(Sequence seq) {
        Rectangle rect = seq.getBounds2D();
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        points.add(new Point2D.Double(rect.x + rect.width / 5, rect.y + rect.height / 5));
        points.add(new Point2D.Double(rect.x + rect.width * 4 / 5, rect.y + rect.height / 5));
        points.add(new Point2D.Double(rect.x + rect.width * 4 / 5, rect.y + rect.height * 2 / 3));
        points.add(new Point2D.Double(rect.x + rect.width / 5, rect.y + rect.height * 2 / 3));
        return new Polygon2D(points);
    }

    private void roisGenerateFromPolygon() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        SequenceCamData seqCamData = exp.seqCamData;
        boolean statusGroup2Mode = this.getCapillariesGrouping() == 2;
        int nbcapillaries = 20;
        int width_between_capillaries = 1;
        int width_interval = 0;
        try {
            nbcapillaries = this.getNbCapillaries();
            if (statusGroup2Mode) {
                width_between_capillaries = this.getWidthSmallInterval();
                width_interval = this.getWidthLongInterval();
            }
        }
        catch (Exception e) {
            new AnnounceFrame("Can't interpret one of the ROI parameters value");
        }
        Polygon2D capillariesPolygon = ROI2DUtilities.orderVerticesofPolygon(this.capillariesRoiPolygon.getPolygon());
        seqCamData.seq.removeROI((ROI)this.capillariesRoiPolygon);
        if (statusGroup2Mode) {
            double span = nbcapillaries / 2 * (width_between_capillaries + width_interval) - width_interval;
            for (int i = 0; i < nbcapillaries; i += 2) {
                double span0 = (width_between_capillaries + width_interval) * i / 2;
                this.addROILine(seqCamData, "line" + i / 2 + "L", capillariesPolygon, span0, span);
                this.addROILine(seqCamData, "line" + i / 2 + "R", capillariesPolygon, span0 += (double)width_between_capillaries, span);
            }
        } else {
            double span = nbcapillaries - 1;
            for (int i = 0; i < nbcapillaries; ++i) {
                double span0 = width_between_capillaries * i;
                this.addROILine(seqCamData, "line" + i, capillariesPolygon, span0, span);
            }
        }
    }

    private void addROILine(SequenceCamData seqCamData, String name, Polygon2D roiPolygon, double span0, double span) {
        double x0 = roiPolygon.xpoints[0] + (roiPolygon.xpoints[3] - roiPolygon.xpoints[0]) * span0 / span;
        double y0 = roiPolygon.ypoints[0] + (roiPolygon.ypoints[3] - roiPolygon.ypoints[0]) * span0 / span;
        if (x0 < 0.0) {
            x0 = 0.0;
        }
        if (y0 < 0.0) {
            y0 = 0.0;
        }
        double x1 = roiPolygon.xpoints[1] + (roiPolygon.xpoints[2] - roiPolygon.xpoints[1]) * span0 / span;
        double y1 = roiPolygon.ypoints[1] + (roiPolygon.ypoints[2] - roiPolygon.ypoints[1]) * span0 / span;
        ROI2DLine roiL1 = new ROI2DLine(x0, y0, x1, y1);
        roiL1.setName(name);
        roiL1.setReadOnly(false);
        seqCamData.seq.addROI((ROI)roiL1, true);
    }
}

