/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.experiment;

import icy.canvas.Canvas2D;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.tools.JComponents.SortedComboBoxModel;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSColumnHeader;

public class Infos
extends JPanel {
    private static final long serialVersionUID = 2190848825783418962L;
    private JComboBox<String> stim1Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> stim2Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> boxIDCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> exptCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> strainCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> sexCombo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> conc1Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JComboBox<String> conc2Combo = new JComboBox<String>(new SortedComboBoxModel());
    private JLabel experimentLabel = new JLabel(EnumXLSColumnHeader.EXP_EXPT.toString());
    private JLabel boxIDLabel = new JLabel(EnumXLSColumnHeader.EXP_BOXID.toString());
    private JLabel stim1Label = new JLabel(EnumXLSColumnHeader.EXP_STIM.toString());
    private JLabel conc1Label = new JLabel(EnumXLSColumnHeader.EXP_CONC.toString());
    private JLabel strainLabel = new JLabel(EnumXLSColumnHeader.EXP_STRAIN.toString());
    private JLabel sexLabel = new JLabel(EnumXLSColumnHeader.EXP_SEX.toString());
    private JLabel stim2Label = new JLabel(EnumXLSColumnHeader.EXP_COND1.toString());
    private JLabel conc2Label = new JLabel(EnumXLSColumnHeader.EXP_COND2.toString());
    private JButton openButton = new JButton("Load...");
    private JButton saveButton = new JButton("Save...");
    private JButton duplicateButton = new JButton("Get previous");
    private JButton zoomButton = new JButton("zoom top");
    private MultiCAFE parent0 = null;
    public boolean disableChangeFile = false;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.parent0 = parent0;
        GridBagLayout layoutThis = new GridBagLayout();
        this.setLayout(layoutThis);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 256;
        c.ipadx = 0;
        c.ipady = 0;
        c.insets = new Insets(1, 2, 1, 2);
        c.gridy = 0;
        this.addLineOfElements(c, this.experimentLabel, this.exptCombo, this.boxIDLabel, this.boxIDCombo, this.openButton);
        c.gridy = 1;
        this.addLineOfElements(c, this.strainLabel, this.strainCombo, this.sexLabel, this.sexCombo, this.saveButton);
        c.gridy = 2;
        this.addLineOfElements(c, this.stim1Label, this.stim1Combo, this.conc1Label, this.stim2Combo, this.duplicateButton);
        c.gridy = 3;
        this.addLineOfElements(c, this.stim2Label, this.conc1Combo, this.conc2Label, this.conc2Combo, this.zoomButton);
        this.zoomButton.setEnabled(false);
        this.boxIDCombo.setEditable(true);
        this.exptCombo.setEditable(true);
        this.stim1Combo.setEditable(true);
        this.stim2Combo.setEditable(true);
        this.strainCombo.setEditable(true);
        this.sexCombo.setEditable(true);
        this.conc1Combo.setEditable(true);
        this.conc2Combo.setEditable(true);
        this.defineActionListeners();
    }

    void addLineOfElements(GridBagConstraints c, JComponent element1, JComponent element2, JComponent element3, JComponent element4, JComponent element5) {
        c.gridx = 0;
        int delta1 = 1;
        int delta2 = 3;
        if (element1 != null) {
            this.add((Component)element1, c);
        }
        c.gridx += delta1;
        if (element2 != null) {
            this.add((Component)element2, c);
        }
        c.gridx += delta2;
        if (element3 != null) {
            this.add((Component)element3, c);
        }
        c.gridx += delta1;
        if (element4 != null) {
            this.add((Component)element4, c);
        }
        c.gridx += delta2;
        if (element5 != null) {
            this.add((Component)element5, c);
        }
    }

    private void defineActionListeners() {
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.xmlLoad_MCExperiment();
                    Infos.this.transferPreviousExperimentInfosToDialog(exp, exp);
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Infos.this.getExperimentInfosFromDialog(exp);
                    exp.xmlSave_MCExperiment();
                }
            }
        });
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos.this.duplicatePreviousDescriptors();
            }
        });
        this.zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Infos.this.zoomToUpperCorner(exp);
                }
            }
        });
    }

    public void transferPreviousExperimentInfosToDialog(Experiment exp_source, Experiment exp_destination) {
        this.setInfoCombo(exp_destination, exp_source, this.boxIDCombo, EnumXLSColumnHeader.EXP_BOXID);
        this.setInfoCombo(exp_destination, exp_source, this.exptCombo, EnumXLSColumnHeader.EXP_EXPT);
        this.setInfoCombo(exp_destination, exp_source, this.stim1Combo, EnumXLSColumnHeader.EXP_STIM);
        this.setInfoCombo(exp_destination, exp_source, this.stim2Combo, EnumXLSColumnHeader.EXP_CONC);
        this.setInfoCombo(exp_destination, exp_source, this.strainCombo, EnumXLSColumnHeader.EXP_STRAIN);
        this.setInfoCombo(exp_destination, exp_source, this.sexCombo, EnumXLSColumnHeader.EXP_SEX);
        this.setInfoCombo(exp_destination, exp_source, this.conc1Combo, EnumXLSColumnHeader.EXP_COND1);
        this.setInfoCombo(exp_destination, exp_source, this.conc2Combo, EnumXLSColumnHeader.EXP_COND2);
    }

    private void setInfoCombo(Experiment exp_dest, Experiment exp_source, JComboBox<String> combo, EnumXLSColumnHeader field) {
        String altText = exp_source.getExperimentField(field);
        String text = exp_dest.getExperimentField(field);
        if (text.equals("..")) {
            exp_dest.setExperimentFieldNoTest(field, altText);
        }
        text = exp_dest.getExperimentField(field);
        this.addItemToComboIfNew(text, combo);
        combo.setSelectedItem(text);
    }

    public void getExperimentInfosFromDialog(Experiment exp) {
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_BOXID, (String)this.boxIDCombo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_EXPT, (String)this.exptCombo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STIM, (String)this.stim1Combo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_CONC, (String)this.stim2Combo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_STRAIN, (String)this.strainCombo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_SEX, (String)this.sexCombo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_COND1, (String)this.conc1Combo.getSelectedItem());
        exp.setExperimentFieldNoTest(EnumXLSColumnHeader.EXP_COND2, (String)this.conc2Combo.getSelectedItem());
    }

    private void addItemToComboIfNew(String toAdd, JComboBox<String> combo) {
        if (toAdd == null) {
            return;
        }
        SortedComboBoxModel model = (SortedComboBoxModel)combo.getModel();
        if (model.getIndexOf(toAdd) == -1) {
            model.addElement(toAdd);
        }
    }

    public void initInfosCombos() {
        this.parent0.expListCombo.getFieldValuesToCombo(this.exptCombo, EnumXLSColumnHeader.EXP_EXPT);
        this.parent0.expListCombo.getFieldValuesToCombo(this.stim1Combo, EnumXLSColumnHeader.EXP_STIM);
        this.parent0.expListCombo.getFieldValuesToCombo(this.stim2Combo, EnumXLSColumnHeader.EXP_CONC);
        this.parent0.expListCombo.getFieldValuesToCombo(this.boxIDCombo, EnumXLSColumnHeader.EXP_BOXID);
        this.parent0.expListCombo.getFieldValuesToCombo(this.strainCombo, EnumXLSColumnHeader.EXP_STRAIN);
        this.parent0.expListCombo.getFieldValuesToCombo(this.sexCombo, EnumXLSColumnHeader.EXP_SEX);
        this.parent0.expListCombo.getFieldValuesToCombo(this.conc1Combo, EnumXLSColumnHeader.EXP_COND1);
        this.parent0.expListCombo.getFieldValuesToCombo(this.conc2Combo, EnumXLSColumnHeader.EXP_COND2);
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.transferPreviousExperimentInfosToDialog(exp, exp);
        }
    }

    public void clearCombos() {
        this.exptCombo.removeAllItems();
        this.stim1Combo.removeAllItems();
        this.stim2Combo.removeAllItems();
        this.boxIDCombo.removeAllItems();
        this.strainCombo.removeAllItems();
        this.sexCombo.removeAllItems();
        this.conc1Combo.removeAllItems();
        this.conc2Combo.removeAllItems();
    }

    void duplicatePreviousDescriptors() {
        int iprevious = this.parent0.expListCombo.getSelectedIndex() - 1;
        if (iprevious < 0) {
            return;
        }
        Experiment exp0 = (Experiment)this.parent0.expListCombo.getItemAt(iprevious);
        Experiment exp = (Experiment)this.parent0.expListCombo.getItemAt(iprevious + 1);
        this.transferPreviousExperimentInfosToDialog(exp0, exp);
        this.parent0.paneCapillaries.transferPreviousExperimentCapillariesInfos(exp0, exp);
    }

    void zoomToUpperCorner(Experiment exp) {
        Sequence seq = exp.seqCamData.seq;
        Viewer v = seq.getFirstViewer();
        if (v != null) {
            Canvas2D canvas = (Canvas2D)v.getCanvas();
            canvas.setScale(2.0, 2.0, true);
            canvas.setOffset(0, 0, true);
        }
    }
}

