/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.collection.array.Array1DUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceKymos;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.experiment.capillaries.CapillaryMeasure;
import plugins.fmp.multicafe.series.BuildSeries;
import plugins.fmp.multicafe.tools.Level2D;

public class DetectGulps
extends BuildSeries {
    @Override
    void analyzeExperiment(Experiment exp) {
        if (this.loadExperimentDataToDetectGulps(exp)) {
            this.buildFilteredImage(exp);
            this.detectGulpsFromExperiment(exp);
        }
        exp.seqKymos.closeSequence();
    }

    private boolean loadExperimentDataToDetectGulps(Experiment exp) {
        exp.xmlLoad_MCExperiment();
        boolean flag = exp.loadMCCapillaries_Only();
        flag &= exp.loadKymographs();
        return flag &= exp.loadCapillaries();
    }

    private void buildFilteredImage(Experiment exp) {
        if (exp.seqKymos == null) {
            return;
        }
        int zChannelDestination = 2;
        exp.kymosBuildFiltered01(0, zChannelDestination, this.options.transformForGulps, this.options.spanDiff);
    }

    public void detectGulpsFromExperiment(Experiment exp) {
        SequenceKymos seqCapillariesKymographs = exp.seqKymos;
        final int jitter = 5;
        int firstCapillary = 0;
        int lastCapillary = seqCapillariesKymographs.seq.getSizeT() - 1;
        if (!this.options.detectAllGulps) {
            lastCapillary = firstCapillary = this.options.kymoFirst;
        }
        seqCapillariesKymographs.seq.beginUpdate();
        this.threadRunning = true;
        this.stopFlag = false;
        ProgressFrame progressBar = new ProgressFrame("Processing with subthreads started");
        int nframes = lastCapillary - firstCapillary + 1;
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("detect_levels");
        processor.setPriority(5);
        ArrayList futures = new ArrayList(nframes);
        futures.clear();
        final Sequence seqAnalyzed = seqCapillariesKymographs.seq;
        for (int indexCapillary = firstCapillary; indexCapillary <= lastCapillary; ++indexCapillary) {
            final Capillary capi = exp.capillaries.capillariesList.get(indexCapillary);
            capi.setGulpsOptions(this.options);
            futures.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    if (DetectGulps.this.options.buildDerivative) {
                        capi.ptsDerivative = new CapillaryMeasure(capi.getLast2ofCapillaryName() + "_derivative", capi.kymographIndex, DetectGulps.this.getDerivativeProfile(seqAnalyzed, capi, jitter));
                    }
                    if (DetectGulps.this.options.buildGulps) {
                        capi.initGulps();
                        capi.detectGulps();
                    }
                }
            }));
        }
        this.waitFuturesCompletion(processor, futures, progressBar);
        exp.saveCapillaries();
        processor.shutdown();
        seqCapillariesKymographs.seq.endUpdate();
        progressBar.close();
    }

    private List<Point2D> getDerivativeProfile(Sequence seq, Capillary cap, int jitter) {
        Level2D polyline = cap.ptsTop.polylineLevel;
        if (polyline == null) {
            return null;
        }
        int z = seq.getSizeZ() - 1;
        int c = 0;
        IcyBufferedImage image = seq.getImage(cap.kymographIndex, z, c);
        ArrayList<Point2D> listOfMaxPoints = new ArrayList<Point2D>();
        int[] kymoImageValues = Array1DUtil.arrayToIntArray((Object)image.getDataXY(c), (boolean)image.isSignedDataType());
        int xwidth = image.getSizeX();
        int yheight = image.getSizeY();
        for (int ix = 1; ix < polyline.npoints; ++ix) {
            int low = (int)polyline.ypoints[ix] - jitter;
            int high = low + 2 * jitter;
            if (low < 0) {
                low = 0;
            }
            if (high >= yheight) {
                high = yheight - 1;
            }
            int max = kymoImageValues[ix + low * xwidth];
            for (int iy = low + 1; iy < high; ++iy) {
                int val = kymoImageValues[ix + iy * xwidth];
                if (max >= val) continue;
                max = val;
            }
            listOfMaxPoints.add(new Point2D.Double(ix, max));
        }
        return listOfMaxPoints;
    }
}

