/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools.Overlay;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.colormap.IcyColorMap;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import plugins.fmp.multicafe.experiment.SequenceCamData;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformInterface;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;
import plugins.fmp.multicafe.tools.Overlay.OverlayColorMask;

public class OverlayThreshold
extends Overlay
implements SequenceListener {
    private float opacity = 0.3f;
    private OverlayColorMask map = new OverlayColorMask("overlaymask", new Color(0xFF0000, true));
    private ImageTransformOptions imageTransformOptions = new ImageTransformOptions();
    private ImageTransformInterface imageTransformFunction = ImageTransformEnums.NONE.getFunction();
    private ImageTransformInterface imageThresholdFunction = ImageTransformEnums.NONE.getFunction();
    private Sequence localSeq = null;

    public OverlayThreshold() {
        super("ThresholdOverlay");
    }

    public OverlayThreshold(SequenceCamData seqCamData) {
        super("ThresholdOverlay");
        this.setSequence(seqCamData);
    }

    public void setSequence(SequenceCamData seqCamData) {
        this.localSeq = seqCamData.seq;
        this.localSeq.addListener((SequenceListener)this);
        this.imageTransformOptions.seqCamData = seqCamData;
    }

    public void setThresholdSingle(int threshold, ImageTransformEnums transformop, boolean ifGreater) {
        this.setThresholdTransform(threshold, transformop, ifGreater);
    }

    public void setThresholdTransform(int threshold, ImageTransformEnums transformop, boolean ifGreater) {
        this.imageTransformOptions.setSingleThreshold(threshold, ifGreater);
        this.imageTransformOptions.transformOption = transformop;
        this.imageTransformFunction = transformop.getFunction();
        this.imageThresholdFunction = ImageTransformEnums.THRESHOLD_SINGLE.getFunction();
    }

    public void setReferenceImage(IcyBufferedImage referenceImage) {
        this.imageTransformOptions.backgroundImage = referenceImage;
    }

    public void setThresholdColor(ArrayList<Color> colorarray, int distancetype, int threshold) {
        this.imageTransformOptions.setColorArrayThreshold(distancetype, threshold, colorarray);
        this.imageTransformFunction = ImageTransformEnums.NONE.getFunction();
        this.imageThresholdFunction = ImageTransformEnums.THRESHOLD_COLORS.getFunction();
    }

    public IcyBufferedImage getTransformedImage(int t) {
        IcyBufferedImage img = this.localSeq.getImage(t, 0);
        IcyBufferedImage img2 = this.imageTransformFunction.getTransformedImage(img, this.imageTransformOptions);
        return this.imageThresholdFunction.getTransformedImage(img2, this.imageTransformOptions);
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        int posT;
        IcyBufferedImage thresholdedImage;
        if (canvas instanceof IcyCanvas2D && g != null && (thresholdedImage = this.getTransformedImage(posT = canvas.getPositionT())) != null) {
            thresholdedImage.setColorMap(0, (IcyColorMap)this.map);
            try {
                BufferedImage bufferedImage = IcyBufferedImageUtil.getARGBImage((IcyBufferedImage)thresholdedImage);
                Composite bck = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, this.opacity));
                g.drawImage((Image)bufferedImage, 0, 0, null);
                g.setComposite(bck);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        if (sequenceEvent.getSourceType() != SequenceEvent.SequenceEventSourceType.SEQUENCE_OVERLAY) {
            return;
        }
        if (sequenceEvent.getSource() == this && sequenceEvent.getType() == SequenceEvent.SequenceEventType.REMOVED) {
            sequenceEvent.getSequence().removeListener((SequenceListener)this);
            this.remove();
        }
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
        this.remove();
    }
}

