/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.viewer1D.plugins.adufour.viewers;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginCanvas;
import icy.sequence.DimensionId;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class LogCanvas2D
extends Plugin
implements PluginCanvas {
    private static final ExecutorService service = new Processor(SystemUtil.getNumberOfCPUs());

    public String getCanvasClassName() {
        return LogCanvas2D.class.getName();
    }

    public IcyCanvas createCanvas(Viewer viewer) {
        return new Canvas2D(viewer){
            private static final long serialVersionUID = 1L;
            private IcyBufferedImage logImage;
            {
                this.logImage = this.createLogImage(this.getImage(this.getPositionT(), this.getPositionZ(), this.getPositionC()));
            }

            public IcyBufferedImage getImage(int t, int z, int c) {
                if (this.logImage == null) {
                    this.logImage = this.createLogImage(super.getImage(t, z, c));
                }
                return this.logImage;
            }

            protected void positionChanged(DimensionId dim) {
                if (dim == DimensionId.T || dim == DimensionId.Z) {
                    this.logImage = this.createLogImage(super.getImage(this.getPositionT(), this.getPositionZ(), this.getPositionC()));
                }
                super.positionChanged(dim);
            }

            private IcyBufferedImage createLogImage(IcyBufferedImage image) {
                if (image == null) {
                    return null;
                }
                final IcyBufferedImage logImage = image.getDataType_() == DataType.DOUBLE ? IcyBufferedImageUtil.getCopy((IcyBufferedImage)image) : IcyBufferedImageUtil.convertToType((IcyBufferedImage)image, (DataType)DataType.DOUBLE, (boolean)false);
                final double[][] data_C_XY = logImage.getDataXYCAsDouble();
                Future[] tasks = new Future[data_C_XY.length];
                int i = 0;
                while (i < data_C_XY.length) {
                    final int channel = i++;
                    tasks[channel] = service.submit(new Runnable(){

                        @Override
                        public void run() {
                            logImage.updateChannelsBounds();
                            double max = logImage.getChannelMax(channel);
                            double ratio = max / Math.log1p(max);
                            double[] array = data_C_XY[channel];
                            for (int i = 0; i < array.length; ++i) {
                                array[i] = Math.log1p(array[i]) * ratio;
                            }
                        }
                    });
                }
                try {
                    for (Future task : tasks) {
                        task.get();
                    }
                    return logImage;
                }
                catch (Exception e) {
                    return image;
                }
            }
        };
    }

    protected void finalize() throws Throwable {
    }
}

