/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.capillaries;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.dlg.capillaries.InfosCapillaryTable;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;

public class Infos
extends JPanel {
    private static final long serialVersionUID = 4950182090521600937L;
    private JSpinner capillaryVolumeSpinner = new JSpinner(new SpinnerNumberModel(5.0, 0.0, 100.0, 1.0));
    private JSpinner capillaryPixelsSpinner = new JSpinner(new SpinnerNumberModel(5, 0, 1000, 1));
    private JButton getCapillaryLengthButton = new JButton("pixels 1rst capillary");
    private JButton editCapillariesButton = new JButton("Edit capillaries infos...");
    private MultiCAFE parent0 = null;
    private InfosCapillaryTable infosCapillaryTable = null;
    private List<Capillary> capillariesArrayCopy = new ArrayList<Capillary>();

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        JPanel panel0 = new JPanel(new FlowLayout(0, 3, 1));
        panel0.add(new JLabel("volume (\u00b5l) ", 4));
        panel0.add(this.capillaryVolumeSpinner);
        panel0.add(new JLabel("length (pixels) ", 4));
        panel0.add(this.capillaryPixelsSpinner);
        panel0.add(this.getCapillaryLengthButton);
        this.add(panel0);
        JPanel panel1 = new JPanel(new FlowLayout(0, 3, 1));
        panel1.add(this.editCapillariesButton);
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.getCapillaryLengthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double npixels = Infos.this.getLengthFirstCapillaryROI();
                Infos.this.capillaryPixelsSpinner.setValue((int)npixels);
            }
        });
        this.editCapillariesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Infos)Infos.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.capillaries.transferDescriptionToCapillaries();
                    if (Infos.this.infosCapillaryTable != null) {
                        Infos.this.infosCapillaryTable.close();
                    }
                    Infos.this.infosCapillaryTable = new InfosCapillaryTable();
                    Infos.this.infosCapillaryTable.initialize(Infos.this.parent0, Infos.this.capillariesArrayCopy);
                    Infos.this.infosCapillaryTable.requestFocus();
                }
            }
        });
    }

    public void setAllDescriptors(Capillaries cap) {
        this.capillaryVolumeSpinner.setValue(cap.capillariesDescription.volume);
        this.capillaryPixelsSpinner.setValue(cap.capillariesDescription.pixels);
    }

    void getDescriptors(Capillaries capList) {
        capList.capillariesDescription.volume = (Double)this.capillaryVolumeSpinner.getValue();
        capList.capillariesDescription.pixels = (Integer)this.capillaryPixelsSpinner.getValue();
    }

    public int getLengthFirstCapillaryROI() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        int npixels = 0;
        if (exp != null) {
            exp.capillaries.updateCapillariesFromSequence(exp.seqCamData.seq);
            if (exp.capillaries.capillariesList.size() > 0) {
                Capillary cap = exp.capillaries.capillariesList.get(0);
                npixels = cap.getCapillaryROILength();
            }
        }
        return npixels;
    }
}

