/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.levels;

import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.capillaries.Capillaries;
import plugins.fmp.multicafe.experiment.capillaries.Capillary;
import plugins.fmp.multicafe.tools.chart.ChartLevels;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;

public class ChartLevelsPanel
extends JPanel
implements SequenceListener {
    private static final long serialVersionUID = -7079184380174992501L;
    private ChartLevels plotTopAndBottom = null;
    private ChartLevels plotDelta = null;
    private ChartLevels plotDerivative = null;
    private ChartLevels plotSumgulps = null;
    private MultiCAFE parent0 = null;
    private JCheckBox limitsCheckbox = new JCheckBox("top/bottom", true);
    private JCheckBox derivativeCheckbox = new JCheckBox("derivative", false);
    private JCheckBox consumptionCheckbox = new JCheckBox("sumGulps", false);
    private JCheckBox deltaCheckbox = new JCheckBox("delta (Vt - Vt-1)", false);
    private JCheckBox correctEvaporationCheckbox = new JCheckBox("correct evaporation", false);
    private JButton displayResultsButton = new JButton("Display results");

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        this.setLayout(capLayout);
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(0);
        JPanel panel = new JPanel(layout);
        panel.add(this.limitsCheckbox);
        panel.add(this.derivativeCheckbox);
        panel.add(this.consumptionCheckbox);
        panel.add(this.deltaCheckbox);
        this.add(panel);
        JPanel panel1 = new JPanel(layout);
        panel1.add(this.correctEvaporationCheckbox);
        this.add(panel1);
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{this.displayResultsButton, new JLabel(" ")}));
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.displayResultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((ChartLevelsPanel)ChartLevelsPanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.seqKymos.validateRois();
                    exp.seqKymos.transferKymosRoisToCapillaries_Measures(exp.capillaries);
                    ChartLevelsPanel.this.displayGraphsPanels(exp);
                }
            }
        });
        this.correctEvaporationCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((ChartLevelsPanel)ChartLevelsPanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    ChartLevelsPanel.this.displayGraphsPanels(exp);
                }
            }
        });
    }

    private Rectangle getInitialUpperLeftPosition(Experiment exp) {
        Rectangle rectv = new Rectangle(50, 500, 10, 10);
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        if (v != null) {
            rectv = v.getBounds();
            rectv.translate(0, rectv.height);
        } else {
            rectv = this.parent0.mainFrame.getBounds();
            rectv.translate(rectv.width, rectv.height + 100);
        }
        return rectv;
    }

    public void displayGraphsPanels(Experiment exp) {
        Rectangle rectv = this.getInitialUpperLeftPosition(exp);
        int dx = 5;
        int dy = 10;
        exp.seqKymos.seq.addListener((SequenceListener)this);
        if (this.limitsCheckbox.isSelected() && this.isThereAnyDataToDisplay(exp, EnumXLSExport.TOPLEVEL) && this.isThereAnyDataToDisplay(exp, EnumXLSExport.BOTTOMLEVEL)) {
            this.plotTopAndBottom = this.plotToChart(exp, "top + bottom levels", EnumXLSExport.TOPLEVEL, this.plotTopAndBottom, rectv);
            rectv.translate(dx, dy);
        } else if (this.plotTopAndBottom != null) {
            this.closeChart(this.plotTopAndBottom);
        }
        if (this.deltaCheckbox.isSelected() && this.isThereAnyDataToDisplay(exp, EnumXLSExport.TOPLEVELDELTA)) {
            this.plotDelta = this.plotToChart(exp, "top delta t -(t-1)", EnumXLSExport.TOPLEVELDELTA, this.plotDelta, rectv);
            rectv.translate(dx, dy);
        } else if (this.plotDelta != null) {
            this.closeChart(this.plotDelta);
        }
        if (this.derivativeCheckbox.isSelected() && this.isThereAnyDataToDisplay(exp, EnumXLSExport.DERIVEDVALUES)) {
            this.plotDerivative = this.plotToChart(exp, "Derivative", EnumXLSExport.DERIVEDVALUES, this.plotDerivative, rectv);
            rectv.translate(dx, dy);
        } else if (this.plotDerivative != null) {
            this.closeChart(this.plotDerivative);
        }
        if (this.consumptionCheckbox.isSelected() && this.isThereAnyDataToDisplay(exp, EnumXLSExport.SUMGULPS)) {
            this.plotSumgulps = this.plotToChart(exp, "Cumulated gulps", EnumXLSExport.SUMGULPS, this.plotSumgulps, rectv);
            rectv.translate(dx, dy);
        } else if (this.plotSumgulps != null) {
            this.closeChart(this.plotSumgulps);
        }
    }

    private ChartLevels plotToChart(Experiment exp, String title, EnumXLSExport option, ChartLevels iChart, Rectangle rectv) {
        if (iChart != null) {
            iChart.mainChartFrame.dispose();
        }
        iChart = new ChartLevels();
        iChart.createChartPanel(this.parent0, title);
        iChart.setUpperLeftLocation(rectv);
        iChart.displayData(exp, option, title, this.correctEvaporationCheckbox.isSelected());
        iChart.mainChartFrame.toFront();
        iChart.mainChartFrame.requestFocus();
        return iChart;
    }

    public void closeAllCharts() {
        this.plotTopAndBottom = this.closeChart(this.plotTopAndBottom);
        this.plotDerivative = this.closeChart(this.plotDerivative);
        this.plotSumgulps = this.closeChart(this.plotSumgulps);
        this.plotDelta = this.closeChart(this.plotDelta);
    }

    private ChartLevels closeChart(ChartLevels chart) {
        if (chart != null) {
            chart.mainChartFrame.dispose();
        }
        chart = null;
        return chart;
    }

    private boolean isThereAnyDataToDisplay(Experiment exp, EnumXLSExport option) {
        Capillary cap;
        boolean flag = false;
        Capillaries capillaries = exp.capillaries;
        Iterator<Capillary> iterator = capillaries.capillariesList.iterator();
        while (iterator.hasNext() && !(flag = (cap = iterator.next()).isThereAnyMeasuresDone(option))) {
        }
        return flag;
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener((SequenceListener)this);
        this.closeAllCharts();
    }
}

