/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.levels;

import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.type.collection.array.Array1DUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.SequenceKymos;

public class Filter
extends JPanel {
    private static final long serialVersionUID = -4413321640245046423L;
    private MultiCAFE parent0;
    private JButton startButton = new JButton("Start");
    private JTextField spanText = new JTextField("10");

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("use N pixels="), this.spanText, new JLabel(" ")}));
        this.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel(" "), new JLabel(" "), this.startButton}));
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Filter)Filter.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SequenceKymos seqKymos = exp.seqKymos;
                    int span = Filter.this.getSpan();
                    int c = 1;
                    for (int t = 0; t < seqKymos.seq.getSizeT(); ++t) {
                        Filter.this.crossCorrelatePixels(seqKymos, t, span, c);
                    }
                }
            }
        });
    }

    int getSpan() {
        return Integer.valueOf(this.spanText.getText());
    }

    private void crossCorrelatePixels(SequenceKymos kymo, int span, int t, int c) {
        IcyBufferedImage image = null;
        image = kymo.seq.getImage(t, 0, c);
        double[] tabValues = Array1DUtil.arrayToDoubleArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
        int xwidth = image.getSizeX();
        int yheight = image.getSizeY();
        double[] col0 = new double[yheight];
        double[] col1 = new double[yheight];
        int npoints = 2 * span;
        int len = yheight - npoints;
        int startx = span;
        double[] correl = new double[npoints];
        int[] ishift = new int[xwidth];
        ishift[0] = 0;
        for (int iy = 0; iy < yheight; ++iy) {
            col0[iy] = tabValues[iy * xwidth];
        }
        for (int ix = 1; ix < xwidth; ++ix) {
            for (int iy = 0; iy < yheight; ++iy) {
                col1[iy] = tabValues[ix + iy * xwidth];
            }
            for (int starty = 0; starty < npoints; ++starty) {
                correl[starty] = this.correlationBetween2Arrays(col0, col1, startx, starty, len);
            }
            int imax = 0;
            double vmax = correl[0];
            for (int i = 1; i < npoints; ++i) {
                if (!(correl[i] > vmax)) continue;
                vmax = correl[i];
                imax = i;
            }
            ishift[ix] = span - imax;
        }
        this.shiftColumnsOfPixels(ishift, kymo);
    }

    private void shiftColumnsOfPixels(int[] shift, SequenceKymos kymographSeq) {
        IcyBufferedImage image0 = kymographSeq.seq.getFirstImage();
        IcyBufferedImage image1 = IcyBufferedImageUtil.getCopy((IcyBufferedImage)image0);
        int xwidth = image0.getSizeX();
        int yheight = image0.getSizeY();
        for (int chan = 0; chan < kymographSeq.seq.getSizeC(); ++chan) {
            Object dataObject0 = image0.getDataXY(chan);
            double[] dataArray0 = Array1DUtil.arrayToDoubleArray((Object)dataObject0, (boolean)image0.isSignedDataType());
            Object dataObject1 = image1.getDataXY(chan);
            double[] dataArray1 = Array1DUtil.arrayToDoubleArray((Object)dataObject1, (boolean)image1.isSignedDataType());
            for (int ix = 0; ix < xwidth; ++ix) {
                int iydest = shift[ix];
                int iy = 0;
                while (iy < yheight) {
                    if (iydest >= 0 && iydest < yheight) {
                        dataArray0[ix + iydest * xwidth] = dataArray1[ix + iy * xwidth];
                    }
                    ++iy;
                    ++iydest;
                }
            }
            Array1DUtil.doubleArrayToSafeArray((double[])dataArray0, (Object)dataObject0, (boolean)image0.isSignedDataType());
            image0.setDataXY(chan, dataObject0);
        }
    }

    private double correlationBetween2Arrays(double[] xs, double[] ys, int startx, int starty, int len) {
        double sx = 0.0;
        double sy = 0.0;
        double sxx = 0.0;
        double syy = 0.0;
        double sxy = 0.0;
        int i = 0;
        while (i < len) {
            double x = xs[startx];
            double y = ys[starty];
            sx += x;
            sy += y;
            sxx += x * x;
            syy += y * y;
            sxy += x * y;
            ++i;
            ++startx;
            ++starty;
        }
        double cov = sxy / (double)len - sx * sy / (double)len / (double)len;
        double sigmax = Math.sqrt(sxx / (double)len - sx * sx / (double)len / (double)len);
        double sigmay = Math.sqrt(syy / (double)len - sy * sy / (double)len / (double)len);
        return cov / sigmax / sigmay;
    }
}

