/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.dlg.levels;

import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import plugins.fmp.multicafe.MultiCAFE;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.tools.ImageKMeans;
import plugins.nherve.maskeditor.MaskEditor;
import plugins.nherve.toolbox.image.feature.region.SupportRegionException;
import plugins.nherve.toolbox.image.feature.signature.SignatureException;
import plugins.nherve.toolbox.image.mask.MaskException;
import plugins.nherve.toolbox.image.mask.MaskStack;
import plugins.nherve.toolbox.image.segmentation.Segmentation;
import plugins.nherve.toolbox.image.segmentation.SegmentationException;
import plugins.nherve.toolbox.image.toolboxes.ColorSpaceTools;

public class LevelsKMeans
extends JPanel {
    private static final long serialVersionUID = 6031521157029550040L;
    private JCheckBox allKymosCheckBox = new JCheckBox("all kymographs", true);
    private String detectString = "  Detect ";
    private JButton detectButton = new JButton(this.detectString);
    private JCheckBox allSeriesCheckBox = new JCheckBox("ALL (current to last)", false);
    private JCheckBox leftCheckBox = new JCheckBox("L", true);
    private JCheckBox rightCheckBox = new JCheckBox("R", true);
    private JButton displayButton = new JButton("Display");
    private JComboBox<String> cbColorSpace = new JComboBox<String>(new String[]{ColorSpaceTools.COLOR_SPACES[0], ColorSpaceTools.COLOR_SPACES[4], ColorSpaceTools.COLOR_SPACES[3]});
    private JSpinner tfNbCluster2 = new JSpinner(new SpinnerNumberModel(3, 1, 10, 1));
    private JSpinner tfNbIteration2 = new JSpinner(new SpinnerNumberModel(100, 1, 999, 1));
    private JSpinner tfStabCrit2 = new JSpinner(new SpinnerNumberModel(0.001, 0.001, 100.0, 0.1));
    private JCheckBox cbSendMaskDirectly = new JCheckBox("To editor");
    private Thread currentlyRunning;
    private MultiCAFE parent0 = null;

    void init(GridLayout capLayout, MultiCAFE parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        JPanel panel0 = new JPanel(layoutLeft);
        ((FlowLayout)panel0.getLayout()).setVgap(0);
        panel0.add(this.detectButton);
        panel0.add(this.allSeriesCheckBox);
        panel0.add(this.allKymosCheckBox);
        panel0.add(this.leftCheckBox);
        panel0.add(this.rightCheckBox);
        panel0.add(this.cbSendMaskDirectly);
        this.add(panel0);
        JPanel panel01 = new JPanel(layoutLeft);
        panel01.add(new JLabel("Color space"));
        panel01.add(this.cbColorSpace);
        panel01.add(new JLabel("Clusters"));
        panel01.add(this.tfNbCluster2);
        panel01.add(new JLabel("Iterations"));
        panel01.add(this.tfNbIteration2);
        panel01.add(this.displayButton);
        this.add(panel01);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(new JLabel("Stabilization"));
        panel1.add(this.tfStabCrit2);
        this.add(panel1);
        this.defineActionListeners();
        this.currentlyRunning = null;
        this.cbSendMaskDirectly.setSelected(false);
        this.detectButton.setEnabled(false);
        this.allSeriesCheckBox.setEnabled(false);
        this.allKymosCheckBox.setEnabled(false);
        this.leftCheckBox.setEnabled(false);
        this.rightCheckBox.setEnabled(false);
    }

    private void defineActionListeners() {
        this.displayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LevelsKMeans)LevelsKMeans.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && LevelsKMeans.this.currentlyRunning == null) {
                    LevelsKMeans.this.runKMeans(exp);
                }
            }
        });
    }

    private int getColorSpaceFromCombo() {
        int cs = 0;
        switch (this.cbColorSpace.getSelectedIndex()) {
            case 1: {
                cs = 4;
                break;
            }
            case 2: {
                cs = 3;
                break;
            }
            default: {
                cs = 0;
            }
        }
        return cs;
    }

    private void runKMeans(final Experiment exp) {
        this.displayButton.setEnabled(false);
        final int nbc2 = (Integer)this.tfNbCluster2.getValue();
        final int nbi2 = (Integer)this.tfNbIteration2.getValue();
        final double stab2 = (Double)this.tfStabCrit2.getValue();
        final int cs = this.getColorSpaceFromCombo();
        this.currentlyRunning = new Thread(){

            @Override
            public void run() {
                try {
                    Sequence seq = exp.seqKymos.seq;
                    Segmentation segmentation = ImageKMeans.doClustering(seq, nbc2, nbi2, stab2, cs);
                    if (LevelsKMeans.this.cbSendMaskDirectly.isSelected()) {
                        LevelsKMeans.this.callMaskEditor(seq, segmentation);
                    } else {
                        LevelsKMeans.this.callDirect(segmentation);
                    }
                }
                catch (SupportRegionException e1) {
                    System.out.println(((Object)((Object)e1)).getClass().getName() + " : " + e1.getMessage());
                }
                catch (SegmentationException e1) {
                    System.out.println(((Object)((Object)e1)).getClass().getName() + " : " + e1.getMessage());
                }
                catch (MaskException e1) {
                    System.out.println(((Object)((Object)e1)).getClass().getName() + " : " + e1.getMessage());
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getClass().getName() + " : " + e.getMessage());
                }
                catch (SignatureException e) {
                    System.out.println(((Object)((Object)e)).getClass().getName() + " : " + e.getMessage());
                }
            }
        };
        this.currentlyRunning.start();
    }

    void callMaskEditor(final Sequence seq, final Segmentation segmentation) {
        final MaskEditor maskEditorPlugin = MaskEditor.getRunningInstance((boolean)true);
        this.currentlyRunning = null;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                maskEditorPlugin.setSegmentationForSequence(seq, (MaskStack)segmentation);
                maskEditorPlugin.switchOpacityOn();
                LevelsKMeans.this.displayButton.setEnabled(true);
            }
        };
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException | InvocationTargetException e) {
            System.out.println(e.getClass().getName() + " : " + e.getMessage());
        }
    }

    void callDirect(Segmentation segmentation) {
        SwimmingObject result = new SwimmingObject((Object)segmentation);
        Icy.getMainInterface().getSwimmingPool().add(result);
        this.currentlyRunning = null;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                LevelsKMeans.this.displayButton.setEnabled(true);
            }
        };
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException | InvocationTargetException e) {
            System.out.println(e.getClass().getName() + " : " + e.getMessage());
        }
    }
}

