/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment.cages;

import icy.roi.ROI;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.experiment.cages.Cage;
import plugins.fmp.multicafe.experiment.cages.FlyPosition;
import plugins.fmp.multicafe.tools.Comparators;
import plugins.fmp.multicafe.tools.ROI2D.ROI2DMeasures;
import plugins.fmp.multicafe.tools.toExcel.EnumXLSExport;
import plugins.fmp.multicafe.tools.toExcel.XLSExportOptions;

public class FlyPositions {
    public Double moveThreshold = 50.0;
    public int sleepThreshold = 5;
    public int lastTimeAlive = 0;
    public int lastIntervalAlive = 0;
    public ArrayList<FlyPosition> flyPositionList = new ArrayList();
    public String name = null;
    public EnumXLSExport exportType = null;
    public int binsize = 1;
    public Point2D origin = new Point2D.Double(0.0, 0.0);
    public double pixelsize = 1.0;
    public int nflies = 1;
    public int csvReadVersion = 1;
    private String ID_NBITEMS = "nb_items";
    private String ID_POSITIONSLIST = "PositionsList";
    private String ID_LASTIMEITMOVED = "lastTimeItMoved";
    private String ID_TLAST = "tlast";
    private String ID_ILAST = "ilast";

    public FlyPositions() {
    }

    public FlyPositions(String name, EnumXLSExport exportType, int nFrames, int binsize) {
        this.name = name;
        this.exportType = exportType;
        this.binsize = binsize;
        this.flyPositionList = new ArrayList(nFrames);
        for (int i = 0; i < nFrames; ++i) {
            this.flyPositionList.add(new FlyPosition(i));
        }
    }

    public void clear() {
        this.flyPositionList.clear();
    }

    public void ensureCapacity(int nFrames) {
        this.flyPositionList.ensureCapacity(nFrames);
    }

    void initArray(int nFrames) {
        for (int i = 0; i < nFrames; ++i) {
            FlyPosition value = new FlyPosition(i);
            this.flyPositionList.add(value);
        }
    }

    public Rectangle2D getRectangle(int i) {
        return this.flyPositionList.get(i).getRectangle2D();
    }

    public Rectangle2D getValidPointAtOrBefore(int index) {
        Rectangle2D rect = new Rectangle2D.Double(-1.0, -1.0, Double.NaN, Double.NaN);
        for (int i = index; i >= 0; --i) {
            FlyPosition xyVal = this.flyPositionList.get(i);
            if (!(xyVal.x >= 0.0) || !(xyVal.y >= 0.0)) continue;
            rect = xyVal.getRectangle2D();
            break;
        }
        return rect;
    }

    public int getTime(int i) {
        return this.flyPositionList.get((int)i).flyIndexT;
    }

    public void addPositionWithoutRoiArea(int t, Rectangle2D rectangle) {
        FlyPosition pos = new FlyPosition(t, rectangle);
        this.flyPositionList.add(pos);
    }

    public void copyPositions(FlyPositions positionsFrom) {
        this.moveThreshold = positionsFrom.moveThreshold;
        this.sleepThreshold = positionsFrom.sleepThreshold;
        this.lastTimeAlive = positionsFrom.lastIntervalAlive;
        this.flyPositionList = new ArrayList(positionsFrom.flyPositionList.size());
        for (FlyPosition flyPosFrom : positionsFrom.flyPositionList) {
            FlyPosition flyPos = new FlyPosition(flyPosFrom);
            this.flyPositionList.add(flyPos);
        }
        this.name = positionsFrom.name;
        this.exportType = positionsFrom.exportType;
        this.binsize = positionsFrom.binsize;
    }

    public boolean xmlLoadXYTPositions(Node node) {
        if (node == null) {
            return false;
        }
        Element node_lastime = XMLUtil.getElement((Node)node, (String)this.ID_LASTIMEITMOVED);
        this.lastTimeAlive = XMLUtil.getAttributeIntValue((Element)node_lastime, (String)this.ID_TLAST, (int)-1);
        this.lastIntervalAlive = XMLUtil.getAttributeIntValue((Element)node_lastime, (String)this.ID_ILAST, (int)-1);
        Element node_position_list = XMLUtil.getElement((Node)node, (String)this.ID_POSITIONSLIST);
        if (node_position_list == null) {
            return false;
        }
        this.flyPositionList.clear();
        int nb_items = XMLUtil.getAttributeIntValue((Element)node_position_list, (String)this.ID_NBITEMS, (int)0);
        this.flyPositionList.ensureCapacity(nb_items);
        for (int i = 0; i < nb_items; ++i) {
            this.flyPositionList.add(new FlyPosition(i));
        }
        boolean bAdded = false;
        for (int i = 0; i < nb_items; ++i) {
            String elementi = "i" + i;
            Element node_position_i = XMLUtil.getElement((Node)node_position_list, (String)elementi);
            FlyPosition pos = new FlyPosition();
            pos.xmlLoadPosition(node_position_i);
            if (pos.flyIndexT < nb_items) {
                this.flyPositionList.set(pos.flyIndexT, pos);
                continue;
            }
            this.flyPositionList.add(pos);
            bAdded = true;
        }
        if (bAdded) {
            Collections.sort(this.flyPositionList, new Comparators.XYTaValue_Tindex_Comparator());
        }
        return true;
    }

    public boolean xmlSaveXYTPositions(Node node) {
        if (node == null) {
            return false;
        }
        Element node_lastime = XMLUtil.addElement((Node)node, (String)this.ID_LASTIMEITMOVED);
        XMLUtil.setAttributeIntValue((Element)node_lastime, (String)this.ID_TLAST, (int)this.lastTimeAlive);
        this.lastIntervalAlive = this.getLastIntervalAlive();
        XMLUtil.setAttributeIntValue((Element)node_lastime, (String)this.ID_ILAST, (int)this.lastIntervalAlive);
        Element node_position_list = XMLUtil.addElement((Node)node, (String)this.ID_POSITIONSLIST);
        XMLUtil.setAttributeIntValue((Element)node_position_list, (String)this.ID_NBITEMS, (int)this.flyPositionList.size());
        int i = 0;
        for (FlyPosition pos : this.flyPositionList) {
            String elementi = "i" + i;
            Element node_position_i = XMLUtil.addElement((Node)node_position_list, (String)elementi);
            pos.xmlSavePosition(node_position_i);
            ++i;
        }
        return true;
    }

    public int computeLastIntervalAlive() {
        this.computeIsAlive();
        return this.lastIntervalAlive;
    }

    public void computeIsAlive() {
        this.computeDistanceBetweenConsecutivePoints();
        this.lastIntervalAlive = 0;
        boolean isalive = false;
        for (int i = this.flyPositionList.size() - 1; i >= 0; --i) {
            FlyPosition pos = this.flyPositionList.get(i);
            if (pos.distance > this.moveThreshold && !isalive) {
                this.lastIntervalAlive = i;
                this.lastTimeAlive = pos.flyIndexT;
                isalive = true;
            }
            pos.bAlive = isalive;
        }
    }

    public void checkIsAliveFromAliveArray() {
        this.lastIntervalAlive = 0;
        boolean isalive = false;
        for (int i = this.flyPositionList.size() - 1; i >= 0; --i) {
            FlyPosition pos = this.flyPositionList.get(i);
            if (!isalive && pos.bAlive) {
                this.lastIntervalAlive = i;
                this.lastTimeAlive = pos.flyIndexT;
                isalive = true;
            }
            pos.bAlive = isalive;
        }
    }

    public void computeDistanceBetweenConsecutivePoints() {
        if (this.flyPositionList.size() <= 0) {
            return;
        }
        Point2D previousPoint = this.flyPositionList.get(0).getCenterRectangle();
        for (FlyPosition pos : this.flyPositionList) {
            Point2D currentPoint = pos.getCenterRectangle();
            pos.distance = currentPoint.distance(previousPoint);
            if (previousPoint.getX() < 0.0 || currentPoint.getX() < 0.0) {
                pos.distance = Double.NaN;
            }
            previousPoint = currentPoint;
        }
    }

    public void computeCumulatedDistance() {
        if (this.flyPositionList.size() <= 0) {
            return;
        }
        double sum = 0.0;
        for (FlyPosition pos : this.flyPositionList) {
            pos.sumDistance = sum += pos.distance;
        }
    }

    public void excelComputeDistanceBetweenPoints(FlyPositions flyPositionsSource, int dataStepMs, int excelStepMs) {
        if (flyPositionsSource.flyPositionList.size() <= 0) {
            return;
        }
        flyPositionsSource.computeDistanceBetweenConsecutivePoints();
        flyPositionsSource.computeCumulatedDistance();
        int excel_startMs = 0;
        int n_excel_intervals = this.flyPositionList.size();
        int excel_endMs = n_excel_intervals * excelStepMs;
        int n_data_intervals = flyPositionsSource.flyPositionList.size();
        double sumDistance_previous = 0.0;
        for (int excel_Ms = excel_startMs; excel_Ms < excel_endMs; excel_Ms += excelStepMs) {
            int excel_bin = excel_Ms / excelStepMs;
            FlyPosition dataFlyPositionThis = this.flyPositionList.get(excel_bin);
            int data_bin = excel_Ms / dataStepMs;
            int data_bin_remainder = excel_Ms % dataStepMs;
            FlyPosition dataFlyPositionSource = flyPositionsSource.flyPositionList.get(data_bin);
            double delta = 0.0;
            if (data_bin_remainder != 0 && data_bin + 1 < n_data_intervals) {
                delta = flyPositionsSource.flyPositionList.get((int)(data_bin + 1)).distance * (double)data_bin_remainder / (double)dataStepMs;
            }
            dataFlyPositionThis.distance = dataFlyPositionSource.sumDistance - sumDistance_previous + delta;
            sumDistance_previous = dataFlyPositionSource.sumDistance;
        }
    }

    public void excelComputeIsAlive(FlyPositions flyPositions, int stepMs, int buildExcelStepMs) {
        flyPositions.computeIsAlive();
        int it_start = 0;
        int it_end = flyPositions.flyPositionList.size() * stepMs;
        int it_out = 0;
        for (int it = it_start; it < it_end && it_out < this.flyPositionList.size(); it += buildExcelStepMs, ++it_out) {
            int index = it / stepMs;
            FlyPosition pos = this.flyPositionList.get(it_out);
            pos.bAlive = flyPositions.flyPositionList.get((int)index).bAlive;
        }
    }

    public void excelComputeSleep(FlyPositions flyPositions, int stepMs, int buildExcelStepMs) {
        flyPositions.computeSleep();
        int it_start = 0;
        int it_end = flyPositions.flyPositionList.size() * stepMs;
        int it_out = 0;
        for (int it = it_start; it < it_end && it_out < this.flyPositionList.size(); it += buildExcelStepMs, ++it_out) {
            int index = it / stepMs;
            FlyPosition pos = this.flyPositionList.get(it_out);
            pos.bSleep = flyPositions.flyPositionList.get((int)index).bSleep;
        }
    }

    public void excelComputeNewPointsOrigin(Point2D newOrigin, FlyPositions flyPositions, int stepMs, int buildExcelStepMs) {
        newOrigin.setLocation(newOrigin.getX() * this.pixelsize, newOrigin.getY() * this.pixelsize);
        double deltaX = newOrigin.getX() - this.origin.getX();
        double deltaY = newOrigin.getY() - this.origin.getY();
        if (deltaX == 0.0 && deltaY == 0.0) {
            return;
        }
        int it_start = 0;
        int it_end = flyPositions.flyPositionList.size() * stepMs;
        int it_out = 0;
        for (int it = it_start; it < it_end && it_out < this.flyPositionList.size(); it += buildExcelStepMs, ++it_out) {
            int index = it / stepMs;
            FlyPosition pos_from = flyPositions.flyPositionList.get(index);
            FlyPosition pos_to = this.flyPositionList.get(it_out);
            pos_to.copy(pos_from);
            pos_to.x -= deltaX;
            pos_to.y -= deltaY;
        }
    }

    public void excelComputeEllipse(FlyPositions flyPositions, int dataStepMs, int excelStepMs) {
        if (flyPositions.flyPositionList.size() <= 0) {
            return;
        }
        flyPositions.computeEllipseAxes();
        int excel_startMs = 0;
        int n_excel_intervals = this.flyPositionList.size();
        int excel_endMs = (n_excel_intervals - 1) * excelStepMs;
        for (int excel_Ms = excel_startMs; excel_Ms < excel_endMs; excel_Ms += excelStepMs) {
            int excel_bin = excel_Ms / excelStepMs;
            FlyPosition excel_pos = this.flyPositionList.get(excel_bin);
            int data_bin = excel_Ms / dataStepMs;
            FlyPosition data_pos = flyPositions.flyPositionList.get(data_bin);
            excel_pos.axis1 = data_pos.axis1;
            excel_pos.axis2 = data_pos.axis2;
        }
    }

    public static List<FlyPositions> computeMoveResults(Experiment expi, EnumXLSExport xlsOption, XLSExportOptions options, int nFrames, double pixelsize) {
        ArrayList<FlyPositions> positionsArrayList = new ArrayList<FlyPositions>(expi.cages.cageList.size());
        for (Cage cell : expi.cages.cageList) {
            FlyPositions flyPositions = new FlyPositions(cell.cageRoi2D.getName(), xlsOption, nFrames, options.buildExcelStepMs);
            flyPositions.nflies = cell.cageNFlies;
            if (flyPositions.nflies >= 0) continue;
            flyPositions.setPixelSize(pixelsize);
            switch (xlsOption) {
                case DISTANCE: {
                    flyPositions.excelComputeDistanceBetweenPoints(cell.flyPositions, (int)expi.camImageBin_ms, options.buildExcelStepMs);
                    break;
                }
                case ISALIVE: {
                    flyPositions.excelComputeIsAlive(cell.flyPositions, (int)expi.camImageBin_ms, options.buildExcelStepMs);
                    break;
                }
                case SLEEP: {
                    flyPositions.excelComputeSleep(cell.flyPositions, (int)expi.camImageBin_ms, options.buildExcelStepMs);
                    break;
                }
                case XYTOPCELL: {
                    flyPositions.excelComputeNewPointsOrigin(cell.getCenterTopCage(), cell.flyPositions, (int)expi.camImageBin_ms, options.buildExcelStepMs);
                    break;
                }
                case XYTIPCAPS: {
                    flyPositions.excelComputeNewPointsOrigin(cell.getCenterTipCapillaries(expi.capillaries), cell.flyPositions, (int)expi.camImageBin_ms, options.buildExcelStepMs);
                    break;
                }
                case ELLIPSEAXES: {
                    flyPositions.excelComputeEllipse(cell.flyPositions, (int)expi.camImageBin_ms, options.buildExcelStepMs);
                    break;
                }
            }
            flyPositions.convertPixelsToPhysicalValues();
            positionsArrayList.add(flyPositions);
        }
        return positionsArrayList;
    }

    public List<Double> getIsAliveAsDoubleArray() {
        ArrayList<Double> dataArray = new ArrayList<Double>();
        dataArray.ensureCapacity(this.flyPositionList.size());
        for (FlyPosition pos : this.flyPositionList) {
            dataArray.add(pos.bAlive ? 1.0 : 0.0);
        }
        return dataArray;
    }

    public List<Integer> getIsAliveAsIntegerArray() {
        ArrayList<Integer> dataArray = new ArrayList<Integer>();
        dataArray.ensureCapacity(this.flyPositionList.size());
        for (FlyPosition pos : this.flyPositionList) {
            dataArray.add(pos.bAlive ? 1 : 0);
        }
        return dataArray;
    }

    public int getLastIntervalAlive() {
        if (this.lastIntervalAlive >= 0) {
            return this.lastIntervalAlive;
        }
        return this.computeLastIntervalAlive();
    }

    private int getDeltaT() {
        return this.flyPositionList.get((int)1).flyIndexT - this.flyPositionList.get((int)0).flyIndexT;
    }

    public Double getDistanceBetween2Points(int firstTimeIndex, int secondTimeIndex) {
        if (this.flyPositionList.size() < 2) {
            return Double.NaN;
        }
        int firstIndex = firstTimeIndex / this.getDeltaT();
        int secondIndex = secondTimeIndex / this.getDeltaT();
        if (firstIndex < 0 || secondIndex < 0 || firstIndex >= this.flyPositionList.size() || secondIndex >= this.flyPositionList.size()) {
            return Double.NaN;
        }
        FlyPosition pos1 = this.flyPositionList.get(firstIndex);
        FlyPosition pos2 = this.flyPositionList.get(secondIndex);
        if (pos1.x < 0.0 || pos2.x < 0.0) {
            return Double.NaN;
        }
        Point2D point2 = pos2.getCenterRectangle();
        Double distance = point2.distance(pos1.getCenterRectangle());
        return distance;
    }

    public int isAliveAtTimeIndex(int timeIndex) {
        if (this.flyPositionList.size() < 2) {
            return 0;
        }
        this.getLastIntervalAlive();
        int index = timeIndex / this.getDeltaT();
        FlyPosition pos = this.flyPositionList.get(index);
        return pos.bAlive ? 1 : 0;
    }

    private List<Integer> getDistanceAsMoveOrNot() {
        this.computeDistanceBetweenConsecutivePoints();
        ArrayList<Integer> dataArray = new ArrayList<Integer>();
        dataArray.ensureCapacity(this.flyPositionList.size());
        for (int i = 0; i < this.flyPositionList.size(); ++i) {
            dataArray.add(this.flyPositionList.get((int)i).distance < this.moveThreshold ? 1 : 0);
        }
        return dataArray;
    }

    public void computeSleep() {
        if (this.flyPositionList.size() < 1) {
            return;
        }
        List<Integer> datai = this.getDistanceAsMoveOrNot();
        int timeBinSize = this.getDeltaT();
        int j = 0;
        for (FlyPosition pos : this.flyPositionList) {
            int isleep = 1;
            int k = 0;
            for (int i = 0; i < this.sleepThreshold && k + j < datai.size() && (isleep = datai.get(k + j) * isleep) != 0; i += timeBinSize) {
                ++k;
            }
            pos.bSleep = isleep == 1;
            ++j;
        }
    }

    public List<Double> getSleepAsDoubleArray() {
        ArrayList<Double> dataArray = new ArrayList<Double>();
        dataArray.ensureCapacity(this.flyPositionList.size());
        for (FlyPosition pos : this.flyPositionList) {
            dataArray.add(pos.bSleep ? 1.0 : 0.0);
        }
        return dataArray;
    }

    public int isAsleepAtTimeIndex(int timeIndex) {
        if (this.flyPositionList.size() < 2) {
            return -1;
        }
        int index = timeIndex / this.getDeltaT();
        if (index >= this.flyPositionList.size()) {
            return -1;
        }
        return this.flyPositionList.get((int)index).bSleep ? 1 : 0;
    }

    public void computeNewPointsOrigin(Point2D newOrigin) {
        newOrigin.setLocation(newOrigin.getX() * this.pixelsize, newOrigin.getY() * this.pixelsize);
        double deltaX = newOrigin.getX() - this.origin.getX();
        double deltaY = newOrigin.getY() - this.origin.getY();
        if (deltaX == 0.0 && deltaY == 0.0) {
            return;
        }
        for (FlyPosition pos : this.flyPositionList) {
            pos.x -= deltaX;
            pos.y -= deltaY;
        }
    }

    public void computeEllipseAxes() {
        if (this.flyPositionList.size() < 1) {
            return;
        }
        for (FlyPosition pos : this.flyPositionList) {
            if (pos.flyRoi != null) {
                double[] ellipsoidValues = null;
                try {
                    ellipsoidValues = ROI2DMeasures.computeOrientation((ROI)pos.flyRoi, null);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                pos.axis1 = ellipsoidValues[0];
                pos.axis2 = ellipsoidValues[1];
                continue;
            }
            if (pos.x == Double.NaN || pos.y == Double.NaN) continue;
            pos.axis1 = pos.h;
            pos.axis2 = pos.w;
            if (!(pos.axis2 > pos.axis1)) continue;
            double x = pos.axis1;
            pos.axis1 = pos.axis2;
            pos.axis2 = x;
        }
    }

    public void setPixelSize(double newpixelSize) {
        this.pixelsize = newpixelSize;
    }

    public void convertPixelsToPhysicalValues() {
        for (FlyPosition pos : this.flyPositionList) {
            pos.x *= this.pixelsize;
            pos.y *= this.pixelsize;
            pos.w *= this.pixelsize;
            pos.h *= this.pixelsize;
            pos.axis1 *= this.pixelsize;
            pos.axis2 *= this.pixelsize;
        }
        this.origin.setLocation(this.origin.getX() * this.pixelsize, this.origin.getY() * this.pixelsize);
    }

    public void clearValues(int fromIndex) {
        int toIndex = this.flyPositionList.size();
        if (fromIndex > 0 && fromIndex < toIndex) {
            this.flyPositionList.subList(fromIndex, toIndex).clear();
        }
    }

    public boolean cvsExport_Parameter_ToRow(StringBuffer sbf, String measure, String strCellNumber, String sep) {
        int npoints = 0;
        if (this.flyPositionList != null && this.flyPositionList.size() > 0) {
            npoints = this.flyPositionList.size();
        }
        sbf.append(strCellNumber + sep);
        sbf.append(measure + sep);
        sbf.append(Integer.toString(npoints) + sep);
        if (npoints > 0) {
            char measureType = measure.charAt(0);
            if (measureType == 't') {
                for (int i = 0; i < npoints; ++i) {
                    this.flyPositionList.get(i).cvsExportT(sbf, sep);
                }
            } else if (measureType == 'x') {
                for (int i = 0; i < npoints; ++i) {
                    this.flyPositionList.get(i).cvsExportX(sbf, sep);
                }
            } else if (measureType == 'y') {
                for (int i = 0; i < npoints; ++i) {
                    this.flyPositionList.get(i).cvsExportY(sbf, sep);
                }
            } else if (measureType == 'w') {
                for (int i = 0; i < npoints; ++i) {
                    this.flyPositionList.get(i).cvsExportWidth(sbf, sep);
                }
            } else if (measureType == 'h') {
                for (int i = 0; i < npoints; ++i) {
                    this.flyPositionList.get(i).cvsExportHeight(sbf, sep);
                }
            }
        }
        sbf.append("\n");
        return true;
    }

    public boolean cvsImport_Parameter_FromRow(String[] data) {
        block9: {
            int offset;
            int npoints;
            char measureType;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            if (data.length < 1) {
                                return false;
                            }
                            measureType = data[1].charAt(0);
                            npoints = Integer.valueOf(data[2]);
                            if (this.flyPositionList.size() != npoints) {
                                this.flyPositionList = new ArrayList(npoints);
                                for (int i = 0; i < npoints; ++i) {
                                    FlyPosition flyPosition = new FlyPosition();
                                    this.flyPositionList.add(flyPosition);
                                }
                            }
                            offset = 3;
                            if (measureType != 't') break block8;
                            for (int i = 0; i < npoints; ++i) {
                                this.flyPositionList.get(i).cvsImportT(data[i + offset]);
                            }
                            break block9;
                        }
                        if (measureType != 'x') break block10;
                        for (int i = 0; i < npoints; ++i) {
                            this.flyPositionList.get(i).cvsImportX(data[i + offset]);
                        }
                        break block9;
                    }
                    if (measureType != 'y') break block11;
                    for (int i = 0; i < npoints; ++i) {
                        this.flyPositionList.get(i).cvsImportY(data[i + offset]);
                    }
                    break block9;
                }
                if (measureType != 'w') break block12;
                for (int i = 0; i < npoints; ++i) {
                    this.flyPositionList.get(i).cvsImportWidth(data[i + offset]);
                }
                break block9;
            }
            if (measureType != 'h') break block9;
            for (int i = 0; i < npoints; ++i) {
                this.flyPositionList.get(i).cvsImportHeight(data[i + offset]);
            }
        }
        return true;
    }

    public boolean csvImport_Rectangle_FromRow(String[] data, int startAt) {
        if (data.length < startAt) {
            return false;
        }
        int npoints = Integer.valueOf(data[startAt]);
        if (npoints > 0) {
            this.flyPositionList = new ArrayList(npoints);
            int offset = startAt + 1;
            for (int i = 0; i < npoints; ++i) {
                FlyPosition flyPosition = new FlyPosition();
                flyPosition.csvImportRectangle(data, offset);
                this.flyPositionList.add(flyPosition);
                offset += 5;
            }
        }
        return true;
    }

    public boolean csvImport_XY_FromRow(String[] data, int startAt) {
        if (data.length < startAt) {
            return false;
        }
        int npoints = Integer.valueOf(data[startAt]);
        if (npoints > 0) {
            this.flyPositionList = new ArrayList(npoints);
            int offset = startAt + 1;
            for (int i = 0; i < npoints; ++i) {
                FlyPosition flyPosition = new FlyPosition();
                flyPosition.csvImportXY(data, offset);
                this.flyPositionList.add(flyPosition);
                offset += 3;
            }
        }
        return true;
    }
}

