/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.experiment.capillaries;

import icy.roi.ROI;
import icy.type.geom.Polyline2D;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multicafe.tools.Level2D;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class CapillaryMeasure {
    public Level2D polylineLevel = new Level2D();
    public Level2D polyline_old = new Level2D();
    public int[] limit = null;
    public String capName = "noname";
    public int capIndexKymo = -1;
    public String header = null;
    private final String ID_NPOINTS = "npoints";
    private final String ID_NAME = "name";
    private final String ID_N = "n";
    private final String ID_X = "x";
    private final String ID_Y = "y";

    CapillaryMeasure(String capName) {
        this.capName = capName;
    }

    public CapillaryMeasure(String name, int indexImage, List<Point2D> limit) {
        this.capName = name;
        this.capIndexKymo = indexImage;
        this.polylineLevel = new Level2D(limit);
    }

    public void clear() {
        this.polylineLevel = new Level2D();
    }

    public void setPolylineLevelFromTempData(String name, int indexImage, int xStart, int xEnd) {
        this.capName = name;
        this.capIndexKymo = indexImage;
        int npoints = xEnd - xStart + 1;
        double[] xpoints = new double[npoints];
        double[] ypoints = new double[npoints];
        int j = 0;
        int i = xStart;
        while (i <= xEnd) {
            xpoints[j] = i;
            ypoints[j] = this.limit[j];
            ++i;
            ++j;
        }
        this.polylineLevel = new Level2D(xpoints, ypoints, npoints);
    }

    public void setTempDataFromPolylineLevel() {
        int npoints = this.polylineLevel.npoints;
        this.limit = new int[npoints];
        for (int j = 0; j < npoints; ++j) {
            this.limit[j] = (int)this.polylineLevel.ypoints[j];
        }
    }

    int getNPoints() {
        if (this.polylineLevel == null) {
            return 0;
        }
        return this.polylineLevel.npoints;
    }

    int restoreNPoints() {
        if (this.polyline_old != null) {
            this.polylineLevel = this.polyline_old.clone();
        }
        return this.polylineLevel.npoints;
    }

    void cropToNPoints(int npoints) {
        if (npoints > this.polylineLevel.npoints) {
            return;
        }
        if (this.polyline_old == null) {
            this.polyline_old = this.polylineLevel.clone();
        }
        Polyline2D pol = new Polyline2D();
        for (int i = 0; i < npoints; ++i) {
            pol.addPoint(this.polylineLevel.xpoints[i], this.polylineLevel.ypoints[i]);
        }
        this.polylineLevel = new Level2D(pol);
    }

    void copy(CapillaryMeasure cap) {
        if (cap.polylineLevel != null) {
            this.polylineLevel = cap.polylineLevel.clone();
        }
    }

    boolean isThereAnyMeasuresDone() {
        return this.polylineLevel != null && this.polylineLevel.npoints > 0;
    }

    ArrayList<Integer> getMeasures(long seriesBinMs, long outputBinMs) {
        if (this.polylineLevel == null || this.polylineLevel.npoints == 0) {
            return null;
        }
        long maxMs = (long)(this.polylineLevel.ypoints.length - 1) * seriesBinMs;
        long npoints = maxMs / outputBinMs + 1L;
        ArrayList<Integer> arrayInt = new ArrayList<Integer>((int)npoints);
        for (double iMs = 0.0; iMs <= (double)maxMs; iMs += (double)outputBinMs) {
            int index = (int)(iMs / (double)seriesBinMs);
            arrayInt.add((int)this.polylineLevel.ypoints[index]);
        }
        return arrayInt;
    }

    List<Integer> getMeasures() {
        return this.getIntegerArrayFromPolyline2D();
    }

    int getLastMeasure() {
        if (this.polylineLevel == null || this.polylineLevel.npoints == 0) {
            return 0;
        }
        int lastitem = this.polylineLevel.ypoints.length - 1;
        int ivalue = (int)this.polylineLevel.ypoints[lastitem];
        return ivalue;
    }

    int getT0Measure() {
        if (this.polylineLevel == null || this.polylineLevel.npoints == 0) {
            return 0;
        }
        return (int)this.polylineLevel.ypoints[0];
    }

    int getLastDeltaMeasure() {
        if (this.polylineLevel == null || this.polylineLevel.npoints == 0) {
            return 0;
        }
        int lastitem = this.polylineLevel.ypoints.length - 1;
        return (int)(this.polylineLevel.ypoints[lastitem] - this.polylineLevel.ypoints[lastitem - 1]);
    }

    boolean transferROIsToMeasures(List<ROI> listRois) {
        for (ROI roi : listRois) {
            String roiname = roi.getName();
            if (!(roi instanceof ROI2DPolyLine) || !roiname.contains(this.capName)) continue;
            this.polylineLevel = new Level2D(((ROI2DPolyLine)roi).getPolyline2D());
            return true;
        }
        return false;
    }

    List<Integer> getIntegerArrayFromPolyline2D() {
        if (this.polylineLevel == null || this.polylineLevel.npoints == 0) {
            return null;
        }
        ArrayList<Integer> arrayInt = new ArrayList<Integer>(this.polylineLevel.ypoints.length);
        for (double i : this.polylineLevel.ypoints) {
            arrayInt.add((int)i);
        }
        return arrayInt;
    }

    public int loadCapillaryLimitFromXML(Node node, String nodename, String header) {
        Element nodeMeta_old;
        Element nodeMeta = XMLUtil.getElement((Node)node, (String)nodename);
        int npoints = 0;
        this.polylineLevel = null;
        if (nodeMeta != null) {
            this.capName = XMLUtil.getElementValue((Node)nodeMeta, (String)"name", (String)nodename);
            if (!this.capName.contains("_")) {
                this.header = header;
                this.capName = header + this.capName;
            }
            this.polylineLevel = this.loadPolyline2DFromXML(nodeMeta);
            if (this.polylineLevel != null) {
                npoints = this.polylineLevel.npoints;
            }
        }
        if ((nodeMeta_old = XMLUtil.getElement((Node)node, (String)(nodename + "old"))) != null) {
            this.polyline_old = this.loadPolyline2DFromXML(nodeMeta_old);
        }
        return npoints;
    }

    Level2D loadPolyline2DFromXML(Node nodeMeta) {
        Level2D line = null;
        int npoints1 = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"npoints", (int)0);
        if (npoints1 > 0) {
            double[] xpoints = new double[npoints1];
            double[] ypoints = new double[npoints1];
            for (int i = 0; i < npoints1; ++i) {
                Element elmt = XMLUtil.getElement((Node)nodeMeta, (String)("n" + i));
                xpoints[i] = i == 0 ? XMLUtil.getAttributeDoubleValue((Element)elmt, (String)"x", (double)0.0) : (double)i + xpoints[0];
                ypoints[i] = XMLUtil.getAttributeDoubleValue((Element)elmt, (String)"y", (double)0.0);
            }
            line = new Level2D(xpoints, ypoints, npoints1);
        }
        return line;
    }

    public void saveCapillaryLimit2XML(Node node, String nodename) {
        if (this.polylineLevel == null || this.polylineLevel.npoints == 0) {
            return;
        }
        Element nodeMeta = XMLUtil.setElement((Node)node, (String)nodename);
        if (nodeMeta != null) {
            XMLUtil.setElementValue((Node)nodeMeta, (String)"name", (String)this.capName);
            this.saveLevel2XML(nodeMeta, this.polylineLevel);
            Element nodeMeta_old = XMLUtil.setElement((Node)node, (String)(nodename + "old"));
            if (this.polyline_old != null && this.polyline_old.npoints != this.polylineLevel.npoints) {
                this.saveLevel2XML(nodeMeta_old, this.polyline_old);
            }
        }
    }

    void saveLevel2XML(Node nodeMeta, Polyline2D polyline) {
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"npoints", (int)polyline.npoints);
        for (int i = 0; i < polyline.npoints; ++i) {
            Element elmt = XMLUtil.setElement((Node)nodeMeta, (String)("n" + i));
            if (i == 0) {
                XMLUtil.setAttributeDoubleValue((Element)elmt, (String)"x", (double)polyline.xpoints[i]);
            }
            XMLUtil.setAttributeDoubleValue((Element)elmt, (String)"y", (double)polyline.ypoints[i]);
        }
    }

    public void adjustToImageWidth(int imageSize) {
        if (this.polylineLevel == null || this.polylineLevel.npoints == 0) {
            return;
        }
        int npoints = this.polylineLevel.npoints;
        int npoints_old = 0;
        if (this.polyline_old != null && this.polyline_old.npoints > npoints) {
            npoints_old = this.polyline_old.npoints;
        }
        if (npoints == imageSize || npoints_old == imageSize) {
            return;
        }
        if (npoints > imageSize) {
            int newSize = imageSize;
            if (npoints < npoints_old) {
                newSize = 1 + imageSize * npoints / npoints_old;
            }
            this.polylineLevel = this.polylineLevel.contractPolylineToNewSize(newSize);
            if (npoints_old != 0) {
                this.polyline_old = this.polyline_old.contractPolylineToNewSize(imageSize);
            }
        } else {
            int newSize = imageSize;
            if (npoints < npoints_old) {
                newSize = imageSize * npoints / npoints_old;
            }
            this.polylineLevel = this.polylineLevel.expandPolylineToNewSize(newSize);
            if (npoints_old != 0) {
                this.polyline_old = this.polyline_old.expandPolylineToNewSize(imageSize);
            }
        }
    }

    public void cropToImageWidth(int imageSize) {
        if (this.polylineLevel == null || this.polylineLevel.npoints == 0) {
            return;
        }
        int npoints = this.polylineLevel.npoints;
        if (npoints == imageSize) {
            return;
        }
        int npoints_old = 0;
        if (this.polyline_old != null && this.polyline_old.npoints > npoints) {
            npoints_old = this.polyline_old.npoints;
        }
        if (npoints == imageSize || npoints_old == imageSize) {
            return;
        }
        int newSize = imageSize;
        this.polylineLevel = this.polylineLevel.cropPolylineToNewSize(newSize);
    }

    public boolean cvsExportXYDataToRow(StringBuffer sbf, String sep) {
        int npoints = 0;
        if (this.polylineLevel != null && this.polylineLevel.npoints > 0) {
            npoints = this.polylineLevel.npoints;
        }
        sbf.append(Integer.toString(npoints) + sep);
        if (npoints > 0) {
            for (int i = 0; i < this.polylineLevel.npoints; ++i) {
                sbf.append(StringUtil.toString((double)this.polylineLevel.xpoints[i]));
                sbf.append(sep);
                sbf.append(StringUtil.toString((double)this.polylineLevel.ypoints[i]));
                sbf.append(sep);
            }
        }
        return true;
    }

    public boolean cvsExportYDataToRow(StringBuffer sbf, String sep) {
        int npoints = 0;
        if (this.polylineLevel != null && this.polylineLevel.npoints > 0) {
            npoints = this.polylineLevel.npoints;
        }
        sbf.append(Integer.toString(npoints) + sep);
        if (npoints > 0) {
            for (int i = 0; i < this.polylineLevel.npoints; ++i) {
                sbf.append(StringUtil.toString((double)this.polylineLevel.ypoints[i]));
                sbf.append(sep);
            }
        }
        return true;
    }

    public boolean csvImportXYDataFromRow(String[] data, int startAt) {
        if (data.length < startAt) {
            return false;
        }
        int npoints = Integer.valueOf(data[startAt]);
        if (npoints > 0) {
            double[] x = new double[npoints];
            double[] y = new double[npoints];
            int offset = startAt + 1;
            for (int i = 0; i < npoints; ++i) {
                x[i] = Double.valueOf(data[offset]);
                y[i] = Double.valueOf(data[++offset]);
                ++offset;
            }
            this.polylineLevel = new Level2D(x, y, npoints);
        }
        return true;
    }

    public boolean csvImportYDataFromRow(String[] data, int startAt) {
        if (data.length < startAt) {
            return false;
        }
        int npoints = Integer.valueOf(data[startAt]);
        if (npoints > 0) {
            double[] x = new double[npoints];
            double[] y = new double[npoints];
            int offset = startAt + 1;
            for (int i = 0; i < npoints; ++i) {
                x[i] = i;
                y[i] = Double.valueOf(data[offset]);
                ++offset;
            }
            this.polylineLevel = new Level2D(x, y, npoints);
        }
        return true;
    }
}

