/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import plugins.fmp.multicafe.experiment.Experiment;
import plugins.fmp.multicafe.series.BuildSeries;
import plugins.fmp.multicafe.series.FlyDetectTools;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformEnums;
import plugins.fmp.multicafe.tools.ImageTransform.ImageTransformOptions;
import plugins.fmp.multicafe.tools.ViewerFMP;

public class BuildBackground
extends BuildSeries {
    public Sequence seqData = new Sequence();
    public Sequence seqReference = null;
    private ViewerFMP vData = null;
    private ViewerFMP vReference = null;
    private FlyDetectTools flyDetectTools = new FlyDetectTools();

    @Override
    void analyzeExperiment(Experiment exp) {
        if (!this.loadDrosoTrack(exp)) {
            return;
        }
        if (!this.checkBoundsForCages(exp)) {
            return;
        }
        this.runBuildBackground(exp);
    }

    private void closeSequences() {
        this.closeSequence(this.seqReference);
        this.closeSequence(this.seqData);
    }

    private void closeViewers() {
        this.closeViewer(this.vData);
        this.closeViewer(this.vReference);
        this.closeSequences();
    }

    private void openBackgroundViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildBackground.this.seqData = BuildBackground.this.newSequence("data recorded", exp.seqCamData.getSeqImage(0, 0));
                    BuildBackground.this.vData = new ViewerFMP(BuildBackground.this.seqData, true, true);
                    exp.seqReference = BuildBackground.this.seqReference = BuildBackground.this.newSequence("referenceImage", exp.seqCamData.refImage);
                    BuildBackground.this.vReference = new ViewerFMP(BuildBackground.this.seqReference, true, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void runBuildBackground(Experiment exp) {
        exp.cleanPreviousDetectedFliesROIs();
        this.flyDetectTools.initParametersForDetection(exp, this.options);
        exp.cages.initFlyPositions(this.options.detectCage);
        this.options.threshold = this.options.thresholdDiff;
        this.openBackgroundViewers(exp);
        try {
            ImageTransformOptions transformOptions = new ImageTransformOptions();
            transformOptions.transformOption = ImageTransformEnums.SUBTRACT;
            transformOptions.setSingleThreshold(this.options.backgroundThreshold, this.stopFlag);
            transformOptions.background_delta = this.options.background_delta;
            transformOptions.background_jitter = this.options.background_jitter;
            this.buildBackgroundImage(exp, transformOptions);
            exp.saveReferenceImage(this.seqReference.getFirstImage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.closeViewers();
    }

    private void buildBackgroundImage(Experiment exp, ImageTransformOptions transformOptions) throws InterruptedException {
        ProgressFrame progress = new ProgressFrame("Build background image...");
        this.flyDetectTools.initParametersForDetection(exp, this.options);
        transformOptions.backgroundImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(this.options.backgroundFirst));
        long first_ms = exp.cages.detectFirst_Ms + (long)this.options.backgroundFirst * exp.camImageBin_ms;
        int t_first = (int)((first_ms - exp.cages.detectFirst_Ms) / exp.camImageBin_ms);
        int t_last = this.options.backgroundFirst + this.options.backgroundNFrames;
        if (t_last > exp.seqCamData.nTotalFrames) {
            t_last = exp.seqCamData.nTotalFrames;
        }
        for (int t = t_first + 1; t <= t_last && !this.stopFlag; ++t) {
            IcyBufferedImage currentImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(t));
            this.seqData.setImage(0, 0, (BufferedImage)currentImage);
            progress.setMessage("Frame #" + t + "/" + t_last);
            this.transformBackground(currentImage, transformOptions);
            this.seqReference.setImage(0, 0, (BufferedImage)transformOptions.backgroundImage);
            if (transformOptions.npixels_changed < 10) break;
        }
        exp.seqCamData.refImage = IcyBufferedImageUtil.getCopy((IcyBufferedImage)this.seqReference.getFirstImage());
        progress.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transformBackground(IcyBufferedImage sourceImage, ImageTransformOptions transformOptions) {
        if (transformOptions.backgroundImage == null) {
            return;
        }
        int width = sourceImage.getSizeX();
        int height = sourceImage.getSizeY();
        int planes = sourceImage.getSizeC();
        transformOptions.npixels_changed = 0;
        int changed = 0;
        IcyBufferedImageCursor sourceCursor = new IcyBufferedImageCursor(sourceImage);
        IcyBufferedImageCursor backgroundCursor = new IcyBufferedImageCursor(transformOptions.backgroundImage);
        double smallThreshold = transformOptions.background_delta;
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    for (int c = 0; c < planes; ++c) {
                        double backgroundValue = backgroundCursor.get(x, y, c);
                        double sourceValue = sourceCursor.get(x, y, c);
                        if (sourceValue < (double)transformOptions.simplethreshold) continue;
                        double differenceValue = sourceValue - backgroundValue;
                        if (!(backgroundValue < (double)transformOptions.simplethreshold) || !(differenceValue > smallThreshold)) continue;
                        ++changed;
                        for (int yy = y - transformOptions.background_jitter; yy < y + transformOptions.background_jitter; ++yy) {
                            if (yy < 0 || yy >= height) continue;
                            for (int xx = x - transformOptions.background_jitter; xx < x + transformOptions.background_jitter; ++xx) {
                                if (xx < 0 || xx >= width) continue;
                                for (int cc = 0; cc < planes; ++cc) {
                                    backgroundCursor.set(xx, yy, cc, sourceCursor.get(xx, yy, cc));
                                }
                            }
                        }
                    }
                }
            }
        }
        finally {
            backgroundCursor.commitChanges();
            transformOptions.npixels_changed = changed;
        }
    }
}

