/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multicafe.tools;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.type.geom.Polygon2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Blobs {
    int[] binaryData = null;
    int sizeX = 0;
    int sizeY = 0;

    public Blobs(IcyBufferedImage img) {
        this.binaryData = img.getDataXYAsInt(0);
        this.sizeX = img.getSizeX();
        this.sizeY = img.getSizeY();
    }

    public int getPixelsConnected() {
        int blobnumber = 1;
        for (int iy = 0; iy < this.sizeY; ++iy) {
            for (int ix = 0; ix < this.sizeX; ++ix) {
                if (this.binaryData[ix + this.sizeX * iy] < 1) continue;
                int ioffset = ix + this.sizeX * iy;
                int ioffsetpreviousrow = ix + this.sizeX * (iy - 1);
                this.binaryData[ioffset] = iy > 0 && ix > 0 && this.binaryData[ioffsetpreviousrow - 1] > 0 ? this.binaryData[ioffsetpreviousrow - 1] : (iy > 0 && this.binaryData[ioffsetpreviousrow] > 0 ? this.binaryData[ioffsetpreviousrow] : (iy > 0 && ix + 1 < this.sizeX && this.binaryData[ioffsetpreviousrow + 1] > 0 ? this.binaryData[ioffsetpreviousrow + 1] : (ix > 0 && this.binaryData[ioffset - 1] > 0 ? this.binaryData[ioffset - 1] : blobnumber++)));
            }
        }
        return blobnumber - 1;
    }

    public void getBlobsConnected() {
        for (int iy = 0; iy < this.sizeY; ++iy) {
            for (int ix = 0; ix < this.sizeX; ++ix) {
                if (this.binaryData[ix + this.sizeX * iy] < 1) continue;
                int ioffset = ix + this.sizeX * iy;
                int ioffsetpreviousrow = ix + this.sizeX * (iy - 1);
                int val = this.binaryData[ioffset];
                if (iy <= 0 || ix <= 0 || this.binaryData[ioffsetpreviousrow - 1] <= 0) continue;
                if (this.binaryData[ioffsetpreviousrow - 1] != val) {
                    this.changeAllBlobNumber1Into2(this.binaryData[ioffsetpreviousrow - 1], val, this.binaryData);
                    continue;
                }
                if (iy <= 0 || this.binaryData[ioffsetpreviousrow] <= 0) continue;
                if (this.binaryData[ioffsetpreviousrow] != val) {
                    this.changeAllBlobNumber1Into2(this.binaryData[ioffsetpreviousrow], val, this.binaryData);
                    continue;
                }
                if (iy <= 0 || ix + 1 >= this.sizeX || this.binaryData[ioffsetpreviousrow + 1] <= 0) continue;
                if (this.binaryData[ioffsetpreviousrow + 1] != val) {
                    this.changeAllBlobNumber1Into2(this.binaryData[ioffsetpreviousrow + 1], val, this.binaryData);
                    continue;
                }
                if (ix <= 0 || this.binaryData[ioffset - 1] <= 0 || this.binaryData[ioffset - 1] == val) continue;
                this.changeAllBlobNumber1Into2(this.binaryData[ioffset - 1], val, this.binaryData);
            }
        }
    }

    private void changeAllBlobNumber1Into2(int oldvalue, int newvalue, int[] binaryData) {
        for (int i = 0; i < binaryData.length; ++i) {
            if (binaryData[i] != oldvalue) continue;
            binaryData[i] = newvalue;
        }
    }

    public void fillBlanksPixelsWithinBlobs() {
        for (int irow = 0; irow < this.sizeY; ++irow) {
            for (int icolumn = 0; icolumn < this.sizeX; ++icolumn) {
                int icolumn1;
                int iblob = this.binaryData[icolumn + this.sizeX * irow];
                if (iblob < 1) continue;
                int icol_first = icolumn;
                int icol_last = icolumn;
                for (icolumn1 = icol_first; icolumn1 < this.sizeX; ++icolumn1) {
                    if (this.binaryData[icolumn1 + this.sizeX * irow] != iblob) continue;
                    icol_last = icolumn1;
                }
                for (icolumn1 = icol_first; icolumn1 <= icol_last; ++icolumn1) {
                    this.binaryData[icolumn1 + this.sizeX * irow] = iblob;
                }
                icolumn = icol_last;
            }
        }
    }

    public int getBlobAt(int ix, int iy) {
        return this.binaryData[ix + this.sizeX * iy];
    }

    public List<Integer> getListOfBlobs(int[] binaryData) {
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        for (int i = 0; i < binaryData.length; ++i) {
            int val = binaryData[i];
            boolean found = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int ref = (Integer)iterator.next();
                if (val != ref) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(val);
        }
        return list;
    }

    public Polygon2D getBlobPolygon2D(int blobNumber) {
        ArrayList<Point> list_right = new ArrayList<Point>();
        ArrayList<Point> list_left = new ArrayList<Point>();
        block0: for (int irow = 0; irow < this.sizeY; ++irow) {
            for (int icolumn = 0; icolumn < this.sizeX; ++icolumn) {
                if (this.binaryData[icolumn + this.sizeX * irow] != blobNumber) continue;
                int icolumn_left = icolumn;
                int icolumn_right = icolumn;
                for (int icolumn1 = icolumn; icolumn1 < this.sizeX; ++icolumn1) {
                    if (this.binaryData[icolumn1 + this.sizeX * irow] == blobNumber) continue;
                    icolumn_right = icolumn1;
                    break;
                }
                list_left.add(new Point(icolumn_left, irow));
                if (icolumn_right == icolumn_left) continue block0;
                list_right.add(new Point(icolumn_right, irow));
                continue block0;
            }
        }
        ArrayList<Point> allpoints = new ArrayList<Point>();
        allpoints.addAll(list_left);
        Collections.reverse(list_right);
        allpoints.addAll(list_right);
        ArrayList<Point2D.Double> points2D = new ArrayList<Point2D.Double>(allpoints.size());
        for (Point pt : allpoints) {
            points2D.add(new Point2D.Double((double)pt.x + 0.5, (double)pt.y + 0.5));
        }
        double dev = 1.0;
        return Polygon2D.getPolygon2D(points2D, (double)dev);
    }

    public BooleanMask2D getBlobBooleanMask2D(int blobNumber) {
        ArrayList<Point> ptList = new ArrayList<Point>();
        block0: for (int irow = 0; irow < this.sizeY; ++irow) {
            for (int icolumn = 0; icolumn < this.sizeX; ++icolumn) {
                if (this.binaryData[icolumn + this.sizeX * irow] != blobNumber) continue;
                for (int icolumn1 = icolumn; icolumn1 < this.sizeX && this.binaryData[icolumn1 + this.sizeX * irow] == blobNumber; ++icolumn1) {
                    ptList.add(new Point(icolumn1, irow));
                }
                continue block0;
            }
        }
        Point[] ptArray = new Point[ptList.size()];
        ptList.toArray(ptArray);
        BooleanMask2D mask = new BooleanMask2D(ptArray);
        return mask;
    }

    public Rectangle getBlobRectangle(int blobNumber) {
        int i;
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        int[] arrayX = new int[this.sizeX];
        int[] arrayY = new int[this.sizeY];
        for (int iy = 0; iy < this.sizeY; ++iy) {
            for (int ix = 0; ix < this.sizeX; ++ix) {
                if (this.binaryData[ix + this.sizeX * iy] != blobNumber) continue;
                int n = ix;
                arrayX[n] = arrayX[n] + 1;
                int n2 = iy;
                arrayY[n2] = arrayY[n2] + 1;
            }
        }
        for (i = 0; i < this.sizeX; ++i) {
            if (arrayX[i] <= 0) continue;
            rect.x = i;
            break;
        }
        for (i = this.sizeX - 1; i >= 0; --i) {
            if (arrayX[i] <= 0) continue;
            rect.width = i - rect.x + 1;
            break;
        }
        for (i = 0; i < this.sizeY; ++i) {
            if (arrayY[i] <= 0) continue;
            rect.y = i;
            break;
        }
        for (i = this.sizeY - 1; i >= 0; --i) {
            if (arrayY[i] <= 0) continue;
            rect.height = i - rect.y + 1;
            break;
        }
        return rect;
    }
}

